/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestGetSegmentedText
extends BaseStreamTest {
    static String sXmlInput = null;
    static String sExpResult = null;

    public void testCoalescingAutoEntity() throws Exception {
        this.doTest(false, true, true);
        this.doTest(true, true, true);
    }

    public void testNonCoalescingAutoEntity() throws Exception {
        this.doTest(false, false, true);
        this.doTest(true, false, true);
    }

    public void testCoalescingNonAutoEntity() throws Exception {
        this.doTest(false, true, false);
        this.doTest(true, true, false);
    }

    public void testNonCoalescingNonAutoEntity() throws Exception {
        this.doTest(false, false, false);
        this.doTest(true, false, false);
    }

    public void testSegmentedGetCharacters() throws XMLStreamException {
        String TEXT = "Let's just add some content in here ('') to fill some of the parser buffers, to test multi-argument getTextCharacters() method";
        String XML = "<!--comment--><root><?proc instr?>Let's just add some content in here ('') to fill some of the parser buffers, to test multi-argument getTextCharacters() method</root>";
        XMLInputFactory f = this.getFactory(true, false, true);
        XMLStreamReader sr = TestGetSegmentedText.constructStreamReader(f, "<!--comment--><root><?proc instr?>Let's just add some content in here ('') to fill some of the parser buffers, to test multi-argument getTextCharacters() method</root>");
        int type = sr.next();
        if (type == 5) {
            type = sr.next();
        }
        TestGetSegmentedText.assertTokenType(1, type);
        TestGetSegmentedText.assertTokenType(3, sr.next());
        type = sr.next();
        TestGetSegmentedText.assertTokenType(4, type);
        StringBuffer sb = new StringBuffer();
        while (type == 4) {
            int len;
            int count;
            char[] buf = new char[5];
            int offset = 0;
            do {
                int start;
                if (!(offset & true)) {
                    start = 2;
                    len = 1;
                } else {
                    start = 0;
                    len = buf.length;
                }
                count = sr.getTextCharacters(offset, buf, start, len);
                if (count <= 0) continue;
                sb.append(buf, start, count);
                offset += count;
            } while (count >= len);
            type = sr.next();
        }
        TestGetSegmentedText.assertEquals((String)"Let's just add some content in here ('') to fill some of the parser buffers, to test multi-argument getTextCharacters() method", (String)sb.toString());
        TestGetSegmentedText.assertTokenType(2, type);
    }

    private void doTest(boolean ns, boolean coalescing, boolean autoEntity) throws Exception {
        if (sXmlInput == null) {
            this.initData();
        }
        for (int sz = 0; sz < 3; ++sz) {
            for (int j = 0; j < 3; ++j) {
                int i;
                XMLStreamReader sr;
                XMLInputFactory f = this.getFactory(ns, coalescing, autoEntity);
                switch (j) {
                    case 0: {
                        sr = TestGetSegmentedText.constructStreamReader(f, sXmlInput);
                        break;
                    }
                    case 1: {
                        ByteArrayInputStream bin = new ByteArrayInputStream(sXmlInput.getBytes("UTF-8"));
                        sr = f.createXMLStreamReader(bin);
                        break;
                    }
                    case 2: {
                        ByteArrayInputStream bin = new ByteArrayInputStream(sXmlInput.getBytes("UTF-8"));
                        InputStreamReader br = new InputStreamReader((InputStream)bin, "UTF-8");
                        sr = f.createXMLStreamReader(br);
                        break;
                    }
                    default: {
                        throw new Error("Internal error");
                    }
                }
                char[] cbuf = sz == 0 ? new char[23] : (sz == 1 ? new char[384] : new char[4005]);
                TestGetSegmentedText.assertTokenType(1, sr.next());
                int segCount = 0;
                int totalLen = sExpResult.length();
                StringBuffer totalBuf = new StringBuffer(totalLen);
                while (sr.next() == 4) {
                    int count;
                    int segOffset = totalBuf.length();
                    if (coalescing && ++segCount > 1) {
                        TestGetSegmentedText.fail((String)("Didn't expect multiple CHARACTERS segments when coalescing: first segment contained " + segOffset + " chars from the whole expected " + totalLen + " chars"));
                    }
                    StringBuffer sb = new StringBuffer();
                    int offset = 0;
                    int readCount = 0;
                    while ((count = sr.getTextCharacters(offset, cbuf, 0, cbuf.length)) > 0) {
                        ++readCount;
                        sb.append(cbuf, 0, count);
                        offset += count;
                    }
                    int expLen = sr.getTextLength();
                    TestGetSegmentedText.assertEquals((String)("Expected segment #" + segOffset + " (one-based; read with " + readCount + " reads) to have length of " + expLen + "; reported to have gotten just " + offset + " chars"), (int)expLen, (int)offset);
                    TestGetSegmentedText.assertEquals((String)("Expected segment #" + segOffset + " (one-based; read with " + readCount + " reads) to get " + expLen + " chars; StringBuffer only has " + sb.length()), (int)expLen, (int)sb.length());
                    totalBuf.append(sb);
                }
                TestGetSegmentedText.assertTokenType(2, sr.getEventType());
                TestGetSegmentedText.assertEquals((String)("Expected total of " + totalLen + " chars, got " + totalBuf.length()), (int)sExpResult.length(), (int)totalBuf.length());
                if (sExpResult.equals(totalBuf.toString())) continue;
                String str1 = sExpResult;
                String str2 = totalBuf.toString();
                int len = str1.length();
                char c1 = 'x';
                char c2 = 'x';
                for (i = 0; i < len && (c1 = (char)str1.charAt(i)) == (c2 = (char)str2.charAt(i)); ++i) {
                }
                TestGetSegmentedText.fail((String)("Expected Strings to equal; differed at character #" + i + " (length " + len + " was correct); expected '" + c1 + "' (" + c1 + "), got '" + c2 + "' (" + c2 + ")"));
                sr.close();
            }
        }
    }

    private XMLInputFactory getFactory(boolean nsAware, boolean coalescing, boolean autoEntity) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestGetSegmentedText.setNamespaceAware(f, nsAware);
        TestGetSegmentedText.setCoalescing(f, coalescing);
        TestGetSegmentedText.setReplaceEntities(f, autoEntity);
        TestGetSegmentedText.setSupportDTD(f, true);
        TestGetSegmentedText.setValidating(f, false);
        return f;
    }

    private void initData() throws XMLStreamException {
        StringBuffer sb = new StringBuffer("<?xml version='1.0'?>");
        sb.append("<root>");
        while (sb.length() < 65000) {
            sb.append("abcd efgh\r\nijkl &amp; mnop &lt; &gt; qrst\n uvwx\r yz &#65;");
        }
        sb.append("</root>");
        String XML = sb.toString();
        XMLInputFactory f = this.getFactory(true, false, true);
        XMLStreamReader sr = TestGetSegmentedText.constructStreamReader(f, XML);
        TestGetSegmentedText.assertTokenType(1, sr.next());
        StringBuffer sb2 = new StringBuffer(XML.length());
        while (sr.next() == 4) {
            sb2.append(sr.getText());
        }
        sXmlInput = XML;
        sExpResult = sb2.toString();
    }
}

