/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestFilteredReader
extends BaseStreamTest {
    public void testCreation() throws XMLStreamException {
        XMLStreamReader sr = this.createFilteredReader(new MyFilter(), "<root>text</root>", true);
        TestFilteredReader.assertTokenType(7, sr.getEventType());
        TestFilteredReader.assertTokenType(1, sr.next());
        TestFilteredReader.assertEquals((String)"root", (String)sr.getLocalName());
        TestFilteredReader.assertEquals((int)0, (int)sr.getAttributeCount());
        TestFilteredReader.assertNotNull((Object)sr.getName());
        TestFilteredReader.assertTokenType(4, sr.next());
        TestFilteredReader.assertEquals((String)"text", (String)TestFilteredReader.getAndVerifyText(sr));
        TestFilteredReader.assertTokenType(2, sr.next());
        TestFilteredReader.assertEquals((String)"root", (String)sr.getLocalName());
        TestFilteredReader.assertTokenType(8, sr.next());
    }

    public void testStartElemFilter1() throws XMLStreamException {
        XMLStreamReader sr = this.createFilteredReader(this.getElementFilter("elem"), "<elem>text</elem>", true);
        TestFilteredReader.assertTokenType(1, sr.getEventType());
    }

    public void testStartElemFilter2() throws XMLStreamException {
        XMLStreamReader sr = this.createFilteredReader(this.getElementFilter("elem"), "<root>...<elem>text</elem></root>", true);
        TestFilteredReader.assertTokenType(1, sr.getEventType());
        TestFilteredReader.assertEquals((String)"elem", (String)sr.getLocalName());
    }

    private StreamFilter getElementFilter(final String localName) {
        return new StreamFilter(){

            public boolean accept(XMLStreamReader r) {
                return r.getEventType() == 1 && r.getLocalName().equals(localName);
            }
        };
    }

    private XMLStreamReader createFilteredReader(StreamFilter filter, String content, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestFilteredReader.setNamespaceAware(f, nsAware);
        XMLStreamReader base = TestFilteredReader.constructStreamReader(f, content);
        return f.createFilteredReader(base, filter);
    }

    static final class MyFilter
    implements StreamFilter {
        MyFilter() {
        }

        public boolean accept(XMLStreamReader reader) {
            return true;
        }
    }
}

