/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestEncodingRead
extends BaseStreamTest {
    final String UTF_1 = String.valueOf('A');
    final String UTF_2 = String.valueOf('\u00a0');
    final String UTF_3 = String.valueOf('\u0b61');
    final String UTF_CONTENT = "" + this.UTF_1 + this.UTF_2 + this.UTF_3 + this.UTF_1 + this.UTF_1 + this.UTF_2 + this.UTF_2 + this.UTF_3 + this.UTF_3 + this.UTF_3 + this.UTF_3 + this.UTF_2 + this.UTF_2 + this.UTF_1 + this.UTF_1 + this.UTF_1 + this.UTF_3 + this.UTF_2 + this.UTF_2 + this.UTF_1 + this.UTF_3 + this.UTF_2 + this.UTF_3 + this.UTF_1 + this.UTF_3 + this.UTF_1 + this.UTF_2 + this.UTF_3 + this.UTF_2 + this.UTF_1;
    static final byte[] BE_BOM = new byte[]{-2, -1};
    static final byte[] LE_BOM = new byte[]{-1, -2};
    static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};

    public TestEncodingRead(String name) {
        super(name);
    }

    public void testUTF8() throws Exception {
        this.doTestEncoding("UTF-8", "UTF-8", null);
        this.doTestEncoding("UTF-8", null, null);
    }

    public void testUTF8WithBOM() throws Exception {
        this.doTestEncoding("UTF-8", "UTF-8", UTF8_BOM);
        this.doTestEncoding("UTF-8", null, UTF8_BOM);
    }

    public void testUTF8Surrogates() throws XMLStreamException, IOException {
        String XML = "<?xml version='1.0' encoding='UTF-8'?><root>XXXX</root>";
        int ix = XML.indexOf(88);
        byte[] src = XML.getBytes("UTF-8");
        src[ix] = -15;
        src[ix + 1] = -112;
        src[ix + 2] = -120;
        src[ix + 3] = -120;
        ByteArrayInputStream in = new ByteArrayInputStream(src);
        XMLInputFactory f = this.getInputFactory();
        XMLStreamReader sr = f.createXMLStreamReader(in);
        TestEncodingRead.assertTokenType(1, sr.next());
        TestEncodingRead.assertEquals((String)"root", (String)sr.getLocalName());
        TestEncodingRead.assertTokenType(4, sr.next());
        String str = TestEncodingRead.getAndVerifyText(sr);
        TestEncodingRead.assertEquals((int)2, (int)str.length());
        TestEncodingRead.assertEquals((char)'\ud900', (char)str.charAt(0));
        TestEncodingRead.assertEquals((char)'\ude08', (char)str.charAt(1));
        TestEncodingRead.assertTokenType(2, sr.next());
    }

    public void testUTF16BEWithBOM() throws XMLStreamException, UnsupportedEncodingException {
        this.doTestEncoding("UTF-16BE", "UTF-16", BE_BOM);
        this.doTestEncoding("UTF-16BE", null, BE_BOM);
        this.doTestEncoding2(true);
    }

    public void testUTF16LEWithBOM() throws XMLStreamException, UnsupportedEncodingException {
        this.doTestEncoding("UTF-16LE", "UTF-16", LE_BOM);
        this.doTestEncoding("UTF-16LE", null, LE_BOM);
        this.doTestEncoding2(false);
    }

    public void doTestEncoding(String javaEnc, String xmlEnc, byte[] bom) throws XMLStreamException, UnsupportedEncodingException {
        String XML = "<?xml version='1.0'";
        if (xmlEnc != null) {
            XML = XML + " encoding='" + xmlEnc + "'";
        }
        XML = XML + "?><root>" + this.UTF_CONTENT + "</root>";
        byte[] b = XML.getBytes(javaEnc);
        if (bom != null) {
            byte[] orig = b;
            b = new byte[b.length + bom.length];
            System.arraycopy(bom, 0, b, 0, bom.length);
            System.arraycopy(orig, 0, b, bom.length, orig.length);
        }
        XMLStreamReader sr = this.getReader(b);
        if (xmlEnc != null) {
            TestEncodingRead.assertEquals((String)xmlEnc, (String)sr.getCharacterEncodingScheme());
        }
        TestEncodingRead.assertEquals((int)1, (int)sr.next());
        TestEncodingRead.assertEquals((int)4, (int)sr.next());
        TestEncodingRead.assertEquals((String)this.UTF_CONTENT, (String)TestEncodingRead.getAllText(sr));
        TestEncodingRead.assertEquals((int)2, (int)sr.getEventType());
        TestEncodingRead.assertEquals((int)8, (int)sr.next());
    }

    private void doTestEncoding2(boolean bigEndian) throws XMLStreamException {
        String XML = "<?xml version='1.0' encoding='UTF-16'?>\n<!--comment--><root>text</root>";
        int len = "<?xml version='1.0' encoding='UTF-16'?>\n<!--comment--><root>text</root>".length();
        byte[] b = new byte[2 + len + len];
        if (bigEndian) {
            b[0] = -2;
            b[1] = -1;
        } else {
            b[0] = -1;
            b[1] = -2;
        }
        int offset = bigEndian ? 3 : 2;
        for (int i = 0; i < len; ++i) {
            b[offset + i + i] = (byte)"<?xml version='1.0' encoding='UTF-16'?>\n<!--comment--><root>text</root>".charAt(i);
        }
        XMLStreamReader sr = this.getReader(b);
        int type = sr.next();
        if (type == 6) {
            type = sr.next();
        }
        TestEncodingRead.assertTokenType(5, type);
        TestEncodingRead.assertTokenType(1, sr.next());
        TestEncodingRead.assertTokenType(4, sr.next());
        TestEncodingRead.assertEquals((String)"text", (String)TestEncodingRead.getAndVerifyText(sr));
        TestEncodingRead.assertTokenType(2, sr.next());
        sr.close();
    }

    private XMLStreamReader getReader(byte[] contents) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEncodingRead.setValidating(f, false);
        return TestEncodingRead.constructStreamReader(f, contents);
    }
}

