/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import com.ctc.wstx.exc.WstxLazyException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestCharacterLimits
extends BaseStreamTest {
    private Reader createLongReader(String pre, final String post, final boolean ws) {
        int max = Integer.MAX_VALUE;
        final StringBuffer start = new StringBuffer("<ns:element xmlns:ns=\"http://foo.com\">" + pre);
        return new Reader(){
            StringReader sreader;
            int count;
            boolean done;
            {
                this.sreader = new StringReader(start.toString());
            }

            public int read(char[] cbuf, int off, int len) throws IOException {
                int i = this.sreader.read(cbuf, off, len);
                if (i == -1) {
                    if (this.count < Integer.MAX_VALUE) {
                        this.sreader = ws ? new StringReader("                              ") : new StringReader("1234567890123<?foo?>78901234567890");
                        ++this.count;
                    } else if (!this.done) {
                        this.sreader = ws ? new StringReader(post + "</ns:element>") : new StringReader(post + "<ns:el2>foo</ns:el2></ns:element>");
                        this.done = true;
                    }
                    i = this.sreader.read(cbuf, off, len);
                }
                return i;
            }

            public void close() throws IOException {
            }
        };
    }

    public void testLongGetElementText() throws Exception {
        try {
            Reader reader = this.createLongReader("", "", false);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            System.out.println(xmlreader.getElementText());
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongElementText() throws Exception {
        try {
            Reader reader = this.createLongReader("", "", false);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 100000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            TestCharacterLimits.assertEquals((int)4, (int)xmlreader.next());
            while (xmlreader.next() != 1) {
            }
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongWhitespaceNextTag() throws Exception {
        try {
            Reader reader = this.createLongReader("", "", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            xmlreader.nextTag();
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongWhitespace() throws Exception {
        try {
            Reader reader = this.createLongReader("", "", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 50000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            TestCharacterLimits.assertEquals((int)4, (int)xmlreader.next());
            while (xmlreader.next() != 1) {
            }
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongCDATA() throws Exception {
        try {
            Reader reader = this.createLongReader("<![CDATA[", "]]>", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 50000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            TestCharacterLimits.assertEquals((int)12, (int)xmlreader.next());
            while (xmlreader.next() != 1) {
            }
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongCDATANextTag() throws Exception {
        try {
            Reader reader = this.createLongReader("<![CDATA[", "]]>", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            xmlreader.nextTag();
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongComment() throws Exception {
        try {
            Reader reader = this.createLongReader("<!--", "-->", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 5) {
            }
            System.out.println(xmlreader.getText());
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (WstxLazyException wstxLazyException) {
            // empty catch block
        }
    }

    public void testLongComment2() throws Exception {
        try {
            Reader reader = this.createLongReader("<!--", "-->", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 5) {
            }
            System.out.println(new String(xmlreader.getTextCharacters()));
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (WstxLazyException wstxLazyException) {
            // empty catch block
        }
    }

    public void testLongCommentNextTag() throws Exception {
        try {
            Reader reader = this.createLongReader("<!--", "-->", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 5) {
            }
            xmlreader.nextTag();
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongCommentCoalescing() throws Exception {
        try {
            Reader reader = this.createLongReader("<!--", "-->", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            xmlreader.nextTag();
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongWhitespaceCoalescing() throws Exception {
        try {
            Reader reader = this.createLongReader("", "", true);
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            factory.setProperty("com.ctc.wstx.maxTextLength", 1000);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 1) {
            }
            xmlreader.nextTag();
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testLongAttribute() throws Exception {
        int max = 500;
        Reader reader = new Reader(){
            StringReader sreader = new StringReader("<ns:element xmlns:ns=\"http://foo.com\" blah=\"");
            int count;
            boolean done;

            public int read(char[] cbuf, int off, int len) throws IOException {
                int i = this.sreader.read(cbuf, off, len);
                if (i == -1) {
                    if (this.count < 500) {
                        this.sreader = new StringReader("          ");
                        ++this.count;
                    } else if (!this.done) {
                        this.sreader = new StringReader("\"/>");
                        this.done = true;
                    }
                    i = this.sreader.read(cbuf, off, len);
                }
                return i;
            }

            public void close() throws IOException {
            }
        };
        try {
            XMLInputFactory factory = TestCharacterLimits.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxAttributeSize", 100);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            while (xmlreader.next() != 8) {
            }
            TestCharacterLimits.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

