/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestStartDocument
extends BaseEventTest {
    public void testTrivialValid() throws XMLStreamException {
        StartDocument devt;
        XMLEvent evt;
        XMLEventReader er;
        boolean coal;
        boolean ns;
        int i;
        String XML = "<root />";
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            evt = er.nextEvent();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            devt = (StartDocument)evt;
            TestStartDocument.assertFalse((boolean)devt.encodingSet());
            TestStartDocument.assertFalse((String)"Stand-alone should not be assumed true if not included in xml declaration", (boolean)devt.standaloneSet());
            TestStartDocument.assertEquals((String)"1.0", (String)devt.getVersion());
            er.close();
        }
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            evt = er.peek();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            devt = (StartDocument)evt;
            TestStartDocument.assertFalse((boolean)devt.encodingSet());
            TestStartDocument.assertFalse((boolean)devt.standaloneSet());
            TestStartDocument.assertEquals((String)"1.0", (String)devt.getVersion());
            er.close();
            evt = er.peek();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            devt = (StartDocument)evt;
        }
    }

    public void testNormalValid() throws XMLStreamException {
        StartDocument devt;
        XMLEvent evt;
        XMLEventReader er;
        boolean coal;
        boolean ns;
        int i;
        String XML = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><root />";
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            evt = er.nextEvent();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            devt = (StartDocument)evt;
            TestStartDocument.assertEquals((String)"1.0", (String)devt.getVersion());
            TestStartDocument.assertTrue((boolean)devt.encodingSet());
            TestStartDocument.assertEquals((String)"UTF-8", (String)devt.getCharacterEncodingScheme());
            TestStartDocument.assertTrue((boolean)devt.standaloneSet());
            TestStartDocument.assertTrue((boolean)devt.isStandalone());
            er.close();
        }
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            evt = er.peek();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            devt = (StartDocument)evt;
            TestStartDocument.assertEquals((String)"1.0", (String)devt.getVersion());
            TestStartDocument.assertTrue((boolean)devt.encodingSet());
            TestStartDocument.assertEquals((String)"UTF-8", (String)devt.getCharacterEncodingScheme());
            TestStartDocument.assertTrue((boolean)devt.standaloneSet());
            TestStartDocument.assertTrue((boolean)devt.isStandalone());
            er.close();
            evt = er.peek();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            devt = (StartDocument)evt;
        }
    }

    public void testNextEvent() throws XMLStreamException {
        QName n;
        StartElement elem;
        XMLEvent evt;
        XMLEventReader er;
        boolean coal;
        boolean ns;
        int i;
        String XML = "<root />";
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            evt = er.nextTag();
            TestStartDocument.assertNotNull((Object)evt);
            TestStartDocument.assertTrue((boolean)evt.isStartElement());
            elem = evt.asStartElement();
            n = elem.getName();
            TestStartDocument.assertNotNull((Object)n);
            TestStartDocument.assertEquals((String)"root", (String)n.getLocalPart());
        }
        XML = "<?xml version='1.0' encoding='UTF-8' standalone='no'?><root />";
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            evt = er.peek();
            TestStartDocument.assertTrue((boolean)evt.isStartDocument());
            evt = er.nextTag();
            TestStartDocument.assertNotNull((Object)evt);
            TestStartDocument.assertTrue((boolean)evt.isStartElement());
            elem = evt.asStartElement();
            n = elem.getName();
            TestStartDocument.assertNotNull((Object)n);
            TestStartDocument.assertEquals((String)"root", (String)n.getLocalPart());
        }
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        return this.getReader(contents, nsAware, coalesce, true);
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce, boolean expandEnt) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestStartDocument.setNamespaceAware(f, nsAware);
        TestStartDocument.setCoalescing(f, coalesce);
        TestStartDocument.setSupportDTD(f, true);
        TestStartDocument.setValidating(f, false);
        TestStartDocument.setReplaceEntities(f, expandEnt);
        return TestStartDocument.constructEventReader(f, contents);
    }
}

