/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventReader
extends BaseEventTest {
    public void testSimpleValid() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root [  ]><root attr='123'><!-- comment -->\n</root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(11, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(5, er.nextEvent().getEventType());
            XMLEvent evt = (XMLEvent)er.next();
            TestEventReader.assertTokenType(4, evt.getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
            er.close();
        }
    }

    public void testInvalidUsage() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><root />";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            XMLEvent evt = er.nextEvent();
            String msg = null;
            try {
                er.remove();
                msg = "Was expecting UnsupportedOperationException for XMLEventReader.remove()";
            }
            catch (UnsupportedOperationException e) {
            }
            catch (Throwable t) {
                msg = "Was expecting UnsupportedOperationException for XMLEventReader.remove(); instead got: " + t;
            }
            if (msg == null) continue;
            TestEventReader.fail((String)msg);
        }
    }

    public void testIterationEndException() throws XMLStreamException {
        String XML = "<root />";
        for (int i = 0; i < 4; ++i) {
            boolean coal = (i & 1) != 0;
            boolean checkHasNext = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, true, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            if (checkHasNext) {
                TestEventReader.assertFalse((boolean)er.hasNext());
            }
            XMLEvent ev = null;
            try {
                ev = er.nextEvent();
            }
            catch (NoSuchElementException nex) {
                continue;
            }
            catch (Throwable t) {
                TestEventReader.fail((String)("Expected a NoSuchElementException after iterating through the document; got " + t));
            }
            TestEventReader.fail((String)("Expected a NoSuchElementException after iterating through the document; got event: " + ev));
        }
    }

    public void testNextTagOk() throws XMLStreamException {
        String XML = "<root>\n<branch>   <leaf>  </leaf></branch></root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextTag().getEventType());
            TestEventReader.assertTokenType(1, er.nextTag().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextTag().getEventType());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
        }
    }

    public void testNextTagInvalid() throws XMLStreamException {
        String XML = "<root>   non-empty<leaf /></root>";
        String XML2 = "<root><leaf></leaf>text   </root>";
        for (int i = 0; i < 4; ++i) {
            XMLEvent evt;
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            String msg = null;
            try {
                evt = er.nextTag();
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on non-empty CHARACTERS";
            }
            catch (XMLStreamException sex) {
            }
            catch (Throwable t) {
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on non-empty CHARACTERS; got (" + t.getClass() + "): " + t;
            }
            if (msg != null) {
                TestEventReader.fail((String)msg);
            }
            er.close();
            er = this.getReader(XML2, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            try {
                evt = er.nextTag();
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on END_ELEMENT and hitting non-ws text; got event " + TestEventReader.tokenTypeDesc(evt);
            }
            catch (XMLStreamException sex) {
                msg = null;
            }
            catch (Throwable t) {
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on END_ELEMENT and hitting non-ws text; got: " + t;
            }
            if (msg != null) {
                TestEventReader.fail((String)msg);
            }
            er.close();
        }
    }

    public void testSkip() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root><root>\n<branch>   <leaf>  </leaf></branch><!-- comment --></root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.peek().getEventType());
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(11, er.peek().getEventType());
            TestEventReader.assertTokenType(11, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(4, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(4, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(4, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.peek().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.peek().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(5, er.peek().getEventType());
            TestEventReader.assertTokenType(5, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.peek().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(8, er.peek().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
        }
    }

    public void testPeek() throws XMLStreamException {
        String XML = "<root>text</root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            XMLEvent tag = er.nextTag();
            TestEventReader.assertTokenType(1, tag.getEventType());
            XMLEvent text = er.peek();
            TestEventReader.assertTokenType(4, text.getEventType());
            Characters chars = text.asCharacters();
            TestEventReader.assertNotNull((Object)chars);
            TestEventReader.assertEquals((String)"text", (String)chars.getData());
            text = er.nextEvent();
            TestEventReader.assertTokenType(4, text.getEventType());
            chars = text.asCharacters();
            TestEventReader.assertNotNull((Object)chars);
            TestEventReader.assertEquals((String)"text", (String)chars.getData());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertNull((Object)er.peek());
        }
    }

    public void testElementText() throws XMLStreamException {
        XMLEvent elem;
        XMLEventReader er;
        boolean coal;
        boolean ns;
        int i;
        String TEXT1 = "some\ntest";
        String TEXT2 = "inside CDATA too!";
        String XML = "<root>" + TEXT1 + "<![CDATA[" + TEXT2 + "]]></root>";
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            elem = er.nextEvent();
            TestEventReader.assertTokenType(1, elem.getEventType());
            try {
                TestEventReader.assertEquals((String)(TEXT1 + TEXT2), (String)er.getElementText());
            }
            catch (XMLStreamException sex) {
                TestEventReader.fail((String)("Failed on XMLEventReader.getElementText(): " + sex));
            }
            elem = er.nextEvent();
            if (elem.getEventType() == 8 || elem.getEventType() == 2) continue;
            TestEventReader.fail((String)("Expected END_DOCUMENT or END_ELEMENT, got " + TestEventReader.tokenTypeDesc(elem.getEventType())));
        }
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            elem = er.nextEvent();
            TestEventReader.assertTokenType(1, elem.getEventType());
            XMLEvent peeked = er.peek();
            TestEventReader.assertTokenType(4, peeked.getEventType());
            TestEventReader.assertEquals((String)(TEXT1 + TEXT2), (String)er.getElementText());
            elem = er.nextEvent();
            if (elem.getEventType() == 8 || elem.getEventType() == 2) continue;
            TestEventReader.fail((String)("Expected END_DOCUMENT or END_ELEMENT, got " + TestEventReader.tokenTypeDesc(elem.getEventType())));
        }
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        return this.getReader(contents, nsAware, coalesce, true);
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce, boolean expandEnt) throws XMLStreamException {
        XMLInputFactory f = TestEventReader.getNewInputFactory();
        TestEventReader.setNamespaceAware(f, nsAware);
        TestEventReader.setCoalescing(f, coalesce);
        TestEventReader.setSupportDTD(f, true);
        TestEventReader.setValidating(f, false);
        TestEventReader.setReplaceEntities(f, expandEnt);
        return TestEventReader.constructEventReader(f, contents);
    }
}

