/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventDTD
extends BaseEventTest {
    static /* synthetic */ Class class$javax$xml$stream$events$EntityDeclaration;
    static /* synthetic */ Class class$javax$xml$stream$events$NotationDeclaration;

    public void testNonExpandingEntities() throws XMLStreamException {
        String URL1 = "nosuchdir/dummyent.xml";
        String XML = "<?xml version='1.0' ?><!DOCTYPE root [\n<!ENTITY intEnt 'internal'>\n<!ENTITY extParsedEnt SYSTEM 'nosuchdir/dummyent.xml'>\n<!NOTATION notation PUBLIC 'notation-public-id'>\n<!ENTITY extUnparsedEnt SYSTEM 'http://localhost/dummy2' NDATA notation>\n]><root>&intEnt;&extParsedEnt;</root>";
        for (int i = 0; i < 2; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = false;
            XMLEventReader er = this.getReader(XML, ns, coal, false);
            TestEventDTD.assertTokenType(7, er.nextEvent().getEventType());
            TestEventDTD.assertTokenType(11, er.nextEvent().getEventType());
            XMLEvent evt = er.nextEvent();
            TestEventDTD.assertTrue((boolean)evt.isStartElement());
            evt = er.nextEvent();
            TestEventDTD.assertTokenType(9, evt.getEventType());
            EntityReference ref = (EntityReference)evt;
            TestEventDTD.assertNotNull((Object)ref);
            TestEventDTD.assertTrue((boolean)ref.isEntityReference());
            TestEventDTD.assertEquals((String)"intEnt", (String)ref.getName());
            EntityDeclaration ed = ref.getDeclaration();
            TestEventDTD.assertNotNull((String)"Declaration of internal entity 'intEnt' should not be null", (Object)ed);
            TestEventDTD.assertEquals((String)"intEnt", (String)ed.getName());
            TestEventDTD.assertEquals((String)"internal", (String)ed.getReplacementText());
            TestEventDTD.assertNullOrEmpty(ed.getNotationName());
            TestEventDTD.assertNullOrEmpty(ed.getPublicId());
            TestEventDTD.assertNullOrEmpty(ed.getSystemId());
            evt = er.nextEvent();
            TestEventDTD.assertTokenType(9, evt.getEventType());
            ref = (EntityReference)evt;
            TestEventDTD.assertNotNull((Object)ref);
            TestEventDTD.assertTrue((boolean)ref.isEntityReference());
            TestEventDTD.assertEquals((String)"extParsedEnt", (String)ref.getName());
            ed = ref.getDeclaration();
            TestEventDTD.assertNotNull((String)"Declaration of external entity 'extParsedEnt' should not be null", (Object)ed);
            TestEventDTD.assertEquals((String)"extParsedEnt", (String)ed.getName());
            TestEventDTD.assertNullOrEmpty(ed.getNotationName());
            TestEventDTD.assertNullOrEmpty(ed.getPublicId());
            TestEventDTD.assertEquals((String)"nosuchdir/dummyent.xml", (String)ed.getSystemId());
            evt = er.nextEvent();
            TestEventDTD.assertTrue((boolean)evt.isEndElement());
            TestEventDTD.assertTokenType(8, er.nextEvent().getEventType());
            TestEventDTD.assertFalse((boolean)er.hasNext());
        }
    }

    public void testValidDtdEvent() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root [\n<!ENTITY intEnt 'internal'>\n<!ENTITY extParsedEnt SYSTEM 'url:dummy'>\n<!NOTATION notation PUBLIC 'notation-public-id'>\n<!NOTATION notation2 SYSTEM 'url:dummy'>\n<!ENTITY extUnparsedEnt SYSTEM 'url:dummy2' NDATA notation>\n]><root />";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventDTD.assertTokenType(7, er.nextEvent().getEventType());
            XMLEvent evt = er.nextEvent();
            TestEventDTD.assertTokenType(11, evt.getEventType());
            DTD dtd = (DTD)evt;
            List<EntityDeclaration> entities = dtd.getEntities();
            TestEventDTD.assertNotNull((String)"Entity list for a DTD declaration with entities should not be null", entities);
            TestEventDTD.assertEquals((int)3, (int)entities.size());
            this.testListElems(entities, class$javax$xml$stream$events$EntityDeclaration == null ? TestEventDTD.class$("javax.xml.stream.events.EntityDeclaration") : class$javax$xml$stream$events$EntityDeclaration);
            List<NotationDeclaration> notations = dtd.getNotations();
            this.testListElems(notations, class$javax$xml$stream$events$NotationDeclaration == null ? TestEventDTD.class$("javax.xml.stream.events.NotationDeclaration") : class$javax$xml$stream$events$NotationDeclaration);
            TestEventDTD.assertNotNull((String)"Notation list for a DTD declaration with notations should not be null", entities);
            TestEventDTD.assertNotNull(notations);
            TestEventDTD.assertEquals((int)2, (int)notations.size());
        }
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        return this.getReader(contents, nsAware, coalesce, true);
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce, boolean expandEnt) throws XMLStreamException {
        XMLInputFactory f = TestEventDTD.getNewInputFactory();
        TestEventDTD.setNamespaceAware(f, nsAware);
        TestEventDTD.setCoalescing(f, coalesce);
        TestEventDTD.setSupportDTD(f, true);
        TestEventDTD.setValidating(f, false);
        TestEventDTD.setReplaceEntities(f, expandEnt);
        return TestEventDTD.constructEventReader(f, contents);
    }

    private void testListElems(List l, Class expType) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            TestEventDTD.assertNotNull(o);
            TestEventDTD.assertTrue((boolean)expType.isAssignableFrom(o.getClass()));
        }
    }
}

