/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventCopy
extends BaseEventTest {
    public void testCopy() throws XMLStreamException {
        String XML = "<root>\n <branch>\n   <leaf attr='123' /> </branch>\n <leaf attr='\"a\"' /></root>";
        XMLEventReader er = this.getEventReader("<root>\n <branch>\n   <leaf attr='123' /> </branch>\n <leaf attr='\"a\"' /></root>", true, true);
        StringWriter strw = new StringWriter();
        XMLOutputFactory f = this.getOutputFactory();
        XMLEventWriter ew = f.createXMLEventWriter(strw);
        while (er.hasNext()) {
            ew.add(er.nextEvent());
        }
        ew.close();
        String results = strw.toString();
        er = this.getEventReader(results, true, true);
        XMLEvent evt = er.nextEvent();
        TestEventCopy.assertNotNull((Object)evt);
        TestEventCopy.assertTrue((boolean)evt.isStartDocument());
        evt = er.nextEvent();
        TestEventCopy.assertEquals((Object)new QName("root"), (Object)evt.asStartElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isCharacters());
        TestEventCopy.assertTrue((boolean)evt.asCharacters().isWhiteSpace());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isStartElement());
        TestEventCopy.assertEquals((Object)new QName("branch"), (Object)evt.asStartElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isCharacters());
        TestEventCopy.assertTrue((boolean)evt.asCharacters().isWhiteSpace());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isStartElement());
        TestEventCopy.assertEquals((Object)new QName("leaf"), (Object)evt.asStartElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isEndElement());
        TestEventCopy.assertEquals((Object)new QName("leaf"), (Object)evt.asEndElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isCharacters());
        TestEventCopy.assertTrue((boolean)evt.asCharacters().isWhiteSpace());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isEndElement());
        TestEventCopy.assertEquals((Object)new QName("branch"), (Object)evt.asEndElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isCharacters());
        TestEventCopy.assertTrue((boolean)evt.asCharacters().isWhiteSpace());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isStartElement());
        TestEventCopy.assertEquals((Object)new QName("leaf"), (Object)evt.asStartElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isEndElement());
        TestEventCopy.assertEquals((Object)new QName("leaf"), (Object)evt.asEndElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isEndElement());
        TestEventCopy.assertEquals((Object)new QName("root"), (Object)evt.asEndElement().getName());
    }

    public void testCopyWithCData() throws XMLStreamException {
        String XML = "<root><![CDATA[a&b]]></root>";
        XMLEventReader er = this.getEventReader("<root><![CDATA[a&b]]></root>", true, false);
        StringWriter strw = new StringWriter();
        XMLOutputFactory f = this.getOutputFactory();
        XMLEventWriter ew = f.createXMLEventWriter(strw);
        while (er.hasNext()) {
            ew.add(er.nextEvent());
        }
        ew.close();
        String results = strw.toString();
        er = this.getEventReader(results, true, false);
        XMLEvent evt = er.nextEvent();
        TestEventCopy.assertNotNull((Object)evt);
        TestEventCopy.assertTrue((boolean)evt.isStartDocument());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isStartElement());
        TestEventCopy.assertEquals((Object)new QName("root"), (Object)evt.asStartElement().getName());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isCharacters());
        TestEventCopy.assertTrue((String)"Expected CDATA block to generate a Characters event for which isCData() returns true", (boolean)evt.asCharacters().isCData());
        TestEventCopy.assertEquals((String)"a&b", (String)evt.asCharacters().getData());
        evt = er.nextEvent();
        TestEventCopy.assertTrue((boolean)evt.isEndElement());
        TestEventCopy.assertEquals((Object)new QName("root"), (Object)evt.asEndElement().getName());
    }

    private XMLEventReader getEventReader(String contents, boolean nsAware, boolean coal) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEventCopy.setNamespaceAware(f, nsAware);
        TestEventCopy.setCoalescing(f, coal);
        TestEventCopy.setSupportDTD(f, true);
        TestEventCopy.setValidating(f, false);
        return TestEventCopy.constructEventReader(f, contents);
    }
}

