/*
 * Decompiled with CFR 0.152.
 */
package stax2.wstream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import stax2.wstream.BaseWriterTest;

public class TestEscaping
extends BaseWriterTest {
    public void testBrokenNsURLs() throws XMLStreamException {
        String BROKEN_URL1 = "<tag>";
        String BROKEN_URL2 = "\"";
        String BROKEN_URL3 = "x&";
        StringWriter strw = new StringWriter();
        XMLStreamWriter2 w = this.getNonRepairingWriter(strw, true);
        w.writeStartDocument();
        w.writeStartElement("", "test", "");
        w.writeNamespace("ns", "<tag>");
        w.writeStartElement("", "test", "");
        w.writeNamespace("ns", "\"");
        w.writeStartElement("", "test", "");
        w.writeNamespace("ns", "x&");
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        String input = strw.toString();
        XMLStreamReader2 sr = this.constructNsStreamReader(input, true);
        TestEscaping.assertTokenType(7, sr.getEventType());
        TestEscaping.assertTokenType(1, sr.next());
        TestEscaping.assertEquals((String)"test", (String)sr.getLocalName());
        TestEscaping.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestEscaping.assertEquals((String)"ns", (String)sr.getNamespacePrefix(0));
        TestEscaping.assertEquals((String)"<tag>", (String)sr.getNamespaceURI(0));
        TestEscaping.assertTokenType(1, sr.next());
        TestEscaping.assertEquals((String)"test", (String)sr.getLocalName());
        TestEscaping.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestEscaping.assertEquals((String)"ns", (String)sr.getNamespacePrefix(0));
        TestEscaping.assertEquals((String)"\"", (String)sr.getNamespaceURI(0));
        TestEscaping.assertTokenType(1, sr.next());
        TestEscaping.assertEquals((String)"test", (String)sr.getLocalName());
        TestEscaping.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestEscaping.assertEquals((String)"ns", (String)sr.getNamespacePrefix(0));
        TestEscaping.assertEquals((String)"x&", (String)sr.getNamespaceURI(0));
        TestEscaping.assertTokenType(2, sr.next());
        TestEscaping.assertTokenType(2, sr.next());
        TestEscaping.assertTokenType(2, sr.next());
        TestEscaping.assertTokenType(8, sr.next());
        sr.close();
    }

    public void testLatin1Quoting() throws XMLStreamException {
        String TEXT = "ab\u00a0cd\tef\u00d8gh\u3c00...";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getNonRepairingWriter(bos, "ISO-8859-1", true);
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeCharacters("ab\u00a0cd\tef\u00d8gh\u3c00...");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
        XMLStreamReader2 sr = this.constructNsStreamReader(in, true);
        TestEscaping.assertTokenType(7, sr.getEventType());
        TestEscaping.assertTokenType(1, sr.next());
        TestEscaping.assertEquals((String)"root", (String)sr.getLocalName());
        TestEscaping.assertTokenType(4, sr.next());
        TestEscaping.assertEquals((String)"ab\u00a0cd\tef\u00d8gh\u3c00...", (String)sr.getText());
        TestEscaping.assertTokenType(2, sr.next());
    }

    public void testAsciiQuoting() throws XMLStreamException {
        String TEXT = "ab\u00a0cd\tef\u00d8gh\u3c00...";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getNonRepairingWriter(bos, "US-ASCII", true);
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeCharacters("ab\u00a0cd\tef\u00d8gh\u3c00...");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
        XMLStreamReader2 sr = this.constructNsStreamReader(in, true);
        TestEscaping.assertTokenType(7, sr.getEventType());
        TestEscaping.assertTokenType(1, sr.next());
        TestEscaping.assertEquals((String)"root", (String)sr.getLocalName());
        TestEscaping.assertTokenType(4, sr.next());
        TestEscaping.assertEquals((String)"ab\u00a0cd\tef\u00d8gh\u3c00...", (String)sr.getText());
        TestEscaping.assertTokenType(2, sr.next());
    }
}

