/*
 * Decompiled with CFR 0.152.
 */
package stax2.wstream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.io.Stax2BlockResult;
import stax2.wstream.BaseWriterTest;

public class TestClosing
extends BaseWriterTest {
    public void testNoAutoCloseWriter() throws XMLStreamException {
        XMLOutputFactory2 f = this.getFactory(false);
        MyWriter output = new MyWriter();
        XMLStreamWriter2 sw = (XMLStreamWriter2)f.createXMLStreamWriter((Writer)output);
        TestClosing.assertFalse((boolean)output.isClosed());
        this.writeDoc((XMLStreamWriter)sw);
        TestClosing.assertFalse((boolean)output.isClosed());
        sw.close();
        TestClosing.assertFalse((boolean)output.isClosed());
        sw.closeCompletely();
        TestClosing.assertTrue((boolean)output.isClosed());
        sw.closeCompletely();
        sw.closeCompletely();
        TestClosing.assertTrue((boolean)output.isClosed());
    }

    public void testNoAutoCloseStream() throws XMLStreamException {
        XMLOutputFactory2 f = this.getFactory(false);
        MyStream output = new MyStream();
        XMLStreamWriter2 sw = (XMLStreamWriter2)f.createXMLStreamWriter((OutputStream)output, "UTF-8");
        TestClosing.assertFalse((boolean)output.isClosed());
        this.writeDoc((XMLStreamWriter)sw);
        TestClosing.assertFalse((boolean)output.isClosed());
        sw.close();
        TestClosing.assertFalse((boolean)output.isClosed());
        sw.closeCompletely();
        TestClosing.assertTrue((boolean)output.isClosed());
        sw.closeCompletely();
        sw.closeCompletely();
        TestClosing.assertTrue((boolean)output.isClosed());
    }

    public void testEnabledAutoClose() throws XMLStreamException {
        XMLOutputFactory2 f = this.getFactory(true);
        MyWriter output = new MyWriter();
        XMLStreamWriter2 sw = (XMLStreamWriter2)f.createXMLStreamWriter((Writer)output);
        TestClosing.assertFalse((boolean)output.isClosed());
        this.writeDoc((XMLStreamWriter)sw);
        sw.close();
        TestClosing.assertTrue((boolean)output.isClosed());
        sw.close();
        sw.close();
        TestClosing.assertTrue((boolean)output.isClosed());
        output = new MyWriter();
        sw = (XMLStreamWriter2)f.createXMLStreamWriter((Writer)output);
        this.writeDoc((XMLStreamWriter)sw);
        TestClosing.assertTrue((boolean)output.isClosed());
    }

    public void testAutoCloseImplicit() throws XMLStreamException {
        XMLOutputFactory2 f = this.getFactory(false);
        MyResult output = new MyResult();
        XMLStreamWriter2 sw = (XMLStreamWriter2)f.createXMLStreamWriter((Result)output);
        TestClosing.assertFalse((boolean)output.isClosed());
        this.writeDoc((XMLStreamWriter)sw);
        sw.close();
        TestClosing.assertFalse((boolean)output.isClosed());
        MyStringResult result = new MyStringResult();
        sw = (XMLStreamWriter2)f.createXMLStreamWriter((Result)((Object)result));
        this.writeDoc((XMLStreamWriter)sw);
        TestClosing.assertTrue((boolean)result.isClosed());
        result = new MyStringResult();
        sw = (XMLStreamWriter2)f.createXMLStreamWriter((Result)((Object)result));
        sw.writeStartDocument();
        sw.writeEmptyElement("test");
        sw.close();
        TestClosing.assertTrue((boolean)result.isClosed());
    }

    XMLOutputFactory2 getFactory(boolean autoClose) {
        XMLOutputFactory2 f = this.getOutputFactory();
        f.setProperty("org.codehaus.stax2.autoCloseOutput", (Object)autoClose);
        return f;
    }

    void writeDoc(XMLStreamWriter sw) throws XMLStreamException {
        sw.writeStartDocument();
        sw.writeEmptyElement("root");
        sw.writeEndDocument();
    }

    private static final class MyStringResult
    extends Stax2BlockResult {
        MyWriter mWriter;

        public Writer constructWriter() {
            this.mWriter = new MyWriter();
            return this.mWriter;
        }

        public OutputStream constructOutputStream() {
            return null;
        }

        public boolean isClosed() {
            return this.mWriter.isClosed();
        }
    }

    static final class MyResult
    extends StreamResult {
        final MyWriter mWriter = new MyWriter();

        private MyResult() {
            this.setWriter(this.mWriter);
        }

        public boolean isClosed() {
            return this.mWriter.isClosed();
        }
    }

    static final class MyStream
    extends ByteArrayOutputStream {
        boolean mIsClosed = false;

        public void close() throws IOException {
            this.mIsClosed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }

    static final class MyWriter
    extends StringWriter {
        boolean mIsClosed = false;

        public void close() throws IOException {
            this.mIsClosed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }
}

