/*
 * Decompiled with CFR 0.152.
 */
package stax2.vwstream;

import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.XMLValidationException;
import stax2.vwstream.BaseOutputTest;

public class TestAttributeValidation
extends BaseOutputTest {
    final String NS_PREFIX = "ns";
    final String NS_PREFIX2 = "ns2";
    final String NS_URI = "http://ns";
    final String FIXED_DTD_STR = "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n";
    final String REQUIRED_DTD_STR = "<!ELEMENT root EMPTY>\n<!ATTLIST root reqAttr CDATA #REQUIRED>\n";
    final String IMPLIED_NS_DTD_STR = "<!ELEMENT root EMPTY>\n<!ATTLIST root ns:attr CDATA #REQUIRED>\n";

    public void testValidFixedAttr() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n", nsAware, repairing);
            sw.writeEmptyElement("root");
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeAttribute("fixAttr", "fixedValue");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
        }
    }

    public void testInvalidFixedAttr() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware;
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[non-namespace-aware]";
                    repairing = false;
                    nsAware = false;
                    break;
                }
                case 1: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    nsAware = true;
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                    nsAware = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeAttribute("fixAttr", "otherValue");
                TestAttributeValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add a #FIXED attribute with 'wrong' value"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            strw = new StringWriter();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeAttribute("fixAttr", "");
                TestAttributeValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add a #FIXED attribute with an empty value"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            strw = new StringWriter();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root fixAttr CDATA #FIXED 'fixedValue'>\n", nsAware, repairing);
            sw.writeEmptyElement("root");
            try {
                sw.writeAttribute("fixAttr", "foobar");
                TestAttributeValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add a #FIXED attribute with an empty value"));
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }

    public void testValidRequiredAttr() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root reqAttr CDATA #REQUIRED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeAttribute("reqAttr", "value");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root reqAttr CDATA #REQUIRED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeAttribute("reqAttr", "");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root reqAttr CDATA #REQUIRED>\n", nsAware, repairing);
            sw.writeEmptyElement("root");
            sw.writeAttribute("reqAttr", "hii & haa");
            sw.writeEndDocument();
            sw.close();
        }
    }

    public void testInvalidRequiredAttr() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware;
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[non-namespace-aware]";
                    repairing = false;
                    nsAware = false;
                    break;
                }
                case 1: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    nsAware = true;
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                    nsAware = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root reqAttr CDATA #REQUIRED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeEndElement();
                TestAttributeValidation.fail((String)(modeDesc + " Expected a validation exception when omitting a #REQUIRED attribute"));
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }

    public void testValidNsAttr() throws XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            boolean repairing = i > 0;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root ns:attr CDATA #REQUIRED>\n", true, repairing);
            sw.writeStartElement("root");
            if (!repairing) {
                sw.writeNamespace("ns", "http://ns");
            }
            sw.writeAttribute("ns", "http://ns", "attr", "value");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
        }
    }

    public void testInvalidNsAttr() throws XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root ns:attr CDATA #REQUIRED>\n", true, repairing);
            sw.writeStartElement("root");
            if (!repairing) {
                sw.writeNamespace("ns", "http://ns");
            }
            try {
                sw.writeAttribute("ns2", "http://ns", "attr", "value");
                TestAttributeValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add an attribute with wrong ns prefix"));
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }
}

