/*
 * Decompiled with CFR 0.152.
 */
package stax2.typed;

import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.w3c.dom.Document;
import stax2.typed.WriterTestBase;

public class TestDOMWriter
extends WriterTestBase {
    Document mDoc;

    protected XMLStreamWriter2 getTypedWriter(ByteArrayOutputStream out, boolean repairing) throws XMLStreamException {
        out.reset();
        XMLOutputFactory2 outf = this.getOutputFactory();
        this.mDoc = this.createDOMDoc(true);
        TestDOMWriter.setRepairing((XMLOutputFactory)outf, repairing);
        return (XMLStreamWriter2)outf.createXMLStreamWriter(new DOMResult(this.mDoc));
    }

    protected byte[] closeWriter(XMLStreamWriter sw, ByteArrayOutputStream out) throws XMLStreamException {
        sw.close();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(this.mDoc), new StreamResult(out));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private Document createDOMDoc(boolean nsAware) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(nsAware);
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

