/*
 * Decompiled with CFR 0.152.
 */
package stax2.typed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import stax2.BaseStax2Test;

public class TestBinaryRoundTrip
extends BaseStax2Test {
    public void testWstx224() throws Exception {
        Base64Variant bv = Base64Variants.MIME;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 writer = this.getTypedWriter(bos);
        byte[] data = new byte[2990];
        Arrays.fill(data, (byte)33);
        writer.writeStartDocument();
        writer.writeStartElement("doc");
        writer.writeStartElement("data");
        writer.writeBinary(bv, data, 0, data.length);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        byte[] xml = bos.toByteArray();
        this._doTest224(data, xml, bv, false);
        this._doTest224(data, xml, bv, true);
    }

    private void _doTest224(byte[] data, byte[] xml, Base64Variant bv, boolean useConvAccessor) throws XMLStreamException {
        XMLStreamReader2 reader = this.getReader(xml);
        byte[] result = null;
        while (reader.hasNext()) {
            if (reader.next() != 1 || !"data".equals(reader.getLocalName())) continue;
            result = this._readBinary(reader, bv, xml.length, useConvAccessor);
            break;
        }
        TestBinaryRoundTrip.assertNotNull(result);
        TestBinaryRoundTrip.assertEquals((int)data.length, (int)result.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == result[i]) continue;
            TestBinaryRoundTrip.fail((String)("Data differs at offset #" + i + "; expected " + data[i] + ", got " + result[i]));
        }
    }

    private byte[] _readBinary(XMLStreamReader2 sr, Base64Variant bv, int expSize, boolean useConvenienceMethod) throws XMLStreamException {
        int offset;
        int count;
        if (useConvenienceMethod) {
            return sr.getElementAsBinary(bv);
        }
        byte[] buffer = new byte[expSize + 100];
        for (offset = 0; offset < buffer.length && (count = sr.readElementAsBinary(buffer, offset, buffer.length - offset, bv)) >= 0; offset += count) {
        }
        byte[] result = new byte[offset];
        System.arraycopy(buffer, 0, result, 0, offset);
        return result;
    }

    private XMLStreamReader2 getReader(byte[] data) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestBinaryRoundTrip.setCoalescing((XMLInputFactory)f, true);
        TestBinaryRoundTrip.setNamespaceAware((XMLInputFactory)f, true);
        return (XMLStreamReader2)f.createXMLStreamReader(new ByteArrayInputStream(data));
    }

    protected XMLStreamWriter2 getTypedWriter(ByteArrayOutputStream out) throws XMLStreamException {
        XMLOutputFactory2 outf = this.getOutputFactory();
        return (XMLStreamWriter2)outf.createXMLStreamWriter(out, "UTF-8");
    }
}

