/*
 * Decompiled with CFR 0.152.
 */
package stax2.typed;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import stax2.BaseStax2Test;

public abstract class ReaderTestBase
extends BaseStax2Test {
    static final long TOO_BIG_FOR_INT = 0x80000000L;
    static final long TOO_SMALL_FOR_INT = -2147483649L;
    static final BigInteger TOO_BIG_FOR_LONG = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(123L));
    static final BigInteger TOO_SMALL_FOR_LONG = BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.valueOf(123L));

    public void testSimpleBooleanElem() throws Exception {
        this.checkBooleanElem("<root>true</root>", true);
        this.checkBooleanElem("<root>\tfalse\n\r</root>", false);
        this.checkBooleanElem("<root>0   \t</root>", false);
        this.checkBooleanElem("<root>\r1</root>", true);
        this.checkBooleanElemException("<root>yes</root>");
        this.checkBooleanElemException("<root>01</root>");
    }

    public void testSimpleBooleanAttr() throws Exception {
        this.checkBooleanAttr("<root attr='true' />", true);
        this.checkBooleanAttr("<root attr=\"\tfalse\n\r\" />", false);
        this.checkBooleanAttr("<root attr='0   \t' />", false);
        this.checkBooleanAttr("<root attr=\"\r1\" />", true);
        this.checkBooleanAttrException("<root attr=\"yes\" />");
        this.checkBooleanAttrException("<root attr='01' />");
    }

    public void testMultipleBooleanAttr() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root a1='true' b=\"false\" third='0' />");
        ReaderTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a1");
        int ix2 = sr.getAttributeIndex("", "b");
        int ix3 = sr.getAttributeIndex("", "third");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            ReaderTestBase.fail((String)("Couldn't find indexes of attributes: a1=" + ix1 + ", b=" + ix2 + ", third=" + ix3));
        }
        ReaderTestBase.assertTrue((boolean)sr.getAttributeAsBoolean(ix1));
        ReaderTestBase.assertFalse((boolean)sr.getAttributeAsBoolean(ix2));
        ReaderTestBase.assertFalse((boolean)sr.getAttributeAsBoolean(ix3));
        sr.close();
    }

    public void testSimpleIntElem() throws Exception {
        this.checkIntElem("<root>000000000000000000000000012</root>", 12);
        this.checkIntElem("<root>0</root>", 0);
        this.checkIntElem("<root>291\t</root>", 291);
        this.checkIntElem("<root>   \t1</root>", 1);
        this.checkIntElem("<root>3 </root>", 3);
        this.checkIntElem("<root>  -7 </root>", -7);
        this.checkIntElem("<root>-1234</root>", -1234);
        this.checkIntElem("<root>+3</root>", 3);
        this.checkIntElem("<root>-0</root>", 0);
        this.checkIntElem("<root>-0000</root>", 0);
        this.checkIntElem("<root>-001</root>", -1);
        this.checkIntElem("<root>+0</root>", 0);
        this.checkIntElem("<root>+0  </root>", 0);
        this.checkIntElem("<root>+00</root>", 0);
        this.checkIntElem("<root>000000000000000000000000012</root>", 12);
        this.checkIntElem("<root>-00000000</root>", 0);
        int v = 1200300400;
        this.checkIntElem("<root>   \r\n+" + v + "</root>", v);
        this.checkIntElem("<root> 2147483647</root>", Integer.MAX_VALUE);
        this.checkIntElem("<root> -2147483648</root>", Integer.MIN_VALUE);
        this.checkIntElemException("<root>12a3</root>");
        this.checkIntElemException("<root>5000100200</root>");
        this.checkIntElemException("<root>3100200300</root>");
        this.checkIntElemException("<root>-4100200300</root>");
        this.checkIntElemException("<root>2147483648</root>");
        this.checkIntElemException("<root>-2147483649</root>");
        this.checkIntElemException("<root>-  </root>");
        this.checkIntElemException("<root>+</root>");
        this.checkIntElemException("<root> -</root>");
    }

    public void testSimpleIntAttr() throws Exception {
        this.checkIntAttr("<root attr='+0   \t' />", 0);
        this.checkIntAttr("<root attr='13' />", 13);
        this.checkIntAttr("<root attr='123' />", 123);
        this.checkIntAttr("<root attr=\"\t-12\n\r\" />", -12);
        this.checkIntAttr("<root attr='+0   \t' />", 0);
        this.checkIntAttr("<root attr=\"\r-00\" />", 0);
        this.checkIntAttr("<root attr='-000000000000012345' />", -12345);
        this.checkIntAttr("<root attr='2147483647  ' />", Integer.MAX_VALUE);
        this.checkIntAttr("<root attr='-2147483648'  />", Integer.MIN_VALUE);
        this.checkIntAttrException("<root attr=\"abc\" />");
        this.checkIntAttrException("<root attr='1c' />");
        this.checkIntAttrException("<root attr='\n2147483648' />");
        this.checkIntAttrException("<root attr=\"-2147483649   \" />");
        this.checkIntAttrException("<root attr='-' />");
        this.checkIntAttrException("<root attr='  + ' />");
    }

    public void testMultipleIntAttr() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root a1='123456789' b=\"-123456789\" third='0' />");
        ReaderTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a1");
        int ix2 = sr.getAttributeIndex("", "b");
        int ix3 = sr.getAttributeIndex("", "third");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            ReaderTestBase.fail((String)("Couldn't find indexes of attributes: a1=" + ix1 + ", b=" + ix2 + ", third=" + ix3));
        }
        ReaderTestBase.assertEquals((int)123456789, (int)sr.getAttributeAsInt(ix1));
        ReaderTestBase.assertEquals((int)-123456789, (int)sr.getAttributeAsInt(ix2));
        ReaderTestBase.assertEquals((int)0, (int)sr.getAttributeAsInt(ix3));
        sr.close();
    }

    public void testSimpleLongElem() throws Exception {
        this.checkLongElem("<root>000000000000000000000000012</root>", 12L);
        this.checkLongElem("<root>0</root>", 0L);
        this.checkLongElem("<root>10091\t</root>", 10091L);
        this.checkLongElem("<root>   \t-1</root>", -1L);
        this.checkLongElem("<root>39876 </root>", 39876L);
        this.checkLongElem("<root>  0701 </root>", 701L);
        this.checkLongElem("<root>-1234</root>", -1234L);
        this.checkLongElem("<root>+3</root>", 3L);
        this.checkLongElem("<root>-0</root>", 0L);
        this.checkLongElem("<root>-001</root>", -1L);
        this.checkLongElem("<root>+0</root>", 0L);
        this.checkLongElem("<root>0000000000000001234567890</root>", 1234567890L);
        this.checkLongElem("<root>-00000000</root>", 0L);
        long v = 1200300400500600L;
        this.checkLongElem("<root>   \r" + v + "</root>", v);
        this.checkLongElem("<root>   \r\n+" + v + "</root>", v);
        v = -1234567890123456789L;
        this.checkLongElem("<root>   \r\n" + v + "</root>", v);
        this.checkLongElem("<root> 9223372036854775807</root>", Long.MAX_VALUE);
        this.checkLongElem("<root> -9223372036854775808</root>", Long.MIN_VALUE);
        this.checkLongElemException("<root>12a3</root>");
        this.checkLongElemException("<root>" + TOO_BIG_FOR_LONG + "</root>");
        this.checkLongElemException("<root>" + TOO_SMALL_FOR_LONG + "</root>");
        this.checkLongElemException("<root>-  </root>");
        this.checkLongElemException("<root>+</root>");
        this.checkLongElemException("<root> -</root>");
    }

    public void testSimpleLongAttr() throws Exception {
        this.checkLongAttr("<root attr='+0   \t' />", 0L);
        this.checkLongAttr("<root attr='13' />", 13L);
        this.checkLongAttr("<root attr='123' />", 123L);
        this.checkLongAttr("<root attr=\"\t-12\n\r\" />", -12L);
        this.checkLongAttr("<root attr='+0   \t' />", 0L);
        this.checkLongAttr("<root attr=\"\r-00\" />", 0L);
        this.checkLongAttr("<root attr='-000000000000012345' />", -12345L);
        this.checkLongAttr("<root attr='9223372036854775807  ' />", Long.MAX_VALUE);
        this.checkLongAttr("<root attr='-9223372036854775808'  />", Long.MIN_VALUE);
        this.checkLongAttrException("<root attr=\"abc\" />");
        this.checkLongAttrException("<root attr='1c' />");
        this.checkLongAttrException("<root attr='\n" + TOO_BIG_FOR_LONG + "' />");
        this.checkLongAttrException("<root attr=\"" + TOO_SMALL_FOR_LONG + "   \" />");
        this.checkLongAttrException("<root attr='-' />");
        this.checkLongAttrException("<root attr='  + ' />");
    }

    public void testMultipleLongAttr() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root a1='12345678900' b=\"-12345678900\" third='0' />");
        ReaderTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a1");
        int ix2 = sr.getAttributeIndex("", "b");
        int ix3 = sr.getAttributeIndex("", "third");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            ReaderTestBase.fail((String)("Couldn't find indexes of attributes: a1=" + ix1 + ", b=" + ix2 + ", third=" + ix3));
        }
        ReaderTestBase.assertEquals((long)12345678900L, (long)sr.getAttributeAsLong(ix1));
        ReaderTestBase.assertEquals((long)-12345678900L, (long)sr.getAttributeAsLong(ix2));
        ReaderTestBase.assertEquals((long)0L, (long)sr.getAttributeAsLong(ix3));
        sr.close();
    }

    public void testSimpleFloatElem() throws Exception {
        this.checkFloatElem("<root>0.0</root>", 0.0f);
        this.checkFloatElem("<root>0</root>", 0.0f);
        this.checkFloatElem("<root>1.0\t</root>", 1.0f);
        this.checkFloatElem("<root>   \t-0.1</root>", -0.1f);
        this.checkFloatElem("<root>+.001 </root>", 0.001f);
        this.checkFloatElem("<root>  -3.1415 </root>", -3.1415f);
        this.checkFloatElem("<root>27.3E-01</root>", 0.273f);
        this.checkFloatElem("<root> 3.4028235E38</root>", Float.MAX_VALUE);
        this.checkFloatElem("<root> 1.4E-45</root>", Float.MIN_VALUE);
        this.checkFloatElem("<root> NaN</root>", Float.NaN);
        this.checkFloatElem("<root>INF  </root>", Float.POSITIVE_INFINITY);
        this.checkFloatElem("<root>\t-INF\t</root>", Float.NEGATIVE_INFINITY);
        this.checkFloatElemException("<root>abcd</root>");
        this.checkFloatElemException("<root>-  </root>");
        this.checkFloatElemException("<root>+</root>");
        this.checkFloatElemException("<root> -</root>");
        this.checkFloatElemException("<root>1e</root>");
    }

    public void testSimpleFloatAttr() throws Exception {
        this.checkFloatAttr("<root attr='+0.1   \t' />", 0.1f);
        this.checkFloatAttr("<root attr='13.23' />", 13.23f);
        this.checkFloatAttr("<root attr='0.123' />", 0.123f);
        this.checkFloatAttr("<root attr=\"\t-12.03\n\r\" />", -12.03f);
        this.checkFloatAttr("<root attr='+0   \t' />", 0.0f);
        this.checkFloatAttr("<root attr=\"\r-00\" />", 0.0f);
        this.checkFloatAttr("<root attr='-000000000000012345' />", -12345.0f);
        this.checkFloatAttr("<root attr='3.4028235E38  ' />", Float.MAX_VALUE);
        this.checkFloatAttr("<root attr='1.4E-45'  />", Float.MIN_VALUE);
        this.checkFloatAttr("<root attr='NaN'/>", Float.NaN);
        this.checkFloatAttr("<root attr=' INF' />", Float.POSITIVE_INFINITY);
        this.checkFloatAttr("<root attr='-INF  ' />", Float.NEGATIVE_INFINITY);
        this.checkFloatAttrException("<root attr=\"abc\" />");
        this.checkFloatAttrException("<root attr='1c' />");
        this.checkFloatAttrException("<root attr='-' />");
        this.checkFloatAttrException("<root attr='  + ' />");
    }

    public void testMultipleFloatAttr() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root a1='-123.456' b=\"0.003\" third='-0.0' />");
        ReaderTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a1");
        int ix2 = sr.getAttributeIndex("", "b");
        int ix3 = sr.getAttributeIndex("", "third");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            ReaderTestBase.fail((String)("Couldn't find indexes of attributes: a1=" + ix1 + ", b=" + ix2 + ", third=" + ix3));
        }
        this.assertEquals(-123.456f, sr.getAttributeAsFloat(ix1));
        this.assertEquals(0.003f, sr.getAttributeAsFloat(ix2));
        this.assertEquals(-0.0f, sr.getAttributeAsFloat(ix3));
        sr.close();
    }

    public void testSimpleDoubleElem() throws Exception {
        this.checkDoubleElem("<root>0.0</root>", 0.0);
        this.checkDoubleElem("<root>0</root>", 0.0);
        this.checkDoubleElem("<root>1.0\t</root>", 1.0);
        this.checkDoubleElem("<root>   \t-0.1</root>", -0.1f);
        this.checkDoubleElem("<root>+.001 </root>", 0.001f);
        this.checkDoubleElem("<root>  -3.1415 </root>", -3.1415f);
        this.checkDoubleElem("<root>27.3E-01</root>", 0.273f);
        this.checkDoubleElem("<root> 1.7976931348623157E308</root>", Double.MAX_VALUE);
        this.checkDoubleElem("<root> 4.9E-324</root>", Double.MIN_VALUE);
        this.checkDoubleElem("<root> NaN</root>", Double.NaN);
        this.checkDoubleElem("<root>INF  </root>", Double.POSITIVE_INFINITY);
        this.checkDoubleElem("<root>\t-INF\t</root>", Double.NEGATIVE_INFINITY);
        this.checkDoubleElemException("<root>abcd</root>");
        this.checkDoubleElemException("<root>-  </root>");
        this.checkDoubleElemException("<root>+</root>");
        this.checkDoubleElemException("<root> -</root>");
        this.checkDoubleElemException("<root>1e</root>");
    }

    public void testSimpleDoubleAttr() throws Exception {
        this.checkDoubleAttr("<root attr='+0.1   \t' />", 0.1f);
        this.checkDoubleAttr("<root attr='13.23' />", 13.23f);
        this.checkDoubleAttr("<root attr='0.123' />", 0.123f);
        this.checkDoubleAttr("<root attr=\"\t-12.03\n\r\" />", -12.03f);
        this.checkDoubleAttr("<root attr='+0   \t' />", 0.0);
        this.checkDoubleAttr("<root attr=\"\r-00\" />", 0.0);
        this.checkDoubleAttr("<root attr='-000000000000012345' />", -12345.0);
        this.checkDoubleAttr("<root attr='1.7976931348623157E308  ' />", Double.MAX_VALUE);
        this.checkDoubleAttr("<root attr='4.9E-324'  />", Double.MIN_VALUE);
        this.checkDoubleAttr("<root attr='NaN'/>", Double.NaN);
        this.checkDoubleAttr("<root attr=' INF' />", Double.POSITIVE_INFINITY);
        this.checkDoubleAttr("<root attr='-INF  ' />", Double.NEGATIVE_INFINITY);
        this.checkDoubleAttrException("<root attr=\"abc\" />");
        this.checkDoubleAttrException("<root attr='1c' />");
        this.checkDoubleAttrException("<root attr='-' />");
        this.checkDoubleAttrException("<root attr='  + ' />");
    }

    public void testMultipleDoubleAttr() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root a1='-123.456' b=\"0.003\" third='-0.0' />");
        ReaderTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a1");
        int ix2 = sr.getAttributeIndex("", "b");
        int ix3 = sr.getAttributeIndex("", "third");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            ReaderTestBase.fail((String)("Couldn't find indexes of attributes: a1=" + ix1 + ", b=" + ix2 + ", third=" + ix3));
        }
        this.assertEquals((double)-123.456f, sr.getAttributeAsDouble(ix1));
        this.assertEquals((double)0.003f, sr.getAttributeAsDouble(ix2));
        this.assertEquals(-0.0, sr.getAttributeAsDouble(ix3));
        sr.close();
    }

    public void testBigInteger() throws Exception {
        BigInteger I = BigInteger.valueOf(3L);
        Random rnd = new Random(1L);
        for (int i = 1; i < 200; ++i) {
            String istr = I.toString();
            switch (i % 4) {
                case 0: {
                    istr = " \t " + istr;
                    break;
                }
                case 1: {
                    istr = istr + "\r";
                    break;
                }
                case 2: {
                    istr = "\n" + istr + " ";
                }
            }
            XMLStreamReader2 sr = this.getRootReader("<root>" + istr + "</root>");
            ReaderTestBase.assertEquals((Object)I, (Object)sr.getElementAsInteger());
            sr.close();
            String doc = "<root attr='" + istr + "' />";
            sr = this.getRootReader(doc);
            ReaderTestBase.assertEquals((Object)I, (Object)sr.getAttributeAsInteger(0));
            sr.close();
            istr = I.toString();
            switch (i % 3) {
                case 0: {
                    istr = "ab" + istr;
                    break;
                }
                case 1: {
                    istr = istr + "!";
                    break;
                }
                case 2: {
                    istr = istr + ".0";
                }
            }
            sr = this.getRootReader("<root>" + istr + "</root>");
            try {
                sr.getElementAsInteger();
                ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
            }
            catch (TypedXMLStreamException xse) {
                // empty catch block
            }
            sr.close();
            sr = this.getRootReader("<root attr='" + istr + " '/>");
            try {
                sr.getAttributeAsInteger(0);
                ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
            }
            catch (TypedXMLStreamException xse) {
                // empty catch block
            }
            sr.close();
            I = I.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(rnd.nextInt() & 0xF));
            if (i % 3 != 0) continue;
            I = I.negate();
        }
    }

    public void testBigDecimal() throws Exception {
        BigDecimal D = BigDecimal.valueOf(1L);
        Random rnd = new Random(6L);
        for (int i = 1; i < 200; ++i) {
            String istr = D.toString();
            switch (i % 4) {
                case 0: {
                    istr = "\t" + istr;
                    break;
                }
                case 1: {
                    istr = istr + "  ";
                    break;
                }
                case 2: {
                    istr = " " + istr + "\r";
                }
            }
            XMLStreamReader2 sr = this.getRootReader("<root>" + istr + "</root>");
            ReaderTestBase.assertEquals((Object)D, (Object)sr.getElementAsDecimal());
            sr.close();
            String doc = "<root attr='" + istr + "' />";
            sr = this.getRootReader(doc);
            ReaderTestBase.assertEquals((Object)D, (Object)sr.getAttributeAsDecimal(0));
            sr.close();
            istr = D.toString();
            switch (i % 3) {
                case 0: {
                    istr = "_x" + istr;
                    break;
                }
                case 1: {
                    istr = istr + "?";
                    break;
                }
                case 2: {
                    istr = istr + "e";
                }
            }
            sr = this.getRootReader("<root>" + istr + "</root>");
            try {
                sr.getElementAsDecimal();
                ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
            }
            catch (TypedXMLStreamException xse) {
                // empty catch block
            }
            sr.close();
            sr = this.getRootReader("<root attr='" + istr + " '/>");
            try {
                sr.getAttributeAsDecimal(0);
                ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
            }
            catch (TypedXMLStreamException xse) {
                // empty catch block
            }
            sr.close();
            D = D.add(BigDecimal.valueOf(rnd.nextInt() & 0xF)).divide(BigDecimal.valueOf(10L));
            if (i % 3 != 0) continue;
            D = D.negate();
        }
    }

    public void testValidQNameElem() throws Exception {
        String URI2 = "http://test.org/";
        String XML = "<root xmlns:ns='" + URI2 + "'>ns:name  </root>";
        XMLStreamReader2 sr = this.getRootReader(XML);
        QName n = sr.getElementAsQName();
        ReaderTestBase.assertNotNull((Object)n);
        ReaderTestBase.assertEquals((String)"name", (String)n.getLocalPart());
        ReaderTestBase.assertEquals((String)"ns", (String)n.getPrefix());
        ReaderTestBase.assertEquals((String)URI2, (String)n.getNamespaceURI());
        sr.close();
    }

    public void testInvalidQNameElemUnbound() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root>ns:name  </root>");
        try {
            sr.getElementAsQName();
            ReaderTestBase.fail((String)"Expected an exception for unbound QName prefix");
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
        sr.close();
    }

    public void testInvalidQNameElemBadChars() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root xmlns:ns='http://foo'>ns:na?me</root>");
        try {
            sr.getElementAsQName();
            ReaderTestBase.fail((String)"Expected an exception for invalid QName (non-xml-name char in the middle)");
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
        sr.close();
    }

    public void testValidQNameAttr() throws Exception {
        String URI2 = "http://test.org/";
        String XML = "<root xmlns:abc='" + URI2 + "' attr='   abc:x1\n' />";
        XMLStreamReader2 sr = this.getRootReader(XML);
        QName n = sr.getAttributeAsQName(0);
        ReaderTestBase.assertNotNull((Object)n);
        ReaderTestBase.assertEquals((String)"x1", (String)n.getLocalPart());
        ReaderTestBase.assertEquals((String)"abc", (String)n.getPrefix());
        ReaderTestBase.assertEquals((String)URI2, (String)n.getNamespaceURI());
        sr.close();
    }

    public void testInvalidQNameAttrUnbound() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root attr='ns:name  ' />");
        try {
            sr.getAttributeAsQName(0);
            ReaderTestBase.fail((String)"Expected an exception for unbound QName prefix");
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
        sr.close();
    }

    public void testInvalidQNameAttrBadChars() throws Exception {
        XMLStreamReader2 sr = this.getRootReader("<root xmlns:ns='http://foo' attr='ns:name:too' />");
        try {
            sr.getAttributeAsQName(0);
            ReaderTestBase.fail((String)"Expected an exception for invalid QName (non-xml-name char in the middle)");
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
        sr.close();
    }

    private void checkBooleanElem(String doc, boolean expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        ReaderTestBase.assertEquals((boolean)expState, (boolean)sr.getElementAsBoolean());
        sr.close();
    }

    private void checkBooleanAttr(String doc, boolean expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        boolean actState = sr.getAttributeAsBoolean(0);
        ReaderTestBase.assertEquals((boolean)expState, (boolean)actState);
        sr.close();
    }

    private void checkBooleanElemException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getElementAsBoolean();
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkBooleanAttrException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getAttributeAsBoolean(0);
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkIntElem(String doc, int expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        ReaderTestBase.assertEquals((int)expState, (int)sr.getElementAsInt());
        sr.close();
    }

    private void checkIntAttr(String doc, int expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        int actState = sr.getAttributeAsInt(0);
        ReaderTestBase.assertEquals((int)expState, (int)actState);
        sr.close();
    }

    private void checkIntElemException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getElementAsInt();
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkIntAttrException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getAttributeAsInt(0);
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkLongElem(String doc, long expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        ReaderTestBase.assertEquals((long)expState, (long)sr.getElementAsLong());
        sr.close();
    }

    private void checkLongAttr(String doc, long expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        long actState = sr.getAttributeAsLong(0);
        ReaderTestBase.assertEquals((long)expState, (long)actState);
        sr.close();
    }

    private void checkLongElemException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getElementAsLong();
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkLongAttrException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getAttributeAsLong(0);
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkFloatElem(String doc, float expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        this.assertEquals(expState, sr.getElementAsFloat());
        sr.close();
    }

    private void checkFloatAttr(String doc, float expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        float actState = sr.getAttributeAsFloat(0);
        this.assertEquals(expState, actState);
        sr.close();
    }

    private void checkFloatElemException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getElementAsFloat();
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkFloatAttrException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getAttributeAsFloat(0);
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkDoubleElem(String doc, double expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        this.assertEquals(expState, sr.getElementAsDouble());
        sr.close();
    }

    private void checkDoubleAttr(String doc, double expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        double actState = sr.getAttributeAsDouble(0);
        this.assertEquals(expState, actState);
        sr.close();
    }

    private void checkDoubleElemException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getElementAsDouble();
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    private void checkDoubleAttrException(String doc) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(doc);
        try {
            sr.getAttributeAsDouble(0);
            ReaderTestBase.fail((String)("Expected exception for invalid input [" + doc + "]"));
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            // empty catch block
        }
    }

    protected abstract XMLStreamReader2 getReader(String var1) throws Exception;

    private void assertEquals(float a, float b) {
        if (Float.isNaN(a)) {
            ReaderTestBase.assertTrue((boolean)Float.isNaN(b));
        } else if (a != b) {
            ReaderTestBase.assertEquals((float)a, (float)b, (float)1000.0f);
        }
    }

    private void assertEquals(double a, double b) {
        if (Double.isNaN(a)) {
            ReaderTestBase.assertTrue((boolean)Double.isNaN(b));
        } else if (a != b) {
            ReaderTestBase.assertEquals((double)a, (double)b, (double)1000.0);
        }
    }

    protected XMLStreamReader2 getRootReader(String str) throws XMLStreamException {
        XMLStreamReader2 sr;
        try {
            sr = this.getReader(str);
        }
        catch (XMLStreamException xse) {
            throw xse;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
        ReaderTestBase.assertTokenType(7, sr.getEventType());
        while (sr.next() != 1) {
        }
        ReaderTestBase.assertTokenType(1, sr.getEventType());
        return sr;
    }
}

