/*
 * Decompiled with CFR 0.152.
 */
package stax2.typed;

import java.util.Random;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.typed.ValueEncoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import stax2.BaseStax2Test;

public abstract class ReaderBinaryTestBase
extends BaseStax2Test {
    static final Base64Variant[] sBase64Variants = new Base64Variant[]{Base64Variants.MIME, Base64Variants.PEM, Base64Variants.MODIFIED_FOR_URL};
    static final Base64Variant[] sPaddingVariants = new Base64Variant[]{Base64Variants.MIME, Base64Variants.PEM};
    static final Base64Variant[] sNonPaddingVariants = new Base64Variant[]{Base64Variants.MODIFIED_FOR_URL};
    static final int[] LEN_ELEM = new int[]{1, 2, 3, 4, 7, 39, 116, 400, 900, 5003, 17045, 125000, 499999};
    static final int[] LEN_ATTR = new int[]{1, 2, 3, 5, 17, 59, 357, 1920, 9000, 63000, 257010};
    static final int[] LEN_ELEM_MULTIPLE = new int[]{4, 7, 16, 99, 458, 3000, 12888, 79003, 145000};
    static final int METHOD_SINGLE = 1;
    static final int METHOD_FULL = 2;
    static final int METHOD_2BYTES = 3;
    static final int METHOD_SEGMENTED = 4;
    static final int METHOD_FULL_CONVENIENT = 5;
    static final String[] INVALID_PADDING = new String[]{"AAAA====", "AAAAB===", "AA=A"};
    static final String[] INVALID_WS = new String[]{"AAA A", "AAAA BBBB C CCC", "ABCD ABCD AB CD"};
    final String[] INVALID_WEIRD_CHARS = new String[]{"AAA?", "AAAA@@@@", "ABCD\u00a0BCD"};

    protected abstract XMLStreamReader2 getReader(String var1) throws XMLStreamException;

    protected XMLStreamReader2 getElemReader(String contents) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(contents);
        ReaderBinaryTestBase.assertTokenType(1, sr.next());
        return sr;
    }

    public void testBinaryElemByteByByte() throws XMLStreamException {
        this._testBinaryElem(1, false);
        this._testBinaryElem(1, true);
    }

    public void testBinaryElemFull() throws XMLStreamException {
        this._testBinaryElem(2, false);
        this._testBinaryElem(2, true);
    }

    public void testBinaryElem2Bytes() throws XMLStreamException {
        this._testBinaryElem(3, false);
        this._testBinaryElem(3, true);
    }

    public void testBinaryElemSegmented() throws XMLStreamException {
        this._testBinaryElem(4, false);
        this._testBinaryElem(4, true);
    }

    public void testBinaryElemFullConvenient() throws XMLStreamException {
        this._testBinaryElem(5, false);
        this._testBinaryElem(5, true);
    }

    public void testMultipleBinaryElems() throws XMLStreamException {
        int REPS = 3;
        for (int bv = 0; bv < sBase64Variants.length; ++bv) {
            Base64Variant b64variant = sBase64Variants[bv];
            for (int x = 0; x < LEN_ELEM_MULTIPLE.length; ++x) {
                int size = LEN_ELEM_MULTIPLE[x];
                Random r = new Random(size + 1);
                byte[][] dataTable = this.generateDataTable(r, size, 3);
                String doc = this.buildMultiElemDoc(b64variant, dataTable);
                XMLStreamReader2 sr = this.getElemReader(doc);
                for (int i = 0; i < 3; ++i) {
                    ReaderBinaryTestBase.assertTokenType(1, sr.next());
                    this._verifyElemData1(sr, b64variant, dataTable[i]);
                    if (sr.getEventType() == 2) {
                        ReaderBinaryTestBase.fail((String)"Should not have yet advanced to END_ELEMENT, when decoding not finished");
                    }
                    while (4 == sr.next()) {
                    }
                    ReaderBinaryTestBase.assertTokenType(2, sr.getEventType());
                }
                sr.close();
            }
        }
    }

    public void testBinaryMixedSegments() throws XMLStreamException {
        Random r = new Random(123L);
        int SIZE = 128000;
        byte[] data = this.generateData(r, 128000);
        char[] buffer = new char[100];
        for (int bv = 0; bv < sPaddingVariants.length; ++bv) {
            Base64Variant b64variant = sPaddingVariants[bv];
            StringBuffer b64 = new StringBuffer(data.length * 2);
            int ptr = 0;
            do {
                int chunkLen = 1 + (r.nextInt() & 7);
                ValueEncoderFactory.Base64Encoder enc = new ValueEncoderFactory().getEncoder(b64variant, data, ptr, chunkLen);
                ptr += chunkLen;
                int len = enc.encodeMore(buffer, 0, buffer.length);
                b64.append(buffer, 0, len);
            } while (b64.length() < 128000);
            int byteLen = ptr;
            String refDoc = "<root>" + b64.toString() + "</root>";
            XMLStreamReader2 sr = this.getElemReader(refDoc);
            this._verifyElemData(sr, b64variant, r, data, byteLen, 2);
            sr.close();
            StringBuffer sb = new StringBuffer(b64.length() * 2);
            sb.append("<root>");
            ptr = 0;
            boolean cdata = false;
            while (ptr < b64.length()) {
                int segLen = 1 + (r.nextInt() & 7);
                if (cdata) {
                    sb.append("<![CDATA[");
                }
                segLen = Math.min(segLen, b64.length() - ptr);
                for (int i = 0; i < segLen; ++i) {
                    sb.append(b64.charAt(ptr++));
                }
                if (cdata) {
                    sb.append("]]>");
                }
                cdata = !cdata;
            }
            sb.append("</root>");
            String actualDoc = sb.toString();
            XMLStreamReader2 sr2 = this.getElemReader(actualDoc);
            this._verifyElemData(sr2, b64variant, r, data, byteLen, 1);
            sr2.close();
        }
    }

    private void _testBinaryElem(int readMethod, boolean addNoise) throws XMLStreamException {
        for (int bv = 0; bv < sBase64Variants.length; ++bv) {
            Base64Variant b64variant = sBase64Variants[bv];
            for (int x = 0; x < LEN_ELEM.length; ++x) {
                int size = LEN_ELEM[x];
                Random r = new Random(size);
                byte[] data = this.generateData(r, size);
                String doc = this.buildDoc(b64variant, r, data, addNoise);
                XMLStreamReader2 sr = this.getElemReader(doc);
                this._verifyElemData(sr, b64variant, r, data, data.length, readMethod);
                sr.close();
            }
        }
    }

    private void _verifyElemData(XMLStreamReader2 sr, Base64Variant b64variant, Random r, byte[] data, int dataLen, int readMethod) throws XMLStreamException {
        switch (readMethod) {
            case 1: {
                int count;
                byte[] buffer = new byte[5];
                int ptr = 0;
                while ((count = sr.readElementAsBinary(buffer, 2, 1, b64variant)) > 0) {
                    ReaderBinaryTestBase.assertEquals((int)1, (int)count);
                    if (ptr + 1 < dataLen && data[ptr] != buffer[2]) {
                        ReaderBinaryTestBase.fail((String)("(base64 variant " + b64variant + ") Corrupt decode at #" + ptr + "/" + dataLen + ", expected " + ReaderBinaryTestBase.displayByte(data[ptr]) + ", got " + ReaderBinaryTestBase.displayByte(buffer[2])));
                    }
                    ++ptr;
                }
                if (ptr == dataLen) break;
                ReaderBinaryTestBase.fail((String)("(base64 variant " + b64variant + ") Expected to get " + dataLen + " bytes, got " + ptr));
                break;
            }
            case 2: {
                byte[] buffer = new byte[dataLen + 100];
                int count = sr.readElementAsBinary(buffer, 3, buffer.length - 3, b64variant);
                ReaderBinaryTestBase.assertEquals((int)dataLen, (int)count);
                for (int i = 0; i < dataLen; ++i) {
                    if (buffer[3 + i] == data[i]) continue;
                    ReaderBinaryTestBase.fail((String)("(base64 variant " + b64variant + ") Corrupt decode at #" + i + ", expected " + ReaderBinaryTestBase.displayByte(data[i]) + ", got " + ReaderBinaryTestBase.displayByte(buffer[3 + i])));
                }
                break;
            }
            case 5: {
                byte[] result = sr.getElementAsBinary(b64variant);
                ReaderBinaryTestBase.assertEquals((int)dataLen, (int)result.length);
                for (int i = 0; i < dataLen; ++i) {
                    if (result[i] == data[i]) continue;
                    ReaderBinaryTestBase.fail((String)("(base64 variant " + b64variant + ") Corrupt decode at #" + i + ", expected " + ReaderBinaryTestBase.displayByte(data[i]) + ", got " + ReaderBinaryTestBase.displayByte(result[i])));
                }
                break;
            }
            default: {
                int len;
                int count;
                boolean random = readMethod != 3;
                byte[] buffer = new byte[200];
                int ptr = 0;
                while ((count = sr.readElementAsBinary(buffer, 0, len = random ? 20 + (r.nextInt() & 0x7F) : 2, b64variant)) >= 0) {
                    if (ptr + count > dataLen) {
                        ptr += count;
                        break;
                    }
                    for (int i = 0; i < count; ++i) {
                        if (data[ptr + i] == buffer[i]) continue;
                        ReaderBinaryTestBase.fail((String)("(base64 variant " + b64variant + ") Corrupt decode at #" + (ptr + i) + "/" + dataLen + " (read len: " + len + "; got " + count + "), expected " + ReaderBinaryTestBase.displayByte(data[ptr + i]) + ", got " + ReaderBinaryTestBase.displayByte(buffer[i])));
                    }
                    ptr += count;
                }
                if (ptr == dataLen) break;
                ReaderBinaryTestBase.fail((String)("(base64 variant " + b64variant + ") Expected " + dataLen + " bytes, got " + ptr));
            }
        }
        ReaderBinaryTestBase.assertTokenType(2, sr.getEventType());
    }

    private void _verifyElemData1(XMLStreamReader2 sr, Base64Variant b64variant, byte[] data) throws XMLStreamException {
        byte[] buffer = new byte[5];
        ReaderBinaryTestBase.assertEquals((int)1, (int)sr.readElementAsBinary(buffer, 1, 1, b64variant));
        ReaderBinaryTestBase.assertEquals((byte)data[0], (byte)buffer[1]);
    }

    public void testInvalidElemPadding() throws XMLStreamException {
        byte[] resultBuffer = new byte[20];
        for (int bv = 0; bv < sPaddingVariants.length; ++bv) {
            Base64Variant b64variant = sPaddingVariants[bv];
            for (int i = 0; i < INVALID_PADDING.length; ++i) {
                String doc = "<root>" + INVALID_PADDING[i] + "</root>";
                XMLStreamReader2 sr = this.getElemReader(doc);
                try {
                    sr.readElementAsBinary(resultBuffer, 0, resultBuffer.length, b64variant);
                    ReaderBinaryTestBase.fail((String)"Should have received an exception for invalid padding");
                }
                catch (TypedXMLStreamException ex) {
                    // empty catch block
                }
                sr.close();
            }
        }
    }

    public void testInvalidWhitespace() throws XMLStreamException {
        byte[] resultBuffer = new byte[20];
        for (int bv = 0; bv < sBase64Variants.length; ++bv) {
            Base64Variant b64variant = sBase64Variants[bv];
            for (int i = 0; i < INVALID_WS.length; ++i) {
                String doc = "<root>" + INVALID_WS[i] + "</root>";
                XMLStreamReader2 sr = this.getElemReader(doc);
                try {
                    sr.readElementAsBinary(resultBuffer, 0, resultBuffer.length, b64variant);
                    ReaderBinaryTestBase.fail((String)"Should have received an exception for white space used 'inside' 4-char base64 unit");
                }
                catch (TypedXMLStreamException ex) {
                    // empty catch block
                }
                sr.close();
            }
        }
    }

    public void testInvalidWeirdChars() throws XMLStreamException {
        byte[] resultBuffer = new byte[20];
        for (int bv = 0; bv < sBase64Variants.length; ++bv) {
            Base64Variant b64variant = sBase64Variants[bv];
            for (int i = 0; i < this.INVALID_WEIRD_CHARS.length; ++i) {
                String doc = "<root>" + this.INVALID_WEIRD_CHARS[i] + "</root>";
                XMLStreamReader2 sr = this.getElemReader(doc);
                try {
                    sr.readElementAsBinary(resultBuffer, 0, resultBuffer.length, b64variant);
                    ReaderBinaryTestBase.fail((String)"Should have received an exception for invalid base64 character");
                }
                catch (TypedXMLStreamException ex) {
                    // empty catch block
                }
                sr.close();
            }
        }
    }

    public void testIncompleteInvalidElem() throws XMLStreamException {
        byte[] data = new byte[6];
        byte[] resultBuffer = new byte[20];
        for (int bv = 0; bv < sPaddingVariants.length; ++bv) {
            Base64Variant b64variant = sPaddingVariants[bv];
            for (int i = 1; i <= data.length; ++i) {
                ValueEncoderFactory.Base64Encoder enc = new ValueEncoderFactory().getEncoder(b64variant, data, 0, i);
                char[] cbuf = new char[20];
                int clen = enc.encodeMore(cbuf, 0, cbuf.length);
                for (int j = 1; j <= 3; ++j) {
                    int testLen = clen - j;
                    StringBuffer sb = new StringBuffer();
                    sb.append("<root>");
                    sb.append(cbuf, 0, testLen);
                    sb.append("</root>");
                    XMLStreamReader2 sr = this.getElemReader(sb.toString());
                    try {
                        sr.readElementAsBinary(resultBuffer, 0, resultBuffer.length, b64variant);
                        ReaderBinaryTestBase.fail((String)"Should have received an exception for incomplete base64 unit");
                    }
                    catch (TypedXMLStreamException ex) {
                        // empty catch block
                    }
                    sr.close();
                }
            }
        }
    }

    public void testBinaryAttrValid() throws XMLStreamException {
        int REPS = 3;
        for (int j = 0; j < 3; ++j) {
            for (int bv = 0; bv < sBase64Variants.length; ++bv) {
                Base64Variant b64variant = sBase64Variants[bv];
                for (int i = 0; i < LEN_ATTR.length; ++i) {
                    int size = LEN_ATTR[i];
                    byte[] data = this.generateData(new Random(size), size);
                    char[] buffer = new char[4 + data.length * 3 / 2];
                    ValueEncoderFactory.Base64Encoder enc = new ValueEncoderFactory().getEncoder(b64variant, data, 0, data.length);
                    int len = enc.encodeMore(buffer, 0, buffer.length);
                    StringBuilder sb = new StringBuilder(buffer.length + 32);
                    sb.append("<root attr='");
                    sb.append(buffer, 0, len);
                    sb.append("' />");
                    XMLStreamReader2 sr = this.getElemReader(sb.toString());
                    byte[] actData = null;
                    try {
                        actData = sr.getAttributeAsBinary(0, b64variant);
                    }
                    catch (TypedXMLStreamException e) {
                        ReaderBinaryTestBase.fail((String)("Failed for variant " + b64variant + ", input '" + e.getLexical() + "': " + e.getMessage()));
                    }
                    ReaderBinaryTestBase.assertNotNull((Object)actData);
                    ReaderBinaryTestBase.assertEquals((int)data.length, (int)actData.length);
                    for (int x = 0; x < data.length; ++x) {
                        if (data[x] == actData[x]) continue;
                        ReaderBinaryTestBase.fail((String)("Corrupt decode at #" + x + "/" + data.length + ", expected " + ReaderBinaryTestBase.displayByte(data[x]) + ", got " + ReaderBinaryTestBase.displayByte(actData[x])));
                    }
                }
            }
        }
    }

    public void testInvalidAttrPadding() throws XMLStreamException {
        for (int bv = 0; bv < sPaddingVariants.length; ++bv) {
            Base64Variant b64variant = sPaddingVariants[bv];
            for (int i = 0; i < INVALID_PADDING.length; ++i) {
                String doc = "<root attr='" + INVALID_PADDING[i] + "' />";
                XMLStreamReader2 sr = this.getElemReader(doc);
                try {
                    sr.getAttributeAsBinary(0, b64variant);
                    ReaderBinaryTestBase.fail((String)"Should have received an exception for invalid padding");
                }
                catch (TypedXMLStreamException ex) {
                    // empty catch block
                }
                sr.close();
            }
        }
    }

    public void testInvalidAttrWhitespace() throws XMLStreamException {
        for (int bv = 0; bv < sBase64Variants.length; ++bv) {
            Base64Variant b64variant = sBase64Variants[bv];
            for (int i = 0; i < INVALID_WS.length; ++i) {
                String doc = "<root x='" + INVALID_WS[i] + "' />";
                XMLStreamReader2 sr = this.getElemReader(doc);
                try {
                    sr.getAttributeAsBinary(0, b64variant);
                    ReaderBinaryTestBase.fail((String)"Should have received an exception for white space used 'inside' 4-char base64 unit");
                }
                catch (TypedXMLStreamException ex) {
                    // empty catch block
                }
                sr.close();
            }
        }
    }

    public void testInvalidAttrWeirdChars() throws XMLStreamException {
        for (int bv = 0; bv < sBase64Variants.length; ++bv) {
            Base64Variant b64variant = sBase64Variants[bv];
            for (int i = 0; i < this.INVALID_WEIRD_CHARS.length; ++i) {
                String doc = "<root abc='" + this.INVALID_WEIRD_CHARS[i] + "'/>";
                XMLStreamReader2 sr = this.getElemReader(doc);
                try {
                    sr.getAttributeAsBinary(0, b64variant);
                    ReaderBinaryTestBase.fail((String)"Should have received an exception for invalid base64 character");
                }
                catch (TypedXMLStreamException ex) {
                    // empty catch block
                }
                sr.close();
            }
        }
    }

    public void testInvalidAttrIncomplete() throws XMLStreamException {
        byte[] data = new byte[6];
        for (int bv = 0; bv < sPaddingVariants.length; ++bv) {
            Base64Variant b64variant = sPaddingVariants[bv];
            for (int i = 1; i <= data.length; ++i) {
                ValueEncoderFactory.Base64Encoder enc = new ValueEncoderFactory().getEncoder(b64variant, data, 0, i);
                char[] cbuf = new char[20];
                int clen = enc.encodeMore(cbuf, 0, cbuf.length);
                for (int j = 1; j <= 3; ++j) {
                    int testLen = clen - j;
                    StringBuffer sb = new StringBuffer();
                    sb.append("<root attr='").append(cbuf, 0, testLen).append("'/>");
                    XMLStreamReader2 sr = this.getElemReader(sb.toString());
                    try {
                        sr.getAttributeAsBinary(0, b64variant);
                        ReaderBinaryTestBase.fail((String)"Should have received an exception for incomplete base64 unit");
                    }
                    catch (TypedXMLStreamException ex) {
                        // empty catch block
                    }
                    sr.close();
                }
            }
        }
    }

    private byte[] generateData(Random r, int size) {
        byte[] result = new byte[size];
        r.nextBytes(result);
        return result;
    }

    private byte[][] generateDataTable(Random r, int size, int reps) {
        byte[][] table = new byte[reps][];
        for (int i = 0; i < reps; ++i) {
            table[i] = this.generateData(r, size);
        }
        return table;
    }

    private String buildDoc(Base64Variant b64variant, Random r, byte[] data, boolean addNoise) {
        ValueEncoderFactory.Base64Encoder enc = new ValueEncoderFactory().getEncoder(b64variant, data, 0, data.length);
        StringBuffer sb = new StringBuffer(data.length * 2);
        sb.append("<root>");
        if (!addNoise) {
            char[] buffer = new char[4 + data.length * 3 / 2];
            int len = enc.encodeMore(buffer, 0, buffer.length);
            sb.append(buffer, 0, len);
        } else {
            char[] buffer = new char[300];
            while (!enc.isCompleted()) {
                boolean cdata;
                int len;
                int offset = r.nextInt() & 0xF;
                int rn = r.nextInt() & 0xF;
                switch (rn) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        len = rn;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        len = 3 + (r.nextInt() & 0xF);
                        break;
                    }
                    default: {
                        len = 20 + (r.nextInt() & 0x7F);
                    }
                }
                int end = enc.encodeMore(buffer, offset, offset + len);
                boolean bl = cdata = r.nextBoolean() && r.nextBoolean();
                if (cdata) {
                    sb.append("<![CDATA[");
                }
                sb.append(buffer, offset, end - offset);
                if (cdata) {
                    sb.append("]]>");
                }
                if (r.nextBoolean() && r.nextBoolean()) {
                    sb.append("<!-- comment: " + len + " -->");
                    continue;
                }
                sb.append("<?pi " + len + "?>");
            }
        }
        sb.append("</root>");
        return sb.toString();
    }

    private String buildMultiElemDoc(Base64Variant b64variant, byte[][] dataTable) {
        StringBuffer sb = new StringBuffer(16 + dataTable.length * dataTable[0].length);
        sb.append("<root>");
        for (int i = 0; i < dataTable.length; ++i) {
            byte[] data = dataTable[i];
            char[] buffer = new char[4 + data.length * 3 / 2];
            ValueEncoderFactory.Base64Encoder enc = new ValueEncoderFactory().getEncoder(b64variant, data, 0, data.length);
            int len = enc.encodeMore(buffer, 0, buffer.length);
            sb.append("<a>");
            sb.append(buffer, 0, len);
            sb.append("</a>");
        }
        sb.append("</root>");
        return sb.toString();
    }

    static final String displayByte(byte b) {
        return "0x" + Integer.toHexString(b & 0xFF);
    }
}

