/*
 * Decompiled with CFR 0.152.
 */
package stax2.typed;

import java.lang.reflect.Array;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public abstract class ReaderArrayTestBase
extends BaseStax2Test {
    static final int[] COUNTS_ELEM = new int[]{7, 39, 116, 900, 5003};
    static final int[] COUNTS_ATTR = new int[]{5, 17, 59, 357, 1920};

    protected abstract XMLStreamReader2 getReader(String var1) throws XMLStreamException;

    public void testSimpleIntArrayElem() throws XMLStreamException {
        this._testSimpleIntArrayElem(false);
    }

    public void testSimpleIntArrayElemWithNoise() throws XMLStreamException {
        this._testSimpleIntArrayElem(true);
    }

    private void _testSimpleIntArrayElem(boolean withNoise) throws XMLStreamException {
        for (int i = 0; i < COUNTS_ELEM.length; ++i) {
            int len = COUNTS_ELEM[i];
            int[] data = this.intArray(len);
            String XML = this.buildDoc(data, withNoise);
            this.verifyInts(XML, data, len);
            this.verifyInts(XML, data, 1);
            this.verifyInts(XML, data, -1);
        }
    }

    public void testSimpleLongArrayElem() throws XMLStreamException {
        this._testSimpleLongArrayElem(false);
    }

    public void testSimpleLongArrayElemWithNoise() throws XMLStreamException {
        this._testSimpleLongArrayElem(true);
    }

    private void _testSimpleLongArrayElem(boolean withNoise) throws XMLStreamException {
        for (int i = 0; i < COUNTS_ELEM.length; ++i) {
            int len = COUNTS_ELEM[i];
            long[] data = this.longArray(len);
            String XML = this.buildDoc(data, withNoise);
            this.verifyLongs(XML, data, len);
            this.verifyLongs(XML, data, 1);
            this.verifyLongs(XML, data, -1);
        }
    }

    public void testSimpleFloatArrayElem() throws XMLStreamException {
        this._testSimpleFloatArrayElem(false);
    }

    public void testSimpleFloatArrayElemWithNoise() throws XMLStreamException {
        this._testSimpleFloatArrayElem(true);
    }

    private void _testSimpleFloatArrayElem(boolean withNoise) throws XMLStreamException {
        for (int i = 0; i < COUNTS_ELEM.length; ++i) {
            int len = COUNTS_ELEM[i];
            float[] data = this.floatArray(len);
            String XML = this.buildDoc(data, withNoise);
            this.verifyFloats(XML, data, len);
            this.verifyFloats(XML, data, 1);
            this.verifyFloats(XML, data, -1);
        }
    }

    public void testSimpleDoubleArrayElem() throws XMLStreamException {
        this._testSimpleDoubleArrayElem(false);
    }

    public void testSimpleDoubleArrayElemWithNoise() throws XMLStreamException {
        this._testSimpleDoubleArrayElem(true);
    }

    private void _testSimpleDoubleArrayElem(boolean withNoise) throws XMLStreamException {
        for (int i = 0; i < COUNTS_ELEM.length; ++i) {
            int len = COUNTS_ELEM[i];
            double[] data = this.doubleArray(len);
            String XML = this.buildDoc(data, withNoise);
            this.verifyDoubles(XML, data, len);
            this.verifyDoubles(XML, data, 1);
            this.verifyDoubles(XML, data, -1);
        }
    }

    public void testEmptyElems() throws XMLStreamException {
        for (int i = 0; i < 4; ++i) {
            int count;
            XMLStreamReader2 sr = this.getReader("<root />");
            ReaderArrayTestBase.assertTokenType(1, sr.next());
            switch (i) {
                case 0: {
                    count = sr.readElementAsIntArray(new int[1], 0, 1);
                    break;
                }
                case 1: {
                    count = sr.readElementAsLongArray(new long[1], 0, 1);
                    break;
                }
                case 2: {
                    count = sr.readElementAsFloatArray(new float[1], 0, 1);
                    break;
                }
                default: {
                    count = sr.readElementAsDoubleArray(new double[1], 0, 1);
                }
            }
            sr.close();
            ReaderArrayTestBase.assertEquals((int)-1, (int)count);
        }
    }

    public void testInvalidIntArrayElem() throws XMLStreamException {
        for (int i = 0; i < 4; ++i) {
            XMLStreamReader2 sr = this.getReader("<root>1 2</root>");
            try {
                switch (i) {
                    case 0: {
                        sr.readElementAsIntArray(new int[3], 0, 1);
                        ReaderArrayTestBase.fail((String)"Expected an exception when trying to read at START_DOCUMENT");
                    }
                    case 1: {
                        sr.readElementAsLongArray(new long[3], 0, 1);
                        ReaderArrayTestBase.fail((String)"Expected an exception when trying to read at START_DOCUMENT");
                    }
                    case 2: {
                        sr.readElementAsFloatArray(new float[3], 0, 1);
                        ReaderArrayTestBase.fail((String)"Expected an exception when trying to read at START_DOCUMENT");
                    }
                }
                sr.readElementAsDoubleArray(new double[3], 0, 1);
                ReaderArrayTestBase.fail((String)"Expected an exception when trying to read at START_DOCUMENT");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            sr = this.getReader("<root><!-- comment --></root>");
            sr.next();
            ReaderArrayTestBase.assertTokenType(5, sr.next());
        }
    }

    public void testSimpleIntArrayAttr() throws XMLStreamException {
        for (int i = 0; i < COUNTS_ATTR.length; ++i) {
            int len = COUNTS_ATTR[i];
            int[] data = this.intArray(len);
            String XML = this.buildAttrDoc(data);
            this.verifyIntsAttr(XML, data);
        }
    }

    public void testSimpleLongArrayAttr() throws XMLStreamException {
        for (int i = 0; i < COUNTS_ATTR.length; ++i) {
            int len = COUNTS_ATTR[i];
            long[] data = this.longArray(len);
            String XML = this.buildAttrDoc(data);
            this.verifyLongsAttr(XML, data);
        }
    }

    public void testSimpleFloatArrayAttr() throws XMLStreamException {
        for (int i = 0; i < COUNTS_ATTR.length; ++i) {
            int len = COUNTS_ATTR[i];
            float[] data = this.floatArray(len);
            String XML = this.buildAttrDoc(data);
            this.verifyFloatsAttr(XML, data);
        }
    }

    public void testSimpleDoubleArrayAttr() throws XMLStreamException {
        for (int i = 0; i < COUNTS_ATTR.length; ++i) {
            int len = COUNTS_ATTR[i];
            double[] data = this.doubleArray(len);
            String XML = this.buildAttrDoc(data);
            this.verifyDoublesAttr(XML, data);
        }
    }

    private int[] intArray(int count) {
        Random r = new Random(count);
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            int base = r.nextInt();
            int shift = r.nextInt() % 24;
            result[i] = base >> shift;
        }
        return result;
    }

    private long[] longArray(int count) {
        Random r = new Random(count);
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            long base = r.nextLong();
            int shift = r.nextInt() % 56;
            result[i] = base >> shift;
        }
        return result;
    }

    private float[] floatArray(int count) {
        Random r = new Random(count);
        float[] result = new float[count];
        for (int i = 0; i < count; ++i) {
            float f = r.nextFloat();
            result[i] = r.nextBoolean() ? -f : f;
        }
        return result;
    }

    private double[] doubleArray(int count) {
        Random r = new Random(count);
        double[] result = new double[count];
        for (int i = 0; i < count; ++i) {
            double d = r.nextDouble();
            result[i] = r.nextBoolean() ? -d : d;
        }
        return result;
    }

    private String buildDoc(Object dataArray, boolean addNoise) {
        int len = Array.getLength(dataArray);
        StringBuilder sb = new StringBuilder(len * 8);
        sb.append("<root>");
        Random r = new Random(Array.get(dataArray, 0).hashCode());
        for (int i = 0; i < len; ++i) {
            String value = Array.get(dataArray, i).toString();
            sb.append((Object)value);
            if (addNoise && r.nextBoolean() && r.nextBoolean()) {
                if (r.nextBoolean()) {
                    sb.append("<!-- comment: " + value + " -->");
                } else {
                    sb.append("<?pi " + value + "?>");
                }
            }
            sb.append(' ');
        }
        sb.append("</root>");
        return sb.toString();
    }

    private String buildAttrDoc(Object dataArray) {
        int len = Array.getLength(dataArray);
        StringBuilder sb = new StringBuilder(len * 8);
        sb.append("<root attr='");
        for (int i = 0; i < len; ++i) {
            String value = Array.get(dataArray, i).toString();
            sb.append((Object)value);
            sb.append(' ');
        }
        sb.append("' />");
        return sb.toString();
    }

    private void assertArraysEqual(Object expArray, Object actArray, int actLen) {
        int expLen = Array.getLength(expArray);
        if (expLen != actLen) {
            ReaderArrayTestBase.fail((String)("Expected number of entries " + expLen + ", got " + actLen));
        }
        for (int i = 0; i < expLen; ++i) {
            Object e2;
            Object e1 = Array.get(expArray, i);
            if (e1.equals(e2 = Array.get(actArray, i))) continue;
            ReaderArrayTestBase.fail((String)("Elements at #" + i + " (len " + expLen + ") differ: expected " + e1 + ", got " + e2));
        }
    }

    private void verifyInts(String doc, int[] data, int blockLen) throws XMLStreamException {
        Random r = new Random(blockLen);
        int[] buffer = new int[Math.max(blockLen, 272)];
        int[] result = new int[data.length];
        int entries = 0;
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        while (true) {
            int got;
            int readLen = r == null ? blockLen : 1 + (r.nextInt() & 0xFF);
            int offset = r.nextInt() & 0xF;
            try {
                got = sr.readElementAsIntArray(buffer, offset, readLen);
                if (got < 0) {
                    break;
                }
            }
            catch (XMLStreamException xse) {
                ReaderArrayTestBase.fail((String)("Did not expect a failure (readLen " + readLen + ", offset " + offset + ", total exp elems " + data.length + "), problem: " + xse.getMessage()));
                got = 0;
            }
            if (entries + got > result.length) {
                int total = entries + got;
                int more = sr.readElementAsIntArray(buffer, 0, 256);
                if (more > 0) {
                    ReaderArrayTestBase.fail((String)("Expected only " + result.length + " entries, total now " + total + ", plus " + more + " more with next call"));
                } else {
                    ReaderArrayTestBase.fail((String)("Expected only " + result.length + " entries, got " + total + " (and that's all)"));
                }
            }
            System.arraycopy(buffer, offset, result, entries, got);
            entries += got;
        }
        this.assertArraysEqual(data, result, entries);
        sr.close();
    }

    private void verifyLongs(String doc, long[] data, int blockLen) throws XMLStreamException {
        int readLen;
        int got;
        Random r = blockLen < 0 ? new Random(blockLen) : null;
        long[] buffer = new long[Math.max(blockLen, 256)];
        long[] result = new long[data.length];
        int entries = 0;
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        while ((got = sr.readElementAsLongArray(buffer, 0, readLen = r == null ? blockLen : 1 + r.nextInt() & 0xFF)) >= 0) {
            if (entries + got > result.length) {
                ReaderArrayTestBase.fail((String)("Expected only " + result.length + " entries, already got " + (entries + got)));
            }
            System.arraycopy(buffer, 0, result, entries, got);
            entries += got;
        }
        this.assertArraysEqual(data, result, entries);
        sr.close();
    }

    private void verifyFloats(String doc, float[] data, int blockLen) throws XMLStreamException {
        int readLen;
        int got;
        Random r = blockLen < 0 ? new Random(blockLen) : null;
        float[] buffer = new float[Math.max(blockLen, 256)];
        float[] result = new float[data.length];
        int entries = 0;
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        while ((got = sr.readElementAsFloatArray(buffer, 0, readLen = r == null ? blockLen : 1 + r.nextInt() & 0xFF)) >= 0) {
            if (entries + got > result.length) {
                ReaderArrayTestBase.fail((String)("Expected only " + result.length + " entries, already got " + (entries + got)));
            }
            System.arraycopy(buffer, 0, result, entries, got);
            entries += got;
        }
        this.assertArraysEqual(data, result, entries);
        sr.close();
    }

    private void verifyDoubles(String doc, double[] data, int blockLen) throws XMLStreamException {
        int readLen;
        int got;
        Random r = blockLen < 0 ? new Random(blockLen) : null;
        double[] buffer = new double[Math.max(blockLen, 256)];
        double[] result = new double[data.length];
        int entries = 0;
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        while ((got = sr.readElementAsDoubleArray(buffer, 0, readLen = r == null ? blockLen : 1 + r.nextInt() & 0xFF)) >= 0) {
            if (entries + got > result.length) {
                ReaderArrayTestBase.fail((String)("Expected only " + result.length + " entries, already got " + (entries + got)));
            }
            System.arraycopy(buffer, 0, result, entries, got);
            entries += got;
        }
        this.assertArraysEqual(data, result, entries);
        sr.close();
    }

    private void verifyIntsAttr(String doc, int[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        int[] result = sr.getAttributeAsIntArray(0);
        this.assertArraysEqual(data, result, result.length);
        sr.close();
    }

    private void verifyLongsAttr(String doc, long[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        long[] result = sr.getAttributeAsLongArray(0);
        this.assertArraysEqual(data, result, result.length);
        sr.close();
    }

    private void verifyFloatsAttr(String doc, float[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        float[] result = sr.getAttributeAsFloatArray(0);
        this.assertArraysEqual(data, result, result.length);
        sr.close();
    }

    private void verifyDoublesAttr(String doc, double[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(doc);
        sr.next();
        ReaderArrayTestBase.assertTokenType(1, sr.getEventType());
        double[] result = sr.getAttributeAsDoubleArray(0);
        this.assertArraysEqual(data, result, result.length);
        sr.close();
    }
}

