/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestStreamReader
extends BaseStax2Test {
    public void testIsCharacters() throws Exception {
        XMLInputFactory2 f = this.getInputFactory();
        TestStreamReader.setNamespaceAware((XMLInputFactory)f, true);
        TestStreamReader.setCoalescing((XMLInputFactory)f, true);
        XMLStreamReader2 sr = TestStreamReader.constructStreamReader((XMLInputFactory)f, "<root><![CDATA[abc]]></root>");
        TestStreamReader.assertTokenType(1, sr.next());
        TestStreamReader.assertEquals((String)"root", (String)sr.getLocalName());
        TestStreamReader.assertTokenType(4, sr.next());
        TestStreamReader.assertEquals((int)4, (int)sr.getEventType());
        TestStreamReader.assertTrue((boolean)sr.isCharacters());
        TestStreamReader.assertTokenType(2, sr.next());
    }

    public void testCData() throws Exception {
        XMLInputFactory2 f = this.getInputFactory();
        TestStreamReader.setNamespaceAware((XMLInputFactory)f, true);
        TestStreamReader.setCoalescing((XMLInputFactory)f, true);
        String strMessage = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Body><echoRequest xmlns=\"http://test.ibm.com/xsd\"><arg0>outside cdata <![CDATA[<data>inside cdata</data>]]></arg0></echoRequest></soapenv:Body></soapenv:Envelope>";
        XMLStreamReader reader = f.createXMLStreamReader((InputStream)new ByteArrayInputStream(strMessage.getBytes("UTF-8")));
        TestStreamReader.assertTokenType(1, reader.next());
        TestStreamReader.assertTokenType(1, reader.next());
        TestStreamReader.assertTokenType(1, reader.next());
        TestStreamReader.assertTokenType(1, reader.next());
        TestStreamReader.assertTokenType(4, reader.next());
        String cdata = new String(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
        TestStreamReader.assertEquals((String)"outside cdata <data>inside cdata</data>", (String)cdata);
    }
}

