/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.io.Stax2CharArraySource;
import org.codehaus.stax2.io.Stax2FileSource;
import org.codehaus.stax2.io.Stax2StringSource;
import org.codehaus.stax2.io.Stax2URLSource;
import stax2.BaseStax2Test;

public class TestReaderConstruction
extends BaseStax2Test {
    public void testCreateWithFile() throws IOException, XMLStreamException {
        File f = this.writeToTempFile("file");
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        this.verifyXML((XMLStreamReader)ifact.createXMLStreamReader(f), "file");
    }

    public void testCreateWithURL() throws IOException, XMLStreamException {
        File f = this.writeToTempFile("URL");
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        URL url = f.toURL();
        this.verifyXML((XMLStreamReader)ifact.createXMLStreamReader(url), "URL");
    }

    public void testCreateWithFileSource() throws IOException, XMLStreamException {
        File f = this.writeToTempFile("Filesource");
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        this.verifyXML(ifact.createXMLStreamReader((Source)new Stax2FileSource(f)), "Filesource");
    }

    public void testCreateWithURLSource() throws IOException, XMLStreamException {
        File f = this.writeToTempFile("URLSource");
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        URL url = f.toURL();
        this.verifyXML(ifact.createXMLStreamReader((Source)new Stax2URLSource(url)), "URLSource");
    }

    public void testCreateWithStringSource() throws XMLStreamException {
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        String xml = this.generateXML("Stringsource");
        this.verifyXML(ifact.createXMLStreamReader((Source)new Stax2StringSource(xml)), "Stringsource");
    }

    public void testCreateWithCharArraySource() throws XMLStreamException {
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        String xml = this.generateXML("CharArraySource");
        char[] ch = xml.toCharArray();
        this.verifyXML(ifact.createXMLStreamReader((Source)new Stax2CharArraySource(ch, 0, ch.length)), "CharArraySource");
    }

    public void testCreateWithByteArraySource() throws XMLStreamException, IOException {
        XMLInputFactory2 ifact = this.getInputFactory();
        TestReaderConstruction.setCoalescing((XMLInputFactory)ifact, true);
        String xml = this.generateXML("ByteArraySource");
        byte[] orig = xml.getBytes("UTF-8");
        byte[] b = (byte[])orig.clone();
        this.verifyXML(ifact.createXMLStreamReader((Source)new Stax2ByteArraySource(b, 0, b.length)), "ByteArraySource");
        int OFFSET = 29;
        int DOCLEN = b.length;
        byte[] b2 = new byte[29 + DOCLEN + 50];
        System.arraycopy(b, 0, b2, 29, DOCLEN);
        this.verifyXML(ifact.createXMLStreamReader((Source)new Stax2ByteArraySource(b2, 29, DOCLEN)), "ByteArraySource");
    }

    public void verifyXML(XMLStreamReader sr, String textValue) throws XMLStreamException {
        TestReaderConstruction.assertTokenType(7, sr.getEventType());
        TestReaderConstruction.assertTokenType(1, sr.next());
        TestReaderConstruction.assertEquals((String)"root", (String)sr.getLocalName());
        TestReaderConstruction.assertTokenType(4, sr.next());
        String str = TestReaderConstruction.getAndVerifyText(sr);
        TestReaderConstruction.assertEquals((String)textValue, (String)str);
        TestReaderConstruction.assertTokenType(2, sr.next());
        TestReaderConstruction.assertEquals((String)"root", (String)sr.getLocalName());
        TestReaderConstruction.assertTokenType(8, sr.next());
        sr.close();
    }

    String generateXML(String text) {
        StringBuffer sb = new StringBuffer("<root>");
        sb.append(text);
        sb.append("</root>");
        return sb.toString();
    }

    File writeToTempFile(String text) throws IOException {
        File f = File.createTempFile("stax2test", null);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
        w.write(this.generateXML(text));
        ((Writer)w).flush();
        ((Writer)w).close();
        f.deleteOnExit();
        return f;
    }
}

