/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestLocationInfo
extends BaseStax2Test {
    static final String TEST_DTD_DOC = "<?xml version='1.0'?><!DOCTYPE root [\n<!ENTITY ent 'simple\ntext'>\n<!ENTITY ent2 '<tag>foo</tag>'>\n]>\n<root>Entity: &ent; <leaf />\r\n&ent2;</root>";
    static final String TEST_LF_DOC = "<root>\n<branch>\r\n <branch2>\r\t\t<leaf />\n </branch2>\r\n\t </branch> </root>";

    public void testInitialLocationNoDecl() throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader("<root />", false);
        LocationInfo loc = sr.getLocationInfo();
        this.assertLocation((XMLStreamReader)sr, loc.getStartLocation(), 1, 1, 0, loc.getStartingByteOffset(), 0, loc.getStartingCharOffset());
        this.assertLocation((XMLStreamReader)sr, loc.getEndLocation(), 1, 1, 0, loc.getEndingByteOffset(), 0, loc.getEndingCharOffset());
        sr.close();
    }

    public void testInitialLocationWithDecl() throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader("<?xml version='1.0'\r\n?>", false);
        LocationInfo loc = sr.getLocationInfo();
        this.assertLocation((XMLStreamReader)sr, loc.getStartLocation(), 1, 1, 0, loc.getStartingByteOffset(), 0, loc.getStartingCharOffset());
        this.assertLocation((XMLStreamReader)sr, loc.getEndLocation(), 3, 2, 23, loc.getEndingByteOffset(), 23, loc.getEndingCharOffset());
        sr.close();
    }

    public void testRowAccuracy() throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(TEST_LF_DOC, false);
        this.assertRow(sr, 1, 1);
        TestLocationInfo.assertTokenType(1, sr.next());
        TestLocationInfo.assertEquals((String)"root", (String)sr.getLocalName());
        this.assertRow(sr, 1, 1);
        TestLocationInfo.assertTokenType(4, sr.next());
        this.assertRow(sr, 1, 2);
        TestLocationInfo.assertTokenType(1, sr.next());
        TestLocationInfo.assertEquals((String)"branch", (String)sr.getLocalName());
        this.assertRow(sr, 2, 2);
        TestLocationInfo.assertTokenType(4, sr.next());
        this.assertRow(sr, 2, 3);
        TestLocationInfo.assertTokenType(1, sr.next());
        TestLocationInfo.assertEquals((String)"branch2", (String)sr.getLocalName());
        this.assertRow(sr, 3, 3);
        TestLocationInfo.assertTokenType(4, sr.next());
        this.assertRow(sr, 3, 4);
        TestLocationInfo.assertTokenType(1, sr.next());
        TestLocationInfo.assertEquals((String)"leaf", (String)sr.getLocalName());
        this.assertRow(sr, 4, 4);
        TestLocationInfo.assertTokenType(2, sr.next());
        TestLocationInfo.assertEquals((String)"leaf", (String)sr.getLocalName());
        this.assertRow(sr, 4, 4);
        TestLocationInfo.assertTokenType(4, sr.next());
        this.assertRow(sr, 4, 5);
        TestLocationInfo.assertTokenType(2, sr.next());
        TestLocationInfo.assertEquals((String)"branch2", (String)sr.getLocalName());
        this.assertRow(sr, 5, 5);
        TestLocationInfo.assertTokenType(4, sr.next());
        this.assertRow(sr, 5, 6);
        TestLocationInfo.assertTokenType(2, sr.next());
        TestLocationInfo.assertEquals((String)"branch", (String)sr.getLocalName());
        this.assertRow(sr, 6, 6);
        TestLocationInfo.assertTokenType(4, sr.next());
        this.assertRow(sr, 6, 6);
        TestLocationInfo.assertTokenType(2, sr.next());
        TestLocationInfo.assertEquals((String)"root", (String)sr.getLocalName());
        this.assertRow(sr, 6, 6);
        sr.close();
    }

    public void testLocationsWithDTD() throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(TEST_DTD_DOC, true);
        if (sr == null) {
            System.err.println("WARN: SupportDTD can not be enabled, need to skip test");
            return;
        }
        LocationInfo loc = sr.getLocationInfo();
        this.assertLocation((XMLStreamReader)sr, loc.getStartLocation(), 1, 1, 0, loc.getStartingByteOffset(), 0, loc.getStartingCharOffset());
        this.assertLocation((XMLStreamReader)sr, loc.getEndLocation(), 22, 1, 21, loc.getEndingByteOffset(), 21, loc.getEndingCharOffset());
        TestLocationInfo.assertTokenType(11, sr.next());
        loc = sr.getLocationInfo();
        this.assertLocation((XMLStreamReader)sr, loc.getStartLocation(), 22, 1, 21, loc.getStartingByteOffset(), 21, loc.getStartingCharOffset());
        this.assertLocation((XMLStreamReader)sr, loc.getEndLocation(), 3, 5, 100, loc.getEndingByteOffset(), 100, loc.getEndingCharOffset());
        while (sr.next() != 1) {
        }
        loc = sr.getLocationInfo();
        this.assertLocation((XMLStreamReader)sr, loc.getStartLocation(), 1, 6, 101, loc.getStartingByteOffset(), 101, loc.getStartingCharOffset());
        this.assertLocation((XMLStreamReader)sr, loc.getEndLocation(), 7, 6, 107, loc.getEndingByteOffset(), 107, loc.getEndingCharOffset());
    }

    private void assertRow(XMLStreamReader2 sr, int startRow, int endRow) throws XMLStreamException {
        LocationInfo li = sr.getLocationInfo();
        XMLStreamLocation2 startLoc = li.getStartLocation();
        TestLocationInfo.assertEquals((String)("Incorrect starting row for event " + TestLocationInfo.tokenTypeDesc(sr.getEventType())), (int)startRow, (int)startLoc.getLineNumber());
        XMLStreamLocation2 endLoc = li.getEndLocation();
        TestLocationInfo.assertEquals((String)("Incorrect ending row for event " + TestLocationInfo.tokenTypeDesc(sr.getEventType())), (int)endRow, (int)endLoc.getLineNumber());
    }

    private void assertLocation(XMLStreamReader sr, XMLStreamLocation2 loc, int expCol, int expRow, int expByteOffset, long actByteOffset, int expCharOffset, long actCharOffset) {
        TestLocationInfo.assertEquals((String)("Incorrect column for " + TestLocationInfo.tokenTypeDesc(sr.getEventType())), (int)expCol, (int)loc.getColumnNumber());
        TestLocationInfo.assertEquals((String)("Incorrect row for " + TestLocationInfo.tokenTypeDesc(sr.getEventType())), (int)expRow, (int)loc.getLineNumber());
        if (actByteOffset != -1L) {
            TestLocationInfo.assertEquals((long)expByteOffset, (long)actByteOffset);
        }
        if (actCharOffset != -1L) {
            TestLocationInfo.assertEquals((long)expCharOffset, (long)actCharOffset);
        }
    }

    private XMLStreamReader2 getReader(String contents, boolean needDTD) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestLocationInfo.setCoalescing((XMLInputFactory)f, false);
        TestLocationInfo.setNamespaceAware((XMLInputFactory)f, true);
        if (!TestLocationInfo.setSupportDTD((XMLInputFactory)f, true)) {
            return null;
        }
        TestLocationInfo.setValidating((XMLInputFactory)f, false);
        return TestLocationInfo.constructStreamReader((XMLInputFactory)f, contents);
    }
}

