/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.io.Stax2StringSource;
import stax2.BaseStax2Test;

public class TestClosing
extends BaseStax2Test {
    public void testNoAutoCloseReader() throws XMLStreamException {
        String XML = "<root>...</root>";
        XMLInputFactory2 f = this.getFactory(false);
        MyReader input = new MyReader("<root>...</root>");
        XMLStreamReader2 sr = (XMLStreamReader2)f.createXMLStreamReader((Reader)input);
        TestClosing.assertFalse((boolean)input.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.close();
        TestClosing.assertFalse((boolean)input.isClosed());
        this.streamThrough((XMLStreamReader)sr);
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.closeCompletely();
        TestClosing.assertTrue((boolean)input.isClosed());
        sr.closeCompletely();
        sr.closeCompletely();
        TestClosing.assertTrue((boolean)input.isClosed());
    }

    public void testNoAutoCloseStream() throws XMLStreamException, IOException {
        String XML = "<root>...</root>";
        XMLInputFactory2 f = this.getFactory(false);
        MyStream input = new MyStream("<root>...</root>".getBytes("UTF-8"));
        XMLStreamReader2 sr = (XMLStreamReader2)f.createXMLStreamReader((InputStream)input);
        TestClosing.assertFalse((boolean)input.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.close();
        TestClosing.assertFalse((boolean)input.isClosed());
        this.streamThrough((XMLStreamReader)sr);
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.closeCompletely();
        TestClosing.assertTrue((boolean)input.isClosed());
        sr.closeCompletely();
        TestClosing.assertTrue((boolean)input.isClosed());
    }

    public void testAutoCloseEnabled() throws XMLStreamException {
        String XML = "<root>...</root>";
        XMLInputFactory2 f = this.getFactory(true);
        MyReader input = new MyReader("<root>...</root>");
        XMLStreamReader2 sr = (XMLStreamReader2)f.createXMLStreamReader((Reader)input);
        TestClosing.assertFalse((boolean)input.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.close();
        TestClosing.assertTrue((boolean)input.isClosed());
        sr.close();
        sr.close();
        TestClosing.assertTrue((boolean)input.isClosed());
        input = new MyReader("<root>...</root>");
        sr = (XMLStreamReader2)f.createXMLStreamReader((Reader)input);
        TestClosing.assertFalse((boolean)input.isClosed());
        this.streamThrough((XMLStreamReader)sr);
        TestClosing.assertTrue((boolean)input.isClosed());
        MySource src = MySource.createFor("<root>...</root>");
        sr = (XMLStreamReader2)f.createXMLStreamReader((Source)src);
        TestClosing.assertFalse((boolean)src.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        this.streamThrough((XMLStreamReader)sr);
        TestClosing.assertTrue((boolean)input.isClosed());
    }

    public void testAutoCloseImplicit() throws XMLStreamException {
        String XML = "<root>...</root>";
        XMLInputFactory2 f = this.getFactory(false);
        MySource input = MySource.createFor("<root>...</root>");
        XMLStreamReader2 sr = (XMLStreamReader2)f.createXMLStreamReader((Source)input);
        TestClosing.assertFalse((boolean)input.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.close();
        TestClosing.assertFalse((boolean)input.isClosed());
        sr.close();
        sr.close();
        TestClosing.assertFalse((boolean)input.isClosed());
        MyStringSource src = new MyStringSource("<root>...</root>");
        sr = (XMLStreamReader2)f.createXMLStreamReader((Source)((Object)src));
        TestClosing.assertFalse((boolean)src.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        TestClosing.assertFalse((boolean)src.isClosed());
        this.streamThrough((XMLStreamReader)sr);
        TestClosing.assertTrue((boolean)src.isClosed());
        src = new MyStringSource("<root>...</root>");
        sr = (XMLStreamReader2)f.createXMLStreamReader((Source)((Object)src));
        TestClosing.assertFalse((boolean)src.isClosed());
        TestClosing.assertTokenType(1, sr.next());
        TestClosing.assertFalse((boolean)src.isClosed());
        sr.close();
        TestClosing.assertTrue((boolean)src.isClosed());
    }

    XMLInputFactory2 getFactory(boolean autoClose) {
        XMLInputFactory2 f = this.getInputFactory();
        f.setProperty("org.codehaus.stax2.closeInputSource", (Object)autoClose);
        return f;
    }

    private static final class MyStringSource
    extends Stax2StringSource {
        MyReader mReader;

        public MyStringSource(String s) {
            super(s);
        }

        public Reader constructReader() {
            this.mReader = new MyReader(this.getText());
            return this.mReader;
        }

        public boolean isClosed() {
            return this.mReader.isClosed();
        }
    }

    static final class MySource
    extends StreamSource {
        final MyReader mReader;

        private MySource(MyReader reader) {
            super(reader);
            this.mReader = reader;
        }

        public static MySource createFor(String content) {
            MyReader r = new MyReader(content);
            return new MySource(r);
        }

        public boolean isClosed() {
            return this.mReader.isClosed();
        }

        public Reader getReader() {
            return this.mReader;
        }
    }

    static final class MyStream
    extends ByteArrayInputStream {
        boolean mIsClosed = false;

        public MyStream(byte[] data) {
            super(data);
        }

        public void close() throws IOException {
            this.mIsClosed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }

    static final class MyReader
    extends StringReader {
        boolean mIsClosed = false;

        public MyReader(String contents) {
            super(contents);
        }

        public void close() {
            this.mIsClosed = true;
            super.close();
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }
}

