/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestAttrInfo
extends BaseStax2Test {
    static final String DEFAULT_VALUE = "default value";
    static final String TEST_DOC_BASIC = "<?xml version='1.0'?><root idAttr='idValue' textAttr='value' notation='not2' textAttr3='1'><leaf /></root>";
    static final String TEST_DOC_DTD = "<?xml version='1.0'?><!DOCTYPE root [\n<!ELEMENT root (leaf)>\n<!ATTLIST root defaultAttr CDATA 'default value'>\n<!ATTLIST root textAttr CDATA #IMPLIED>\n<!ATTLIST root idAttr ID #IMPLIED>\n<!NOTATION not1 PUBLIC 'some-public-id'>\n<!NOTATION not2 PUBLIC 'other-public-id'>\n<!ATTLIST root notation NOTATION (not1 | not2) #IMPLIED>\n<!ATTLIST root textAttr2 CDATA #IMPLIED>\n<!ATTLIST root textAttr3 CDATA #IMPLIED>\n<!ELEMENT leaf EMPTY>\n<!ATTLIST leaf dummyAttr CDATA #IMPLIED>\n]><root idAttr='idValue' textAttr='value' notation='not2' textAttr3='1'><leaf /></root>";

    public void testAttrFindBasic() throws XMLStreamException {
        XMLStreamReader2 sr = this.getAttrReader(TEST_DOC_BASIC);
        TestAttrInfo.assertEquals((int)4, (int)sr.getAttributeCount());
        AttributeInfo info = sr.getAttributeInfo();
        TestAttrInfo.assertNotNull((Object)info);
        int ix = info.findAttributeIndex(null, "textAttr");
        if (ix < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'textAttr'");
        }
        TestAttrInfo.assertEquals((String)"value", (String)sr.getAttributeValue(ix));
        ix = info.findAttributeIndex(null, "textAttr2");
        if (ix >= 0) {
            TestAttrInfo.fail((String)"Found a phantom index for (missing) attribute 'textAttr2'");
        }
        if ((ix = info.findAttributeIndex(null, "textAttr3")) < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'textAttr3'");
        }
        TestAttrInfo.assertEquals((String)"1", (String)sr.getAttributeValue(ix));
        ix = info.findAttributeIndex(null, "notation");
        if (ix < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'notation'");
        }
        TestAttrInfo.assertEquals((String)"not2", (String)sr.getAttributeValue(ix));
        int notIx = info.getNotationAttributeIndex();
        if (notIx >= 0) {
            TestAttrInfo.fail((String)("Found a bogus notation attribute index (" + notIx + ")"));
        }
        if ((ix = info.findAttributeIndex(null, "idAttr")) < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'id'");
        }
        TestAttrInfo.assertEquals((String)"idValue", (String)sr.getAttributeValue(ix));
        TestAttrInfo.assertEquals((int)-1, (int)info.findAttributeIndex(null, "foo"));
        TestAttrInfo.assertEquals((int)-1, (int)info.findAttributeIndex("http://foo", "id"));
        TestAttrInfo.assertTokenType(1, sr.next());
        TestAttrInfo.assertEquals((int)0, (int)sr.getAttributeCount());
        TestAttrInfo.assertEquals((int)-1, (int)info.findAttributeIndex(null, "dummyAttr"));
        this.finishAttrReader((XMLStreamReader)sr);
    }

    public void testAttrFindDTD() throws XMLStreamException {
        int idIx;
        int notIx;
        XMLStreamReader2 sr = this.getAttrReader(TEST_DOC_DTD);
        TestAttrInfo.assertEquals((int)5, (int)sr.getAttributeCount());
        AttributeInfo info = sr.getAttributeInfo();
        TestAttrInfo.assertNotNull((Object)info);
        int ix = info.findAttributeIndex(null, "textAttr");
        if (ix < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'textAttr'");
        }
        TestAttrInfo.assertEquals((String)"value", (String)sr.getAttributeValue(ix));
        ix = info.findAttributeIndex(null, "textAttr2");
        if (ix >= 0) {
            TestAttrInfo.fail((String)"Found a phantom index for (missing) attribute 'textAttr2'");
        }
        if ((ix = info.findAttributeIndex(null, "textAttr3")) < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'textAttr3'");
        }
        TestAttrInfo.assertEquals((String)"1", (String)sr.getAttributeValue(ix));
        ix = info.findAttributeIndex(null, "notation");
        if (ix < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'notation'");
        }
        if ((notIx = info.getNotationAttributeIndex()) < 0) {
            TestAttrInfo.fail((String)"Failed to find index of the notation attribute");
        }
        TestAttrInfo.assertEquals((int)ix, (int)notIx);
        TestAttrInfo.assertEquals((String)"not2", (String)sr.getAttributeValue(notIx));
        ix = info.findAttributeIndex(null, "idAttr");
        if (ix < 0) {
            TestAttrInfo.fail((String)"Failed to find index of attribute 'id'");
        }
        if ((idIx = info.getIdAttributeIndex()) < 0) {
            TestAttrInfo.fail((String)"Failed to find index of the id attribute");
        }
        TestAttrInfo.assertEquals((int)ix, (int)idIx);
        TestAttrInfo.assertEquals((String)"idValue", (String)sr.getAttributeValue(idIx));
        TestAttrInfo.assertEquals((int)-1, (int)info.findAttributeIndex(null, "foo"));
        TestAttrInfo.assertEquals((int)-1, (int)info.findAttributeIndex("http://foo", "id"));
        TestAttrInfo.assertTokenType(1, sr.next());
        TestAttrInfo.assertEquals((int)0, (int)sr.getAttributeCount());
        TestAttrInfo.assertEquals((int)-1, (int)info.findAttributeIndex(null, "dummyAttr"));
        this.finishAttrReader((XMLStreamReader)sr);
    }

    private XMLStreamReader2 getAttrReader(String str) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(str);
        TestAttrInfo.assertTokenType(7, sr.getEventType());
        int type = sr.next();
        if (type == 11) {
            type = sr.next();
        }
        TestAttrInfo.assertTokenType(1, type);
        return sr;
    }

    private void finishAttrReader(XMLStreamReader sr) throws XMLStreamException {
        while (sr.getEventType() != 8) {
            sr.next();
        }
    }

    private XMLStreamReader2 getReader(String contents) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestAttrInfo.setCoalescing((XMLInputFactory)f, false);
        TestAttrInfo.setNamespaceAware((XMLInputFactory)f, true);
        TestAttrInfo.setSupportDTD((XMLInputFactory)f, true);
        TestAttrInfo.setValidating((XMLInputFactory)f, true);
        return TestAttrInfo.constructStreamReader((XMLInputFactory)f, contents);
    }
}

