/*
 * Decompiled with CFR 0.152.
 */
package stax2.evt;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLInputFactory2;
import stax2.BaseStax2Test;

public class TestStartElementEvent
extends BaseStax2Test {
    public void testStartEventAttrs() throws XMLStreamException {
        String DOC = "<a><b a=\"aaa\" b=\"bbb\" c=\"ccc\" problem=\"problem\">some content</b><b a=\"aaa\" b=\"bbb\" c=\"ccc\" d=\"ddd\" problem=\"problem\">some content</b></a>";
        XMLInputFactory2 f = TestStartElementEvent.getNewInputFactory();
        XMLEventReader er = f.createXMLEventReader(new StringReader("<a><b a=\"aaa\" b=\"bbb\" c=\"ccc\" problem=\"problem\">some content</b><b a=\"aaa\" b=\"bbb\" c=\"ccc\" d=\"ddd\" problem=\"problem\">some content</b></a>"));
        ArrayList<StartElement> elemEvents = new ArrayList<StartElement>();
        TestStartElementEvent.assertTokenType(7, er.nextEvent());
        XMLEvent evt = er.nextEvent();
        TestStartElementEvent.assertTokenType(1, evt);
        elemEvents.add(evt.asStartElement());
        evt = er.nextEvent();
        TestStartElementEvent.assertTokenType(1, evt);
        elemEvents.add(evt.asStartElement());
        TestStartElementEvent.assertTokenType(4, er.nextEvent());
        TestStartElementEvent.assertTokenType(2, er.nextEvent());
        evt = er.nextEvent();
        TestStartElementEvent.assertTokenType(1, evt);
        elemEvents.add(evt.asStartElement());
        TestStartElementEvent.assertTokenType(4, er.nextEvent());
        TestStartElementEvent.assertTokenType(2, er.nextEvent());
        TestStartElementEvent.assertTokenType(2, er.nextEvent());
        er.close();
        this._verifyAttrCount((StartElement)elemEvents.get(1), 4, true);
    }

    private void _verifyAttrCount(StartElement start, int expCount, boolean hasProb) {
        Attribute probAttr = start.getAttributeByName(new QName("problem"));
        if (hasProb) {
            TestStartElementEvent.assertNotNull((Object)probAttr);
        } else {
            TestStartElementEvent.assertNull((Object)probAttr);
        }
        Iterator<Attribute> it = start.getAttributes();
        int count = 0;
        HashMap<QName, String> attrs = new HashMap<QName, String>();
        while (it.hasNext()) {
            ++count;
            Attribute attr = it.next();
            attrs.put(attr.getName(), attr.getValue());
        }
        TestStartElementEvent.assertEquals((int)expCount, (int)attrs.size());
        Iterator it2 = attrs.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry en = it2.next();
            QName key = (QName)en.getKey();
            String value = (String)en.getValue();
            Attribute attr = start.getAttributeByName(key);
            TestStartElementEvent.assertNotNull((Object)attr);
            TestStartElementEvent.assertEquals((String)value, (String)attr.getValue());
            TestStartElementEvent.assertNull((Object)start.getAttributeByName(new QName("bogus+" + key.getLocalPart())));
        }
    }
}

