/*
 * Decompiled with CFR 0.152.
 */
package stax2.dtd;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestNonValidatingDtdAware
extends BaseStax2Test {
    public void testSpaceNs() throws XMLStreamException {
        this.doTestWS(true, false);
        this.doTestWS(true, true);
    }

    public void testSpaceNonNs() throws XMLStreamException {
        this.doTestWS(false, false);
        this.doTestWS(false, true);
    }

    public void testFalseSpace() throws XMLStreamException {
        this.doTestFalseWS(true, false);
        this.doTestFalseWS(true, true);
        this.doTestFalseWS(false, false);
        this.doTestFalseWS(false, true);
    }

    public void doTestWS(boolean ns, boolean coalesce) throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf EMPTY>\n]><root>\n  <leaf />\n</root>";
        XMLStreamReader2 sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf EMPTY>\n]><root>\n  <leaf />\n</root>", ns, coalesce);
        TestNonValidatingDtdAware.assertTokenType(7, sr.getEventType());
        TestNonValidatingDtdAware.assertTokenType(11, sr.next());
        TestNonValidatingDtdAware.assertTokenType(1, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"root", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(6, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"\n  ", (String)TestNonValidatingDtdAware.getAndVerifyText((XMLStreamReader)sr));
        TestNonValidatingDtdAware.assertTokenType(1, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(2, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(6, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"\n", (String)TestNonValidatingDtdAware.getAndVerifyText((XMLStreamReader)sr));
        TestNonValidatingDtdAware.assertTokenType(2, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"root", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(8, sr.next());
    }

    public void doTestFalseWS(boolean ns, boolean coalesce) throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf EMPTY>\n]><root>\n  Foo<leaf />bar</root>";
        XMLStreamReader2 sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf EMPTY>\n]><root>\n  Foo<leaf />bar</root>", ns, coalesce);
        TestNonValidatingDtdAware.assertTokenType(7, sr.getEventType());
        TestNonValidatingDtdAware.assertTokenType(11, sr.next());
        TestNonValidatingDtdAware.assertTokenType(1, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"root", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(6, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"\n  ", (String)TestNonValidatingDtdAware.getAndVerifyText((XMLStreamReader)sr));
        TestNonValidatingDtdAware.assertTokenType(4, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"Foo", (String)TestNonValidatingDtdAware.getAndVerifyText((XMLStreamReader)sr));
        TestNonValidatingDtdAware.assertTokenType(1, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(2, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(4, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"bar", (String)TestNonValidatingDtdAware.getAndVerifyText((XMLStreamReader)sr));
        TestNonValidatingDtdAware.assertTokenType(2, sr.next());
        TestNonValidatingDtdAware.assertEquals((String)"root", (String)sr.getLocalName());
        TestNonValidatingDtdAware.assertTokenType(8, sr.next());
    }

    private XMLStreamReader2 getReader(String contents, boolean nsAware, boolean coal) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestNonValidatingDtdAware.setNamespaceAware((XMLInputFactory)f, nsAware);
        TestNonValidatingDtdAware.setCoalescing((XMLInputFactory)f, coal);
        TestNonValidatingDtdAware.setSupportDTD((XMLInputFactory)f, true);
        TestNonValidatingDtdAware.setValidating((XMLInputFactory)f, false);
        return TestNonValidatingDtdAware.constructStreamReader((XMLInputFactory)f, contents);
    }
}

