/*
 * Decompiled with CFR 0.152.
 */
package stax2.dom;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.typed.TypedXMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import stax2.wstream.BaseWriterTest;

public class TestDomWrite
extends BaseWriterTest {
    static final int TYPE_NON_NS = 0;
    static final int TYPE_NS = 1;
    static final int TYPE_NS_REPAIRING = 2;

    public void testNonNsOutput() throws Exception {
        XMLOutputFactory of = this.getFactory(0);
        if (of == null) {
            System.err.println("Skipping " + this.getClass().getName() + "#testNonNsOutput: non-namespace-aware mode not supported");
            return;
        }
        Document doc = this.createDomDoc(false);
        XMLStreamWriter sw = of.createXMLStreamWriter(new DOMResult(doc));
        sw.writeStartDocument();
        sw.writeStartElement("root");
        sw.writeAttribute("attr", "value");
        sw.writeAttribute("ns:attr2", "value2");
        sw.writeEmptyElement("leaf");
        sw.writeCharacters("text?<ok>");
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        Element root = doc.getDocumentElement();
        TestDomWrite.assertNotNull((Object)root);
        TestDomWrite.assertEquals((String)"root", (String)root.getTagName());
        NamedNodeMap attrs = root.getAttributes();
        TestDomWrite.assertEquals((int)2, (int)attrs.getLength());
        TestDomWrite.assertEquals((String)"value", (String)root.getAttribute("attr"));
        TestDomWrite.assertEquals((String)"value2", (String)root.getAttribute("ns:attr2"));
        Node child = root.getFirstChild();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)1, (short)child.getNodeType());
        Element elem = (Element)child;
        TestDomWrite.assertEquals((String)"leaf", (String)elem.getTagName());
        attrs = elem.getAttributes();
        TestDomWrite.assertEquals((int)0, (int)attrs.getLength());
        child = child.getNextSibling();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)3, (short)child.getNodeType());
        TestDomWrite.assertEquals((String)"text?<ok>", (String)child.getNodeValue());
    }

    public void testMiscOutput() throws Exception {
        XMLOutputFactory of = this.getFactory(0);
        if (of == null) {
            System.err.println("Skipping " + this.getClass().getName() + "#testNonNsOutput: non-namespace-aware mode not supported");
            return;
        }
        Document doc = this.createDomDoc(false);
        XMLStreamWriter sw = of.createXMLStreamWriter(new DOMResult(doc));
        sw.writeStartDocument();
        sw.writeStartElement("root");
        sw.writeComment("comment!");
        sw.writeCData("cdata!");
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        Element root = doc.getDocumentElement();
        TestDomWrite.assertNotNull((Object)root);
        TestDomWrite.assertEquals((String)"root", (String)root.getTagName());
        Node child = root.getFirstChild();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)8, (short)child.getNodeType());
        TestDomWrite.assertEquals((String)"comment!", (String)child.getNodeValue());
        child = child.getNextSibling();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)4, (short)child.getNodeType());
        TestDomWrite.assertEquals((String)"cdata!", (String)child.getNodeValue());
        TestDomWrite.assertNull((Object)child.getNextSibling());
    }

    public void testNsOutput() throws Exception {
        Document doc = this.createDomDoc(false);
        XMLOutputFactory of = this.getFactory(1);
        XMLStreamWriter sw = of.createXMLStreamWriter(new DOMResult(doc));
        String NS_URI = "http://foo";
        sw.writeStartDocument();
        sw.writeStartElement("ns", "root", "http://foo");
        sw.writeNamespace("ns", "http://foo");
        sw.writeAttribute("ns", "http://foo", "attr", "value");
        sw.writeCharacters("...");
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        Element root = doc.getDocumentElement();
        TestDomWrite.assertNotNull((Object)root);
        TestDomWrite.assertEquals((String)"ns:root", (String)root.getTagName());
        NamedNodeMap attrs = root.getAttributes();
        TestDomWrite.assertEquals((int)2, (int)attrs.getLength());
        TestDomWrite.assertEquals((String)"http://foo", (String)root.getAttribute("xmlns:ns"));
        TestDomWrite.assertEquals((String)"value", (String)root.getAttribute("ns:attr"));
        Node child = root.getFirstChild();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)3, (short)child.getNodeType());
        TestDomWrite.assertEquals((String)"...", (String)child.getNodeValue());
    }

    public void testRepairingNsOutput() throws Exception {
        String URI1 = "urn:1";
        String URI2 = "urn:2";
        Document doc = this.createDomDoc(false);
        XMLOutputFactory of = this.getFactory(2);
        XMLStreamWriter sw = of.createXMLStreamWriter(new DOMResult(doc));
        sw.writeStartDocument();
        sw.writeStartElement("urn:1", "root");
        sw.writeAttribute("attr", "x");
        sw.writeEmptyElement("urn:2", "leaf");
        sw.writeStartElement("urn:2", "leaf2");
        sw.writeAttribute("urn:2", "attr2", "<value>");
        sw.writeEndElement();
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        Element root = doc.getDocumentElement();
        TestDomWrite.assertNotNull((Object)root);
        TestDomWrite.assertEquals((String)"root", (String)root.getLocalName());
        TestDomWrite.assertEquals((String)"urn:1", (String)root.getNamespaceURI());
        NamedNodeMap attrs = root.getAttributes();
        TestDomWrite.assertEquals((int)2, (int)attrs.getLength());
        TestDomWrite.assertEquals((String)"x", (String)root.getAttributeNS(null, "attr"));
        Node child = root.getFirstChild();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)1, (short)child.getNodeType());
        Element elem = (Element)child;
        TestDomWrite.assertEquals((String)"leaf", (String)elem.getLocalName());
        attrs = elem.getAttributes();
        TestDomWrite.assertEquals((int)1, (int)attrs.getLength());
        child = child.getNextSibling();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)1, (short)child.getNodeType());
        elem = (Element)child;
        TestDomWrite.assertEquals((String)"leaf2", (String)elem.getLocalName());
        attrs = elem.getAttributes();
        int count = attrs.getLength();
        if (count < 2 || count > 3) {
            TestDomWrite.fail((String)("Expected 2 or 3 attributes (including namespace declarations), got " + count));
        }
        TestDomWrite.assertEquals((String)"<value>", (String)elem.getAttributeNS("urn:2", "attr2"));
    }

    public void testTypedOutputInt() throws Exception {
        Document doc = this.createDomDoc(false);
        XMLOutputFactory of = this.getFactory(1);
        TypedXMLStreamWriter sw = (TypedXMLStreamWriter)of.createXMLStreamWriter(new DOMResult(doc));
        sw.writeStartDocument();
        sw.writeStartElement("root");
        sw.writeIntAttribute(null, null, "attr", -900);
        sw.writeInt(123);
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        Element root = doc.getDocumentElement();
        TestDomWrite.assertNotNull((Object)root);
        TestDomWrite.assertEquals((String)"root", (String)root.getTagName());
        NamedNodeMap attrs = root.getAttributes();
        TestDomWrite.assertEquals((int)1, (int)attrs.getLength());
        TestDomWrite.assertEquals((String)"-900", (String)root.getAttribute("attr"));
        Node child = root.getFirstChild();
        TestDomWrite.assertNotNull((Object)child);
        TestDomWrite.assertEquals((short)3, (short)child.getNodeType());
        TestDomWrite.assertEquals((String)"123", (String)child.getNodeValue());
    }

    private Document createDomDoc(boolean nsAware) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsAware);
        return dbf.newDocumentBuilder().newDocument();
    }

    private XMLOutputFactory getFactory(int type) throws Exception {
        boolean ns;
        XMLOutputFactory2 f = this.getOutputFactory();
        boolean bl = ns = type > 0;
        if (!TestDomWrite.setNamespaceAware((XMLOutputFactory)f, ns) && !ns) {
            return null;
        }
        TestDomWrite.setRepairing((XMLOutputFactory)f, type > 1);
        return f;
    }
}

