/*
 * Decompiled with CFR 0.152.
 */
package stax2.dom;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import stax2.wstream.BaseWriterTest;

public class TestDomResultHandling
extends BaseWriterTest {
    public void testWriteToDocument() throws Exception {
        this.createXMLEventWriter(this.createDomDoc(true));
    }

    public void testWriteToRootElementNotInDOM() throws Exception {
        Document doc = this.createDomDoc(true);
        Element root = doc.createElementNS("ns", "my:root");
        this.createXMLEventWriter(root);
        TestDomResultHandling.assertNull((Object)doc.getDocumentElement());
    }

    public void testWriteToRootElementInDOM() throws Exception {
        Document doc = this.createDomDoc(true);
        Element root = doc.createElementNS("ns", "my:root");
        doc.appendChild(root);
        this.createXMLEventWriter(root);
    }

    public void testWriteBeforeSibling() throws Exception {
        Document doc = this.createDomDoc(true);
        Element root = doc.createElementNS("ns", "my:root");
        doc.appendChild(root);
        Element insertBefore = doc.createElementNS("ns", "my:beforeMe");
        root.appendChild(insertBefore);
        this.createXMLEventWriter(root, insertBefore);
    }

    private XMLEventWriter createXMLEventWriter(Node parent, Node insertBefore) throws XMLStreamException {
        XMLOutputFactory2 f = this.getOutputFactory();
        return f.createXMLEventWriter(new DOMResult(parent, insertBefore));
    }

    private XMLEventWriter createXMLEventWriter(Node resultNode) throws XMLStreamException {
        return this.createXMLEventWriter(resultNode, null);
    }

    private Document createDomDoc(boolean nsAware) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsAware);
        return dbf.newDocumentBuilder().newDocument();
    }
}

