/*
 * Decompiled with CFR 0.152.
 */
package stax2.dom;

import java.io.StringReader;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import stax2.BaseStax2Test;

public class TestDomCompat
extends BaseStax2Test {
    public void testSimpleDomInput() throws Exception {
        String XML = "<?xml version='1.0' ?><!--prolog--><ns:root xmlns:ns='http://foo' attr='value'><leaf ns:attr='value2' /><?proc instr?><!--comment-->\nAnd some text</ns:root><?pi-in epilog?>";
        XMLStreamReader2 sr = this.createDomBasedReader("<?xml version='1.0' ?><!--prolog--><ns:root xmlns:ns='http://foo' attr='value'><leaf ns:attr='value2' /><?proc instr?><!--comment-->\nAnd some text</ns:root><?pi-in epilog?>", true);
        TestDomCompat.assertTokenType(5, sr.next());
        TestDomCompat.assertEquals((String)"prolog", (String)TestDomCompat.getAndVerifyText((XMLStreamReader)sr));
        TestDomCompat.assertNotNull((Object)sr.getLocation());
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertEquals((String)"ns", (String)sr.getPrefix());
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        QName n = sr.getName();
        TestDomCompat.assertNotNull((Object)n);
        TestDomCompat.assertEquals((String)"root", (String)n.getLocalPart());
        TestDomCompat.assertEquals((int)1, (int)sr.getAttributeCount());
        TestDomCompat.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestDomCompat.assertEquals((String)"", (String)sr.getAttributePrefix(0));
        TestDomCompat.assertEquals((String)"", (String)sr.getAttributeNamespace(0));
        n = sr.getAttributeName(0);
        TestDomCompat.assertNotNull((Object)n);
        TestDomCompat.assertEquals((String)"attr", (String)n.getLocalPart());
        TestDomCompat.assertEquals((String)"value", (String)sr.getAttributeValue(0));
        TestDomCompat.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestDomCompat.assertEquals((String)"ns", (String)sr.getNamespacePrefix(0));
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getNamespaceURI(0));
        NamespaceContext nsCtxt = sr.getNamespaceContext();
        TestDomCompat.assertNotNull((Object)nsCtxt);
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestDomCompat.assertEquals((String)"", (String)sr.getPrefix());
        TestDomCompat.assertEquals((String)"", (String)sr.getNamespaceURI());
        TestDomCompat.assertEquals((int)1, (int)sr.getAttributeCount());
        TestDomCompat.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestDomCompat.assertEquals((String)"ns", (String)sr.getAttributePrefix(0));
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getAttributeNamespace(0));
        TestDomCompat.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestDomCompat.assertTokenType(2, sr.next());
        TestDomCompat.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestDomCompat.assertEquals((String)"", (String)sr.getPrefix());
        TestDomCompat.assertEquals((String)"", (String)sr.getNamespaceURI());
        TestDomCompat.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestDomCompat.assertTokenType(3, sr.next());
        TestDomCompat.assertEquals((String)"proc", (String)sr.getPITarget());
        TestDomCompat.assertEquals((String)"instr", (String)sr.getPIData());
        TestDomCompat.assertTokenType(5, sr.next());
        TestDomCompat.assertEquals((String)"comment", (String)TestDomCompat.getAndVerifyText((XMLStreamReader)sr));
        TestDomCompat.assertTokenType(4, sr.next());
        TestDomCompat.assertEquals((String)"\nAnd some text", (String)TestDomCompat.getAndVerifyText((XMLStreamReader)sr));
        TestDomCompat.assertTokenType(2, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertEquals((String)"ns", (String)sr.getPrefix());
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        TestDomCompat.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestDomCompat.assertEquals((String)"ns", (String)sr.getNamespacePrefix(0));
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getNamespaceURI(0));
        TestDomCompat.assertTokenType(3, sr.next());
        TestDomCompat.assertEquals((String)"pi-in", (String)sr.getPITarget());
        TestDomCompat.assertEquals((String)"epilog", (String)sr.getPIData());
        TestDomCompat.assertTokenType(8, sr.next());
        TestDomCompat.assertFalse((boolean)sr.hasNext());
        sr.close();
    }

    public void testDomWhitespace() throws Exception {
        String XML = "<?xml version='1.0' ?><root>  \n<leaf>\t</leaf>  x </root>";
        XMLStreamReader2 sr = this.createDomBasedReader("<?xml version='1.0' ?><root>  \n<leaf>\t</leaf>  x </root>", true);
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertTokenType(4, sr.next());
        TestDomCompat.assertTrue((boolean)sr.isWhiteSpace());
        TestDomCompat.assertEquals((String)"  \n", (String)TestDomCompat.getAndVerifyText((XMLStreamReader)sr));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestDomCompat.assertTokenType(4, sr.next());
        TestDomCompat.assertTrue((boolean)sr.isWhiteSpace());
        TestDomCompat.assertEquals((String)"\t", (String)TestDomCompat.getAndVerifyText((XMLStreamReader)sr));
        TestDomCompat.assertTokenType(2, sr.next());
        TestDomCompat.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestDomCompat.assertTokenType(4, sr.next());
        TestDomCompat.assertFalse((boolean)sr.isWhiteSpace());
        TestDomCompat.assertEquals((String)"  x ", (String)TestDomCompat.getAndVerifyText((XMLStreamReader)sr));
        TestDomCompat.assertTokenType(2, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertTokenType(8, sr.next());
        sr.close();
    }

    public void testDomCoalescingText() throws Exception {
        String XML = "<root>Some <![CDATA[content]]> in cdata</root>";
        Document doc = this.parseDomDoc("<root>Some <![CDATA[content]]> in cdata</root>", true);
        XMLInputFactory2 ifact = this.getInputFactory();
        TestDomCompat.setCoalescing((XMLInputFactory)ifact, true);
        XMLStreamReader sr = ifact.createXMLStreamReader((Source)new DOMSource(doc));
        TestDomCompat.assertTokenType(7, sr.getEventType());
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertTokenType(4, sr.next());
        TestDomCompat.assertEquals((String)"Some content in cdata", (String)TestDomCompat.getAndVerifyText(sr));
        TestDomCompat.assertTokenType(2, sr.next());
        TestDomCompat.assertTokenType(8, sr.next());
    }

    public void testDomCoalescingType() throws Exception {
        String XML = "<root><![CDATA[...]]></root>";
        Document doc = this.parseDomDoc("<root><![CDATA[...]]></root>", true);
        XMLInputFactory2 ifact = this.getInputFactory();
        TestDomCompat.setCoalescing((XMLInputFactory)ifact, true);
        XMLStreamReader sr = ifact.createXMLStreamReader((Source)new DOMSource(doc));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertTokenType(4, sr.next());
        TestDomCompat.assertEquals((String)"...", (String)TestDomCompat.getAndVerifyText(sr));
        TestDomCompat.assertTokenType(2, sr.next());
        TestDomCompat.assertTokenType(8, sr.next());
    }

    public void testDomInternProperties() throws Exception {
        Document doc = this.parseDomDoc("<root />", true);
        XMLInputFactory2 ifact = this.getInputFactory();
        XMLStreamReader2 sr = (XMLStreamReader2)ifact.createXMLStreamReader((Source)new DOMSource(doc));
        boolean okSet = sr.setProperty("org.codehaus.stax2.internNames", (Object)Boolean.TRUE);
        TestDomCompat.assertTrue((boolean)okSet);
        TestDomCompat.assertEquals((Object)Boolean.TRUE, (Object)sr.getProperty("org.codehaus.stax2.internNames"));
        okSet = sr.setProperty("org.codehaus.stax2.internNames", (Object)Boolean.FALSE);
        TestDomCompat.assertTrue((boolean)okSet);
        TestDomCompat.assertEquals((Object)Boolean.FALSE, (Object)sr.getProperty("org.codehaus.stax2.internNames"));
        okSet = sr.setProperty("org.codehaus.stax2.internNsUris", (Object)Boolean.TRUE);
        TestDomCompat.assertTrue((boolean)okSet);
        TestDomCompat.assertEquals((Object)Boolean.TRUE, (Object)sr.getProperty("org.codehaus.stax2.internNsUris"));
        okSet = sr.setProperty("org.codehaus.stax2.internNsUris", (Object)Boolean.FALSE);
        TestDomCompat.assertTrue((boolean)okSet);
        TestDomCompat.assertEquals((Object)Boolean.FALSE, (Object)sr.getProperty("org.codehaus.stax2.internNsUris"));
    }

    public void testDomInternNames() throws Exception {
        String ELEM = "root";
        String PREFIX = "ns";
        String ATTR = "attr";
        String URI2 = "http://foo";
        String XML = "<ns:root attr='1' xmlns:ns='http://foo' />";
        Document doc = this.parseDomDoc("<ns:root attr='1' xmlns:ns='http://foo' />", true);
        XMLInputFactory2 ifact = this.getInputFactory();
        ifact.setProperty("org.codehaus.stax2.internNames", (Object)Boolean.TRUE);
        XMLStreamReader sr = ifact.createXMLStreamReader((Source)new DOMSource(doc));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertSame((Object)"root", (Object)sr.getLocalName());
        TestDomCompat.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestDomCompat.assertSame((Object)"attr", (Object)sr.getAttributeLocalName(0));
        TestDomCompat.assertEquals((String)"ns", (String)sr.getPrefix());
        TestDomCompat.assertSame((Object)"ns", (Object)sr.getPrefix());
        sr.close();
        ifact.setProperty("org.codehaus.stax2.internNames", (Object)Boolean.FALSE);
        sr = ifact.createXMLStreamReader((Source)new DOMSource(doc));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertNotSame((Object)"root", (Object)sr.getLocalName());
        TestDomCompat.assertEquals((String)"ns", (String)sr.getPrefix());
        TestDomCompat.assertNotSame((Object)"ns", (Object)sr.getPrefix());
        sr.close();
    }

    public void testDomInternNsURIs() throws Exception {
        String ELEM = "root";
        String URI2 = "http://foo";
        String XML = "<root xmlns='http://foo' />";
        Document doc = this.parseDomDoc("<root xmlns='http://foo' />", true);
        XMLInputFactory2 ifact = this.getInputFactory();
        ifact.setProperty("org.codehaus.stax2.internNsUris", (Object)Boolean.TRUE);
        XMLStreamReader sr = ifact.createXMLStreamReader((Source)new DOMSource(doc));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        TestDomCompat.assertSame((Object)"http://foo", (Object)sr.getNamespaceURI());
        sr.close();
        ifact.setProperty("org.codehaus.stax2.internNsUris", (Object)Boolean.FALSE);
        sr = ifact.createXMLStreamReader((Source)new DOMSource(doc));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"root", (String)sr.getLocalName());
        TestDomCompat.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        sr.close();
    }

    public void testGetElementTExt() throws Exception {
        String XML = "<root>Some<![CDATA[ ]]>text</root>";
        XMLInputFactory2 ifact = this.getInputFactory();
        TestDomCompat.setCoalescing((XMLInputFactory)ifact, false);
        XMLStreamReader sr = ifact.createXMLStreamReader((Source)new DOMSource(this.parseDomDoc("<root>Some<![CDATA[ ]]>text</root>", true)));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"Some text", (String)sr.getElementText());
        TestDomCompat.assertTokenType(2, sr.getEventType());
        TestDomCompat.assertTokenType(8, sr.next());
        sr.close();
        TestDomCompat.setCoalescing((XMLInputFactory)ifact, true);
        sr = ifact.createXMLStreamReader((Source)new DOMSource(this.parseDomDoc("<root>Some<![CDATA[ ]]>text</root>", true)));
        TestDomCompat.assertTokenType(1, sr.next());
        TestDomCompat.assertEquals((String)"Some text", (String)sr.getElementText());
        TestDomCompat.assertTokenType(2, sr.getEventType());
        TestDomCompat.assertTokenType(8, sr.next());
        sr.close();
    }

    public void testEmptyFragment() throws Exception {
        DocumentFragment fragment = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createDocumentFragment();
        XMLStreamReader sr = XMLInputFactory.newInstance().createXMLStreamReader(new DOMSource(fragment));
        TestDomCompat.assertTokenType(7, sr.getEventType());
        TestDomCompat.assertTokenType(8, sr.next());
        TestDomCompat.assertFalse((boolean)sr.hasNext());
    }

    private XMLStreamReader2 createDomBasedReader(String content, boolean nsAware) throws Exception {
        XMLInputFactory2 ifact = this.getInputFactory();
        XMLStreamReader2 sr = (XMLStreamReader2)ifact.createXMLStreamReader((Source)new DOMSource(this.parseDomDoc(content, nsAware)));
        TestDomCompat.assertTokenType(7, sr.getEventType());
        return sr;
    }

    private Document parseDomDoc(String content, boolean nsAware) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsAware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new InputSource(new StringReader(content)));
    }
}

