/*
 * Decompiled with CFR 0.152.
 */
package stax2;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import stax2.BaseStax2Test;

public class TestFactories
extends BaseStax2Test {
    private final String NO_SUCH_PROPERTY = "noSuchProperty";

    public void testPropertiesInputFactory() throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestFactories.assertFalse((boolean)f.isPropertySupported("noSuchProperty"));
        try {
            f.getProperty("noSuchProperty");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
        try {
            f.setProperty("noSuchProperty", "foobar");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
    }

    public void testPropertiesStreamReader() throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        XMLStreamReader2 r = (XMLStreamReader2)f.createXMLStreamReader(new StringReader("<root></root>"));
        TestFactories.assertFalse((boolean)r.isPropertySupported("noSuchProperty"));
        Object ob = r.getProperty("noSuchProperty");
        TestFactories.assertNull((Object)ob);
        try {
            r.setProperty("noSuchProperty", (Object)"foobar");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
    }

    public void testPropertiesOutputFactory() throws XMLStreamException {
        XMLOutputFactory2 f = this.getOutputFactory();
        TestFactories.assertFalse((boolean)f.isPropertySupported("noSuchProperty"));
        try {
            f.getProperty("noSuchProperty");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
        try {
            f.setProperty("noSuchProperty", "foobar");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
    }

    public void testPropertiesStreamWriter() throws XMLStreamException {
        XMLOutputFactory2 f = this.getOutputFactory();
        XMLStreamWriter2 w = (XMLStreamWriter2)f.createXMLStreamWriter(new StringWriter());
        TestFactories.assertFalse((boolean)w.isPropertySupported("noSuchProperty"));
        try {
            w.getProperty("noSuchProperty");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
        try {
            w.setProperty("noSuchProperty", (Object)"foobar");
            TestFactories.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            this.verifyException(e, "noSuchProperty");
        }
    }
}

