/*
 * Decompiled with CFR 0.152.
 */
package stax2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import junit.framework.TestCase;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.evt.XMLEventFactory2;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;

public abstract class BaseStax2Test
extends TestCase
implements XMLStreamConstants {
    static final String ELEM_NO_PREFIX = "";
    static final String ATTR_NO_PREFIX = "";
    static final HashMap mTokenTypes = new HashMap();
    protected static boolean DEF_PRINT_EXP_EXCEPTION;
    protected boolean PRINT_EXP_EXCEPTION = DEF_PRINT_EXP_EXCEPTION;
    XMLInputFactory2 mInputFactory = null;
    XMLOutputFactory2 mOutputFactory = null;
    XMLEventFactory2 mEventFactory = null;

    protected XMLInputFactory2 getInputFactory() {
        if (this.mInputFactory == null) {
            this.mInputFactory = BaseStax2Test.getNewInputFactory();
        }
        return this.mInputFactory;
    }

    protected XMLStreamReader2 constructNsStreamReader(String content, boolean coal) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        BaseStax2Test.setNamespaceAware((XMLInputFactory)f, true);
        BaseStax2Test.setCoalescing((XMLInputFactory)f, coal);
        return (XMLStreamReader2)f.createXMLStreamReader(new StringReader(content));
    }

    protected XMLStreamReader2 constructNsStreamReader(InputStream in, boolean coal) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        BaseStax2Test.setNamespaceAware((XMLInputFactory)f, true);
        BaseStax2Test.setCoalescing((XMLInputFactory)f, coal);
        return (XMLStreamReader2)f.createXMLStreamReader(in);
    }

    protected XMLEventFactory2 getEventFactory() {
        if (this.mEventFactory == null) {
            this.mEventFactory = (XMLEventFactory2)XMLEventFactory.newInstance();
        }
        return this.mEventFactory;
    }

    protected static XMLInputFactory2 getNewInputFactory() {
        return (XMLInputFactory2)XMLInputFactory.newInstance();
    }

    protected XMLOutputFactory2 getOutputFactory() {
        if (this.mOutputFactory == null) {
            this.mOutputFactory = BaseStax2Test.getNewOutputFactory();
        }
        return this.mOutputFactory;
    }

    protected static XMLOutputFactory2 getNewOutputFactory() {
        return (XMLOutputFactory2)XMLOutputFactory.newInstance();
    }

    protected static XMLStreamReader2 constructStreamReader(XMLInputFactory f, String content) throws XMLStreamException {
        return (XMLStreamReader2)f.createXMLStreamReader(new StringReader(content));
    }

    protected static XMLStreamReader2 constructStreamReader(XMLInputFactory f, byte[] data) throws XMLStreamException {
        return (XMLStreamReader2)f.createXMLStreamReader(new ByteArrayInputStream(data));
    }

    protected static XMLStreamReader2 constructStreamReaderForFile(XMLInputFactory f, String filename) throws IOException, XMLStreamException {
        File inf = new File(filename);
        XMLStreamReader sr = f.createXMLStreamReader(inf.toURL().toString(), new FileReader(inf));
        BaseStax2Test.assertEquals((int)sr.getEventType(), (int)7);
        return (XMLStreamReader2)sr;
    }

    protected static XMLEventReader2 constructEventReader(XMLInputFactory f, String content) throws XMLStreamException {
        return (XMLEventReader2)f.createXMLEventReader(new StringReader(content));
    }

    protected XMLStreamReader2 constructNonNsStreamReader(String content, boolean coal) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        BaseStax2Test.setNamespaceAware((XMLInputFactory)f, false);
        BaseStax2Test.setCoalescing((XMLInputFactory)f, coal);
        return (XMLStreamReader2)f.createXMLStreamReader(new StringReader(content));
    }

    protected XMLStreamReader2 wrapWithAdapter(XMLStreamReader sr) {
        return new ForcedAdapter(sr);
    }

    protected static boolean setNamespaceAware(XMLInputFactory f, boolean state) throws XMLStreamException {
        try {
            f.setProperty("javax.xml.stream.isNamespaceAware", state ? Boolean.TRUE : Boolean.FALSE);
            return BaseStax2Test.isNamespaceAware(f) == state;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static boolean isNamespaceAware(XMLInputFactory f) throws XMLStreamException {
        return (Boolean)f.getProperty("javax.xml.stream.isNamespaceAware");
    }

    protected static void setCoalescing(XMLInputFactory f, boolean state) throws XMLStreamException {
        f.setProperty("javax.xml.stream.isCoalescing", state);
    }

    protected static void setValidating(XMLInputFactory f, boolean state) throws XMLStreamException {
        f.setProperty("javax.xml.stream.isValidating", state);
    }

    protected static boolean setSupportDTD(XMLInputFactory f, boolean state) throws XMLStreamException {
        try {
            f.setProperty("javax.xml.stream.supportDTD", state);
            return BaseStax2Test.willSupportDTD(f) == state;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static boolean willSupportDTD(XMLInputFactory f) throws XMLStreamException {
        return (Boolean)f.getProperty("javax.xml.stream.supportDTD");
    }

    protected static void setReplaceEntities(XMLInputFactory f, boolean state) throws XMLStreamException {
        f.setProperty("javax.xml.stream.isReplacingEntityReferences", state ? Boolean.TRUE : Boolean.FALSE);
    }

    protected static void setSupportExternalEntities(XMLInputFactory f, boolean state) throws XMLStreamException {
        f.setProperty("javax.xml.stream.isSupportingExternalEntities", state ? Boolean.TRUE : Boolean.FALSE);
    }

    protected static void setLazyParsing(XMLInputFactory f, boolean state) throws XMLStreamException {
        f.setProperty("com.ctc.wstx.lazyParsing", state ? Boolean.TRUE : Boolean.FALSE);
    }

    protected static void setRepairing(XMLOutputFactory f, boolean state) {
        f.setProperty("javax.xml.stream.isRepairingNamespaces", state);
    }

    protected static boolean setNamespaceAware(XMLOutputFactory f, boolean state) throws XMLStreamException {
        try {
            f.setProperty("javax.xml.stream.isNamespaceAware", state ? Boolean.TRUE : Boolean.FALSE);
            return BaseStax2Test.isNamespaceAware(f) == state;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static boolean isNamespaceAware(XMLOutputFactory f) throws XMLStreamException {
        return (Boolean)f.getProperty("javax.xml.stream.isNamespaceAware");
    }

    protected int streamThrough(XMLStreamReader sr) throws XMLStreamException {
        int result = 0;
        while (sr.hasNext()) {
            int type = sr.next();
            result += type;
            if (sr.hasText()) {
                result += BaseStax2Test.getAndVerifyText(sr).hashCode();
            }
            if (!sr.hasName()) continue;
            result += sr.getName().hashCode();
        }
        return result;
    }

    protected int streamThroughFailing(XMLInputFactory f, String contents, String msg) throws XMLStreamException {
        int result = 0;
        try {
            XMLStreamReader2 sr = BaseStax2Test.constructStreamReader(f, contents);
            result = this.streamThrough((XMLStreamReader)sr);
        }
        catch (XMLStreamException ex) {
            if (this.PRINT_EXP_EXCEPTION) {
                System.out.println("Expected failure: '" + ex.getMessage() + "' " + "(matching message: '" + msg + "')");
            }
            return 0;
        }
        catch (RuntimeException ex2) {
            if (this.PRINT_EXP_EXCEPTION) {
                System.out.println("Expected failure: '" + ex2.getMessage() + "' " + "(matching message: '" + msg + "')");
            }
            return 0;
        }
        catch (Throwable t) {
            BaseStax2Test.fail((String)("Expected an XMLStreamException or RuntimeException for " + msg + ", got: " + t));
        }
        BaseStax2Test.fail((String)("Expected an exception for " + msg));
        return result;
    }

    protected int streamThroughFailing(XMLStreamReader sr, String msg) throws XMLStreamException {
        int result = 0;
        try {
            result = this.streamThrough(sr);
        }
        catch (XMLStreamException ex) {
            if (this.PRINT_EXP_EXCEPTION) {
                System.out.println("Expected failure: '" + ex.getMessage() + "' " + "(matching message: '" + msg + "')");
            }
            return 0;
        }
        catch (RuntimeException ex2) {
            if (this.PRINT_EXP_EXCEPTION) {
                System.out.println("Expected failure: '" + ex2.getMessage() + "' " + "(matching message: '" + msg + "')");
            }
            return 0;
        }
        catch (Throwable t) {
            BaseStax2Test.fail((String)("Expected an XMLStreamException or RuntimeException for " + msg + ", got: " + t));
        }
        BaseStax2Test.fail((String)("Expected an exception for " + msg));
        return result;
    }

    protected static String tokenTypeDesc(int tt) {
        String desc = (String)mTokenTypes.get(new Integer(tt));
        return desc == null ? "[" + tt + "]" : desc;
    }

    protected static void assertTokenType(int expType, XMLEvent evt) {
        BaseStax2Test.assertTokenType(expType, evt.getEventType());
    }

    protected static void assertTokenType(int expType, int actType) {
        if (expType != actType) {
            String expStr = BaseStax2Test.tokenTypeDesc(expType);
            String actStr = BaseStax2Test.tokenTypeDesc(actType);
            if (expStr == null) {
                expStr = "" + expType;
            }
            if (actStr == null) {
                actStr = "" + actType;
            }
            BaseStax2Test.fail((String)("Expected token " + expStr + "; got " + actStr + "."));
        }
    }

    protected static void assertNullOrEmpty(String str) {
        if (str != null && str.length() > 0) {
            BaseStax2Test.fail((String)("Expected String to be empty or null; was '" + str + "' (length " + str.length() + ")"));
        }
    }

    protected static void assertNotNullOrEmpty(String str) {
        if (str == null || str.length() == 0) {
            BaseStax2Test.fail((String)("Expected String to be non-empty; got " + (str == null ? "NULL" : "\"\"")));
        }
    }

    protected static void assertNoElemPrefix(XMLStreamReader sr) throws XMLStreamException {
        String prefix = sr.getPrefix();
        if (prefix != "") {
            BaseStax2Test.fail((String)("Element that does not have a prefix should be indicated with <>, not <" + prefix + ">"));
        }
    }

    protected static void assertNoAttrPrefix(String attrPrefix) throws XMLStreamException {
        if (attrPrefix != "") {
            BaseStax2Test.fail((String)("Attribute that does not have a prefix should be indicated with <>, not <" + attrPrefix + ">"));
        }
    }

    protected static void assertElemNotInNamespace(XMLStreamReader sr) throws XMLStreamException {
        String uri = sr.getNamespaceURI();
        if (uri == null) {
            BaseStax2Test.fail((String)"Excepted empty String to indicate \"no namespace\": got null");
        } else if (uri.length() != 0) {
            BaseStax2Test.fail((String)("Excepted no (null) namespace URI: got '" + uri + "'"));
        }
    }

    protected static void assertNoAttrNamespace(String attrNsURI) throws XMLStreamException {
        if (attrNsURI == null) {
            BaseStax2Test.fail((String)"Expected empty String to indicate \"no namespace\" (for attribute): got null");
        } else if (attrNsURI.length() != 0) {
            BaseStax2Test.fail((String)("Expected empty String to indicate \"no namespace\" (for attribute): got '" + attrNsURI + "'"));
        }
    }

    protected static void failStrings(String msg, String exp, String act) {
        BaseStax2Test.fail((String)(msg + ": expected " + BaseStax2Test.quotedPrintable(exp) + ", got " + BaseStax2Test.quotedPrintable(act)));
    }

    protected static String getAndVerifyText(XMLStreamReader sr) throws XMLStreamException {
        int type = sr.getEventType();
        if (type == 9 || type == 11) {
            return sr.getText();
        }
        int expLen = sr.getTextLength();
        if (type == 4) {
            BaseStax2Test.assertTrue((String)"Stream reader should never return empty Strings.", (expLen > 0 ? 1 : 0) != 0);
        }
        String text = sr.getText();
        BaseStax2Test.assertNotNull((String)"getText() should never return null.", (Object)text);
        BaseStax2Test.assertEquals((String)("Expected text length of " + expLen + ", got " + text.length()), (int)expLen, (int)text.length());
        char[] textChars = sr.getTextCharacters();
        int start = sr.getTextStart();
        String text2 = new String(textChars, start, expLen);
        BaseStax2Test.assertEquals((String)text, (String)text2);
        return text;
    }

    protected void verifyException(Throwable e, String match) {
        String lmatch;
        String msg = e.getMessage();
        String lmsg = msg.toLowerCase();
        if (lmsg.indexOf(lmatch = match.toLowerCase()) < 0) {
            BaseStax2Test.fail((String)("Expected an exception with sub-string \"" + match + "\": got one with message \"" + msg + "\""));
        }
    }

    public static void warn(String msg) {
        System.err.println("WARN: " + msg);
    }

    public static String printable(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == ' ') {
            return "_";
        }
        if (ch > '\u007f' || ch < ' ') {
            StringBuffer sb = new StringBuffer(6);
            sb.append("\\u");
            String hex = Integer.toHexString(ch);
            int len = 4 - hex.length();
            for (int i = 0; i < len; ++i) {
                sb.append('0');
            }
            sb.append(hex);
            return sb.toString();
        }
        return null;
    }

    public static String printableWithSpaces(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch > '\u007f' || ch < ' ') {
            StringBuffer sb = new StringBuffer(6);
            sb.append("\\u");
            String hex = Integer.toHexString(ch);
            int len = 4 - hex.length();
            for (int i = 0; i < len; ++i) {
                sb.append('0');
            }
            sb.append(hex);
            return sb.toString();
        }
        return null;
    }

    public static String printable(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 64);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String res = BaseStax2Test.printable(c);
            if (res == null) {
                sb.append(c);
                continue;
            }
            sb.append(res);
        }
        return sb.toString();
    }

    public static String printableWithSpaces(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 64);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String res = BaseStax2Test.printableWithSpaces(c);
            if (res == null) {
                sb.append(c);
                continue;
            }
            sb.append(res);
        }
        return sb.toString();
    }

    protected static String quotedPrintable(String str) {
        if (str == null || str.length() == 0) {
            return "[0]''";
        }
        return "[len: " + str.length() + "] '" + BaseStax2Test.printable(str) + "'";
    }

    static {
        mTokenTypes.put(new Integer(1), "START_ELEMENT");
        mTokenTypes.put(new Integer(2), "END_ELEMENT");
        mTokenTypes.put(new Integer(7), "START_DOCUMENT");
        mTokenTypes.put(new Integer(8), "END_DOCUMENT");
        mTokenTypes.put(new Integer(4), "CHARACTERS");
        mTokenTypes.put(new Integer(12), "CDATA");
        mTokenTypes.put(new Integer(5), "COMMENT");
        mTokenTypes.put(new Integer(3), "PROCESSING_INSTRUCTION");
        mTokenTypes.put(new Integer(11), "DTD");
        mTokenTypes.put(new Integer(6), "SPACE");
        mTokenTypes.put(new Integer(9), "ENTITY_REFERENCE");
        DEF_PRINT_EXP_EXCEPTION = false;
    }

    static final class ForcedAdapter
    extends Stax2ReaderAdapter {
        public ForcedAdapter(XMLStreamReader sr) {
            super(sr);
        }
    }
}

