/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.wstream;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax.test.wstream.BaseWriterTest;

public class TestOutputEncoding
extends BaseWriterTest {
    final String ISO_LATIN_ENCODING = "ISO-8859-1";
    final String UTF8_ENCODING = "UTF-8";

    public void testSimpleContentQuoting() throws IOException, XMLStreamException {
        String TEXT = "<tag>&amp;";
        this.doTestSimpleQuoting("ISO-8859-1", TEXT);
        this.doTestSimpleQuoting("UTF-8", TEXT);
        TEXT = "Need to quote this too: ]]>";
        this.doTestSimpleQuoting("ISO-8859-1", TEXT);
        this.doTestSimpleQuoting("UTF-8", TEXT);
        TEXT = "And nbsp: \u00a0.";
        this.doTestSimpleQuoting("ISO-8859-1", TEXT);
        this.doTestSimpleQuoting("UTF-8", TEXT);
    }

    public void testSimpleAttrQuoting() throws IOException, XMLStreamException {
        String TEXT = "<tag>&amp;";
        this.doTestSimpleAttr("ISO-8859-1", TEXT);
        this.doTestSimpleAttr("UTF-8", TEXT);
        TEXT = "'\"fab\"'";
        this.doTestSimpleAttr("ISO-8859-1", TEXT);
        this.doTestSimpleAttr("UTF-8", TEXT);
        TEXT = "Nbsp -> \u00a0.";
        this.doTestSimpleAttr("ISO-8859-1", TEXT);
        this.doTestSimpleAttr("UTF-8", TEXT);
    }

    private void doTestSimpleQuoting(String encoding, String content) throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        w.writeStartDocument(encoding, "1.0");
        w.writeStartElement("root");
        w.writeCharacters(content);
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString(), true);
        TestOutputEncoding.assertTokenType(7, sr.getEventType());
        TestOutputEncoding.assertEquals((String)encoding, (String)sr.getCharacterEncodingScheme());
        TestOutputEncoding.assertTokenType(1, sr.next());
        TestOutputEncoding.assertTokenType(4, sr.next());
        TestOutputEncoding.assertEquals((String)content, (String)TestOutputEncoding.getAllText(sr));
        TestOutputEncoding.assertTokenType(2, sr.getEventType());
        TestOutputEncoding.assertTokenType(8, sr.next());
    }

    private void doTestSimpleAttr(String encoding, String attrValue) throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        w.writeStartDocument(encoding, "1.0");
        w.writeStartElement("root");
        w.writeAttribute("attr", attrValue);
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString(), true);
        TestOutputEncoding.assertTokenType(7, sr.getEventType());
        TestOutputEncoding.assertEquals((String)encoding, (String)sr.getCharacterEncodingScheme());
        TestOutputEncoding.assertTokenType(1, sr.next());
        TestOutputEncoding.assertEquals((int)1, (int)sr.getAttributeCount());
        TestOutputEncoding.assertEquals((String)attrValue, (String)sr.getAttributeValue(0));
        TestOutputEncoding.assertTokenType(2, sr.next());
        TestOutputEncoding.assertTokenType(8, sr.next());
    }
}

