/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestRandomStream
extends BaseStreamTest {
    public TestRandomStream(String name) {
        super(name);
    }

    public void testCoalescingAutoEntity() throws Exception {
        this.doTest(false, true, true);
        this.doTest(true, true, true);
    }

    public void testNonCoalescingAutoEntity() throws Exception {
        this.doTest(false, false, true);
        this.doTest(true, false, true);
    }

    public void testCoalescingNonAutoEntity() throws Exception {
        this.doTest(false, true, false);
        this.doTest(true, true, false);
    }

    public void testNonCoalescingNonAutoEntity() throws Exception {
        this.doTest(false, false, false);
        this.doTest(true, false, false);
    }

    private void doTest(boolean ns, boolean coalescing, boolean autoEntity) throws Exception {
        long seed = 123457L;
        if (ns) {
            seed ^= (long)"ns".hashCode();
        }
        if (coalescing) {
            seed ^= (long)"coalescing".hashCode();
        }
        if (autoEntity) {
            seed ^= (long)"autoEntity".hashCode();
        }
        Random r = new Random(seed);
        int ROUNDS = 5;
        for (int i = 0; i < 5; ++i) {
            StringBuffer inputBuf = new StringBuffer(1000);
            StringBuffer expOutBuf = new StringBuffer(1000);
            this.generateData(r, inputBuf, expOutBuf, autoEntity);
            String input = inputBuf.toString();
            String expOutput = expOutBuf.toString();
            for (int j = 0; j < 3; ++j) {
                XMLStreamReader sr;
                XMLInputFactory f = this.getFactory(ns, coalescing, autoEntity);
                switch (j) {
                    case 0: {
                        sr = TestRandomStream.constructStreamReader(f, input);
                        break;
                    }
                    case 1: {
                        ByteArrayInputStream bin = new ByteArrayInputStream(input.getBytes("UTF-8"));
                        sr = f.createXMLStreamReader(bin);
                        break;
                    }
                    case 2: {
                        ByteArrayInputStream bin = new ByteArrayInputStream(input.getBytes("UTF-8"));
                        InputStreamReader br = new InputStreamReader((InputStream)bin, "UTF-8");
                        sr = f.createXMLStreamReader(br);
                        break;
                    }
                    default: {
                        throw new Error("Internal error");
                    }
                }
                String actual = null;
                actual = this.runTest(sr);
                TestRandomStream.assertEquals((String)expOutput, (String)actual);
            }
        }
    }

    private String runTest(XMLStreamReader sr) throws Exception {
        int type;
        TestRandomStream.assertEquals((int)11, (int)sr.next());
        while ((type = sr.next()) == 6) {
        }
        TestRandomStream.assertEquals((int)1, (int)type);
        StringBuffer act = new StringBuffer(1000);
        do {
            if (type == 1 || type == 2) {
                String prefix;
                act.append('<');
                if (type == 2) {
                    act.append('/');
                }
                if ((prefix = sr.getPrefix()) != null && prefix.length() > 0) {
                    act.append(prefix);
                    act.append(':');
                }
                act.append(sr.getLocalName());
                act.append('>');
            } else if (type == 4 || type == 6 || type == 12) {
                try {
                    act.append(TestRandomStream.getAndVerifyText(sr));
                }
                catch (XMLStreamException xse) {
                    TestRandomStream.fail((String)("Expected succesful entity expansion, got: " + xse));
                }
                catch (RuntimeException rex) {
                    if (rex.getCause() instanceof XMLStreamException) {
                        TestRandomStream.fail((String)("Expected succesful entity expansion, got: " + rex));
                    }
                    throw rex;
                }
            } else if (type == 5) {
                act.append("<!--");
                act.append(sr.getText());
                act.append("-->");
            } else if (type == 9) {
                act.append(sr.getText());
            } else {
                TestRandomStream.fail((String)("Unexpected event type " + type));
            }
            try {
                type = sr.next();
            }
            catch (XMLStreamException xse) {
                TestRandomStream.fail((String)("Parse problem: " + xse));
            }
        } while (type != 8);
        return act.toString();
    }

    private void generateData(Random r, StringBuffer input, StringBuffer output, boolean autoEnt) {
        String PREAMBLE = "<?xml version='1.0' encoding='UTF-8'?><!DOCTYPE root [\n <!ENTITY ent1 'ent1Value'>\n <!ENTITY x 'Y'>\n <!ENTITY both '&ent1;&x;'>\n]>";
        String TEMPLATE = "<root> * Text ****<empty></empty>\n<empty>*</empty>*  * xx<empty></empty>\n<tag>Text ******</tag>\n<a>*...</a><b>...*</b><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*<d>*<e>*</e></d></c><c><d><e>*</e>*</d>*</c>a*b*c*d*e*f*g*h*i*j*k</root>";
        input.append("<root> * Text ****<empty></empty>\n<empty>*</empty>*  * xx<empty></empty>\n<tag>Text ******</tag>\n<a>*...</a><b>...*</b><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*<d>*<e>*</e></d></c><c><d><e>*</e>*</d>*</c>a*b*c*d*e*f*g*h*i*j*k</root>");
        output.append("<root> * Text ****<empty></empty>\n<empty>*</empty>*  * xx<empty></empty>\n<tag>Text ******</tag>\n<a>*...</a><b>...*</b><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*<d>*<e>*</e></d></c><c><d><e>*</e>*</d>*</c>a*b*c*d*e*f*g*h*i*j*k</root>");
        int i = "<root> * Text ****<empty></empty>\n<empty>*</empty>*  * xx<empty></empty>\n<tag>Text ******</tag>\n<a>*...</a><b>...*</b><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*<d>*<e>*</e></d></c><c><d><e>*</e>*</d>*</c>a*b*c*d*e*f*g*h*i*j*k</root>".length();
        while (--i >= 0) {
            char c = "<root> * Text ****<empty></empty>\n<empty>*</empty>*  * xx<empty></empty>\n<tag>Text ******</tag>\n<a>*...</a><b>...*</b><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*</c><c>*<d>*<e>*</e></d></c><c><d><e>*</e>*</d>*</c>a*b*c*d*e*f*g*h*i*j*k</root>".charAt(i);
            if (c != '*') continue;
            this.replaceEntity(input, output, autoEnt, r, i);
        }
        input.insert(0, "<?xml version='1.0' encoding='UTF-8'?><!DOCTYPE root [\n <!ENTITY ent1 'ent1Value'>\n <!ENTITY x 'Y'>\n <!ENTITY both '&ent1;&x;'>\n]>");
    }

    private void replaceEntity(StringBuffer input, StringBuffer output, boolean autoEnt, Random r, int index) {
        String out;
        String in;
        block0 : switch (Math.abs(r.nextInt()) % 5) {
            case 0: {
                switch (Math.abs(r.nextInt()) % 5) {
                    case 0: {
                        in = "&amp;";
                        out = "&";
                        break block0;
                    }
                    case 1: {
                        in = "&apos;";
                        out = "'";
                        break block0;
                    }
                    case 2: {
                        in = "&lt;";
                        out = "<";
                        break block0;
                    }
                    case 3: {
                        in = "&gt;";
                        out = ">";
                        break block0;
                    }
                    case 4: {
                        in = "&quot;";
                        out = "\"";
                        break block0;
                    }
                }
                throw new Error("Internal error!");
            }
            case 1: {
                switch (Math.abs(r.nextInt()) % 4) {
                    case 0: {
                        in = "<![CDATA[]] >]]>";
                        out = "]] >";
                        break block0;
                    }
                    case 1: {
                        in = "<![CDATA[xyz&abc]]>";
                        out = "xyz&abc";
                        break block0;
                    }
                    case 2: {
                        in = "<!--comment-->";
                        out = "<!--comment-->";
                        break block0;
                    }
                    case 3: {
                        in = "<![CDATA[ ]]>";
                        out = " ";
                        break block0;
                    }
                }
                throw new Error("Internal error!");
            }
            case 2: {
                switch (Math.abs(r.nextInt()) % 4) {
                    case 0: {
                        in = "&#35;";
                        out = "#";
                        break block0;
                    }
                    case 1: {
                        in = "&#x24;";
                        out = "$";
                        break block0;
                    }
                    case 2: {
                        in = "&#169;";
                        out = "\u00a9";
                        break block0;
                    }
                    case 3: {
                        in = "&#xc4;";
                        out = "\u00c4";
                        break block0;
                    }
                }
                throw new Error("Internal error!");
            }
            case 3: {
                switch (Math.abs(r.nextInt()) % 3) {
                    case 0: {
                        in = "&ent1;";
                        out = "ent1Value";
                        break block0;
                    }
                    case 1: {
                        in = "&x;";
                        out = "Y";
                        break block0;
                    }
                    case 2: {
                        in = "&both;";
                        out = autoEnt ? "ent1ValueY" : "&ent1;&x;";
                        break block0;
                    }
                }
                throw new Error("Internal error!");
            }
            case 4: {
                out = "(\u00a9)";
                in = "(\u00a9)";
                break;
            }
            default: {
                throw new Error("Internal error!");
            }
        }
        input.replace(index, index + 1, in);
        output.replace(index, index + 1, out);
    }

    private XMLInputFactory getFactory(boolean nsAware, boolean coalescing, boolean autoEntity) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestRandomStream.setNamespaceAware(f, nsAware);
        TestRandomStream.setCoalescing(f, coalescing);
        TestRandomStream.setReplaceEntities(f, autoEntity);
        TestRandomStream.setSupportDTD(f, true);
        TestRandomStream.setValidating(f, false);
        return f;
    }
}

