/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestNamespaces
extends BaseStreamTest {
    final String VALID_NS_XML = "<root xmlns:a='myurl' attr1='value' a:attr1=''><a:branch xmlns='someurl' xmlns:a='whatever' attr='value'><leaf a='xxx' a:a='yyy' /></a:branch></root>";
    final String VALID_NS_XML2 = "<?xml version='1.0' ?><root xmlns:a='myurl' xmlns=\"http://foo\">text<empty attr='&amp;'/><a:empty /></root>";

    public void testValidNs() throws XMLStreamException {
        XMLStreamReader sr = this.getNsReader("<root xmlns:a='myurl' attr1='value' a:attr1=''><a:branch xmlns='someurl' xmlns:a='whatever' attr='value'><leaf a='xxx' a:a='yyy' /></a:branch></root>", true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.getAttributeCount());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertNoNsURI(sr);
        TestNamespaces.assertEquals((String)"value", (String)sr.getAttributeValue(null, "attr1"));
        TestNamespaces.assertEquals((String)"", (String)sr.getAttributeValue("myurl", "attr1"));
        this.checkIllegalAttributeIndexes(sr);
        TestNamespaces.assertNull((Object)sr.getAttributeValue("xmlns", "a"));
        TestNamespaces.assertEquals((String)"myurl", (String)sr.getNamespaceURI("a"));
        TestNamespaces.assertNull((Object)sr.getNamespaceURI("myurl"));
        TestNamespaces.assertEquals((String)"", (String)sr.getNamespaceURI(""));
        TestNamespaces.assertNull((Object)sr.getNamespaceURI("nosuchurl"));
        NamespaceContext nc = sr.getNamespaceContext();
        TestNamespaces.assertNotNull((Object)nc);
        TestNamespaces.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)nc.getNamespaceURI("xml"));
        TestNamespaces.assertEquals((String)"xml", (String)nc.getPrefix("http://www.w3.org/XML/1998/namespace"));
        TestNamespaces.assertEquals((String)"http://www.w3.org/2000/xmlns/", (String)nc.getNamespaceURI("xmlns"));
        TestNamespaces.assertEquals((String)"xmlns", (String)nc.getPrefix("http://www.w3.org/2000/xmlns/"));
        TestNamespaces.assertEquals((String)"myurl", (String)nc.getNamespaceURI("a"));
        TestNamespaces.assertEquals((String)"a", (String)nc.getPrefix("myurl"));
        Iterator<String> it = nc.getPrefixes("foobar");
        if (it != null) {
            TestNamespaces.assertFalse((boolean)it.hasNext());
        }
        it = nc.getPrefixes("myurl");
        TestNamespaces.assertNotNull(it);
        TestNamespaces.assertTrue((boolean)it.hasNext());
        TestNamespaces.assertEquals((String)"a", (String)it.next());
        TestNamespaces.assertFalse((boolean)it.hasNext());
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)2, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNamespaces.assertEquals((String)"a", (String)sr.getPrefix());
        TestNamespaces.assertEquals((String)"branch", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"whatever", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((String)"value", (String)sr.getAttributeValue(null, "attr"));
        TestNamespaces.assertEquals((String)"value", (String)sr.getAttributeValue(0));
        TestNamespaces.assertEquals((String)"someurl", (String)sr.getNamespaceURI(""));
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.getAttributeCount());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"yyy", (String)sr.getAttributeValue("whatever", "a"));
        TestNamespaces.assertEquals((String)"xxx", (String)sr.getAttributeValue(null, "a"));
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)2, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"a", (String)sr.getPrefix());
        TestNamespaces.assertEquals((String)"branch", (String)sr.getLocalName());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertNoNsURI(sr);
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertEquals((int)8, (int)sr.next());
        TestNamespaces.assertFalse((boolean)sr.hasNext());
    }

    public void testMultipleValidNs() throws XMLStreamException {
        XMLStreamReader sr = this.getNsReader("<?xml version='1.0' ?><root xmlns:a='myurl' xmlns=\"http://foo\">text<empty attr='&amp;'/><a:empty /></root>", true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)2, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)0, (int)sr.getAttributeCount());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((String)"myurl", (String)sr.getNamespaceURI("a"));
        while (sr.next() == 4) {
        }
        TestNamespaces.assertTokenType(1, sr.getEventType());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"empty", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((String)"myurl", (String)sr.getNamespaceURI("a"));
        TestNamespaces.assertNoAttrNamespace(sr.getAttributeNamespace(0));
        TestNamespaces.assertNoAttrPrefix(sr.getAttributePrefix(0));
        TestNamespaces.assertEquals((String)"&", (String)sr.getAttributeValue(0));
        TestNamespaces.assertTokenType(2, sr.next());
        TestNamespaces.assertTokenType(1, sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)0, (int)sr.getAttributeCount());
        TestNamespaces.assertEquals((String)"empty", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"a", (String)sr.getPrefix());
        TestNamespaces.assertEquals((String)"myurl", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((String)"myurl", (String)sr.getNamespaceURI("a"));
        TestNamespaces.assertEquals((String)"http://foo", (String)sr.getNamespaceURI(""));
        TestNamespaces.assertTokenType(2, sr.next());
        TestNamespaces.assertTokenType(2, sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"http://foo", (String)sr.getNamespaceURI());
        TestNamespaces.assertTokenType(8, sr.next());
    }

    public void testValidNonNs() throws XMLStreamException {
        XMLStreamReader sr = this.getNsReader("<root xmlns:a='myurl' attr1='value' a:attr1=''><a:branch xmlns='someurl' xmlns:a='whatever' attr='value'><leaf a='xxx' a:a='yyy' /></a:branch></root>", false);
        if (sr == null) {
            this.reportNADueToNS("testValidNonNs");
            return;
        }
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)3, (int)sr.getAttributeCount());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertNoNsURI(sr);
        TestNamespaces.assertEquals((String)"value", (String)sr.getAttributeValue(null, "attr1"));
        TestNamespaces.assertEquals(null, (String)sr.getAttributeValue(null, "foobar"));
        this.checkIllegalAttributeIndexes(sr);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)3, (int)sr.getAttributeCount());
        TestNamespaces.assertEquals((String)"a:branch", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.getAttributeCount());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"xxx", (String)sr.getAttributeValue(null, "a"));
        TestNamespaces.assertEquals((String)"yyy", (String)sr.getAttributeValue(null, "a:a"));
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"a:branch", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertEquals((int)8, (int)sr.next());
        TestNamespaces.assertFalse((boolean)sr.hasNext());
    }

    public void testInvalidNs() throws XMLStreamException {
        this.testPotentiallyInvalid(true, "testInvalidNs");
    }

    public void testInvalidNonNs() throws XMLStreamException {
        this.testPotentiallyInvalid(false, "testInvalidNonNs");
    }

    public void testInvalidStandardBindings() throws XMLStreamException {
        this.doTestXmlBinding(true, "testInvalidStandardBindings");
        this.doTestXmlnsBinding(true, "testInvalidStandardBindings");
    }

    public void testInvalidStandardBindingsNonNs() throws XMLStreamException {
        this.doTestXmlBinding(false, "testInvalidStandardBindingsNonNs");
        this.doTestXmlnsBinding(false, "testInvalidStandardBindingsNonNs");
    }

    public void testDefaultNs() throws XMLStreamException {
        String XML = "<root xmlns='url' />";
        XMLStreamReader sr = this.getNsReader(XML, true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"url", (String)sr.getNamespaceURI());
        TestNamespaces.assertNoPrefix(sr);
        NamespaceContext ctxt = sr.getNamespaceContext();
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"url", (String)sr.getNamespaceURI(0));
        TestNamespaces.assertNoAttrPrefix(sr.getNamespacePrefix(0));
        TestNamespaces.assertEquals((String)"url", (String)ctxt.getNamespaceURI(""));
        TestNamespaces.assertEquals((String)"", (String)ctxt.getPrefix("url"));
        TestNamespaces.assertNull((Object)ctxt.getNamespaceURI("b"));
        TestNamespaces.assertNull((Object)ctxt.getPrefix("ns:b"));
        XML = "<root xmlns:a='url' />";
        sr = this.getNsReader(XML, true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertNoNsURI(sr);
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"url", (String)sr.getNamespaceURI(0));
        TestNamespaces.assertEquals((String)"a", (String)sr.getNamespacePrefix(0));
    }

    public void testMaskingNs() throws XMLStreamException {
        String XML = "<a:root xmlns:a='ns:a'><a:child xmlns:a='ns:b' /></a:root>";
        XMLStreamReader sr = this.getNsReader("<a:root xmlns:a='ns:a'><a:child xmlns:a='ns:b' /></a:root>", true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"a", (String)sr.getPrefix());
        TestNamespaces.assertEquals((String)"ns:a", (String)sr.getNamespaceURI());
        NamespaceContext ctxt = sr.getNamespaceContext();
        TestNamespaces.assertEquals((String)"ns:a", (String)ctxt.getNamespaceURI("a"));
        TestNamespaces.assertNull((Object)ctxt.getNamespaceURI("b"));
        TestNamespaces.assertEquals((String)"a", (String)ctxt.getPrefix("ns:a"));
        TestNamespaces.assertNull((Object)ctxt.getPrefix("ns:b"));
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"child", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"a", (String)sr.getPrefix());
        TestNamespaces.assertEquals((String)"ns:b", (String)sr.getNamespaceURI());
        ctxt = sr.getNamespaceContext();
        TestNamespaces.assertEquals((String)"ns:b", (String)ctxt.getNamespaceURI("a"));
        TestNamespaces.assertEquals((String)"a", (String)ctxt.getPrefix("ns:b"));
        TestNamespaces.assertNull((Object)ctxt.getNamespaceURI("b"));
        String prefix = ctxt.getPrefix("ns:a");
        if (prefix != null) {
            TestNamespaces.fail((String)("Failed: second declaration for prefix 'a' should have masked previous one; and there should not be a prefix for 'ns:a'. Instead, prefix '" + prefix + "' was considered to (still) be bound"));
        }
    }

    public void testMaskingDefaultNs() throws XMLStreamException {
        String XML = "<root xmlns='someurl'><branch xmlns=''><leaf /><leaf xmlns='anotherurl' /></branch></root>";
        XMLStreamReader sr = this.getNsReader("<root xmlns='someurl'><branch xmlns=''><leaf /><leaf xmlns='anotherurl' /></branch></root>", true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"someurl", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"branch", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertNoNsURI(sr);
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertNoNsURI(sr);
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        TestNamespaces.assertEquals((String)"anotherurl", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
    }

    public void testUnbindingInvalindInXml10() throws XMLStreamException {
        String XML = "<?xml version='1.0'?><root xmlns:ns='http://ns'><branch xmlns:ns='' /></root>";
        XMLStreamReader sr = this.getNsReader("<?xml version='1.0'?><root xmlns:ns='http://ns'><branch xmlns:ns='' /></root>", true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        TestNamespaces.assertNoPrefix(sr);
        try {
            sr.next();
            sr.next();
            TestNamespaces.fail((String)"Expected an exception when trying to unbind namespace mapping for prefix 'ns': not legal in xml 1.0 documents");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        sr.close();
    }

    public void testPredefinedXmlNs() throws XMLStreamException {
        String XML = "<root xml:lang='fi'><xml:a /></root>";
        XMLStreamReader sr = this.getNsReader("<root xml:lang='fi'><xml:a /></root>", true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"xml", (String)sr.getAttributePrefix(0));
        TestNamespaces.assertEquals((String)"lang", (String)sr.getAttributeLocalName(0));
        TestNamespaces.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)sr.getAttributeNamespace(0));
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"xml", (String)sr.getPrefix());
        TestNamespaces.assertEquals((String)"a", (String)sr.getLocalName());
        TestNamespaces.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)sr.getNamespaceURI());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
    }

    public void testNoNamespace() throws XMLStreamException {
        String XML = "<root xmlns=''>xyz</root>";
        XMLStreamReader sr = this.getNsReader(XML, true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestNamespaces.assertEquals((String)"", (String)sr.getNamespaceURI(0));
        sr.close();
    }

    private void checkIllegalAttributeIndexes(XMLStreamReader sr) throws XMLStreamException {
        try {
            String str = sr.getAttributeValue(-1);
            if (str != null && str.length() > 0) {
                TestNamespaces.fail((String)("Did not expect to find a non-empty value when trying to access attribute #-1, got '" + str + "'"));
            }
            this.warn("Did not get an exception when calling sr.getAttributeValue(-1): seems odd, but legal?");
        }
        catch (Exception e) {
            // empty catch block
        }
        int count = sr.getAttributeCount();
        try {
            String str = sr.getAttributeValue(count);
            if (str != null && str.length() > 0) {
                TestNamespaces.fail((String)("Did not expect to find a non-empty value when trying to access attribute #" + count + " [with element only having " + count + " attribute(s)], got '" + str + "'"));
            }
            this.warn("Did not get an exception when calling sr.getAttributeValue(" + count + "): [with element only having " + count + " attribute(s)] seems odd, but legal?");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void testPotentiallyInvalid(boolean nsAware, String method) throws XMLStreamException {
        block12: {
            XMLStreamReader sr;
            block11: {
                try {
                    sr = this.getNsReader("<ns1:elem />", nsAware);
                    if (sr == null) {
                        this.reportNADueToNS(method);
                        return;
                    }
                    this.streamThrough(sr);
                    if (nsAware) {
                        TestNamespaces.fail((String)"Was expecting an exception for content that uses undeclared namespace prefix.");
                    }
                }
                catch (Exception e) {
                    if (nsAware) break block11;
                    TestNamespaces.fail((String)("Was not expecting an exception for undeclared namespace when namespaces support not enabled: " + e));
                }
            }
            try {
                sr = this.getNsReader("<elem xmlns='aaa' xmlns='bbb' />", nsAware);
                this.streamThrough(sr);
                TestNamespaces.fail((String)"Was expecting an exception for content that has duplicate declaration of the default namespace.");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                sr = this.getNsReader("<elem xmlns:a='aaa' xmlns:a='bbb' />", nsAware);
                this.streamThrough(sr);
                TestNamespaces.fail((String)"Was expecting an exception for content that has duplicate declaration for a prefix.");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                sr = this.getNsReader("<elem xmlns:a=\"aaa\" xmlns:b='aaa' a:attr1='1' b:attr1=\"2\" />", nsAware);
                this.streamThrough(sr);
                if (nsAware) {
                    TestNamespaces.fail((String)"Was expecting an exception for content that has duplicate attribute (even though prefixes differ, they point to the same URI)");
                }
            }
            catch (Exception e) {
                if (nsAware) break block12;
                TestNamespaces.fail((String)("Was NOT expecting an exception since in non-namespace mode attributes 'a:attr1' and 'b:attr1' are not equivalent: " + e));
            }
        }
    }

    private void doTestXmlBinding(boolean nsAware, String method) throws XMLStreamException {
        block12: {
            XMLStreamReader sr;
            block11: {
                block10: {
                    sr = this.getNsReader("<elem xmlns:xml='http://www.w3.org/XML/1998/namespace' />", nsAware);
                    if (sr == null) {
                        this.reportNADueToNS(method);
                        return;
                    }
                    this.streamThrough(sr);
                    try {
                        sr = this.getNsReader("<elem xmlns:xml='xxx' />", nsAware);
                        this.streamThrough(sr);
                        if (nsAware) {
                            TestNamespaces.fail((String)"Was expecting an exception for content that tries to redeclare 'xml' to different URI.");
                        }
                    }
                    catch (Exception e) {
                        if (nsAware) break block10;
                        TestNamespaces.fail((String)("Was not expecting an exception for redeclaration of 'xml' when namespace support not enabled: " + e));
                    }
                }
                try {
                    sr = this.getNsReader("<elem xmlns:foo='http://www.w3.org/XML/1998/namespace' />", nsAware);
                    this.streamThrough(sr);
                    if (nsAware) {
                        TestNamespaces.fail((String)"Was expecting an exception for content that tries to bind prefix other than 'xml' to URI 'http://www.w3.org/XML/1998/namespace'");
                    }
                }
                catch (Exception e) {
                    if (nsAware) break block11;
                    TestNamespaces.fail((String)"Was not expecting an exception for binding 'xml' URI");
                }
            }
            try {
                sr = this.getNsReader("<elem xmlns='http://www.w3.org/XML/1998/namespace' />", nsAware);
                this.streamThrough(sr);
                if (nsAware) {
                    TestNamespaces.fail((String)"Was expecting an exception for content that tries to bind the default namespace to 'xml' URI 'http://www.w3.org/XML/1998/namespace'");
                }
            }
            catch (Exception e) {
                if (nsAware) break block12;
                TestNamespaces.fail((String)"Was not expecting an exception for binding default namespace to 'xml' URI");
            }
        }
    }

    private void doTestXmlnsBinding(boolean nsAware, String method) throws XMLStreamException {
        block12: {
            XMLStreamReader sr;
            block11: {
                block10: {
                    try {
                        sr = this.getNsReader("<elem xmlns:xmlns='yyy' />", nsAware);
                        if (sr == null) {
                            this.reportNADueToNS(method);
                            return;
                        }
                        this.streamThrough(sr);
                        if (nsAware) {
                            TestNamespaces.fail((String)"Was expecting an exception for content that tries to redeclare 'xml' or 'xmlns' to different URI.");
                        }
                    }
                    catch (Exception e) {
                        if (nsAware) break block10;
                        TestNamespaces.fail((String)("Was not expecting an exception for redeclaration of 'xmlns' when namespace support not enabled: " + e));
                    }
                }
                try {
                    sr = this.getNsReader("<elem xmlns:foo='http://www.w3.org/2000/xmlns/' />", nsAware);
                    this.streamThrough(sr);
                    if (nsAware) {
                        TestNamespaces.fail((String)"Was expecting an exception for content that tries to bind prefix other than 'xml' to URI 'http://www.w3.org/2000/xmlns/'");
                    }
                }
                catch (Exception e) {
                    if (nsAware) break block11;
                    TestNamespaces.fail((String)"Was not expecting an exception for binding 'xml' URI");
                }
            }
            try {
                sr = this.getNsReader("<elem xmlns='http://www.w3.org/2000/xmlns/' />", nsAware);
                this.streamThrough(sr);
                if (nsAware) {
                    TestNamespaces.fail((String)"Was expecting an exception for content that tries to bind the default namespace to 'xml' URI 'http://www.w3.org/2000/xmlns/'");
                }
            }
            catch (Exception e) {
                if (nsAware) break block12;
                TestNamespaces.fail((String)"Was not expecting an exception for binding default namespace to 'xml' URI");
            }
        }
    }

    private XMLStreamReader getNsReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        if (!TestNamespaces.setNamespaceAware(f, nsAware)) {
            return null;
        }
        TestNamespaces.setCoalescing(f, true);
        TestNamespaces.setValidating(f, false);
        return TestNamespaces.constructStreamReader(f, contents);
    }
}

