/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.util.NoSuchElementException;
import java.util.Random;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestMisc
extends BaseStreamTest {
    public void testRequire() throws XMLStreamException {
        String XML = "<root><!-- comment --><?proc instr?><tag>Text</tag><tag><![CDATA[xx]]></tag><a:empty xmlns:a='http://foo' /></root>";
        XMLStreamReader sr = this.getReader(XML, true, true);
        sr.require(7, null, null);
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(5, sr.next());
        sr.require(5, null, null);
        try {
            sr.require(5, null, "tag");
            TestMisc.fail((String)"Should have thrown an exception when checking local name of a COMMENT");
        }
        catch (XMLStreamException e) {
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        TestMisc.assertTokenType(3, sr.next());
        sr.require(3, null, null);
        TestMisc.assertTokenType(1, sr.next());
        sr.require(1, null, "tag");
        String nsURI = sr.getNamespaceURI();
        try {
            sr.require(1, "", "tag");
        }
        catch (XMLStreamException e) {
            TestMisc.fail((String)("Did not expect problems with <tag> match (current ns URI as reported by stream reader = '" + nsURI + "'), got: " + e.getMessage()));
        }
        try {
            sr.require(1, "http://foo", "tag");
            TestMisc.fail((String)"Should have thrown an exception for incorrect NS URI");
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        TestMisc.assertTokenType(4, sr.next());
        sr.require(4, null, null);
        TestMisc.assertTokenType(2, sr.next());
        sr.require(2, null, "tag");
        sr.require(2, "", "tag");
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(4, sr.next());
        sr.require(4, null, null);
        TestMisc.assertTokenType(2, sr.next());
        TestMisc.assertTokenType(1, sr.next());
        sr.require(1, "http://foo", "empty");
        TestMisc.assertTokenType(2, sr.next());
        sr.require(2, "http://foo", "empty");
        sr.require(2, "http://foo", null);
        sr.require(2, null, "empty");
        TestMisc.assertTokenType(2, sr.next());
        sr.require(2, "", "root");
        TestMisc.assertTokenType(8, sr.next());
        sr.require(8, null, null);
    }

    public void testGetElementText() throws XMLStreamException {
        this._testGetElementText(false);
        this._testGetElementText(true);
    }

    private void _testGetElementText(boolean textual) throws XMLStreamException {
        String XML = "<root><tag>Got some <!-- comment --> text &apos;n stuff!</tag><tag><?proc instr?>more <![CDATA[stuff]]> </tag><tag>a<?pi?>b<!--comment-->c<!--c-2--><?pi -3?>de</tag></root>";
        XMLInputFactory f = this.getInputFactory();
        TestMisc.setNamespaceAware(f, true);
        XMLStreamReader sr = textual ? TestMisc.constructCharStreamReader(f, XML) : TestMisc.constructUtf8StreamReader(f, XML);
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"Got some  text 'n stuff!", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"more stuff ", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"abcde", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(2, sr.next());
        sr.close();
    }

    public void testGetElementTextInvalid() throws XMLStreamException {
        String XML = "<root>Invalid: <tag><empty /> (no kids allowed!)</tag></root>";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.next());
        try {
            String str = sr.getElementText();
            TestMisc.fail((String)"Expected an exception for nested start element");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testGetElementTextLong() throws XMLStreamException {
        int[] lengths = new int[]{50, 190, 2400, 9300, 42000};
        for (int i = 0; i < lengths.length; ++i) {
            int len = lengths[i];
            StringBuffer input = new StringBuffer(len * 3 / 2);
            StringBuffer output = new StringBuffer(len + 100);
            Random r = new Random(i);
            while (output.length() < len) {
                String str = null;
                switch (Math.abs(r.nextInt()) % 7) {
                    case 0: {
                        int nr = r.nextInt();
                        input.append(" ").append(nr).append("\r\n");
                        output.append(" ").append(nr).append("\n");
                        break;
                    }
                    case 1: {
                        input.append("&amp;");
                        output.append("&");
                        break;
                    }
                    case 2: {
                        input.append("<?processing instr \n.... ?>");
                        break;
                    }
                    case 3: {
                        input.append("<!-- comment\r nr ").append(r.nextInt()).append(" -->");
                        break;
                    }
                    case 4: {
                        str = "abc " + (char)(65 + i) + " xyz";
                        break;
                    }
                    case 5: {
                        str = ">>> ";
                        break;
                    }
                    case 6: {
                        str = "; ?? (\u00a0, \u1123)";
                    }
                }
                if (str == null) continue;
                if ((r.nextInt() & 3) == 1) {
                    input.append("<![CDATA[").append(str).append("]]>");
                } else {
                    input.append(str);
                }
                output.append(str);
            }
            String XML = "<root>" + input.toString() + "</root>";
            XMLStreamReader sr = this.getReader(XML, true, false);
            TestMisc.assertTokenType(1, sr.next());
            String act = sr.getElementText();
            String exp = output.toString();
            TestMisc.assertEquals((String)exp, (String)act);
            sr.close();
        }
    }

    public void testGetElementTextEmpty() throws XMLStreamException {
        String XML = "<root />";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
        TestMisc.assertTokenType(8, sr.next());
        sr.close();
        XML = "<root><a></a><b /></root>";
        sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"a", (String)sr.getLocalName());
        TestMisc.assertEquals((String)"", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"b", (String)sr.getLocalName());
        TestMisc.assertEquals((String)"", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(2, sr.next());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
        TestMisc.assertTokenType(8, sr.next());
    }

    public void testNextTag() throws XMLStreamException {
        String XML = "<root>   <tag>   </tag><tag><leaf />   </tag><tag>text</tag>";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        try {
            int type = sr.nextTag();
            TestMisc.fail((String)"Expected an exception for non-whitespace text");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testNextTagWithCommentsAndPIs() throws XMLStreamException {
        String XML = "<root>   <!-- comment -->   <leaf />\n<leaf><?target data.. ?></leaf>\n<leaf><!-- comment --><!-- comment --> <!--comment--></leaf>\n<leaf><?target data.. ?><!--comment  --><?target?></leaf>\n</root>";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
    }

    public void testEndOfStream() throws XMLStreamException {
        String XML = "<root>x</root>";
        XMLStreamReader sr = this.getReader(XML, true, true);
        TestMisc.assertTokenType(7, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(4, sr.next());
        TestMisc.assertTokenType(2, sr.next());
        TestMisc.assertTokenType(8, sr.next());
        TestMisc.assertFalse((boolean)sr.hasNext());
        try {
            int type = sr.next();
            TestMisc.fail((String)("Expected NoSuchElementException when trying to access events after END_DOCUMENT returned (but received event " + TestMisc.tokenTypeDesc(type) + ")"));
        }
        catch (NoSuchElementException ne) {
        }
        catch (XMLStreamException e) {
            TestMisc.fail((String)("Expected NoSuchElementException; received (type " + e.getClass() + "): " + e));
        }
    }

    public void testIsWhiteSpace() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root>&#65;?</root>", true, true);
        TestMisc.assertTokenType(7, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(4, sr.next());
        if (sr.isWhiteSpace()) {
            TestMisc.fail((String)("XMLStreamReader.isWhiteSpace() should return false, text = '" + sr.getText() + "'"));
        }
        sr.close();
        sr = this.getReader("<root>\n<x>&#65;?</x></root>", true, true);
        TestMisc.assertTokenType(7, sr.getEventType());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertTokenType(4, sr.next());
        if (sr.isWhiteSpace()) {
            TestMisc.fail((String)("XMLStreamReader.isWhiteSpace() should return false, text = '" + sr.getText() + "'"));
        }
        sr.close();
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, boolean coalescing) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestMisc.setNamespaceAware(f, nsAware);
        TestMisc.setSupportDTD(f, true);
        TestMisc.setCoalescing(f, coalescing);
        TestMisc.setReplaceEntities(f, true);
        TestMisc.setValidating(f, false);
        return TestMisc.constructStreamReader(f, contents);
    }
}

