/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestLinefeeds
extends BaseStreamTest {
    final String IN_SPACES1 = "  \r \n  \r\n   ";
    final String OUT_SPACES1 = "  \n \n  \n   ";
    final String IN_SPACES2 = "\r\r \n \r";
    final String OUT_SPACES2 = "\n\n \n \n";
    final String IN_SPACES3 = "  \r\n  \r\n \r\n";
    final String OUT_SPACES3 = "  \n  \n \n";
    final String IN_MIXED1 = "Something\nwonderful (?)\rhas...\r\r\n happened ";
    final String OUT_MIXED1 = "Something\nwonderful (?)\nhas...\n\n happened ";

    public TestLinefeeds(String name) {
        super(name);
    }

    public void testLfInEpilog() throws XMLStreamException {
        String contents = "  \r \n  \r\n   <root />\r\r \n \r";
        for (int i = 0; i < 4; ++i) {
            String str;
            XMLInputFactory f = this.getInputFactory();
            boolean coal = (i & 1) == 0;
            boolean ns = (i & 2) == 0;
            TestLinefeeds.setCoalescing(f, coal);
            TestLinefeeds.setNamespaceAware(f, ns);
            XMLStreamReader sr = TestLinefeeds.constructStreamReader(f, "  \r \n  \r\n   <root />\r\r \n \r");
            int type = sr.next();
            if (type == 6) {
                str = TestLinefeeds.getAndVerifyText(sr);
                while ((type = sr.next()) == 6) {
                    str = str + TestLinefeeds.getAndVerifyText(sr);
                }
                TestLinefeeds.assertEquals((String)TestLinefeeds.printable("  \n \n  \n   "), (String)TestLinefeeds.printable(str));
            }
            TestLinefeeds.assertEquals((int)1, (int)type);
            TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
            TestLinefeeds.assertNoPrefix(sr);
            TestLinefeeds.assertEquals((int)2, (int)sr.next());
            TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
            TestLinefeeds.assertNoPrefix(sr);
            type = sr.next();
            if (type == 6) {
                str = TestLinefeeds.getAndVerifyText(sr);
                while ((type = sr.next()) == 6) {
                    str = str + TestLinefeeds.getAndVerifyText(sr);
                }
                if (!str.equals("\n\n \n \n")) {
                    String exp = TestLinefeeds.printable("\n\n \n \n");
                    String act = TestLinefeeds.printable(str);
                    TestLinefeeds.fail((String)("Failed (coalesce: " + coal + ", ns-aware: " + ns + "); expected '" + exp + "', got '" + act + "'."));
                }
            }
            TestLinefeeds.assertEquals((int)8, (int)type);
        }
    }

    public void testLfInCData() throws XMLStreamException {
        this.doTestLfInCData(false, false);
        this.doTestLfInCData(false, true);
        this.doTestLfInCData(true, false);
        this.doTestLfInCData(true, true);
    }

    private void doTestLfInCData(boolean ns, boolean coalescing) throws XMLStreamException {
        String contents = "<root><![CDATA[  \r \n  \r\n   \r\r \n \r]]></root>";
        XMLInputFactory f = this.getInputFactory();
        TestLinefeeds.setCoalescing(f, coalescing);
        TestLinefeeds.setNamespaceAware(f, ns);
        XMLStreamReader sr = TestLinefeeds.constructStreamReader(f, "<root><![CDATA[  \r \n  \r\n   \r\r \n \r]]></root>");
        TestLinefeeds.assertEquals((int)1, (int)sr.next());
        TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
        TestLinefeeds.assertNoPrefix(sr);
        int type = sr.next();
        TestLinefeeds.assertTrue((String)("Expected either CDATA or CHARACTERS event, got " + type), (type == 12 || type == 4 ? 1 : 0) != 0);
        String str = TestLinefeeds.getAndVerifyText(sr);
        if (coalescing) {
            type = sr.next();
        } else {
            while ((type = sr.next()) == 12 || type == 4) {
                str = str + TestLinefeeds.getAndVerifyText(sr);
            }
        }
        String exp = "  \n \n  \n   \n\n \n \n";
        if (!str.equals(exp)) {
            TestLinefeeds.fail((String)("Failed (coalesce: " + coalescing + ", ns-aware: " + ns + "); expected '" + TestLinefeeds.printable(exp) + "', got '" + TestLinefeeds.printable(str) + "'."));
        }
        TestLinefeeds.assertEquals((int)2, (int)type);
        TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
        TestLinefeeds.assertNoPrefix(sr);
        TestLinefeeds.assertEquals((int)8, (int)sr.next());
    }

    public void testLfInProcInstr() throws XMLStreamException {
        String contents = "<root><?target  [  \r \n  \r\n   \r\r \n \r]?><?target [  \r\n  \r\n \r\n]?></root>";
        for (int i = 0; i < 4; ++i) {
            XMLInputFactory f = this.getInputFactory();
            TestLinefeeds.setCoalescing(f, (i & 1) == 0);
            TestLinefeeds.setNamespaceAware(f, (i & 2) == 0);
            XMLStreamReader sr = TestLinefeeds.constructStreamReader(f, "<root><?target  [  \r \n  \r\n   \r\r \n \r]?><?target [  \r\n  \r\n \r\n]?></root>");
            TestLinefeeds.assertEquals((int)1, (int)sr.next());
            TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
            TestLinefeeds.assertNoPrefix(sr);
            TestLinefeeds.assertEquals((int)3, (int)sr.next());
            TestLinefeeds.assertEquals((String)"target", (String)sr.getPITarget());
            String data = sr.getPIData();
            String exp = "[  \n \n  \n   \n\n \n \n]";
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable(exp), (String)TestLinefeeds.printable(data));
            TestLinefeeds.assertEquals((int)3, (int)sr.next());
            TestLinefeeds.assertEquals((String)"target", (String)sr.getPITarget());
            data = sr.getPIData();
            exp = "[  \n  \n \n]";
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable(exp), (String)TestLinefeeds.printable(data));
            TestLinefeeds.assertEquals((int)2, (int)sr.next());
            TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
            TestLinefeeds.assertNoPrefix(sr);
            TestLinefeeds.assertEquals((int)8, (int)sr.next());
        }
    }

    public void testLfInComment() throws XMLStreamException {
        String contents = "<root><!--  \r \n  \r\n   --><!--\r\r \n \r--><!--  \r\n  \r\n \r\n--><!--Something\nwonderful (?)\rhas...\r\r\n happened --></root>";
        for (int i = 0; i < 4; ++i) {
            XMLInputFactory f = this.getInputFactory();
            TestLinefeeds.setCoalescing(f, (i & 1) == 0);
            TestLinefeeds.setNamespaceAware(f, (i & 2) == 0);
            XMLStreamReader sr = TestLinefeeds.constructStreamReader(f, "<root><!--  \r \n  \r\n   --><!--\r\r \n \r--><!--  \r\n  \r\n \r\n--><!--Something\nwonderful (?)\rhas...\r\r\n happened --></root>");
            TestLinefeeds.assertEquals((int)1, (int)sr.next());
            TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
            TestLinefeeds.assertNoPrefix(sr);
            TestLinefeeds.assertEquals((int)5, (int)sr.next());
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable("  \n \n  \n   "), (String)TestLinefeeds.printable(sr.getText()));
            TestLinefeeds.assertEquals((int)5, (int)sr.next());
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable("\n\n \n \n"), (String)TestLinefeeds.printable(sr.getText()));
            TestLinefeeds.assertEquals((int)5, (int)sr.next());
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable("  \n  \n \n"), (String)TestLinefeeds.printable(sr.getText()));
            TestLinefeeds.assertEquals((int)5, (int)sr.next());
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable("Something\nwonderful (?)\nhas...\n\n happened "), (String)TestLinefeeds.printable(sr.getText()));
            TestLinefeeds.assertEquals((int)2, (int)sr.next());
            TestLinefeeds.assertEquals((String)"root", (String)sr.getLocalName());
            TestLinefeeds.assertNoPrefix(sr);
            TestLinefeeds.assertEquals((int)8, (int)sr.next());
        }
    }

    public void testLfInText() throws XMLStreamException {
        String contents = "<root>  \r \n  \r\n   \r\r \n \r</root>";
        for (int i = 0; i < 4; ++i) {
            int type;
            XMLInputFactory f = this.getInputFactory();
            boolean coalescing = (i & 1) == 0;
            TestLinefeeds.setCoalescing(f, coalescing);
            TestLinefeeds.setNamespaceAware(f, (i & 2) == 0);
            XMLStreamReader sr = TestLinefeeds.constructStreamReader(f, "<root>  \r \n  \r\n   \r\r \n \r</root>");
            TestLinefeeds.assertEquals((int)1, (int)sr.next());
            TestLinefeeds.assertEquals((int)4, (int)sr.next());
            String str = TestLinefeeds.getAndVerifyText(sr);
            if (coalescing) {
                type = sr.next();
            } else {
                while ((type = sr.next()) == 12 || type == 4) {
                    str = str + TestLinefeeds.getAndVerifyText(sr);
                }
            }
            TestLinefeeds.assertEquals((String)TestLinefeeds.printable("  \n \n  \n   \n\n \n \n"), (String)TestLinefeeds.printable(str));
            TestLinefeeds.assertEquals((int)2, (int)type);
            TestLinefeeds.assertEquals((int)8, (int)sr.next());
        }
    }
}

