/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.SimpleResolver;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestEntityRead
extends BaseStreamTest {
    public TestEntityRead(String name) {
        super(name);
    }

    public void testEntityProperties() throws XMLStreamException {
        this.doTestProperties(true);
        this.doTestProperties(false);
    }

    public void testValidPredefdEntities() throws XMLStreamException {
        int type;
        String EXP = "Testing \"this\" & 'that' !? !";
        String XML = "<root>Testing &quot;this&quot; &amp; &apos;that&apos; &#x21;&#63; &#33;</root>";
        XMLStreamReader sr = this.getReader(XML, false, true, true);
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertTokenType(4, sr.next());
        StringBuffer sb = new StringBuffer(TestEntityRead.getAndVerifyText(sr));
        while ((type = sr.next()) == 4) {
            sb.append(TestEntityRead.getAndVerifyText(sr));
        }
        TestEntityRead.assertEquals((String)EXP, (String)sb.toString());
        TestEntityRead.assertTokenType(2, type);
    }

    public void testValidCharEntities() throws XMLStreamException {
        int type;
        String XML = "<root>surrogates: &#x50000;.</root>";
        XMLStreamReader sr = this.getReader(XML, true, true, true);
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertTokenType(4, sr.next());
        StringBuffer sb = new StringBuffer(TestEntityRead.getAndVerifyText(sr));
        while ((type = sr.next()) == 4) {
            sb.append(TestEntityRead.getAndVerifyText(sr));
        }
        String exp = "surrogates: \ud900\udc00.";
        String result = sb.toString();
        if (!exp.equals(result)) {
            TestEntityRead.failStrings("Expected character entity &x#50000 to expand to surrogate pair with chars 0xD900 and 0xDC00", exp, result);
        }
        TestEntityRead.assertTokenType(2, type);
        sr.close();
    }

    public void testValidGeneralEntities() throws XMLStreamException {
        String EXP = "y yabc abc&";
        String XML = "<!DOCTYPE root [\n<!ENTITY x 'y'><!ENTITY aa 'abc'>\n<!ENTITY both '&x;&aa;'\n><!ENTITY myAmp '&amp;'\n>]>\n<root>&x; &both; &aa;&myAmp;</root>";
        XMLStreamReader sr = this.getReader(XML, false, true, true);
        TestEntityRead.assertTokenType(11, sr.next());
        int type = sr.next();
        if (type == 6) {
            type = sr.next();
        }
        TestEntityRead.assertTokenType(1, type);
        try {
            TestEntityRead.assertTokenType(4, sr.next());
        }
        catch (XMLStreamException xse) {
            TestEntityRead.fail((String)("Expected succesful entity expansion, got: " + xse));
        }
        String actual = TestEntityRead.getAndVerifyText(sr);
        TestEntityRead.assertEquals((String)EXP, (String)actual);
    }

    public void testUnexpandedEntities() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n <!ENTITY myent 'data'>]>\n<root>&amp;Start&quot;&myent;End&#33;</root>";
        XMLStreamReader sr = this.getReader(XML, false, true, false);
        TestEntityRead.assertTokenType(11, sr.next());
        int type = sr.next();
        while (type == 6) {
            type = sr.next();
        }
        TestEntityRead.assertTokenType(1, type);
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)"&Start\"", (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertTokenType(9, sr.next());
        TestEntityRead.assertEquals((String)"myent", (String)sr.getLocalName());
        TestEntityRead.assertEquals((String)"data", (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)"End!", (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertTokenType(2, sr.next());
        TestEntityRead.assertTokenType(8, sr.next());
        XML = "<!DOCTYPE root [\n <!ENTITY myent 'data'>]>\n<root>&amp;Start&quot;&myent;End&#33;\n   &#x21;&myent;&myent;<![CDATA[!]]>&myent;<![CDATA[...]]>&amp;</root>";
        sr = this.getReader(XML, false, false, false);
        this.streamThrough(sr);
        sr = this.getReader(XML, false, true, false);
        this.streamThrough(sr);
    }

    public void testUnexpandedEntities2() throws XMLStreamException {
        String ENTITY_VALUE = "Something slightly longer &amp; challenging\nwhich may or may not work";
        String XML = "<!DOCTYPE root [\n <!ENTITY myent '" + ENTITY_VALUE + "'>]>" + "<root>&myent;</root>";
        XMLStreamReader sr = this.getReader(XML, false, true, false);
        TestEntityRead.assertTokenType(11, sr.next());
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertTokenType(9, sr.next());
        TestEntityRead.assertEquals((String)"myent", (String)sr.getLocalName());
        TestEntityRead.assertEquals((String)ENTITY_VALUE, (String)sr.getText());
        TestEntityRead.assertTokenType(2, sr.next());
        TestEntityRead.assertTokenType(8, sr.next());
    }

    public void testElementEntities() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n <!ENTITY ent1 '<tag>text</tag>'>\n <!ENTITY ent2 '<!--comment-->'>\n <!ENTITY ent3 '<?proc instr?>'>\n <!ENTITY ent4a '&ent4b;'>\n <!ENTITY ent4b '&#65;'>\n]>\n<root>&ent1;&ent2;&ent3;&ent4a;</root>";
        XMLStreamReader sr = this.getReader(XML, true, true, true);
        TestEntityRead.assertTokenType(11, sr.next());
        int type = sr.next();
        if (type == 6) {
            type = sr.next();
        }
        TestEntityRead.assertTokenType(1, type);
        TestEntityRead.assertEquals((String)"root", (String)sr.getLocalName());
        try {
            type = sr.next();
        }
        catch (XMLStreamException xse) {
            TestEntityRead.fail((String)("Expected succesful entity expansion, got: " + xse));
        }
        if (type != 1) {
            if (type == 9) {
                TestEntityRead.fail((String)("Implementation fails to re-parse general entity expansion text: instead of element <tag>, received entity reference &" + sr.getLocalName() + ";"));
            }
            if (type == 4) {
                String text = sr.getText();
                TestEntityRead.fail((String)("Implementation fails to re-parse general entity expansion text: instead of element <tag>, received text [" + text.length() + "]: '" + text + "'"));
            }
            TestEntityRead.assertTokenType(1, type);
        }
        TestEntityRead.assertEquals((String)"tag", (String)sr.getLocalName());
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)"text", (String)sr.getText());
        TestEntityRead.assertTokenType(2, sr.next());
        TestEntityRead.assertEquals((String)"tag", (String)sr.getLocalName());
        TestEntityRead.assertTokenType(5, sr.next());
        TestEntityRead.assertEquals((String)"comment", (String)sr.getText());
        TestEntityRead.assertTokenType(3, sr.next());
        TestEntityRead.assertEquals((String)"proc", (String)sr.getPITarget());
        TestEntityRead.assertEquals((String)"instr", (String)sr.getPIData().trim());
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)"A", (String)sr.getText());
        TestEntityRead.assertTokenType(2, sr.next());
        TestEntityRead.assertEquals((String)"root", (String)sr.getLocalName());
    }

    public void testQuotedCDataEndMarker() throws XMLStreamException {
        XMLStreamReader sr;
        String XML;
        try {
            XML = "<root>Ok the usual one: ]]&gt; and then alternatives: &#93;]>, &#93;&#93;&gt;</root>";
            sr = this.getReader(XML, true, false, true);
            this.streamThrough(sr);
        }
        catch (Exception e) {
            TestEntityRead.fail((String)("Didn't except problems with pre-def/char entity quoted ']]>'; got: " + e));
        }
        try {
            XML = "<!DOCTYPE root [\n<!ENTITY doubleBracket ']]'>\n]>\n<root> &doubleBracket;> and &doubleBracket;&gt;</root>";
            sr = this.getReader(XML, true, false, true);
            this.streamThrough(sr);
        }
        catch (Exception e) {
            TestEntityRead.fail((String)("Didn't except problems with general entity quoted ']]>'; got: " + e));
        }
    }

    public void testInvalidEntityUndeclared() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root>&myent;</root>", true, false, true);
        try {
            this.streamThrough(sr);
            TestEntityRead.fail((String)"Expected an exception for invalid comment content");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInvalidEntityRecursive() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ENTITY ent1 '&ent2;'>\n<!ENTITY ent2 '&ent2;'>\n]> <root>&ent1;</root>", false, true, true);
        this.streamThroughFailing(sr, "recursive general entity/ies");
    }

    public void testInvalidEntityPEInIntSubset() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ENTITY % pe 'xxx'>\n<!ENTITY foobar '%pe;'>\n]> <root />", false, true, true);
        this.streamThroughFailing(sr, "declaring a parameter entity in the internal DTD subset");
    }

    public void testInvalidEntityPartial() throws XMLStreamException {
        int lastType;
        int type2;
        int type1;
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ENTITY partial '&amp'>\n]><root>&partial;;</root>", false, false, true);
        try {
            type1 = sr.next();
            type2 = sr.next();
            while ((lastType = sr.next()) == 4) {
            }
        }
        catch (XMLStreamException e) {
            return;
        }
        catch (RuntimeException e) {
            return;
        }
        TestEntityRead.assertTokenType(11, type1);
        TestEntityRead.assertTokenType(1, type2);
        TestEntityRead.fail((String)("Expected an exception for partial entity reference: current token after text: " + TestEntityRead.tokenTypeDesc(lastType)));
    }

    public void testExternalEntityWithResolver() throws XMLStreamException {
        String ENTITY_VALUE1 = "some text from the external entity";
        String ACTUAL_VALUE1 = "ent='" + ENTITY_VALUE1 + "'";
        String XML = "<!DOCTYPE root [\n<!ENTITY extEnt SYSTEM 'myurl'>\n]><root>ent='&extEnt;'</root>";
        XMLInputFactory f = this.doGetFactory(true, true, true);
        if (!TestEntityRead.setSupportExternalEntities(f, true)) {
            this.reportNADueToExtEnt("testExternalEntityWithResolver");
            return;
        }
        TestEntityRead.setResolver(f, new SimpleResolver(ENTITY_VALUE1));
        XMLStreamReader sr = TestEntityRead.constructStreamReader(f, XML);
        TestEntityRead.assertTokenType(11, sr.next());
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)ACTUAL_VALUE1, (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertTokenType(2, sr.next());
        sr.close();
        String ENTITY_VALUE2 = "external entity: <leaf /> this &amp; that &intEnt;";
        String ACTUAL_VALUE2a = "ent='external entity: ";
        String ACTUAL_VALUE2b = " this & that & more!'";
        String XML2 = "<!DOCTYPE root [\n<!ENTITY extEnt SYSTEM 'myurl'>\n<!ENTITY intEnt '&amp; more!'>\n]><root>ent='&extEnt;'</root>";
        TestEntityRead.setResolver(f, new SimpleResolver(ENTITY_VALUE2));
        sr = TestEntityRead.constructStreamReader(f, XML2);
        TestEntityRead.assertTokenType(11, sr.next());
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)ACTUAL_VALUE2a, (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestEntityRead.assertTokenType(2, sr.next());
        TestEntityRead.assertTokenType(4, sr.next());
        TestEntityRead.assertEquals((String)ACTUAL_VALUE2b, (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertTokenType(2, sr.next());
        sr.close();
    }

    private void doTestProperties(boolean nsAware) throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ENTITY myent 'value'>\n<!ENTITY ent2 PUBLIC 'myurl' 'whatever.xml'>\n]><root>&myent;&ent2;</root>", nsAware, false, false);
        TestEntityRead.assertTokenType(11, sr.next());
        TestEntityRead.assertTokenType(1, sr.next());
        TestEntityRead.assertTokenType(9, sr.next());
        TestEntityRead.assertEquals((boolean)false, (boolean)sr.isStartElement());
        TestEntityRead.assertEquals((boolean)false, (boolean)sr.isEndElement());
        TestEntityRead.assertEquals((boolean)false, (boolean)sr.isCharacters());
        TestEntityRead.assertEquals((boolean)false, (boolean)sr.isWhiteSpace());
        TestEntityRead.assertEquals((boolean)false, (boolean)sr.hasName());
        TestEntityRead.assertEquals((boolean)true, (boolean)sr.hasText());
        TestEntityRead.assertEquals((String)"myent", (String)sr.getLocalName());
        TestEntityRead.assertEquals((String)"value", (String)TestEntityRead.getAndVerifyText(sr));
        TestEntityRead.assertNotNull((Object)sr.getLocation());
        if (nsAware) {
            TestEntityRead.assertNotNull((Object)sr.getNamespaceContext());
        }
        for (int i = 0; i <= 9; ++i) {
            String method = "";
            try {
                Object result = null;
                switch (i) {
                    case 0: {
                        method = "getName";
                        result = sr.getName();
                        break;
                    }
                    case 1: {
                        method = "getPrefix";
                        result = sr.getPrefix();
                        break;
                    }
                    case 2: {
                        method = "getNamespaceURI";
                        result = sr.getNamespaceURI();
                        break;
                    }
                    case 3: {
                        method = "getNamespaceCount";
                        result = new Integer(sr.getNamespaceCount());
                        break;
                    }
                    case 4: {
                        method = "getAttributeCount";
                        result = new Integer(sr.getAttributeCount());
                        break;
                    }
                    case 5: {
                        method = "getPITarget";
                        result = sr.getPITarget();
                        break;
                    }
                    case 6: {
                        method = "getPIData";
                        result = sr.getPIData();
                        break;
                    }
                    case 7: {
                        method = "getTextCharacters";
                        result = sr.getTextCharacters();
                        break;
                    }
                    case 8: {
                        method = "getTextStart";
                        result = new Integer(sr.getTextStart());
                        break;
                    }
                    case 9: {
                        method = "getTextLength";
                        result = new Integer(sr.getTextLength());
                    }
                }
                TestEntityRead.fail((String)("Expected IllegalArgumentException, when calling " + method + "() for ENTITY_REFERENCE"));
                continue;
            }
            catch (IllegalStateException iae) {
                // empty catch block
            }
        }
        TestEntityRead.assertTokenType(9, sr.next());
        TestEntityRead.assertEquals((String)"ent2", (String)sr.getLocalName());
        String text = sr.getText();
        if (text != null && text.length() > 0) {
            TestEntityRead.fail((String)("Expected getText() for external entity 'ent2' to return null or empty String; instead got '" + text + "'"));
        }
        TestEntityRead.assertTokenType(2, sr.next());
        TestEntityRead.assertTokenType(8, sr.next());
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, boolean coalescing, boolean replEntities) throws XMLStreamException {
        XMLInputFactory f = this.doGetFactory(nsAware, coalescing, replEntities);
        return TestEntityRead.constructStreamReader(f, contents);
    }

    private XMLInputFactory doGetFactory(boolean nsAware, boolean coalescing, boolean replEntities) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEntityRead.setNamespaceAware(f, nsAware);
        TestEntityRead.setSupportDTD(f, true);
        TestEntityRead.setCoalescing(f, coalescing);
        TestEntityRead.setSupportExternalEntities(f, true);
        TestEntityRead.setReplaceEntities(f, replEntities);
        TestEntityRead.setValidating(f, false);
        return f;
    }
}

