/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.NotationDeclaration;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestDoctypeDecl
extends BaseStreamTest {
    static final String UNPARSED_ENTITY_XML = "<!DOCTYPE root [\n<!NOTATION mynot PUBLIC 'some-notation'>\n<!ENTITY unp SYSTEM 'http://foo' NDATA mynot>\n]><root />";

    public void testProperties() throws XMLStreamException {
        this.doTestProperties(false);
        this.doTestProperties(true);
    }

    public void testMinimalValidDecl() throws XMLStreamException {
        this.doTestMinimalValid(false);
        this.doTestMinimalValid(true);
    }

    public void testSimpleValidDecl() throws XMLStreamException {
        this.doTestSimpleValid(false);
        this.doTestSimpleValid(true);
    }

    public void testTypicalValid() throws XMLStreamException {
        this.doTestTypicalValid(false);
        this.doTestTypicalValid(true);
    }

    public void testSimpleInvalidDecl() throws XMLStreamException {
        this.doTestSimpleInvalid(false);
        this.doTestSimpleInvalid(true);
    }

    public void testSimpleEntity() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(UNPARSED_ENTITY_XML, true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        List l = (List)sr.getProperty("javax.xml.stream.entities");
        TestDoctypeDecl.assertNotNull((Object)l);
        TestDoctypeDecl.assertEquals((int)1, (int)l.size());
        EntityDeclaration ed = (EntityDeclaration)l.get(0);
        TestDoctypeDecl.assertEquals((String)"unp", (String)ed.getName());
        TestDoctypeDecl.assertEquals((String)"mynot", (String)ed.getNotationName());
        sr.close();
    }

    public void testSimpleNotation() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(UNPARSED_ENTITY_XML, true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        List l = (List)sr.getProperty("javax.xml.stream.notations");
        TestDoctypeDecl.assertNotNull((Object)l);
        TestDoctypeDecl.assertEquals((int)1, (int)l.size());
        NotationDeclaration nd = (NotationDeclaration)l.get(0);
        TestDoctypeDecl.assertEquals((String)"mynot", (String)nd.getName());
    }

    public void testNonVldWithEmptyContentModel() throws XMLStreamException {
        boolean NS = true;
        String XML1 = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ELEMENT leaf ANY>\n]><root>";
        String XML2 = "</root>";
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ELEMENT leaf ANY>\n]><root>some text</root>", true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        TestDoctypeDecl.assertTokenType(1, sr.next());
        TestDoctypeDecl.assertTokenType(4, sr.next());
        this.streamThrough(sr);
        sr.close();
        sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ELEMENT leaf ANY>\n]><root>&amp;</root>", true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        this.streamThrough(sr);
        sr.close();
        sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ELEMENT leaf ANY>\n]><root><leaf></leaf></root>", true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        this.streamThrough(sr);
        sr.close();
    }

    public void testNonVldWithNonMixedContentModel() throws XMLStreamException {
        boolean NS = true;
        String XML1 = "<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf ANY>\n]><root>";
        String XML2 = "</root>";
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf ANY>\n]><root>some text<leaf /></root>", true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        TestDoctypeDecl.assertTokenType(1, sr.next());
        TestDoctypeDecl.assertTokenType(4, sr.next());
        this.streamThrough(sr);
        sr.close();
        sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root (leaf+)>\n<!ELEMENT leaf ANY>\n]><root>&amp; xxx<leaf></leaf></root>", true);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        this.streamThrough(sr);
        sr.close();
    }

    private void doTestProperties(boolean nsAware) throws XMLStreamException {
        String PROP_TEST = "<!DOCTYPE root [ <!-- comment --> ]><root />";
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [ <!-- comment --> ]><root />", nsAware);
        TestDoctypeDecl.assertEquals((int)11, (int)sr.next());
        TestDoctypeDecl.assertEquals((boolean)false, (boolean)sr.isStartElement());
        TestDoctypeDecl.assertEquals((boolean)false, (boolean)sr.isEndElement());
        TestDoctypeDecl.assertEquals((boolean)false, (boolean)sr.isCharacters());
        TestDoctypeDecl.assertEquals((boolean)false, (boolean)sr.isWhiteSpace());
        TestDoctypeDecl.assertEquals((boolean)false, (boolean)sr.hasName());
        TestDoctypeDecl.assertEquals((boolean)true, (boolean)sr.hasText());
        for (int i = 0; i <= 10; ++i) {
            String method = "";
            try {
                Object result = null;
                switch (i) {
                    case 0: {
                        method = "getName";
                        result = sr.getName();
                        break;
                    }
                    case 1: {
                        method = "getPrefix";
                        result = sr.getPrefix();
                        break;
                    }
                    case 2: {
                        method = "getLocalName";
                        result = sr.getLocalName();
                        break;
                    }
                    case 3: {
                        method = "getNamespaceURI";
                        result = sr.getNamespaceURI();
                        break;
                    }
                    case 4: {
                        method = "getNamespaceCount";
                        result = new Integer(sr.getNamespaceCount());
                        break;
                    }
                    case 5: {
                        method = "getAttributeCount";
                        result = new Integer(sr.getAttributeCount());
                        break;
                    }
                    case 6: {
                        method = "getPITarget";
                        result = sr.getPITarget();
                        break;
                    }
                    case 7: {
                        method = "getPIData";
                        result = sr.getPIData();
                        break;
                    }
                    case 8: {
                        method = "getTextCharacters";
                        result = sr.getTextCharacters();
                        break;
                    }
                    case 9: {
                        method = "getTextStart";
                        result = new Integer(sr.getTextStart());
                        break;
                    }
                    case 10: {
                        method = "getTextLength";
                        result = new Integer(sr.getTextLength());
                    }
                }
                TestDoctypeDecl.fail((String)("Expected IllegalStateException, when calling " + method + "() for DTD"));
                continue;
            }
            catch (IllegalStateException iae) {
                // empty catch block
            }
        }
        String str = sr.getText();
        if (str == null || str.trim().length() == 0) {
            TestDoctypeDecl.fail((String)"Internal subset not available; StreamReader.getText() returned an empty String (after trim())");
        }
    }

    private void doTestMinimalValid(boolean nsAware) throws XMLStreamException {
        String VALID_TEST = "<!DOCTYPE root><root />";
        XMLStreamReader sr = this.getReader("<!DOCTYPE root><root />", nsAware);
        TestDoctypeDecl.assertEquals((int)11, (int)sr.next());
        TestDoctypeDecl.assertEquals((int)1, (int)sr.next());
    }

    private void doTestSimpleValid(boolean nsAware) throws XMLStreamException {
        String INT_SUBSET = "<!-- comment -->";
        String VALID_TEST = "<!DOCTYPE root [ <!-- comment --> ]><root />";
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [ <!-- comment --> ]><root />", nsAware);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        String str = TestDoctypeDecl.getAndVerifyText(sr).trim();
        TestDoctypeDecl.assertEquals((String)"<!-- comment -->", (String)str);
        sr.close();
        String VALID_TEST2 = "<!DOCTYPE root><fubar />";
        sr = this.getReader("<!DOCTYPE root><fubar />", nsAware);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        TestDoctypeDecl.assertTokenType(1, sr.next());
        TestDoctypeDecl.assertEquals((String)"fubar", (String)sr.getLocalName());
        TestDoctypeDecl.assertTokenType(2, sr.next());
        TestDoctypeDecl.assertTokenType(8, sr.next());
    }

    private void doTestTypicalValid(boolean nsAware) throws XMLStreamException {
        int type;
        String VALID_TEST = "<!DOCTYPE root [\n<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n]>\n<root />";
        XMLStreamReader sr = this.getReader("<!DOCTYPE root [\n<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n]>\n<root />", nsAware);
        TestDoctypeDecl.assertTokenType(11, sr.next());
        while ((type = sr.next()) == 6) {
        }
        TestDoctypeDecl.assertTokenType(1, type);
    }

    private void doTestSimpleInvalid(boolean nsAware) throws XMLStreamException {
        String INVALID1 = "<!DOCTYPE>  <root />";
        this.streamThroughFailing(this.getReader("<!DOCTYPE>  <root />", nsAware), "invalid DOCTYPE declaration (missing root element)");
        String INVALID3 = "<!DOCTYPE root SYSTEM  ><root />";
        this.streamThroughFailing(this.getReader("<!DOCTYPE root SYSTEM  ><root />", nsAware), "invalid DOCTYPE declaration (missing SYSTEM identifier for DTD)");
        String INVALID4 = "<!DOCTYPE root PUBLIC  ><root />";
        this.streamThroughFailing(this.getReader("<!DOCTYPE root PUBLIC  ><root />", nsAware), "invalid DOCTYPE declaration (missing PUBLIC identifier for DTD)");
        String INVALID5 = "<!DOCTYPE & ><root />";
        this.streamThroughFailing(this.getReader("<!DOCTYPE & ><root />", nsAware), "invalid DOCTYPE declaration (unexpected ampersand character)");
    }

    private XMLStreamReader getReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestDoctypeDecl.setCoalescing(f, false);
        TestDoctypeDecl.setNamespaceAware(f, nsAware);
        TestDoctypeDecl.setValidating(f, false);
        TestDoctypeDecl.setSupportDTD(f, true);
        return TestDoctypeDecl.constructStreamReader(f, contents);
    }
}

