/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestCDataRead
extends BaseStreamTest {
    static final String CDATA1;
    static final String CDATA2;
    static final String CDATA3 = " ]] ";
    static final String EXP_CDATA;
    static final String VALID_XML;

    public void testCDataSimple() throws XMLStreamException {
        String XML = "<doc><![CDATA[<&]>]]]></doc>";
        String EXP = "<&]>]";
        XMLStreamReader sr = this.getReader(XML, true);
        TestCDataRead.assertTokenType(1, sr.next());
        TestCDataRead.assertTokenType(4, sr.next());
        String act = TestCDataRead.getAndVerifyText(sr);
        TestCDataRead.assertEquals((String)EXP, (String)act);
        TestCDataRead.assertTokenType(2, sr.next());
    }

    public void testCDataCoalescing() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(VALID_XML, true);
        TestCDataRead.assertTokenType(1, sr.next());
        TestCDataRead.assertTokenType(4, sr.next());
        String act = TestCDataRead.getAndVerifyText(sr);
        TestCDataRead.assertEquals((String)EXP_CDATA, (String)act);
        TestCDataRead.assertTokenType(2, sr.next());
    }

    public void testCDataNonCoalescing() throws XMLStreamException {
        XMLStreamReader sr = this.getReader(VALID_XML, false);
        TestCDataRead.assertTokenType(1, sr.next());
        int type = sr.next();
        if (type != 4) {
            TestCDataRead.assertEquals((String)("Unexpected token type (" + TestCDataRead.tokenTypeDesc(type) + ") returned; expected CDATA or CHARACTERS"), (int)12, (int)type);
        }
        StringBuffer sb = new StringBuffer(16000);
        do {
            sb.append(TestCDataRead.getAndVerifyText(sr));
        } while ((type = sr.next()) == 12 || type == 4);
        TestCDataRead.assertEquals((String)EXP_CDATA, (String)sb.toString());
        TestCDataRead.assertTokenType(2, sr.getEventType());
    }

    public void testInvalidCData() throws XMLStreamException {
        String XML = "<root><![CDATA[   </root>";
        String MSG = "unfinished CDATA section";
        this.streamThroughFailing(this.getReader(XML, false), MSG);
        this.streamThroughFailing(this.getReader(XML, true), MSG);
        XML = "<root><![CDATA  [text]]>   </root>";
        MSG = "malformed CDATA section";
        this.streamThroughFailing(this.getReader(XML, false), MSG);
        this.streamThroughFailing(this.getReader(XML, true), MSG);
        XML = "<root><!  [ CDATA  [text]]>   </root>";
        this.streamThroughFailing(this.getReader(XML, false), MSG);
        this.streamThroughFailing(this.getReader(XML, true), MSG);
        XML = "<root><![CDATA[text   ]] >   </root>";
        this.streamThroughFailing(this.getReader(XML, false), MSG);
        this.streamThroughFailing(this.getReader(XML, true), MSG);
    }

    public void testInvalidNestedCData() throws XMLStreamException {
        String XML = "<doc>\n<![CDATA[\n<![CDATA[XML doesn't allow CDATA sections to nest]]>\n\n]]>\n</doc>";
        block3: for (int i = 0; i < 2; ++i) {
            boolean coal = i > 0;
            XMLStreamReader sr = this.getReader(XML, coal);
            TestCDataRead.assertTokenType(1, sr.next());
            StringBuffer sb = new StringBuffer();
            int type = -1;
            try {
                while ((type = sr.next()) == 12 || type == 4) {
                    sb.append(TestCDataRead.getAndVerifyText(sr));
                }
            }
            catch (XMLStreamException sex) {
                continue;
            }
            catch (RuntimeException rex) {
                for (Throwable t = rex; t != null; t = t.getCause()) {
                    if (t instanceof XMLStreamException) continue block3;
                }
                TestCDataRead.fail((String)("Expected an XMLStreamException for nested CDATA section (coalescing: " + coal + "); instead got exception (" + rex.getClass() + "): " + rex.getMessage()));
            }
            TestCDataRead.fail((String)("Expected an exception for nested CDATA section (coalescing: " + coal + "); instead got text \"" + sb.toString() + "\" (next event " + TestCDataRead.tokenTypeDesc(type) + ")"));
        }
    }

    private XMLStreamReader getReader(String contents, boolean coalescing) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestCDataRead.setCoalescing(f, coalescing);
        TestCDataRead.setReplaceEntities(f, true);
        TestCDataRead.setValidating(f, false);
        return TestCDataRead.constructStreamReader(f, contents);
    }

    static {
        StringBuffer sb1 = new StringBuffer(8000);
        StringBuffer sb2 = new StringBuffer(8000);
        sb1.append("...");
        sb2.append("\n \n\n ");
        for (int i = 0; i < 200; ++i) {
            String txt = "Round #" + i + "; & that's fun: &x" + i + "; <> %xx; &ent  <<< %%% <![CDATA ]]  > ]> ";
            sb1.append(txt);
            sb1.append("  ");
            sb2.append("\n");
            sb2.append(txt);
        }
        CDATA1 = sb1.toString();
        CDATA2 = sb2.toString();
        EXP_CDATA = CDATA1 + CDATA2 + CDATA3;
        VALID_XML = "<root><![CDATA[" + CDATA1 + "]]>" + "<![CDATA[" + CDATA2 + "]]>" + "<![CDATA[]]>" + "<![CDATA[" + CDATA3 + "]]>" + "</root>";
    }
}

