/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestAttributeRead
extends BaseStreamTest {
    final String VALID_XML1 = "<root a='r&amp;b' a:b=\"&quot;\" xmlns:a='url' />";
    final String VALID_XML2 = "<root a:b=\"&quot;\" xmlns:a='url' />";
    final String VALID_XML3 = "<root><e1 a='123' /><e2 /></root>";
    static final String[] ATTR11_NAMES = new String[]{"method", "activeShell", "source", "data", "widget", "length", "start", "styledTextNewValue", "replacedText", "styledTextFunction", "raw"};
    static final String[] ATTR11_VALUES = new String[]{"a", "x", "y", "z", "a", "1", "2", "t", "", "f", "b"};

    public void testValidNsAttrsByName() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root a='r&amp;b' a:b=\"&quot;\" xmlns:a='url' />", true);
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)2, (int)sr.getAttributeCount());
        TestAttributeRead.assertEquals((String)"r&b", (String)sr.getAttributeValue(null, "a"));
        TestAttributeRead.assertEquals((String)"\"", (String)sr.getAttributeValue("url", "b"));
        String val = sr.getAttributeValue("a", "b");
        TestAttributeRead.assertNull((String)("Should get null, not '" + val + "'"), (Object)val);
        val = sr.getAttributeValue("", "b");
        TestAttributeRead.assertNull((String)("Should get null, not '" + val + "'"), (Object)val);
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((int)8, (int)sr.next());
    }

    public void testValidNsAttrsByName2() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root attr='1' />", true);
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttributeRead.assertEquals((String)"1", (String)sr.getAttributeValue(null, "attr"));
        TestAttributeRead.assertEquals((String)"1", (String)sr.getAttributeValue("", "attr"));
        TestAttributeRead.assertNull((Object)sr.getAttributeValue(null, "b"));
        TestAttributeRead.assertNull((Object)sr.getAttributeValue("", "b"));
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((int)8, (int)sr.next());
    }

    public void testValidNsAttrsByIndex() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root a='r&amp;b' a:b=\"&quot;\" xmlns:a='url' />", true);
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)2, (int)sr.getAttributeCount());
        String ln1 = sr.getAttributeLocalName(0);
        int index1 = 0;
        int index2 = 1;
        if (!ln1.equals("a")) {
            if (ln1.equals("b")) {
                index1 = 1;
                index2 = 0;
            } else {
                TestAttributeRead.fail((String)("Unexpected local name for attribute #0; expected either 'a' or 'b'; got '" + ln1 + "'."));
            }
        }
        TestAttributeRead.assertEquals((String)"a", (String)sr.getAttributeLocalName(index1));
        TestAttributeRead.assertEquals((String)"b", (String)sr.getAttributeLocalName(index2));
        TestAttributeRead.assertEquals((String)"r&b", (String)sr.getAttributeValue(index1));
        TestAttributeRead.assertEquals((String)"\"", (String)sr.getAttributeValue(index2));
        TestAttributeRead.assertNoAttrPrefix(sr.getAttributePrefix(index1));
        TestAttributeRead.assertEquals((String)"a", (String)sr.getAttributePrefix(index2));
        TestAttributeRead.assertNoAttrNamespace(sr.getAttributeNamespace(index1));
        TestAttributeRead.assertEquals((String)"url", (String)sr.getAttributeNamespace(index2));
    }

    public void testValidNsAttrs2() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root><e1 a='123' /><e2 /></root>", true);
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((String)"root", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((String)"e1", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttributeRead.assertEquals((String)"a", (String)sr.getAttributeLocalName(0));
        TestAttributeRead.assertEquals((String)"123", (String)sr.getAttributeValue(0));
        TestAttributeRead.assertEquals((String)"123", (String)sr.getAttributeValue(null, "a"));
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((String)"e1", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((String)"e2", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)0, (int)sr.getAttributeCount());
        String val = sr.getAttributeValue(null, "a");
        if (val != null) {
            TestAttributeRead.fail((String)("Should not find a value for attribute 'a', found '" + val + "'"));
        }
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((String)"e2", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((String)"root", (String)sr.getLocalName());
        sr.close();
    }

    public void testValidNsAttrNsInfo() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root a='xyz' xmlns:b='http://foo'><leaf b:attr='1' /></root>", true);
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((String)"root", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttributeRead.assertNoAttrPrefix(sr.getAttributePrefix(0));
        TestAttributeRead.assertNoAttrNamespace(sr.getAttributeNamespace(0));
        TestAttributeRead.assertEquals((String)"xyz", (String)sr.getAttributeValue(0));
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestAttributeRead.assertEquals((String)"b", (String)sr.getAttributePrefix(0));
        TestAttributeRead.assertEquals((String)"http://foo", (String)sr.getAttributeNamespace(0));
        TestAttributeRead.assertEquals((String)"1", (String)sr.getAttributeValue(0));
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((String)"root", (String)sr.getLocalName());
        TestAttributeRead.assertEquals((int)8, (int)sr.next());
    }

    public void testValidNonNsAttrs() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root a='r&amp;b' a:b=\"&quot;\" xmlns:a='url' />", false);
        if (sr == null) {
            return;
        }
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)3, (int)sr.getAttributeCount());
        TestAttributeRead.assertEquals((String)"r&b", (String)sr.getAttributeValue(null, "a"));
        TestAttributeRead.assertEquals((String)"\"", (String)sr.getAttributeValue(null, "a:b"));
        TestAttributeRead.assertEquals((int)2, (int)sr.next());
        TestAttributeRead.assertEquals((int)8, (int)sr.next());
    }

    public void testValidNonNsAttrsByIndex() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<root a:b=\"&quot;\" xmlns:a='url' />", false);
        if (sr == null) {
            return;
        }
        TestAttributeRead.assertEquals((int)1, (int)sr.next());
        TestAttributeRead.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestAttributeRead.assertEquals((int)2, (int)sr.getAttributeCount());
        String ln1 = sr.getAttributeLocalName(0);
        int index1 = 0;
        int index2 = 1;
        if (!ln1.equals("a:b")) {
            if (ln1.equals("xmlns:a")) {
                index1 = 1;
                index2 = 0;
            } else {
                TestAttributeRead.fail((String)("Unexpected local name for attribute #0; expected either 'a:b' or 'xmlns:a'; got '" + ln1 + "'."));
            }
        }
        TestAttributeRead.assertEquals((String)"a:b", (String)sr.getAttributeLocalName(index1));
        TestAttributeRead.assertEquals((String)"xmlns:a", (String)sr.getAttributeLocalName(index2));
        TestAttributeRead.assertEquals((String)"\"", (String)sr.getAttributeValue(index1));
        TestAttributeRead.assertEquals((String)"url", (String)sr.getAttributeValue(index2));
        TestAttributeRead.assertNoAttrPrefix(sr.getAttributePrefix(index1));
        TestAttributeRead.assertNoAttrPrefix(sr.getAttributePrefix(index2));
        TestAttributeRead.assertNoAttrNamespace(sr.getAttributeNamespace(index1));
        TestAttributeRead.assertNoAttrNamespace(sr.getAttributeNamespace(index2));
    }

    public void testInvalidAttrNames() throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<tree .attr='value' />", true);
        if (sr != null) {
            this.streamThroughFailing(sr, "invalid attribute name; can not start with '.'");
        }
        if ((sr = this.getReader("<tree .attr='value' />", false)) != null) {
            this.streamThroughFailing(sr, "invalid attribute name; can not start with '.'");
        }
        if ((sr = this.getReader("<tree attr?='value' />", false)) != null) {
            this.streamThroughFailing(sr, "invalid attribute name can not contain '?'");
        }
        if ((sr = this.getReader("<tree attr?='value' />", true)) != null) {
            this.streamThroughFailing(sr, "invalid attribute name can not contain '?'");
        }
    }

    public void testInvalidAttrValue() throws XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            String XML = "<root a='<' />";
            boolean ns = i > 0;
            XMLStreamReader sr = this.getReader(XML, ns);
            if (sr == null) continue;
            this.streamThroughFailing(sr, "unquoted '<' in attribute value");
            XML = "<root a />";
            this.streamThroughFailing(this.getReader(XML, ns), "missing value for attribute");
        }
    }

    public void testInvalidAttrSpaces() throws XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            String XML = "<root a='b'b='a' />";
            boolean ns = i > 0;
            XMLStreamReader sr = this.getReader(XML, ns);
            if (sr == null) continue;
            this.streamThroughFailing(sr, "missing space between attributes");
            XML = "<root a=\"b\"b=\"a\" />";
            this.streamThroughFailing(this.getReader(XML, ns), "missing space between attributes");
        }
    }

    public void testInvalidNsAttrDup() throws XMLStreamException {
        String XML = "<root xmlns:a='xxx' a:attr='1' a:attr='2' />";
        this.streamThroughFailing(this.getReader(XML, true), "duplicate attributes");
        XML = "<root xmlns:a='xxx' xmlns:b='xxx' a:attr='1' b:attr='2' />";
        this.streamThroughFailing(this.getReader(XML, true), "duplicate attributes (same URI, different prefix)");
        XML = "<a xmlns:a='abc' a:a='1' a:b='2' a:c='3' a:d='1' a:e='' a:b='2' />";
        this.streamThroughFailing(this.getReader(XML, true), "duplicate attributes");
        XML = "<a xmlns:a='abc' xmlns:b='abc' a:a='1' a:b='2' a:c='3' a:d='1' a:e='' b:c='2' />";
        this.streamThroughFailing(this.getReader(XML, true), "duplicate attributes (same URI, different prefix)");
    }

    public void testInvalidNonNsAttrDup() throws XMLStreamException {
        String XML = "<root xmlns:a='xxx' a:attr='1' a:attr='2' />";
        XMLStreamReader sr = this.getReader(XML, false);
        if (sr != null) {
            this.streamThroughFailing(sr, "duplicate attributes");
        }
        XML = "<root xmlns:a='xxx' xmlns:b='xxx' a:attr='1' b:attr='2' />";
        try {
            sr = this.getReader(XML, false);
            if (sr == null) {
                return;
            }
            this.streamThrough(sr);
        }
        catch (Exception e) {
            TestAttributeRead.fail((String)("Didn't expect an exception when namespace support not enabled: " + e));
        }
    }

    public void testManyAttrsNs() throws Exception {
        this.doTestManyAttrs(true);
    }

    public void testManyAttrsNonNs() throws Exception {
        this.doTestManyAttrs(false);
    }

    public void testInvalidAccessByIndex() throws Exception {
        Object n;
        String XML = "<root attr1='1' attr2='2'><leaf attr3='3' /></root>";
        XMLStreamReader sr = this.getReader(XML, true);
        TestAttributeRead.assertTokenType(1, sr.next());
        TestAttributeRead.assertEquals((int)2, (int)sr.getAttributeCount());
        TestAttributeRead.assertTokenType(1, sr.next());
        TestAttributeRead.assertEquals((int)1, (int)sr.getAttributeCount());
        try {
            String str = sr.getAttributeValue(1);
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeValue() with illegal index, no exception, value = [" + str + "]"));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeValue() with illegal index, got: " + e));
        }
        try {
            n = sr.getAttributeName(1);
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeName() with illegal index, no exception, name = [" + n + "]"));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeName() with illegal index, got: " + e));
        }
        try {
            n = sr.getAttributeLocalName(1);
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeLocalName() with illegal index, no exception, got = [" + (String)n + "]"));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeLocalName() with illegal index, got: " + e));
        }
        try {
            n = sr.getAttributeNamespace(1);
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeNamespace() with illegal index, no exception, got = [" + (String)n + "]"));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributeNamespace() with illegal index, got: " + e));
        }
        try {
            n = sr.getAttributePrefix(1);
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributePrefix() with illegal index, no exception, got = [" + (String)n + "]"));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception e) {
            TestAttributeRead.fail((String)("Expected IllegalArgumentException for sr.getAttributePrefix() with illegal index, got: " + e));
        }
        sr.close();
    }

    public void testManyAttributes() throws Exception {
        int max = 100;
        Reader reader = new Reader(){
            StringReader sreader = new StringReader("<ns:element xmlns:ns=\"http://foo.com\"");
            int count;
            boolean done;

            public int read(char[] cbuf, int off, int len) throws IOException {
                int i = this.sreader.read(cbuf, off, len);
                if (i == -1) {
                    if (this.count < 100) {
                        this.sreader = new StringReader(" attribute" + this.count++ + "=\"foo\"");
                    } else if (!this.done) {
                        this.sreader = new StringReader("/>");
                        this.done = true;
                    }
                    i = this.sreader.read(cbuf, off, len);
                }
                return i;
            }

            public void close() throws IOException {
            }
        };
        try {
            XMLInputFactory factory = TestAttributeRead.getNewInputFactory();
            factory.setProperty("com.ctc.wstx.maxAttributesPerElement", 50);
            XMLStreamReader xmlreader = factory.createXMLStreamReader(reader);
            xmlreader.getProperty("com.ctc.wstx.maxAttributesPerElement");
            xmlreader.nextTag();
            TestAttributeRead.fail((String)"Should have failed");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private String get11AttrDoc() {
        StringBuffer sb = new StringBuffer();
        sb.append("<root");
        for (int i = 0; i < ATTR11_NAMES.length; ++i) {
            sb.append(' ');
            sb.append(ATTR11_NAMES[i]);
            sb.append('=');
            sb.append((i & 1) == 0 ? (char)'\"' : '\'');
            sb.append(ATTR11_VALUES[i]);
            sb.append((i & 1) == 0 ? (char)'\"' : '\'');
        }
        sb.append(" />");
        return sb.toString();
    }

    private void doTestManyAttrs(boolean ns) throws XMLStreamException {
        XMLStreamReader sr = this.getReader(this.get11AttrDoc(), ns);
        if (sr == null) {
            return;
        }
        TestAttributeRead.assertTokenType(1, sr.next());
        TestAttributeRead.assertEquals((int)11, (int)sr.getAttributeCount());
        int i = ATTR11_NAMES.length;
        while (--i >= 0) {
            String name = ATTR11_NAMES[i];
            String value = ATTR11_VALUES[i];
            TestAttributeRead.assertEquals((String)value, (String)sr.getAttributeValue(null, name));
            TestAttributeRead.assertEquals((String)value, (String)sr.getAttributeValue(null, "" + name));
            String start = name.substring(0, 1);
            TestAttributeRead.assertNull((String)value, (Object)sr.getAttributeValue(null, name + start));
            TestAttributeRead.assertNull((String)value, (Object)sr.getAttributeValue(null, start + name));
        }
        TestAttributeRead.assertTokenType(2, sr.next());
    }

    private XMLStreamReader getReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        if (!TestAttributeRead.setNamespaceAware(f, nsAware)) {
            return null;
        }
        TestAttributeRead.setCoalescing(f, true);
        TestAttributeRead.setValidating(f, false);
        return TestAttributeRead.constructStreamReader(f, contents);
    }
}

