//
//  UISwitch+Combine.swift
//  CombineCocoa
//
//  Created by Shai Mishali on 02/08/2019.
//  Copyright © 2019 Shai Mishali. All rights reserved.
//

import Combine
import UIKit

public extension UISwitch {
  /// A publisher emitting on status changes for this switch.
  var isOnPublisher: AnyPublisher<Bool, Never> {
    CombineControlProperty(control: self, events: .defaultValueEvents, keyPath: \.isOn)
      .eraseToAnyPublisher()
  }
}
