/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Collection;
import sandbox.java.util.HashMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.ResourceBundle;

public class Level
implements Serializable {
    private static final String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private transient String localizedLevelName;
    private transient Locale cachedLocale;
    public static final Level OFF;
    public static final Level SEVERE;
    public static final Level WARNING;
    public static final Level INFO;
    public static final Level CONFIG;
    public static final Level FINE;
    public static final Level FINER;
    public static final Level FINEST;
    public static final Level ALL;
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String string, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        this(string, n, null);
    }

    protected Level(String string, int n, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;Z)V");
        this(string, n, string2, true);
    }

    private Level(String string, int n, String string2, boolean bl) {
        String string3;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.name = string;
        this.value = n;
        this.resourceBundleName = string2;
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            string3 = string;
            RuntimeCostAccounter.recordJump();
        } else {
            string3 = null;
        }
        this.localizedLevelName = string3;
        this.cachedLocale = null;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.add:(Ljava/util/logging/Level;)V");
            KnownLevel.add(this);
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.getLocalizedLevelName:()Ljava/lang/String;");
        return this.getLocalizedLevelName();
    }

    final String getLevelName() {
        return this.name;
    }

    /*
     * Unable to fully structure code
     */
    private String computeLocalizedLevelName(Locale var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getBundle:(Ljava/lang/String;Ljava/util/Locale;)Ljava/util/ResourceBundle;");
        var2_2 = ResourceBundle.getBundle(this.resourceBundleName, var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getString:(Ljava/lang/String;)Ljava/lang/String;");
        var3_3 = var2_2.getString(this.name);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        var4_4 = "sun.util.logging.resources.logging".equals(this.resourceBundleName);
        RuntimeCostAccounter.recordJump();
        if (!var4_4) {
            return var3_3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getLocale:()Ljava/util/Locale;");
        var5_5 = var2_2.getLocale();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
        v0 = Locale.ROOT.equals(var5_5);
        RuntimeCostAccounter.recordJump();
        if (v0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
        v1 = var3_3.toUpperCase(Locale.ROOT);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        v2 = this.name.equals(v1);
        RuntimeCostAccounter.recordJump();
        if (v2) lbl-1000:
        // 2 sources

        {
            v3 = Locale.ROOT;
            RuntimeCostAccounter.recordJump();
        } else {
            v3 = var5_5;
        }
        var6_6 = v3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
        v4 = Locale.ROOT.equals(var6_6);
        RuntimeCostAccounter.recordJump();
        if (v4) {
            v5 = this.name;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
            v5 = var3_3.toUpperCase(var6_6);
        }
        return v5;
    }

    final String getCachedLocalizedLevelName() {
        RuntimeCostAccounter.recordJump();
        if (this.localizedLevelName != null) {
            RuntimeCostAccounter.recordJump();
            if (this.cachedLocale != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
                Locale locale = Locale.getDefault();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.cachedLocale.equals(locale);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return this.localizedLevelName;
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.resourceBundleName == null) {
            return this.name;
        }
        return null;
    }

    final synchronized String getLocalizedLevelName() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.getCachedLocalizedLevelName:()Ljava/lang/String;");
        String string = this.getCachedLocalizedLevelName();
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            return string;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.computeLocalizedLevelName:(Ljava/util/Locale;)Ljava/lang/String;");
            this.localizedLevelName = this.computeLocalizedLevelName(locale);
        }
        catch (Exception exception) {
            this.localizedLevelName = this.name;
        }
        RuntimeCostAccounter.recordJump();
        this.cachedLocale = locale;
        return this.localizedLevelName;
    }

    static Level findLevel(String string) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByName:(Ljava/lang/String;)Ljava/util/logging/Level$KnownLevel;");
        KnownLevel knownLevel = KnownLevel.findByName(string);
        RuntimeCostAccounter.recordJump();
        if (knownLevel != null) {
            return knownLevel.mirroredLevel;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
            int n = Integer.parseInt(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByValue:(I)Ljava/util/logging/Level$KnownLevel;");
            knownLevel = KnownLevel.findByValue(n);
            RuntimeCostAccounter.recordJump();
            if (knownLevel == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;I)V");
                Level level = new Level(string, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByValue:(I)Ljava/util/logging/Level$KnownLevel;");
                knownLevel = KnownLevel.findByValue(n);
            }
            return knownLevel.mirroredLevel;
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByLocalizedLevelName:(Ljava/lang/String;)Ljava/util/logging/Level$KnownLevel;");
            knownLevel = KnownLevel.findByLocalizedLevelName(string);
            RuntimeCostAccounter.recordJump();
            if (knownLevel != null) {
                return knownLevel.mirroredLevel;
            }
            return null;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    private Object readResolve() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.matches:(Ljava/util/logging/Level;)Ljava/util/logging/Level$KnownLevel;");
        KnownLevel knownLevel = KnownLevel.matches(this);
        RuntimeCostAccounter.recordJump();
        if (knownLevel != null) {
            return knownLevel.levelObject;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        Level level = new Level(this.name, this.value, this.resourceBundleName);
        return level;
    }

    public static synchronized Level parse(String string) throws IllegalArgumentException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        string.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByName:(Ljava/lang/String;)Ljava/util/logging/Level$KnownLevel;");
        KnownLevel knownLevel = KnownLevel.findByName(string);
        RuntimeCostAccounter.recordJump();
        if (knownLevel != null) {
            return knownLevel.levelObject;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
            int n = Integer.parseInt(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByValue:(I)Ljava/util/logging/Level$KnownLevel;");
            knownLevel = KnownLevel.findByValue(n);
            RuntimeCostAccounter.recordJump();
            if (knownLevel == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;I)V");
                Level level = new Level(string, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByValue:(I)Ljava/util/logging/Level$KnownLevel;");
                knownLevel = KnownLevel.findByValue(n);
            }
            return knownLevel.levelObject;
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.findByLocalizedLevelName:(Ljava/lang/String;)Ljava/util/logging/Level$KnownLevel;");
            knownLevel = KnownLevel.findByLocalizedLevelName(string);
            RuntimeCostAccounter.recordJump();
            if (knownLevel != null) {
                return knownLevel.levelObject;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Bad level \"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("\"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
    }

    public boolean equals(Object object) {
        try {
            boolean bl;
            Level level = (Level)object;
            int n = level.value;
            RuntimeCostAccounter.recordJump();
            if (n == this.value) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    /* synthetic */ Level(String string, int n, String string2, boolean bl, 1 var5_5) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;Z)V");
        this(string, n, string2, bl);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        OFF = new Level("OFF", Integer.MAX_VALUE, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        SEVERE = new Level("SEVERE", 1000, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        WARNING = new Level("WARNING", 900, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        INFO = new Level("INFO", 800, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        CONFIG = new Level("CONFIG", 700, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        FINE = new Level("FINE", 500, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        FINER = new Level("FINER", 400, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        FINEST = new Level("FINEST", 300, defaultBundle);
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;)V");
        ALL = new Level("ALL", Integer.MIN_VALUE, defaultBundle);
    }

    static final class KnownLevel {
        private static Map<String, List<KnownLevel>> nameToLevels;
        private static Map<Integer, List<KnownLevel>> intToLevels;
        final Level levelObject;
        final Level mirroredLevel;

        KnownLevel(Level level) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.levelObject = level;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = level.getClass();
            RuntimeCostAccounter.recordJump();
            if (clazz == Level.class) {
                this.mirroredLevel = level;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$000:(Ljava/util/logging/Level;)Ljava/lang/String;");
                String string = level.name;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$100:(Ljava/util/logging/Level;)I");
                int n = level.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$200:(Ljava/util/logging/Level;)Ljava/lang/String;");
                String string2 = level.resourceBundleName;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.<init>:(Ljava/lang/String;ILjava/lang/String;ZLjava/util/logging/Level$1;)V");
                this.mirroredLevel = new Level(string, n, string2, false, null);
            }
        }

        static synchronized void add(Level level) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/logging/Level$KnownLevel");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level$KnownLevel.<init>:(Ljava/util/logging/Level;)V");
            KnownLevel knownLevel = new KnownLevel(level);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$000:(Ljava/util/logging/Level;)Ljava/lang/String;");
            String string = level.name;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            List<KnownLevel> list = nameToLevels.get(string);
            RuntimeCostAccounter.recordJump();
            if (list == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
                list = new ArrayList<KnownLevel>();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$000:(Ljava/util/logging/Level;)Ljava/lang/String;");
                String string2 = level.name;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                nameToLevels.put(string2, list);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            list.add(knownLevel);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$100:(Ljava/util/logging/Level;)I");
            int n = level.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            Integer n2 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            list = intToLevels.get(n2);
            RuntimeCostAccounter.recordJump();
            if (list == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
                list = new ArrayList<KnownLevel>();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$100:(Ljava/util/logging/Level;)I");
                int n3 = level.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                Integer n4 = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                intToLevels.put(n4, list);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            list.add(knownLevel);
        }

        static synchronized KnownLevel findByName(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            List<KnownLevel> list = nameToLevels.get(string);
            RuntimeCostAccounter.recordJump();
            if (list != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                return list.get(0);
            }
            return null;
        }

        static synchronized KnownLevel findByValue(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            Integer n2 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            List<KnownLevel> list = intToLevels.get(n2);
            RuntimeCostAccounter.recordJump();
            if (list != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                return list.get(0);
            }
            return null;
        }

        static synchronized KnownLevel findByLocalizedLevelName(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.values:()Ljava/util/Collection;");
            Collection<List<KnownLevel>> collection = nameToLevels.values();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
            Iterator<List<KnownLevel>> iterator = collection.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                List<KnownLevel> list = iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
                Iterator<KnownLevel> iterator2 = list.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl2 = iterator2.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    KnownLevel knownLevel = iterator2.next();
                    Level level = knownLevel.levelObject;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.getLocalizedLevelName:()Ljava/lang/String;");
                    String string2 = level.getLocalizedLevelName();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = string.equals(string2);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        return knownLevel;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            }
            return null;
        }

        static synchronized KnownLevel matches(Level level) {
            block3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$000:(Ljava/util/logging/Level;)Ljava/lang/String;");
                String string = level.name;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                List<KnownLevel> list = nameToLevels.get(string);
                RuntimeCostAccounter.recordJump();
                if (list == null) break block3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
                Iterator<KnownLevel> iterator = list.iterator();
                while (true) {
                    block4: {
                        KnownLevel knownLevel;
                        block5: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                            boolean bl = iterator.hasNext();
                            RuntimeCostAccounter.recordJump();
                            if (!bl) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                            knownLevel = iterator.next();
                            Level level2 = knownLevel.mirroredLevel;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$100:(Ljava/util/logging/Level;)I");
                            int n = level.value;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$100:(Ljava/util/logging/Level;)I");
                            int n2 = level2.value;
                            RuntimeCostAccounter.recordJump();
                            if (n != n2) break block4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$200:(Ljava/util/logging/Level;)Ljava/lang/String;");
                            String string2 = level.resourceBundleName;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$200:(Ljava/util/logging/Level;)Ljava/lang/String;");
                            String string3 = level2.resourceBundleName;
                            RuntimeCostAccounter.recordJump();
                            if (string2 == string3) break block5;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$200:(Ljava/util/logging/Level;)Ljava/lang/String;");
                            String string4 = level.resourceBundleName;
                            RuntimeCostAccounter.recordJump();
                            if (string4 == null) break block4;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$200:(Ljava/util/logging/Level;)Ljava/lang/String;");
                            String string5 = level.resourceBundleName;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.access$200:(Ljava/util/logging/Level;)Ljava/lang/String;");
                            String string6 = level2.resourceBundleName;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                            boolean bl2 = string5.equals(string6);
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) break block4;
                        }
                        return knownLevel;
                    }
                    RuntimeCostAccounter.recordJump();
                }
            }
            return null;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
            nameToLevels = new HashMap<String, List<KnownLevel>>();
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
            intToLevels = new HashMap<Integer, List<KnownLevel>>();
        }
    }
}

