/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Period;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateImpl;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.JapaneseChronology;
import sandbox.java.time.chrono.JapaneseEra;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Calendar;
import sandbox.java.util.Objects;
import sandbox.sun.util.calendar.CalendarDate;
import sandbox.sun.util.calendar.Era;
import sandbox.sun.util.calendar.LocalGregorianCalendar;

public final class JapaneseDate
extends ChronoLocalDateImpl<JapaneseDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -305327627230580483L;
    private final transient LocalDate isoDate;
    private transient JapaneseEra era;
    private transient int yearOfEra;
    static final LocalDate MEIJI_6_ISODATE;

    public static JapaneseDate now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.now:(Ljava/time/Clock;)Ljava/time/chrono/JapaneseDate;");
        return JapaneseDate.now(clock);
    }

    public static JapaneseDate now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.now:(Ljava/time/Clock;)Ljava/time/chrono/JapaneseDate;");
        return JapaneseDate.now(clock);
    }

    public static JapaneseDate now(Clock clock) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
        return new JapaneseDate(localDate);
    }

    public static JapaneseDate of(JapaneseEra japaneseEra, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(japaneseEra, "era");
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.newCalendarDate:(Ljava/util/TimeZone;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
        LocalGregorianCalendar.Date date = JapaneseChronology.JCAL.newCalendarDate(null);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
        Era era = japaneseEra.getPrivateEra();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setEra:(Lsun/util/calendar/Era;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
        LocalGregorianCalendar.Date date2 = date.setEra(era);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setDate:(III)Lsun/util/calendar/CalendarDate;");
        date2.setDate(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.validate:(Lsun/util/calendar/CalendarDate;)Z");
        boolean bl = JapaneseChronology.JCAL.validate((CalendarDate)date);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("year, month, and day not valid for Era");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getNormalizedYear:()I");
        int n4 = date.getNormalizedYear();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n4, n2, n3);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/chrono/JapaneseEra;ILjava/time/LocalDate;)V");
        return new JapaneseDate(japaneseEra, n, localDate);
    }

    public static JapaneseDate of(int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
        return new JapaneseDate(localDate);
    }

    static JapaneseDate ofYearDay(JapaneseEra japaneseEra, int n, int n2) {
        LocalGregorianCalendar.Date date;
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(japaneseEra, "era");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
                Era era = japaneseEra.getPrivateEra();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getSinceDate:()Lsun/util/calendar/CalendarDate;");
                CalendarDate calendarDate = era.getSinceDate();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.newCalendarDate:(Ljava/util/TimeZone;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
                date = JapaneseChronology.JCAL.newCalendarDate(null);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
                Era era2 = japaneseEra.getPrivateEra();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setEra:(Lsun/util/calendar/Era;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
                date.setEra(era2);
                RuntimeCostAccounter.recordJump();
                if (n == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getMonth:()I");
                    int n3 = calendarDate.getMonth();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getDayOfMonth:()I");
                    int n4 = calendarDate.getDayOfMonth() + n2 - 1;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setDate:(III)Lsun/util/calendar/CalendarDate;");
                    date.setDate(n, n3, n4);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setDate:(III)Lsun/util/calendar/CalendarDate;");
                    date.setDate(n, 1, n2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.normalize:(Lsun/util/calendar/CalendarDate;)Z");
                JapaneseChronology.JCAL.normalize((CalendarDate)date);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getPrivateEra:()Lsun/util/calendar/Era;");
                Era era3 = japaneseEra.getPrivateEra();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getEra:()Lsun/util/calendar/Era;");
                Era era4 = date.getEra();
                RuntimeCostAccounter.recordJump();
                if (era3 != era4) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getYear:()I");
                int n5 = date.getYear();
                RuntimeCostAccounter.recordJump();
                if (n == n5) break block6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Invalid parameters");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getNormalizedYear:()I");
        int n6 = date.getNormalizedYear();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getMonth:()I");
        int n7 = date.getMonth();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getDayOfMonth:()I");
        int n8 = date.getDayOfMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n6, n7, n8);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/chrono/JapaneseEra;ILjava/time/LocalDate;)V");
        return new JapaneseDate(japaneseEra, n, localDate);
    }

    public static JapaneseDate from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/JapaneseDate;");
        return JapaneseChronology.INSTANCE.date(temporalAccessor);
    }

    JapaneseDate(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isBefore:(Ljava/time/chrono/ChronoLocalDate;)Z");
        boolean bl = localDate.isBefore(MEIJI_6_ISODATE);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("JapaneseDate before Meiji 6 is not supported");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.toPrivateJapaneseDate:(Ljava/time/LocalDate;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
        LocalGregorianCalendar.Date date = JapaneseDate.toPrivateJapaneseDate(localDate);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getEra:()Lsun/util/calendar/Era;");
        Era era = date.getEra();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.toJapaneseEra:(Lsun/util/calendar/Era;)Ljava/time/chrono/JapaneseEra;");
        this.era = JapaneseEra.toJapaneseEra(era);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.getYear:()I");
        this.yearOfEra = date.getYear();
        this.isoDate = localDate;
    }

    JapaneseDate(JapaneseEra japaneseEra, int n, LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isBefore:(Ljava/time/chrono/ChronoLocalDate;)Z");
        boolean bl = localDate.isBefore(MEIJI_6_ISODATE);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("JapaneseDate before Meiji 6 is not supported");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        this.era = japaneseEra;
        this.yearOfEra = n;
        this.isoDate = localDate;
    }

    @Override
    public JapaneseChronology getChronology() {
        return JapaneseChronology.INSTANCE;
    }

    @Override
    public JapaneseEra getEra() {
        return this.era;
    }

    @Override
    public int lengthOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.lengthOfMonth:()I");
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public int lengthOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getInstance:(Ljava/util/Locale;)Ljava/util/Calendar;");
        Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
        int n = this.era.getValue() + 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.set:(II)V");
        calendar.set(0, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonthValue:()I");
        int n2 = this.isoDate.getMonthValue() - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
        int n3 = this.isoDate.getDayOfMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.set:(III)V");
        calendar.set(this.yearOfEra, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getActualMaximum:(I)I");
        return calendar.getActualMaximum(6);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (temporalField == ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH) break block2;
                RuntimeCostAccounter.recordJump();
                if (temporalField == ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR) break block2;
                RuntimeCostAccounter.recordJump();
                if (temporalField == ChronoField.ALIGNED_WEEK_OF_MONTH) break block2;
                RuntimeCostAccounter.recordJump();
                if (temporalField != ChronoField.ALIGNED_WEEK_OF_YEAR) break block3;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
        return ChronoLocalDate.super.isSupported(temporalField);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl2 = this.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                ChronoField chronoField = (ChronoField)temporalField;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
                switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                    case 1: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.lengthOfMonth:()I");
                        long l = this.lengthOfMonth();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, l);
                    }
                    case 2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.lengthOfYear:()I");
                        long l = this.lengthOfYear();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, l);
                    }
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getInstance:(Ljava/util/Locale;)Ljava/util/Calendar;");
                        Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
                        int n = this.era.getValue() + 2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.set:(II)V");
                        calendar.set(0, n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonthValue:()I");
                        int n2 = this.isoDate.getMonthValue() - 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
                        int n3 = this.isoDate.getDayOfMonth();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.set:(III)V");
                        calendar.set(this.yearOfEra, n2, n3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getActualMaximum:(I)I");
                        long l = calendar.getActualMaximum(1);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, l);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getChronology:()Ljava/time/chrono/JapaneseChronology;");
                JapaneseChronology japaneseChronology = this.getChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                return japaneseChronology.range(chronoField);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                    UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedTemporalTypeException;
                }
                case 3: {
                    return this.yearOfEra;
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
                    return this.era.getValue();
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.getInstance:(Ljava/util/Locale;)Ljava/util/Calendar;");
                    Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.getValue:()I");
                    int n = this.era.getValue() + 2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.set:(II)V");
                    calendar.set(0, n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonthValue:()I");
                    int n2 = this.isoDate.getMonthValue() - 1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
                    int n3 = this.isoDate.getDayOfMonth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.set:(III)V");
                    calendar.set(this.yearOfEra, n2, n3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Calendar.get:(I)I");
                    return calendar.get(6);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
            return this.isoDate.getLong(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    private static LocalGregorianCalendar.Date toPrivateJapaneseDate(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.newCalendarDate:(Ljava/util/TimeZone;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
        LocalGregorianCalendar.Date date = JapaneseChronology.JCAL.newCalendarDate(null);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.privateEraFrom:(Ljava/time/LocalDate;)Lsun/util/calendar/Era;");
        Era era = JapaneseEra.privateEraFrom(localDate);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
        int n = localDate.getYear();
        RuntimeCostAccounter.recordJump();
        if (era != null) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/Era.getSinceDate:()Lsun/util/calendar/CalendarDate;");
            CalendarDate calendarDate = era.getSinceDate();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.getYear:()I");
            n -= calendarDate.getYear() - 1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setEra:(Lsun/util/calendar/Era;)Lsun/util/calendar/LocalGregorianCalendar$Date;");
        LocalGregorianCalendar.Date date2 = date.setEra(era);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setYear:(I)Lsun/util/calendar/LocalGregorianCalendar$Date;");
        LocalGregorianCalendar.Date date3 = date2.setYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonthValue:()I");
        int n2 = localDate.getMonthValue();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar$Date.setMonth:(I)Lsun/util/calendar/CalendarDate;");
        CalendarDate calendarDate = date3.setMonth(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
        int n3 = localDate.getDayOfMonth();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/CalendarDate.setDayOfMonth:(I)Lsun/util/calendar/CalendarDate;");
        calendarDate.setDayOfMonth(n3);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/LocalGregorianCalendar.normalize:(Lsun/util/calendar/CalendarDate;)Z");
        JapaneseChronology.JCAL.normalize((CalendarDate)date);
        return date;
    }

    @Override
    public JapaneseDate with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getLong:(Ljava/time/temporal/TemporalField;)J");
            long l2 = this.getLong(chronoField) - l;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 == false) {
                return this;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 3: 
                case 8: 
                case 9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getChronology:()Ljava/time/chrono/JapaneseChronology;");
                    JapaneseChronology japaneseChronology = this.getChronology();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                    ValueRange valueRange = japaneseChronology.range(chronoField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                    int n = valueRange.checkValidIntValue(l, chronoField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
                    switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                        case 3: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.withYear:(I)Ljava/time/chrono/JapaneseDate;");
                            return this.withYear(n);
                        }
                        case 9: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                            LocalDate localDate = this.isoDate.withYear(n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
                            return this.with(localDate);
                        }
                        case 8: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseEra.of:(I)Ljava/time/chrono/JapaneseEra;");
                            JapaneseEra japaneseEra = JapaneseEra.of(n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.withYear:(Ljava/time/chrono/JapaneseEra;I)Ljava/time/chrono/JapaneseDate;");
                            return this.withYear(japaneseEra, this.yearOfEra);
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalDate;");
            LocalDate localDate = this.isoDate.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
            return this.with(localDate);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.with(temporalField, l);
    }

    @Override
    public JapaneseDate with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.with(temporalAdjuster);
    }

    @Override
    public JapaneseDate plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.plus(temporalAmount);
    }

    @Override
    public JapaneseDate minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.minus(temporalAmount);
    }

    private JapaneseDate withYear(JapaneseEra japaneseEra, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n2 = JapaneseChronology.INSTANCE.prolepticYear(japaneseEra, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.withYear(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
        return this.with(localDate);
    }

    private JapaneseDate withYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getEra:()Ljava/time/chrono/JapaneseEra;");
        JapaneseEra japaneseEra = this.getEra();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.withYear:(Ljava/time/chrono/JapaneseEra;I)Ljava/time/chrono/JapaneseDate;");
        return this.withYear(japaneseEra, n);
    }

    @Override
    JapaneseDate plusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusYears(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
        return this.with(localDate);
    }

    @Override
    JapaneseDate plusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusMonths(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
        return this.with(localDate);
    }

    @Override
    JapaneseDate plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusWeeks(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
        return this.with(localDate);
    }

    @Override
    JapaneseDate plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.isoDate.plusDays(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.with:(Ljava/time/LocalDate;)Ljava/time/chrono/JapaneseDate;");
        return this.with(localDate);
    }

    @Override
    public JapaneseDate plus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.plus(l, temporalUnit);
    }

    @Override
    public JapaneseDate minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.minus(l, temporalUnit);
    }

    @Override
    JapaneseDate minusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.minusYears(l);
    }

    @Override
    JapaneseDate minusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.minusMonths(l);
    }

    @Override
    JapaneseDate minusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.minusWeeks(l);
    }

    @Override
    JapaneseDate minusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.minusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
        return (JapaneseDate)super.minusDays(l);
    }

    private JapaneseDate with(LocalDate localDate) {
        JapaneseDate japaneseDate;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.equals:(Ljava/lang/Object;)Z");
        boolean bl = localDate.equals(this.isoDate);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            japaneseDate = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/JapaneseDate");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.<init>:(Ljava/time/LocalDate;)V");
            japaneseDate = new JapaneseDate(localDate);
        }
        return japaneseDate;
    }

    public final ChronoLocalDateTime<JapaneseDate> atTime(LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.until:(Ljava/time/chrono/ChronoLocalDate;)Ljava/time/Period;");
        Period period = this.isoDate.until(chronoLocalDate);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getChronology:()Ljava/time/chrono/JapaneseChronology;");
        JapaneseChronology japaneseChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getYears:()I");
        int n = period.getYears();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getMonths:()I");
        int n2 = period.getMonths();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getDays:()I");
        int n3 = period.getDays();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.period:(III)Ljava/time/chrono/ChronoPeriod;");
        return japaneseChronology.period(n, n2, n3);
    }

    @Override
    public long toEpochDay() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof JapaneseDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            JapaneseDate japaneseDate = (JapaneseDate)object;
            LocalDate localDate = japaneseDate.isoDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.equals:(Ljava/lang/Object;)Z");
            return this.isoDate.equals(localDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.getChronology:()Ljava/time/chrono/JapaneseChronology;");
        JapaneseChronology japaneseChronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.getId:()Ljava/lang/String;");
        String string = japaneseChronology.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        int n = string.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.hashCode:()I");
        return n ^ this.isoDate.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(4, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n = this.get(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n2 = this.get(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseDate.get:(Ljava/time/temporal/TemporalField;)I");
        int n3 = this.get(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n3);
    }

    static JapaneseDate readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by2 = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/JapaneseChronology.date:(III)Ljava/time/chrono/JapaneseDate;");
        return JapaneseChronology.INSTANCE.date(n, by, by2);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        MEIJI_6_ISODATE = LocalDate.of(1873, 1, 1);
    }
}

