/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.locks;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.concurrent.ThreadLocalRandom;
import sandbox.sun.misc.Unsafe;

public class LockSupport {
    private static final Unsafe UNSAFE;
    private static final long parkBlockerOffset;
    private static final long SEED;
    private static final long PROBE;
    private static final long SECONDARY;

    private LockSupport() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    private static void setBlocker(Thread thread, Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
        UNSAFE.putObject((Object)thread, parkBlockerOffset, object);
    }

    public static void unpark(Thread thread) {
        RuntimeCostAccounter.recordJump();
        if (thread != null) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.unpark:(Ljava/lang/Object;)V");
            UNSAFE.unpark((Object)thread);
        }
    }

    public static void park(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.setBlocker:(Ljava/lang/Thread;Ljava/lang/Object;)V");
        LockSupport.setBlocker(thread, object);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
        UNSAFE.park(false, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.setBlocker:(Ljava/lang/Thread;Ljava/lang/Object;)V");
        LockSupport.setBlocker(thread, null);
    }

    public static void parkNanos(Object object, long l) {
        RuntimeCostAccounter.recordJump();
        if (l > 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.setBlocker:(Ljava/lang/Thread;Ljava/lang/Object;)V");
            LockSupport.setBlocker(thread, object);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
            UNSAFE.park(false, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.setBlocker:(Ljava/lang/Thread;Ljava/lang/Object;)V");
            LockSupport.setBlocker(thread, null);
        }
    }

    public static void parkUntil(Object object, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.setBlocker:(Ljava/lang/Thread;Ljava/lang/Object;)V");
        LockSupport.setBlocker(thread, object);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
        UNSAFE.park(true, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.setBlocker:(Ljava/lang/Thread;Ljava/lang/Object;)V");
        LockSupport.setBlocker(thread, null);
    }

    public static Object getBlocker(Thread thread) {
        RuntimeCostAccounter.recordJump();
        if (thread == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
        return UNSAFE.getObjectVolatile((Object)thread, parkBlockerOffset);
    }

    public static void park() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
        UNSAFE.park(false, 0L);
    }

    public static void parkNanos(long l) {
        RuntimeCostAccounter.recordJump();
        if (l > 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
            UNSAFE.park(false, l);
        }
    }

    public static void parkUntil(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.park:(ZJ)V");
        UNSAFE.park(true, l);
    }

    static final int nextSecondarySeed() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getInt:(Ljava/lang/Object;J)I");
        int n = UNSAFE.getInt((Object)thread, SECONDARY);
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextInt:()I");
            n = threadLocalRandom.nextInt();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                n = 1;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putInt:(Ljava/lang/Object;JI)V");
        UNSAFE.putInt((Object)thread, SECONDARY, n);
        return n;
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("parkBlocker");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            parkBlockerOffset = UNSAFE.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = clazz.getDeclaredField("threadLocalRandomSeed");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            SEED = UNSAFE.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = clazz.getDeclaredField("threadLocalRandomProbe");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PROBE = UNSAFE.objectFieldOffset(field3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field4 = clazz.getDeclaredField("threadLocalRandomSecondarySeed");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            SECONDARY = UNSAFE.objectFieldOffset(field4);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }
}

