/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.locks;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Collection;
import sandbox.java.util.Date;
import sandbox.java.util.concurrent.TimeUnit;
import sandbox.java.util.concurrent.locks.AbstractOwnableSynchronizer;
import sandbox.java.util.concurrent.locks.Condition;
import sandbox.java.util.concurrent.locks.LockSupport;
import sandbox.sun.misc.Unsafe;

public abstract class AbstractQueuedLongSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414692L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile long state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe;
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;
    private static final long nextOffset;

    protected AbstractQueuedLongSynchronizer() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractOwnableSynchronizer.<init>:()V");
    }

    protected final long getState() {
        return this.state;
    }

    protected final void setState(long l) {
        this.state = l;
    }

    protected final boolean compareAndSetState(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapLong:(Ljava/lang/Object;JJJ)Z");
        return unsafe.compareAndSwapLong((Object)this, stateOffset, l, l2);
    }

    private Node enq(Node node) {
        while (true) {
            Node node2 = this.tail;
            RuntimeCostAccounter.recordJump();
            if (node2 == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.<init>:()V");
                Node node3 = new Node();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetHead:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                boolean bl = this.compareAndSetHead(node3);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    this.tail = this.head;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                node.prev = node2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetTail:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                boolean bl = this.compareAndSetTail(node2, node);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    node2.next = node;
                    return node2;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private Node addWaiter(Node node) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.<init>:(Ljava/lang/Thread;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
        Node node2 = new Node(thread, node);
        Node node3 = this.tail;
        RuntimeCostAccounter.recordJump();
        if (node3 != null) {
            node2.prev = node3;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetTail:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl = this.compareAndSetTail(node3, node2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                node3.next = node2;
                return node2;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.enq:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Node node2;
        block8: {
            block7: {
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
                    AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, n, 0);
                }
                node2 = node.next;
                RuntimeCostAccounter.recordJump();
                if (node2 == null) break block7;
                int n2 = node2.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n2 <= 0) break block8;
            }
            node2 = null;
            Node node3 = this.tail;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node3 == null) break;
                RuntimeCostAccounter.recordJump();
                if (node3 == node) break;
                int n = node3.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n <= 0) {
                    node2 = node3;
                }
                node3 = node3.prev;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (node2 != null) {
            Thread thread = node2.thread;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
            LockSupport.unpark(thread);
        }
    }

    private void doReleaseShared() {
        while (true) {
            Node node = this.head;
            RuntimeCostAccounter.recordJump();
            if (node != null) {
                RuntimeCostAccounter.recordJump();
                if (node != this.tail) {
                    int n = node.waitStatus;
                    RuntimeCostAccounter.recordJump();
                    if (n == -1) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
                        boolean bl = AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -1, 0);
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.unparkSuccessor:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                        this.unparkSuccessor(node);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (n == 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
                            boolean bl = AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, 0, -3);
                            RuntimeCostAccounter.recordJump();
                            if (!bl) {
                                RuntimeCostAccounter.recordJump();
                                continue;
                            }
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (node == this.head) break;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
    }

    private void setHeadAndPropagate(Node node, long l) {
        block3: {
            block4: {
                block2: {
                    Node node2 = this.head;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHead:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.setHead(node);
                    RuntimeCostAccounter.recordJump();
                    if (l > 0L) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (node2 == null) break block2;
                    int n = node2.waitStatus;
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block2;
                    node2 = this.head;
                    RuntimeCostAccounter.recordJump();
                    if (node2 == null) break block2;
                    int n2 = node2.waitStatus;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= 0) break block3;
                }
                Node node3 = node.next;
                RuntimeCostAccounter.recordJump();
                if (node3 == null) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.isShared:()Z");
                boolean bl = node3.isShared();
                RuntimeCostAccounter.recordJump();
                if (!bl) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doReleaseShared:()V");
            this.doReleaseShared();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void cancelAcquire(Node var1_1) {
        block7: {
            block8: {
                block6: {
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 == null) {
                        return;
                    }
                    var1_1.thread = null;
                    var2_2 = var1_1.prev;
                    while (true) {
                        v0 = var2_2.waitStatus;
                        RuntimeCostAccounter.recordJump();
                        if (v0 <= 0) break;
                        var1_1.prev = var2_2 = var2_2.prev;
                        RuntimeCostAccounter.recordJump();
                    }
                    var3_3 = var2_2.next;
                    var1_1.waitStatus = 1;
                    RuntimeCostAccounter.recordJump();
                    if (var1_1 != this.tail) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetTail:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                    v1 = this.compareAndSetTail(var1_1, var2_2);
                    RuntimeCostAccounter.recordJump();
                    if (!v1) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetNext:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                    AbstractQueuedLongSynchronizer.compareAndSetNext(var2_2, var3_3, null);
                    RuntimeCostAccounter.recordJump();
                    break block7;
                }
                RuntimeCostAccounter.recordJump();
                if (var2_2 == this.head) ** GOTO lbl-1000
                var4_4 = var2_2.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (var4_4 == -1) break block8;
                RuntimeCostAccounter.recordJump();
                if (var4_4 > 0) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
                v2 = AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(var2_2, var4_4, -1);
                RuntimeCostAccounter.recordJump();
                if (!v2) ** GOTO lbl-1000
            }
            v3 = var2_2.thread;
            RuntimeCostAccounter.recordJump();
            if (v3 != null) {
                var5_5 = var1_1.next;
                RuntimeCostAccounter.recordJump();
                if (var5_5 != null) {
                    v4 = var5_5.waitStatus;
                    RuntimeCostAccounter.recordJump();
                    if (v4 <= 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetNext:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                        AbstractQueuedLongSynchronizer.compareAndSetNext(var2_2, var3_3, var5_5);
                    }
                }
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 4 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.unparkSuccessor:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.unparkSuccessor(var1_1);
            }
            var1_1.next = var1_1;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node, Node node2) {
        int n = node.waitStatus;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            return true;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            int n2;
            do {
                node2.prev = node = node.prev;
                n2 = node.waitStatus;
                RuntimeCostAccounter.recordJump();
            } while (n2 > 0);
            node.next = node2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
            AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, n, -1);
        }
        return false;
    }

    static void selfInterrupt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
        thread.interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
        LockSupport.park(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, long l) {
        boolean bl;
        Node node2;
        boolean bl2;
        boolean bl3 = true;
        try {
            bl2 = false;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.predecessor:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
                node2 = node.predecessor();
                RuntimeCostAccounter.recordJump();
                if (node2 != this.head) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquire:(J)Z");
                boolean bl4 = this.tryAcquire(l);
                RuntimeCostAccounter.recordJump();
                if (!bl4) break block8;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHead:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.setHead(node);
                node2.next = null;
                bl3 = false;
                bl = bl2;
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.cancelAcquire(node);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block8: {
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.cancelAcquire(node);
                }
                return bl;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl5 = AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node);
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.parkAndCheckInterrupt:()Z");
                boolean bl6 = this.parkAndCheckInterrupt();
                RuntimeCostAccounter.recordJump();
                if (bl6) {
                    bl2 = true;
                }
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * Loose catch block
     */
    private void doAcquireInterruptibly(long l) throws InterruptedException {
        Node node;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.addWaiter:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
        Node node2 = this.addWaiter(Node.EXCLUSIVE);
        boolean bl = true;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.predecessor:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            node = node2.predecessor();
            RuntimeCostAccounter.recordJump();
            if (node != this.head) break block8;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquire:(J)Z");
            boolean bl2 = this.tryAcquire(l);
            RuntimeCostAccounter.recordJump();
            if (!bl2) break block8;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHead:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
            this.setHead(node2);
            node.next = null;
            bl = false;
            break;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.cancelAcquire(node2);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block8: {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.cancelAcquire(node2);
                }
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl3 = AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node, node2);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.parkAndCheckInterrupt:()Z");
                boolean bl4 = this.parkAndCheckInterrupt();
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                    InterruptedException interruptedException = new InterruptedException();
                    RuntimeCostAccounter.recordThrow();
                    throw interruptedException;
                }
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * Loose catch block
     */
    private boolean doAcquireNanos(long l, long l2) throws InterruptedException {
        boolean bl;
        Node node;
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l3 = System.nanoTime() + l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.addWaiter:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
        Node node2 = this.addWaiter(Node.EXCLUSIVE);
        boolean bl2 = true;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.predecessor:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            node = node2.predecessor();
            RuntimeCostAccounter.recordJump();
            if (node != this.head) break block12;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquire:(J)Z");
            boolean bl3 = this.tryAcquire(l);
            RuntimeCostAccounter.recordJump();
            if (!bl3) break block12;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHead:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
            this.setHead(node2);
            node.next = null;
            bl2 = false;
            bl = true;
            break;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.cancelAcquire(node2);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block13: {
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                        this.cancelAcquire(node2);
                    }
                    return bl;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = l3 - System.nanoTime();
                RuntimeCostAccounter.recordJump();
                if (l2 > 0L) break block13;
                boolean bl4 = false;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.cancelAcquire(node2);
                }
                return bl4;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl5 = AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node, node2);
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordJump();
                if (l2 > 1000L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                    LockSupport.parkNanos(this, l2);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl6 = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl6) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    private void doAcquireShared(long l) {
        Node node;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.addWaiter:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
        Node node2 = this.addWaiter(Node.SHARED);
        boolean bl2 = true;
        try {
            bl = false;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.predecessor:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
                node = node2.predecessor();
                RuntimeCostAccounter.recordJump();
                if (node != this.head) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquireShared:(J)J");
                long l2 = this.tryAcquireShared(l);
                RuntimeCostAccounter.recordJump();
                if (l2 < 0L) break block9;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHeadAndPropagate:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)V");
                this.setHeadAndPropagate(node2, l2);
                node.next = null;
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.selfInterrupt:()V");
                    AbstractQueuedLongSynchronizer.selfInterrupt();
                }
                bl2 = false;
                break;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.cancelAcquire(node2);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block9: {
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.cancelAcquire(node2);
                }
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl3 = AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node, node2);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.parkAndCheckInterrupt:()Z");
                boolean bl4 = this.parkAndCheckInterrupt();
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    bl = true;
                }
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * Loose catch block
     */
    private void doAcquireSharedInterruptibly(long l) throws InterruptedException {
        Node node;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.addWaiter:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
        Node node2 = this.addWaiter(Node.SHARED);
        boolean bl = true;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.predecessor:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            node = node2.predecessor();
            RuntimeCostAccounter.recordJump();
            if (node != this.head) break block8;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquireShared:(J)J");
            long l2 = this.tryAcquireShared(l);
            RuntimeCostAccounter.recordJump();
            if (l2 < 0L) break block8;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHeadAndPropagate:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)V");
            this.setHeadAndPropagate(node2, l2);
            node.next = null;
            bl = false;
            break;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.cancelAcquire(node2);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block8: {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.cancelAcquire(node2);
                }
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl2 = AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node, node2);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.parkAndCheckInterrupt:()Z");
                boolean bl3 = this.parkAndCheckInterrupt();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                    InterruptedException interruptedException = new InterruptedException();
                    RuntimeCostAccounter.recordThrow();
                    throw interruptedException;
                }
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    /*
     * Loose catch block
     */
    private boolean doAcquireSharedNanos(long l, long l2) throws InterruptedException {
        boolean bl;
        Node node;
        RuntimeCostAccounter.recordJump();
        if (l2 <= 0L) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l3 = System.nanoTime() + l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.addWaiter:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
        Node node2 = this.addWaiter(Node.SHARED);
        boolean bl2 = true;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.predecessor:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            node = node2.predecessor();
            RuntimeCostAccounter.recordJump();
            if (node != this.head) break block12;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquireShared:(J)J");
            long l4 = this.tryAcquireShared(l);
            RuntimeCostAccounter.recordJump();
            if (l4 < 0L) break block12;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.setHeadAndPropagate:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)V");
            this.setHeadAndPropagate(node2, l4);
            node.next = null;
            bl2 = false;
            bl = true;
            break;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.cancelAcquire(node2);
            }
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        {
            block13: {
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                        this.cancelAcquire(node2);
                    }
                    return bl;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = l3 - System.nanoTime();
                RuntimeCostAccounter.recordJump();
                if (l2 > 0L) break block13;
                boolean bl3 = false;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.cancelAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.cancelAcquire(node2);
                }
                return bl3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl4 = AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node, node2);
            RuntimeCostAccounter.recordJump();
            if (bl4) {
                RuntimeCostAccounter.recordJump();
                if (l2 > 1000L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                    LockSupport.parkNanos(this, l2);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl5 = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            RuntimeCostAccounter.recordJump();
            continue;
        }
    }

    protected boolean tryAcquire(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    protected boolean tryRelease(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    protected long tryAcquireShared(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    protected boolean tryReleaseShared(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    protected boolean isHeldExclusively() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    public final void acquire(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquire:(J)Z");
        boolean bl = this.tryAcquire(l);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.addWaiter:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            Node node = this.addWaiter(Node.EXCLUSIVE);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.acquireQueued:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)Z");
            boolean bl2 = this.acquireQueued(node, l);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.selfInterrupt:()V");
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }
    }

    public final void acquireInterruptibly(long l) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquire:(J)Z");
        boolean bl2 = this.tryAcquire(l);
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doAcquireInterruptibly:(J)V");
            this.doAcquireInterruptibly(l);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean tryAcquireNanos(long l, long l2) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquire:(J)Z");
        boolean bl2 = this.tryAcquire(l);
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doAcquireNanos:(JJ)Z");
            boolean bl3 = this.doAcquireNanos(l, l2);
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
        }
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    public final boolean release(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryRelease:(J)Z");
        boolean bl = this.tryRelease(l);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Node node = this.head;
            RuntimeCostAccounter.recordJump();
            if (node != null) {
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.unparkSuccessor:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                    this.unparkSuccessor(node);
                }
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquireShared:(J)J");
        long l2 = this.tryAcquireShared(l) - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doAcquireShared:(J)V");
            this.doAcquireShared(l);
        }
    }

    public final void acquireSharedInterruptibly(long l) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquireShared:(J)J");
        long l2 = this.tryAcquireShared(l) - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doAcquireSharedInterruptibly:(J)V");
            this.doAcquireSharedInterruptibly(l);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean tryAcquireSharedNanos(long l, long l2) throws InterruptedException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
        boolean bl = Thread.interrupted();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
            InterruptedException interruptedException = new InterruptedException();
            RuntimeCostAccounter.recordThrow();
            throw interruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryAcquireShared:(J)J");
        long l3 = this.tryAcquireShared(l) - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l4 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doAcquireSharedNanos:(JJ)Z");
            boolean bl2 = this.doAcquireSharedNanos(l, l2);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
        }
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    public final boolean releaseShared(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.tryReleaseShared:(J)Z");
        boolean bl = this.tryReleaseShared(l);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.doReleaseShared:()V");
            this.doReleaseShared();
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.head != this.tail) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean hasContended() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.head != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public final Thread getFirstQueuedThread() {
        Thread thread;
        RuntimeCostAccounter.recordJump();
        if (this.head == this.tail) {
            thread = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.fullGetFirstQueuedThread:()Ljava/lang/Thread;");
            thread = this.fullGetFirstQueuedThread();
        }
        return thread;
    }

    private Thread fullGetFirstQueuedThread() {
        block7: {
            Thread thread;
            block6: {
                Node node;
                Node node2;
                block5: {
                    node2 = this.head;
                    RuntimeCostAccounter.recordJump();
                    if (node2 == null) break block5;
                    node = node2.next;
                    RuntimeCostAccounter.recordJump();
                    if (node == null) break block5;
                    Node node3 = node.prev;
                    RuntimeCostAccounter.recordJump();
                    if (node3 != this.head) break block5;
                    thread = node.thread;
                    RuntimeCostAccounter.recordJump();
                    if (thread != null) break block6;
                }
                node2 = this.head;
                RuntimeCostAccounter.recordJump();
                if (node2 == null) break block7;
                node = node2.next;
                RuntimeCostAccounter.recordJump();
                if (node == null) break block7;
                Node node4 = node.prev;
                RuntimeCostAccounter.recordJump();
                if (node4 != this.head) break block7;
                thread = node.thread;
                RuntimeCostAccounter.recordJump();
                if (thread == null) break block7;
            }
            return thread;
        }
        Node node = this.tail;
        Thread thread = null;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            RuntimeCostAccounter.recordJump();
            if (node == this.head) break;
            Thread thread2 = node.thread;
            RuntimeCostAccounter.recordJump();
            if (thread2 != null) {
                thread = thread2;
            }
            node = node.prev;
            RuntimeCostAccounter.recordJump();
        }
        return thread;
    }

    public final boolean isQueued(Thread thread) {
        RuntimeCostAccounter.recordJump();
        if (thread == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        Node node = this.tail;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            Thread thread2 = node.thread;
            RuntimeCostAccounter.recordJump();
            if (thread2 == thread) {
                return true;
            }
            node = node.prev;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean apparentlyFirstQueuedIsExclusive() {
        Node node = this.head;
        RuntimeCostAccounter.recordJump();
        if (node == null) return false;
        Node node2 = node.next;
        RuntimeCostAccounter.recordJump();
        if (node2 == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.isShared:()Z");
        boolean bl = node2.isShared();
        RuntimeCostAccounter.recordJump();
        if (bl) return false;
        Thread thread = node2.thread;
        RuntimeCostAccounter.recordJump();
        if (thread == null) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasQueuedPredecessors() {
        Node node = this.tail;
        Node node2 = this.head;
        RuntimeCostAccounter.recordJump();
        if (node2 == node) return false;
        Node node3 = node2.next;
        RuntimeCostAccounter.recordJump();
        if (node3 != null) {
            Thread thread = node3.thread;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread2 = Thread.currentThread();
            RuntimeCostAccounter.recordJump();
            if (thread == thread2) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public final int getQueueLength() {
        int n = 0;
        Node node = this.tail;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            Thread thread = node.thread;
            RuntimeCostAccounter.recordJump();
            if (thread != null) {
                ++n;
            }
            node = node.prev;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            Thread thread = node.thread;
            RuntimeCostAccounter.recordJump();
            if (thread != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                arrayList.add(thread);
            }
            node = node.prev;
            RuntimeCostAccounter.recordJump();
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.isShared:()Z");
            boolean bl = node.isShared();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                Thread thread = node.thread;
                RuntimeCostAccounter.recordJump();
                if (thread != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                    arrayList.add(thread);
                }
            }
            node = node.prev;
            RuntimeCostAccounter.recordJump();
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.isShared:()Z");
            boolean bl = node.isShared();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                Thread thread = node.thread;
                RuntimeCostAccounter.recordJump();
                if (thread != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                    arrayList.add(thread);
                }
            }
            node = node.prev;
            RuntimeCostAccounter.recordJump();
        }
        return arrayList;
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.getState:()J");
        long l = this.getState();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.hasQueuedThreads:()Z");
        boolean bl = this.hasQueuedThreads();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = "non";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "";
        }
        String string2 = string;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.toString:()Ljava/lang/String;");
        String string3 = super.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append("[State = ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(", ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append("empty queue]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder7.toString();
    }

    final boolean isOnSyncQueue(Node node) {
        block5: {
            block4: {
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n == -2) break block4;
                Node node2 = node.prev;
                RuntimeCostAccounter.recordJump();
                if (node2 != null) break block5;
            }
            return false;
        }
        Node node3 = node.next;
        RuntimeCostAccounter.recordJump();
        if (node3 != null) {
            return true;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.findNodeFromTail:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node node2 = this.tail;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (node2 == node) {
                return true;
            }
            RuntimeCostAccounter.recordJump();
            if (node2 == null) {
                return false;
            }
            node2 = node2.prev;
            RuntimeCostAccounter.recordJump();
        }
    }

    final boolean transferForSignal(Node node) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
                boolean bl = AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -2, 0);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.enq:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
                Node node2 = this.enq(node);
                int n = node2.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n > 0) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
                boolean bl2 = AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, n, -1);
                RuntimeCostAccounter.recordJump();
                if (bl2) break block5;
            }
            Thread thread = node.thread;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.unpark:(Ljava/lang/Thread;)V");
            LockSupport.unpark(thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.compareAndSetWaitStatus:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;II)Z");
        boolean bl = AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -2, 0);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.enq:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            this.enq(node);
            return true;
        }
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isOnSyncQueue:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
            boolean bl2 = this.isOnSyncQueue(node);
            RuntimeCostAccounter.recordJump();
            if (bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.yield:()V");
            Thread.yield();
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    final long fullyRelease(Node node) {
        block5: {
            long l;
            boolean bl = true;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.getState:()J");
                long l2 = this.getState();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.release:(J)Z");
                boolean bl2 = this.release(l2);
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block5;
                bl = false;
                l = l2;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    node.waitStatus = 1;
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            if (bl) {
                node.waitStatus = 1;
            }
            return l;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
        IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
        RuntimeCostAccounter.recordThrow();
        throw illegalMonitorStateException;
    }

    public final boolean owns(ConditionObject conditionObject) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.isOwnedBy:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer;)Z");
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.owns:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject;)Z");
        boolean bl = this.owns(conditionObject);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.hasWaiters:()Z");
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.owns:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject;)Z");
        boolean bl = this.owns(conditionObject);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.getWaitQueueLength:()I");
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.owns:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject;)Z");
        boolean bl = this.owns(conditionObject);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Not owner");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.getWaitingThreads:()Ljava/util/Collection;");
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return unsafe.compareAndSwapObject((Object)this, headOffset, null, (Object)node);
    }

    private final boolean compareAndSetTail(Node node, Node node2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return unsafe.compareAndSwapObject((Object)this, tailOffset, (Object)node, (Object)node2);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapInt:(Ljava/lang/Object;JII)Z");
        return unsafe.compareAndSwapInt((Object)node, waitStatusOffset, n, n2);
    }

    private static final boolean compareAndSetNext(Node node, Node node2, Node node3) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return unsafe.compareAndSwapObject((Object)node, nextOffset, (Object)node2, (Object)node3);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
        unsafe = Unsafe.getUnsafe();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = AbstractQueuedLongSynchronizer.class.getDeclaredField("state");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            stateOffset = unsafe.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = AbstractQueuedLongSynchronizer.class.getDeclaredField("head");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            headOffset = unsafe.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = AbstractQueuedLongSynchronizer.class.getDeclaredField("tail");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            tailOffset = unsafe.objectFieldOffset(field3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field4 = Node.class.getDeclaredField("waitStatus");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            waitStatusOffset = unsafe.objectFieldOffset(field4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field5 = Node.class.getDeclaredField("next");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            nextOffset = unsafe.objectFieldOffset(field5);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        public ConditionObject() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        private Node addConditionWaiter() {
            Node node = this.lastWaiter;
            RuntimeCostAccounter.recordJump();
            if (node != null) {
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n != -2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.unlinkCancelledWaiters:()V");
                    this.unlinkCancelledWaiters();
                    node = this.lastWaiter;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.<init>:(Ljava/lang/Thread;I)V");
            Node node2 = new Node(thread, -2);
            RuntimeCostAccounter.recordJump();
            if (node == null) {
                this.firstWaiter = node2;
                RuntimeCostAccounter.recordJump();
            } else {
                node.nextWaiter = node2;
            }
            this.lastWaiter = node2;
            return node2;
        }

        private void doSignal(Node node) {
            do {
                this.firstWaiter = node.nextWaiter;
                RuntimeCostAccounter.recordJump();
                if (this.firstWaiter == null) {
                    this.lastWaiter = null;
                }
                node.nextWaiter = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.transferForSignal:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                boolean bl = AbstractQueuedLongSynchronizer.this.transferForSignal(node);
                RuntimeCostAccounter.recordJump();
                if (bl) break;
                node = this.firstWaiter;
                RuntimeCostAccounter.recordJump();
            } while (node != null);
        }

        private void doSignalAll(Node node) {
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                Node node2 = node.nextWaiter;
                node.nextWaiter = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.transferForSignal:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                AbstractQueuedLongSynchronizer.this.transferForSignal(node);
                node = node2;
                RuntimeCostAccounter.recordJump();
            } while (node != null);
        }

        private void unlinkCancelledWaiters() {
            Node node = this.firstWaiter;
            Node node2 = null;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                Node node3 = node.nextWaiter;
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n != -2) {
                    node.nextWaiter = null;
                    RuntimeCostAccounter.recordJump();
                    if (node2 == null) {
                        this.firstWaiter = node3;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        node2.nextWaiter = node3;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (node3 == null) {
                        this.lastWaiter = node2;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    node2 = node;
                }
                node = node3;
                RuntimeCostAccounter.recordJump();
            }
        }

        @Override
        public final void signal() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isHeldExclusively:()Z");
            boolean bl = AbstractQueuedLongSynchronizer.this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            Node node = this.firstWaiter;
            RuntimeCostAccounter.recordJump();
            if (node != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.doSignal:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.doSignal(node);
            }
        }

        @Override
        public final void signalAll() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isHeldExclusively:()Z");
            boolean bl = AbstractQueuedLongSynchronizer.this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            Node node = this.firstWaiter;
            RuntimeCostAccounter.recordJump();
            if (node != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.doSignalAll:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)V");
                this.doSignalAll(node);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            block4: {
                block3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.addConditionWaiter:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
                    Node node = this.addConditionWaiter();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.fullyRelease:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)J");
                    long l = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
                    boolean bl = false;
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isOnSyncQueue:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                        boolean bl2 = AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                        LockSupport.park(this);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                        boolean bl3 = Thread.interrupted();
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) continue;
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.acquireQueued:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)Z");
                    boolean bl4 = AbstractQueuedLongSynchronizer.this.acquireQueued(node, l);
                    RuntimeCostAccounter.recordJump();
                    if (bl4) break block3;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.selfInterrupt:()V");
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.transferAfterCancelledWait:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                boolean bl2 = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    n = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 1;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                n = 0;
            }
            return n;
        }

        private void reportInterruptAfterWait(int n) throws InterruptedException {
            RuntimeCostAccounter.recordJump();
            if (n == -1) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.selfInterrupt:()V");
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            int n;
            long l;
            Node node;
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                boolean bl = Thread.interrupted();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                    InterruptedException interruptedException = new InterruptedException();
                    RuntimeCostAccounter.recordThrow();
                    throw interruptedException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.addConditionWaiter:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
                node = this.addConditionWaiter();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.fullyRelease:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)J");
                l = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
                n = 0;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isOnSyncQueue:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                    boolean bl2 = AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.park:(Ljava/lang/Object;)V");
                    LockSupport.park(this);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.checkInterruptWhileWaiting:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)I");
                    n = this.checkInterruptWhileWaiting(node);
                    RuntimeCostAccounter.recordJump();
                } while (n == 0);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.acquireQueued:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)Z");
            boolean bl = AbstractQueuedLongSynchronizer.this.acquireQueued(node, l);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (n != -1) {
                    n = 1;
                }
            }
            Node node2 = node.nextWaiter;
            RuntimeCostAccounter.recordJump();
            if (node2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.unlinkCancelledWaiters:()V");
                this.unlinkCancelledWaiters();
            }
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.reportInterruptAfterWait:(I)V");
                this.reportInterruptAfterWait(n);
            }
        }

        @Override
        public final long awaitNanos(long l) throws InterruptedException {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.addConditionWaiter:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            Node node = this.addConditionWaiter();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.fullyRelease:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)J");
            long l2 = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
            long l3 = System.nanoTime() + l;
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isOnSyncQueue:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                boolean bl2 = AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node);
                RuntimeCostAccounter.recordJump();
                if (bl2) break;
                RuntimeCostAccounter.recordJump();
                if (l <= 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.transferAfterCancelledWait:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                    AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (l >= 1000L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                    LockSupport.parkNanos(this, l);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.checkInterruptWhileWaiting:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)I");
                n = this.checkInterruptWhileWaiting(node);
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l = l3 - System.nanoTime();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.acquireQueued:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)Z");
            boolean bl3 = AbstractQueuedLongSynchronizer.this.acquireQueued(node, l2);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordJump();
                if (n != -1) {
                    n = 1;
                }
            }
            Node node2 = node.nextWaiter;
            RuntimeCostAccounter.recordJump();
            if (node2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.unlinkCancelledWaiters:()V");
                this.unlinkCancelledWaiters();
            }
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.reportInterruptAfterWait:(I)V");
                this.reportInterruptAfterWait(n);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
            return l3 - System.nanoTime();
        }

        @Override
        public final boolean awaitUntil(Date date) throws InterruptedException {
            boolean bl;
            int n;
            boolean bl2;
            long l;
            Node node;
            block9: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Date.getTime:()J");
                long l2 = date.getTime();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
                boolean bl3 = Thread.interrupted();
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                    InterruptedException interruptedException = new InterruptedException();
                    RuntimeCostAccounter.recordThrow();
                    throw interruptedException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.addConditionWaiter:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
                node = this.addConditionWaiter();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.fullyRelease:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)J");
                l = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
                bl2 = false;
                n = 0;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isOnSyncQueue:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                    boolean bl4 = AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node);
                    RuntimeCostAccounter.recordJump();
                    if (bl4) break block9;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
                    long l3 = System.currentTimeMillis() - l2;
                    long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l4 > 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.transferAfterCancelledWait:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                        bl2 = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                        RuntimeCostAccounter.recordJump();
                        break block9;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkUntil:(Ljava/lang/Object;J)V");
                    LockSupport.parkUntil(this, l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.checkInterruptWhileWaiting:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)I");
                    n = this.checkInterruptWhileWaiting(node);
                    RuntimeCostAccounter.recordJump();
                } while (n == 0);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.acquireQueued:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)Z");
            boolean bl5 = AbstractQueuedLongSynchronizer.this.acquireQueued(node, l);
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordJump();
                if (n != -1) {
                    n = 1;
                }
            }
            Node node2 = node.nextWaiter;
            RuntimeCostAccounter.recordJump();
            if (node2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.unlinkCancelledWaiters:()V");
                this.unlinkCancelledWaiters();
            }
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.reportInterruptAfterWait:(I)V");
                this.reportInterruptAfterWait(n);
            }
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/TimeUnit.toNanos:(J)J");
            long l2 = timeUnit.toNanos(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupted:()Z");
            boolean bl2 = Thread.interrupted();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/InterruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/InterruptedException.<init>:()V");
                InterruptedException interruptedException = new InterruptedException();
                RuntimeCostAccounter.recordThrow();
                throw interruptedException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.addConditionWaiter:()Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;");
            Node node = this.addConditionWaiter();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.fullyRelease:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)J");
            long l3 = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
            long l4 = System.nanoTime() + l2;
            boolean bl3 = false;
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isOnSyncQueue:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                boolean bl4 = AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node);
                RuntimeCostAccounter.recordJump();
                if (bl4) break;
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.transferAfterCancelledWait:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)Z");
                    bl3 = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (l2 >= 1000L) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/LockSupport.parkNanos:(Ljava/lang/Object;J)V");
                    LockSupport.parkNanos(this, l2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.checkInterruptWhileWaiting:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;)I");
                n = this.checkInterruptWhileWaiting(node);
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
                l2 = l4 - System.nanoTime();
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.acquireQueued:(Ljava/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node;J)Z");
            boolean bl5 = AbstractQueuedLongSynchronizer.this.acquireQueued(node, l3);
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordJump();
                if (n != -1) {
                    n = 1;
                }
            }
            Node node2 = node.nextWaiter;
            RuntimeCostAccounter.recordJump();
            if (node2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.unlinkCancelledWaiters:()V");
                this.unlinkCancelledWaiters();
            }
            RuntimeCostAccounter.recordJump();
            if (n != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$ConditionObject.reportInterruptAfterWait:(I)V");
                this.reportInterruptAfterWait(n);
            }
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        final boolean isOwnedBy(AbstractQueuedLongSynchronizer abstractQueuedLongSynchronizer) {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (abstractQueuedLongSynchronizer == AbstractQueuedLongSynchronizer.this) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        protected final boolean hasWaiters() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isHeldExclusively:()Z");
            boolean bl = AbstractQueuedLongSynchronizer.this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            Node node = this.firstWaiter;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n == -2) {
                    return true;
                }
                node = node.nextWaiter;
                RuntimeCostAccounter.recordJump();
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isHeldExclusively:()Z");
            boolean bl = AbstractQueuedLongSynchronizer.this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            int n = 0;
            Node node = this.firstWaiter;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                int n2 = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n2 == -2) {
                    ++n;
                }
                node = node.nextWaiter;
                RuntimeCostAccounter.recordJump();
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer.isHeldExclusively:()Z");
            boolean bl = AbstractQueuedLongSynchronizer.this.isHeldExclusively();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalMonitorStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalMonitorStateException.<init>:()V");
                IllegalMonitorStateException illegalMonitorStateException = new IllegalMonitorStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalMonitorStateException;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            Node node = this.firstWaiter;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (node == null) break;
                int n = node.waitStatus;
                RuntimeCostAccounter.recordJump();
                if (n == -2) {
                    Thread thread = node.thread;
                    RuntimeCostAccounter.recordJump();
                    if (thread != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                        arrayList.add(thread);
                    }
                }
                node = node.nextWaiter;
                RuntimeCostAccounter.recordJump();
            }
            return arrayList;
        }
    }

    static final class Node {
        static final Node SHARED;
        static final Node EXCLUSIVE;
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final int PROPAGATE = -3;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (this.nextWaiter == SHARED) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        final Node predecessor() throws NullPointerException {
            Node node = this.prev;
            RuntimeCostAccounter.recordJump();
            if (node == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            return node;
        }

        Node() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        Node(Thread thread, Node node) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.nextWaiter = node;
            this.thread = thread;
        }

        Node(Thread thread, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.waitStatus = n;
            this.thread = thread;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/locks/AbstractQueuedLongSynchronizer$Node.<init>:()V");
            SHARED = new Node();
            EXCLUSIVE = null;
        }
    }
}

