/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.math;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.math.BigInteger;
import sandbox.java.math.MutableBigInteger;
import sandbox.java.util.Random;

class BitSieve {
    private long[] bits;
    private int length;
    private static BitSieve smallSieve;

    private BitSieve() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.length = 9600;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.unitIndex:(I)I");
        int n = BitSieve.unitIndex(this.length - 1) + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.bits = new long[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.set:(I)V");
        this.set(0);
        int n2 = 1;
        int n3 = 3;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.sieveSingle:(III)V");
            this.sieveSingle(this.length, n2 + n3, n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.sieveSearch:(II)I");
            n2 = this.sieveSearch(this.length, n2 + 1);
            n3 = 2 * n2 + 1;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordJump();
        } while (n3 < this.length);
    }

    BitSieve(BigInteger bigInteger, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.unitIndex:(I)I");
        int n2 = BitSieve.unitIndex(n - 1) + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.bits = new long[n2];
        this.length = n;
        int n3 = 0;
        int n4 = BitSieve.smallSieve.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.sieveSearch:(II)I");
        int n5 = smallSieve.sieveSearch(n4, n3);
        int n6 = n5 * 2 + 1;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger(bigInteger);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideOneWord:(ILjava/math/MutableBigInteger;)I");
            n3 = mutableBigInteger.divideOneWord(n6, mutableBigInteger2);
            n3 = n6 - n3;
            RuntimeCostAccounter.recordJump();
            if (n3 % 2 == 0) {
                n3 += n6;
            }
            int n7 = (n3 - 1) / 2;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.sieveSingle:(III)V");
            this.sieveSingle(n, n7, n6);
            int n8 = BitSieve.smallSieve.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.sieveSearch:(II)I");
            n5 = smallSieve.sieveSearch(n8, n5 + 1);
            n6 = n5 * 2 + 1;
            RuntimeCostAccounter.recordJump();
        } while (n5 > 0);
    }

    private static int unitIndex(int n) {
        return n >>> 6;
    }

    private static long bit(int n) {
        return 1L << (n & 0x3F);
    }

    private boolean get(int n) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.unitIndex:(I)I");
        int n2 = BitSieve.unitIndex(n);
        long l = this.bits[n2];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.bit:(I)J");
        long l2 = (l & BitSieve.bit(n)) - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 != false) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    private void set(int n) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.unitIndex:(I)I");
        int n3 = n2 = BitSieve.unitIndex(n);
        long l = this.bits[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.bit:(I)J");
        this.bits[n3] = l | BitSieve.bit(n);
    }

    private int sieveSearch(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n2 >= n) {
            return -1;
        }
        int n3 = n2;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.get:(I)Z");
            boolean bl = this.get(n3);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return n3;
            }
            RuntimeCostAccounter.recordJump();
        } while (++n3 < n - 1);
        return -1;
    }

    private void sieveSingle(int n, int n2, int n3) {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.set:(I)V");
            this.set(n2);
            n2 += n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    BigInteger retrieve(BigInteger bigInteger, int n, Random random) {
        int n2 = 1;
        int n3 = 0;
        while (true) {
            int n4 = this.bits.length;
            RuntimeCostAccounter.recordJump();
            if (n3 >= n4) break;
            long l = this.bits[n3] ^ 0xFFFFFFFFFFFFFFFFL;
            int n5 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n5 >= 64) break;
                RuntimeCostAccounter.recordJump();
                if ((l & 1L) == 1L) {
                    long l2 = n2;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
                    BigInteger bigInteger2 = BigInteger.valueOf(l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                    BigInteger bigInteger3 = bigInteger.add(bigInteger2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primeToCertainty:(ILjava/util/Random;)Z");
                    boolean bl = bigInteger3.primeToCertainty(n, random);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return bigInteger3;
                    }
                }
                l >>>= 1;
                n2 += 2;
                ++n5;
                RuntimeCostAccounter.recordJump();
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/math/BitSieve");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.<init>:()V");
        smallSieve = new BitSieve();
    }
}

