/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.math;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.math.BitSieve;
import sandbox.java.math.MutableBigInteger;
import sandbox.java.util.Arrays;
import sandbox.java.util.Random;
import sandbox.java.util.concurrent.ThreadLocalRandom;
import sandbox.sun.misc.Unsafe;

public class BigInteger
extends Number
implements Comparable<BigInteger> {
    final int signum;
    final int[] mag;
    @Deprecated
    private int bitCount;
    @Deprecated
    private int bitLength;
    @Deprecated
    private int lowestSetBit;
    @Deprecated
    private int firstNonzeroIntNum;
    static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int PRIME_SEARCH_BIT_LENGTH_LIMIT = 500000000;
    private static final int KARATSUBA_THRESHOLD = 80;
    private static final int TOOM_COOK_THRESHOLD = 240;
    private static final int KARATSUBA_SQUARE_THRESHOLD = 128;
    private static final int TOOM_COOK_SQUARE_THRESHOLD = 216;
    static final int BURNIKEL_ZIEGLER_THRESHOLD = 80;
    static final int BURNIKEL_ZIEGLER_OFFSET = 40;
    private static final int SCHOENHAGE_BASE_CONVERSION_THRESHOLD = 20;
    private static final int MULTIPLY_SQUARE_THRESHOLD = 20;
    private static long[] bitsPerDigit;
    private static final int SMALL_PRIME_THRESHOLD = 95;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    private static final BigInteger SMALL_PRIME_PRODUCT;
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst;
    private static BigInteger[] negConst;
    private static volatile BigInteger[][] powerCache;
    private static final double[] logCache;
    private static final double LOG_TWO;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final BigInteger NEGATIVE_ONE;
    public static final BigInteger TEN;
    static int[] bnExpModThreshTable;
    private static String[] zeros;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static int[] digitsPerInt;
    private static int[] intRadix;
    private static final long serialVersionUID = -8287574255936472291L;
    private static final ObjectStreamField[] serialPersistentFields;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BigInteger(byte[] byArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        int n = byArray.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException("Zero length BigInteger");
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        byte by = byArray[0];
        RuntimeCostAccounter.recordJump();
        if (by < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.makePositive:([B)[I");
            this.mag = BigInteger.makePositive(byArray);
            this.signum = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.stripLeadingZeroBytes:([B)[I");
            this.mag = BigInteger.stripLeadingZeroBytes(byArray);
            int n3 = this.mag.length;
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = 1;
            }
            this.signum = n2;
        }
        int n4 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n4 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    private BigInteger(int[] nArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        int n = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException("Zero length BigInteger");
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        int n2 = nArray[0];
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.makePositive:([I)[I");
            this.mag = BigInteger.makePositive(nArray);
            this.signum = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            int n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
            this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
            int n4 = this.mag.length;
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                n3 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n3 = 1;
            }
            this.signum = n3;
        }
        int n5 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n5 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    public BigInteger(int n, byte[] byArray) {
        block8: {
            block7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.stripLeadingZeroBytes:([B)[I");
                this.mag = BigInteger.stripLeadingZeroBytes(byArray);
                RuntimeCostAccounter.recordJump();
                if (n < -1) break block7;
                RuntimeCostAccounter.recordJump();
                if (n <= 1) break block8;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException("Invalid signum value");
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        int n2 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            this.signum = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                NumberFormatException numberFormatException = new NumberFormatException("signum-magnitude mismatch");
                RuntimeCostAccounter.recordThrow();
                throw numberFormatException;
            }
            this.signum = n;
        }
        int n3 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n3 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    private BigInteger(int n, int[] nArray) {
        block8: {
            block7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.stripLeadingZeroInts:([I)[I");
                this.mag = BigInteger.stripLeadingZeroInts(nArray);
                RuntimeCostAccounter.recordJump();
                if (n < -1) break block7;
                RuntimeCostAccounter.recordJump();
                if (n <= 1) break block8;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException("Invalid signum value");
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        int n2 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            this.signum = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                NumberFormatException numberFormatException = new NumberFormatException("signum-magnitude mismatch");
                RuntimeCostAccounter.recordThrow();
                throw numberFormatException;
            }
            this.signum = n;
        }
        int n3 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n3 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    public BigInteger(String string, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        block23: {
            int n6;
            block20: {
                block22: {
                    block21: {
                        block19: {
                            block18: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
                                n5 = 0;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                n4 = string.length();
                                RuntimeCostAccounter.recordJump();
                                if (n < 2) break block18;
                                RuntimeCostAccounter.recordJump();
                                if (n <= 36) break block19;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                            NumberFormatException numberFormatException = new NumberFormatException("Radix out of range");
                            RuntimeCostAccounter.recordThrow();
                            throw numberFormatException;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n4 == 0) {
                            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                            NumberFormatException numberFormatException = new NumberFormatException("Zero length BigInteger");
                            RuntimeCostAccounter.recordThrow();
                            throw numberFormatException;
                        }
                        n3 = 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(I)I");
                        int n7 = string.lastIndexOf(45);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(I)I");
                        n6 = string.lastIndexOf(43);
                        RuntimeCostAccounter.recordJump();
                        if (n7 < 0) break block20;
                        RuntimeCostAccounter.recordJump();
                        if (n7 != 0) break block21;
                        RuntimeCostAccounter.recordJump();
                        if (n6 < 0) break block22;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                    NumberFormatException numberFormatException = new NumberFormatException("Illegal embedded sign character");
                    RuntimeCostAccounter.recordThrow();
                    throw numberFormatException;
                }
                n3 = -1;
                n5 = 1;
                RuntimeCostAccounter.recordJump();
                break block23;
            }
            RuntimeCostAccounter.recordJump();
            if (n6 >= 0) {
                RuntimeCostAccounter.recordJump();
                if (n6 != 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                    NumberFormatException numberFormatException = new NumberFormatException("Illegal embedded sign character");
                    RuntimeCostAccounter.recordThrow();
                    throw numberFormatException;
                }
                n5 = 1;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n5 == n4) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException("Zero length BigInteger");
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c = string.charAt(n5);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.digit:(CI)I");
            int n8 = Character.digit(c, n);
            RuntimeCostAccounter.recordJump();
            if (n8 != 0) break;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n5 == n4) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n9 = n4 - n5;
        this.signum = n3;
        long l = ((long)n9 * bitsPerDigit[n] >>> 10) + 1L;
        RuntimeCostAccounter.recordJump();
        if (l + 31L >= 0x100000000L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.reportOverflow:()V");
            BigInteger.reportOverflow();
        }
        int n10 = n2 = (int)(l + 31L) >>> 5;
        RuntimeCostAccounter.recordArrayAllocation((int)n10, (int)4);
        int[] nArray = new int[n10];
        int n11 = n9 % digitsPerInt[n];
        RuntimeCostAccounter.recordJump();
        if (n11 == 0) {
            n11 = digitsPerInt[n];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        String string2 = string.substring(n5, n5 += n11);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;I)I");
        nArray[n2 - 1] = Integer.parseInt(string2, n);
        int n12 = nArray[n2 - 1];
        RuntimeCostAccounter.recordJump();
        if (n12 < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException("Illegal digit");
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        int n13 = intRadix[n];
        int n14 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            string2 = string.substring(n5, n5 += digitsPerInt[n]);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;I)I");
            n14 = Integer.parseInt(string2, n);
            RuntimeCostAccounter.recordJump();
            if (n14 < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                NumberFormatException numberFormatException = new NumberFormatException("Illegal digit");
                RuntimeCostAccounter.recordThrow();
                throw numberFormatException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.destructiveMulAdd:([III)V");
            BigInteger.destructiveMulAdd(nArray, n13, n14);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
        int n15 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n15 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    BigInteger(char[] cArray, int n, int n2) {
        int n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n2) break;
            char c = cArray[n4];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.digit:(CI)I");
            int n5 = Character.digit(c, 10);
            RuntimeCostAccounter.recordJump();
            if (n5 != 0) break;
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n4 == n2) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n6 = n2 - n4;
        this.signum = n;
        RuntimeCostAccounter.recordJump();
        if (n2 < 10) {
            n3 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            long l = ((long)n6 * bitsPerDigit[10] >>> 10) + 1L;
            RuntimeCostAccounter.recordJump();
            if (l + 31L >= 0x100000000L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.reportOverflow:()V");
                BigInteger.reportOverflow();
            }
            n3 = (int)(l + 31L) >>> 5;
        }
        int n7 = n3;
        RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)4);
        int[] nArray = new int[n7];
        int n8 = n6 % digitsPerInt[10];
        RuntimeCostAccounter.recordJump();
        if (n8 == 0) {
            n8 = digitsPerInt[10];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.parseInt:([CII)I");
        nArray[n3 - 1] = this.parseInt(cArray, n4, n4 += n8);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.parseInt:([CII)I");
            int n9 = this.parseInt(cArray, n4, n4 += digitsPerInt[10]);
            int n10 = intRadix[10];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.destructiveMulAdd:([III)V");
            BigInteger.destructiveMulAdd(nArray, n10, n9);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
        int n11 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n11 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    private int parseInt(char[] cArray, int n, int n2) {
        char c = cArray[n++];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.digit:(CI)I");
        int n3 = Character.digit(c, 10);
        RuntimeCostAccounter.recordJump();
        if (n3 == -1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([C)V");
            String string = new String(cArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
            NumberFormatException numberFormatException = new NumberFormatException(string);
            RuntimeCostAccounter.recordThrow();
            throw numberFormatException;
        }
        int n4 = n;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n2) break;
            char c2 = cArray[n4];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.digit:(CI)I");
            int n5 = Character.digit(c2, 10);
            RuntimeCostAccounter.recordJump();
            if (n5 == -1) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NumberFormatException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([C)V");
                String string = new String(cArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NumberFormatException.<init>:(Ljava/lang/String;)V");
                NumberFormatException numberFormatException = new NumberFormatException(string);
                RuntimeCostAccounter.recordThrow();
                throw numberFormatException;
            }
            n3 = 10 * n3 + n5;
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        return n3;
    }

    private static void destructiveMulAdd(int[] nArray, int n, int n2) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        int n3 = nArray.length;
        long l3 = 0L;
        long l4 = 0L;
        int n4 = n3 - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) break;
            l3 = l * ((long)nArray[n4] & 0xFFFFFFFFL) + l4;
            nArray[n4] = (int)l3;
            l4 = l3 >>> 32;
            --n4;
            RuntimeCostAccounter.recordJump();
        }
        long l5 = ((long)nArray[n3 - 1] & 0xFFFFFFFFL) + l2;
        nArray[n3 - 1] = (int)l5;
        l4 = l5 >>> 32;
        int n5 = n3 - 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 < 0) break;
            l5 = ((long)nArray[n5] & 0xFFFFFFFFL) + l4;
            nArray[n5] = (int)l5;
            l4 = l5 >>> 32;
            --n5;
            RuntimeCostAccounter.recordJump();
        }
    }

    public BigInteger(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(Ljava/lang/String;I)V");
        this(string, 10);
    }

    public BigInteger(int n, Random random) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.randomBits:(ILjava/util/Random;)[B");
        byte[] byArray = BigInteger.randomBits(n, random);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(I[B)V");
        this(1, byArray);
    }

    private static byte[] randomBits(int n, Random random) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("numBits must be non-negative");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n3 = n2 = (int)(((long)n + 7L) / 8L);
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)1);
        byte[] byArray = new byte[n3];
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextBytes:([B)V");
            random.nextBytes(byArray);
            int n4 = 8 * n2 - n;
            byArray[0] = (byte)(byArray[0] & (1 << 8 - n4) - 1);
        }
        return byArray;
    }

    public BigInteger(int n, int n2, Random random) {
        BigInteger bigInteger;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("bitLength < 2");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 95) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.smallPrime:(IILjava/util/Random;)Ljava/math/BigInteger;");
            bigInteger = BigInteger.smallPrime(n, n2, random);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.largePrime:(IILjava/util/Random;)Ljava/math/BigInteger;");
            bigInteger = BigInteger.largePrime(n, n2, random);
        }
        BigInteger bigInteger2 = bigInteger;
        this.signum = 1;
        this.mag = bigInteger2.mag;
    }

    public static BigInteger probablePrime(int n, Random random) {
        BigInteger bigInteger;
        RuntimeCostAccounter.recordJump();
        if (n < 2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("bitLength < 2");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 95) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.smallPrime:(IILjava/util/Random;)Ljava/math/BigInteger;");
            bigInteger = BigInteger.smallPrime(n, 100, random);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.largePrime:(IILjava/util/Random;)Ljava/math/BigInteger;");
            bigInteger = BigInteger.largePrime(n, 100, random);
        }
        return bigInteger;
    }

    private static BigInteger smallPrime(int n, int n2, Random random) {
        int n3;
        int n4 = n3 = n + 31 >>> 5;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        int n5 = 1 << (n + 31 & 0x1F);
        int n6 = (n5 << 1) - 1;
        while (true) {
            int n7 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:()I");
                nArray[n7] = random.nextInt();
                ++n7;
                RuntimeCostAccounter.recordJump();
            }
            nArray[0] = nArray[0] & n6 | n5;
            RuntimeCostAccounter.recordJump();
            if (n > 2) {
                int n8 = n3 - 1;
                nArray[n8] = nArray[n8] | 1;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            BigInteger bigInteger = new BigInteger(nArray, 1);
            RuntimeCostAccounter.recordJump();
            if (n > 6) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.remainder:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                BigInteger bigInteger2 = bigInteger.remainder(SMALL_PRIME_PRODUCT);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
                long l = bigInteger2.longValue();
                RuntimeCostAccounter.recordJump();
                if (l % 3L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 5L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 7L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 11L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 13L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 17L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 19L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 23L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 29L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 31L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 37L == 0L) continue;
                RuntimeCostAccounter.recordJump();
                if (l % 41L == 0L) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n < 4) {
                return bigInteger;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primeToCertainty:(ILjava/util/Random;)Z");
            boolean bl = bigInteger.primeToCertainty(n2, random);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return bigInteger;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private static BigInteger largePrime(int n, int n2, Random random) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(ILjava/util/Random;)V");
        BigInteger bigInteger = new BigInteger(n, random);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.setBit:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = bigInteger.setBit(n - 1);
        int n3 = bigInteger2.mag.length - 1;
        bigInteger2.mag[n3] = bigInteger2.mag[n3] & 0xFFFFFFFE;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getPrimeSearchLen:(I)I");
        int n4 = BigInteger.getPrimeSearchLen(n);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BitSieve");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.<init>:(Ljava/math/BigInteger;I)V");
        BitSieve bitSieve = new BitSieve(bigInteger2, n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.retrieve:(Ljava/math/BigInteger;ILjava/util/Random;)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = bitSieve.retrieve(bigInteger2, n2, random);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (bigInteger3 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                int n5 = bigInteger3.bitLength();
                RuntimeCostAccounter.recordJump();
                if (n5 == n) break;
            }
            long l = 2 * n4;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
            BigInteger bigInteger4 = BigInteger.valueOf(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            bigInteger2 = bigInteger2.add(bigInteger4);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
            int n6 = bigInteger2.bitLength();
            RuntimeCostAccounter.recordJump();
            if (n6 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(ILjava/util/Random;)V");
                BigInteger bigInteger5 = new BigInteger(n, random);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.setBit:(I)Ljava/math/BigInteger;");
                bigInteger2 = bigInteger5.setBit(n - 1);
            }
            int n7 = bigInteger2.mag.length - 1;
            bigInteger2.mag[n7] = bigInteger2.mag[n7] & 0xFFFFFFFE;
            RuntimeCostAccounter.recordAllocation((String)"java/math/BitSieve");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.<init>:(Ljava/math/BigInteger;I)V");
            bitSieve = new BitSieve(bigInteger2, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.retrieve:(Ljava/math/BigInteger;ILjava/util/Random;)Ljava/math/BigInteger;");
            bigInteger3 = bitSieve.retrieve(bigInteger2, n2, random);
            RuntimeCostAccounter.recordJump();
        }
        return bigInteger3;
    }

    public BigInteger nextProbablePrime() {
        BigInteger bigInteger;
        block16: {
            block15: {
                block14: {
                    RuntimeCostAccounter.recordJump();
                    if (this.signum < 0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("start < 0: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(this);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                        ArithmeticException arithmeticException = new ArithmeticException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw arithmeticException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.signum == 0) break block14;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                    boolean bl = this.equals(ONE);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block15;
                }
                return TWO;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            bigInteger = this.add(ONE);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
            int n = bigInteger.bitLength();
            RuntimeCostAccounter.recordJump();
            if (n >= 95) break block16;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
            boolean bl = bigInteger.testBit(0);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                bigInteger = bigInteger.add(ONE);
            }
            while (true) {
                block17: {
                    block18: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                        int n2 = bigInteger.bitLength();
                        RuntimeCostAccounter.recordJump();
                        if (n2 <= 6) break block17;
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.remainder:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                        BigInteger bigInteger2 = bigInteger.remainder(SMALL_PRIME_PRODUCT);
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
                        long l = bigInteger2.longValue();
                        RuntimeCostAccounter.recordJump();
                        if (l % 3L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 5L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 7L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 11L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 13L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 17L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 19L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 23L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 29L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 31L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 37L == 0L) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (l % 41L != 0L) break block17;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                    bigInteger = bigInteger.add(TWO);
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                int n3 = bigInteger.bitLength();
                RuntimeCostAccounter.recordJump();
                if (n3 < 4) {
                    return bigInteger;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primeToCertainty:(ILjava/util/Random;)Z");
                boolean bl2 = bigInteger.primeToCertainty(100, null);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    return bigInteger;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                bigInteger = bigInteger.add(TWO);
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
        boolean bl = bigInteger.testBit(0);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            bigInteger = bigInteger.subtract(ONE);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n = bigInteger.bitLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getPrimeSearchLen:(I)I");
        int n4 = BigInteger.getPrimeSearchLen(n);
        while (true) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BitSieve");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.<init>:(Ljava/math/BigInteger;I)V");
            BitSieve bitSieve = new BitSieve(bigInteger, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BitSieve.retrieve:(Ljava/math/BigInteger;ILjava/util/Random;)Ljava/math/BigInteger;");
            BigInteger bigInteger3 = bitSieve.retrieve(bigInteger, 100, null);
            RuntimeCostAccounter.recordJump();
            if (bigInteger3 != null) {
                return bigInteger3;
            }
            long l = 2 * n4;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
            BigInteger bigInteger4 = BigInteger.valueOf(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            bigInteger = bigInteger.add(bigInteger4);
            RuntimeCostAccounter.recordJump();
        }
    }

    private static int getPrimeSearchLen(int n) {
        RuntimeCostAccounter.recordJump();
        if (n > 500000001) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Prime search implementation restriction on bitLength");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        return n / 20 * 64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean primeToCertainty(int n, Random random) {
        int n2;
        int n3 = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n4 = (Math.min(n, 0x7FFFFFFE) + 1) / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n5 = this.bitLength();
        RuntimeCostAccounter.recordJump();
        if (n5 < 100) {
            int n6;
            n3 = 50;
            RuntimeCostAccounter.recordJump();
            if (n4 < n3) {
                n6 = n4;
                RuntimeCostAccounter.recordJump();
            } else {
                n6 = n3;
            }
            n3 = n6;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.passesMillerRabin:(ILjava/util/Random;)Z");
            return this.passesMillerRabin(n3, random);
        }
        RuntimeCostAccounter.recordJump();
        if (n5 < 256) {
            n3 = 27;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n5 < 512) {
                n3 = 15;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n5 < 768) {
                    n3 = 8;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (n5 < 1024) {
                        n3 = 4;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n3 = 2;
                    }
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n4 < n3) {
            n2 = n4;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n3;
        }
        n3 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.passesMillerRabin:(ILjava/util/Random;)Z");
        boolean bl = this.passesMillerRabin(n3, random);
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.passesLucasLehmer:()Z");
        boolean bl2 = this.passesLucasLehmer();
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    private boolean passesLucasLehmer() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger = this.add(ONE);
        int n = 5;
        while (true) {
            int n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.jacobiSymbol:(ILjava/math/BigInteger;)I");
            int n3 = BigInteger.jacobiSymbol(n, this);
            RuntimeCostAccounter.recordJump();
            if (n3 == -1) break;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                n2 = Math.abs(n) + 2;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = -(n + 2);
            }
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.lucasLehmerSequence:(ILjava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = BigInteger.lucasLehmerSequence(n, bigInteger, this);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = bigInteger2.mod(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
        return bigInteger3.equals(ZERO);
    }

    private static int jacobiSymbol(int n, BigInteger bigInteger) {
        int n2;
        int n3;
        int n4;
        block17: {
            block18: {
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    return 0;
                }
                n4 = 1;
                n3 = bigInteger.mag[bigInteger.mag.length - 1];
                RuntimeCostAccounter.recordJump();
                if (n >= 0) break block17;
                n = -n;
                n2 = n3 & 7;
                RuntimeCostAccounter.recordJump();
                if (n2 == 3) break block18;
                RuntimeCostAccounter.recordJump();
                if (n2 != 7) break block17;
            }
            n4 = -n4;
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if ((n & 3) != 0) break;
            n >>= 2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if ((n & 1) == 0) {
            n >>= 1;
            RuntimeCostAccounter.recordJump();
            if (((n3 ^ n3 >> 1) & 2) != 0) {
                n4 = -n4;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (n == 1) {
            return n4;
        }
        RuntimeCostAccounter.recordJump();
        if ((n & n3 & 2) != 0) {
            n4 = -n4;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = BigInteger.valueOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = bigInteger.mod(bigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intValue:()I");
        n3 = bigInteger3.intValue();
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) break;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if ((n3 & 3) != 0) break;
                n3 >>= 2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if ((n3 & 1) == 0) {
                n3 >>= 1;
                RuntimeCostAccounter.recordJump();
                if (((n ^ n >> 1) & 2) != 0) {
                    n4 = -n4;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n3 == 1) {
                return n4;
            }
            RuntimeCostAccounter.recordJump();
            if (!$assertionsDisabled) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                    AssertionError assertionError = new AssertionError();
                    RuntimeCostAccounter.recordThrow();
                    throw assertionError;
                }
            }
            n2 = n3;
            n3 = n;
            n = n2;
            RuntimeCostAccounter.recordJump();
            if ((n3 & n & 2) != 0) {
                n4 = -n4;
            }
            n3 %= n;
            RuntimeCostAccounter.recordJump();
        }
        return 0;
    }

    private static BigInteger lucasLehmerSequence(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = BigInteger.valueOf(l);
        BigInteger bigInteger4 = ONE;
        BigInteger bigInteger5 = ONE;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n2 = bigInteger.bitLength() - 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger7 = bigInteger6.mod(bigInteger2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
            BigInteger bigInteger8 = bigInteger5.square();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
            BigInteger bigInteger9 = bigInteger4.square();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger10 = bigInteger3.multiply(bigInteger9);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger11 = bigInteger8.add(bigInteger10);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger12 = bigInteger11.mod(bigInteger2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
            boolean bl = bigInteger12.testBit(0);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                bigInteger12 = bigInteger12.subtract(bigInteger2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
            bigInteger12 = bigInteger12.shiftRight(1);
            bigInteger4 = bigInteger7;
            bigInteger5 = bigInteger12;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
            boolean bl2 = bigInteger.testBit(n2);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                BigInteger bigInteger13 = bigInteger4.add(bigInteger5);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                bigInteger7 = bigInteger13.mod(bigInteger2);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
                boolean bl3 = bigInteger7.testBit(0);
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                    bigInteger7 = bigInteger7.subtract(bigInteger2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
                bigInteger7 = bigInteger7.shiftRight(1);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                BigInteger bigInteger14 = bigInteger3.multiply(bigInteger4);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                BigInteger bigInteger15 = bigInteger5.add(bigInteger14);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                bigInteger12 = bigInteger15.mod(bigInteger2);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
                boolean bl4 = bigInteger12.testBit(0);
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                    bigInteger12 = bigInteger12.subtract(bigInteger2);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
                bigInteger12 = bigInteger12.shiftRight(1);
                bigInteger4 = bigInteger7;
                bigInteger5 = bigInteger12;
            }
            --n2;
            RuntimeCostAccounter.recordJump();
        }
        return bigInteger4;
    }

    private boolean passesMillerRabin(int n, Random random) {
        BigInteger bigInteger;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = bigInteger = this.subtract(ONE);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLowestSetBit:()I");
        int n2 = bigInteger2.getLowestSetBit();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
        bigInteger2 = bigInteger2.shiftRight(n2);
        RuntimeCostAccounter.recordJump();
        if (random == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
            random = ThreadLocalRandom.current();
        }
        int n3 = 0;
        while (true) {
            BigInteger bigInteger3;
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            while (true) {
                RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                int n4 = this.bitLength();
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(ILjava/util/Random;)V");
                bigInteger3 = new BigInteger(n4, random);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareTo:(Ljava/math/BigInteger;)I");
                int n5 = bigInteger3.compareTo(ONE);
                RuntimeCostAccounter.recordJump();
                if (n5 <= 0) continue;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareTo:(Ljava/math/BigInteger;)I");
                int n6 = bigInteger3.compareTo(this);
                RuntimeCostAccounter.recordJump();
                if (n6 < 0) break;
            }
            int n7 = 0;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.modPow:(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, this);
            while (true) {
                block10: {
                    block9: {
                        block8: {
                            RuntimeCostAccounter.recordJump();
                            if (n7 == 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                                boolean bl = bigInteger4.equals(ONE);
                                RuntimeCostAccounter.recordJump();
                                if (bl) break;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                            boolean bl = bigInteger4.equals(bigInteger);
                            RuntimeCostAccounter.recordJump();
                            if (bl) break;
                            RuntimeCostAccounter.recordJump();
                            if (n7 <= 0) break block8;
                            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                            boolean bl2 = bigInteger4.equals(ONE);
                            RuntimeCostAccounter.recordJump();
                            if (bl2) break block9;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (++n7 != n2) break block10;
                    }
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.modPow:(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                bigInteger4 = bigInteger4.modPow(TWO, this);
                RuntimeCostAccounter.recordJump();
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    BigInteger(int[] nArray, int n) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        int n3 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            n2 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n;
        }
        this.signum = n2;
        this.mag = nArray;
        int n4 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n4 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    private BigInteger(byte[] byArray, int n) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        int n3 = byArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            n2 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n;
        }
        this.signum = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.stripLeadingZeroBytes:([B)[I");
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
        int n4 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n4 >= 0x4000000) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
            this.checkRange();
        }
    }

    private void checkRange() {
        block3: {
            block2: {
                int n = this.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n > 0x4000000) break block2;
                int n2 = this.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n2 != 0x4000000) break block3;
                int n3 = this.mag[0];
                RuntimeCostAccounter.recordJump();
                if (n3 >= 0) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.reportOverflow:()V");
            BigInteger.reportOverflow();
        }
    }

    private static void reportOverflow() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
        ArithmeticException arithmeticException = new ArithmeticException("BigInteger would overflow supported range");
        RuntimeCostAccounter.recordThrow();
        throw arithmeticException;
    }

    public static BigInteger valueOf(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (l > 0L) {
            RuntimeCostAccounter.recordJump();
            if (l <= 16L) {
                return posConst[(int)l];
            }
        }
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordJump();
            if (l >= -16L) {
                return negConst[(int)(-l)];
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(J)V");
        return new BigInteger(l);
    }

    private BigInteger(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Number.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            l = -l;
            this.signum = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            this.signum = 1;
        }
        int n = (int)(l >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)4);
            this.mag = new int[1];
            this.mag[0] = (int)l;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)4);
            this.mag = new int[2];
            this.mag[0] = n;
            this.mag[1] = (int)l;
        }
    }

    private static BigInteger valueOf(int[] nArray) {
        BigInteger bigInteger;
        int n = nArray[0];
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            bigInteger = new BigInteger(nArray, 1);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([I)V");
            bigInteger = new BigInteger(nArray);
        }
        return bigInteger;
    }

    public BigInteger add(BigInteger bigInteger) {
        int n;
        int[] nArray;
        int n2 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return this;
        }
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return bigInteger;
        }
        int n3 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n3 == this.signum) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            int[] nArray2 = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:([I[I)[I");
            int[] nArray3 = BigInteger.add(this.mag, nArray2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray3, this.signum);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareMagnitude:(Ljava/math/BigInteger;)I");
        int n4 = this.compareMagnitude(bigInteger);
        RuntimeCostAccounter.recordJump();
        if (n4 == 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (n4 > 0) {
            int[] nArray4 = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:([I[I)[I");
            nArray = BigInteger.subtract(this.mag, nArray4);
            RuntimeCostAccounter.recordJump();
        } else {
            int[] nArray5 = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:([I[I)[I");
            nArray = BigInteger.subtract(nArray5, this.mag);
        }
        int[] nArray6 = nArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        nArray6 = BigInteger.trustedStripLeadingZeroInts(nArray6);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordJump();
        if (n4 == this.signum) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray6, n);
    }

    BigInteger add(long l) {
        int n;
        int[] nArray;
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
            return BigInteger.valueOf(l);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.signum:(J)I");
        int n2 = Long.signum(l);
        RuntimeCostAccounter.recordJump();
        if (n2 == this.signum) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
            long l2 = Math.abs(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:([IJ)[I");
            int[] nArray2 = BigInteger.add(this.mag, l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray2, this.signum);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareMagnitude:(J)I");
        int n3 = this.compareMagnitude(l);
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
            long l3 = Math.abs(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:([IJ)[I");
            nArray = BigInteger.subtract(this.mag, l3);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
            long l4 = Math.abs(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(J[I)[I");
            nArray = BigInteger.subtract(l4, this.mag);
        }
        int[] nArray3 = nArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        nArray3 = BigInteger.trustedStripLeadingZeroInts(nArray3);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordJump();
        if (n3 == this.signum) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray3, n);
    }

    private static int[] add(int[] nArray, long l) {
        boolean bl;
        int[] nArray2;
        long l2 = 0L;
        int n = nArray.length;
        int n2 = (int)(l >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            int n3 = n--;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
            nArray2 = new int[n3];
            l2 = ((long)nArray[n] & 0xFFFFFFFFL) + l;
            nArray2[n] = (int)l2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (n == 1) {
                RuntimeCostAccounter.recordArrayAllocation((int)2, (int)4);
                int[] nArray3 = new int[2];
                l2 = l + ((long)nArray[0] & 0xFFFFFFFFL);
                nArray3[1] = (int)l2;
                nArray3[0] = (int)(l2 >>> 32);
                return nArray3;
            }
            int n4 = n--;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
            nArray2 = new int[n4];
            l2 = ((long)nArray[n] & 0xFFFFFFFFL) + (l & 0xFFFFFFFFL);
            nArray2[n] = (int)l2;
            l2 = ((long)nArray[--n] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) + (l2 >>> 32);
            nArray2[n] = (int)l2;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 >>> 32 != 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        while (true) {
            boolean bl3;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            nArray2[--n] = nArray[n] + 1;
            RuntimeCostAccounter.recordJump();
            if (nArray2[--n] == 0) {
                bl3 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl3 = false;
            }
            bl2 = bl3;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            nArray2[--n] = nArray[n];
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            int n5 = nArray2.length + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
            int[] nArray4 = new int[n5];
            int n6 = nArray2.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(nArray2, 0, nArray4, 1, n6);
            nArray4[0] = 1;
            return nArray4;
        }
        return nArray2;
    }

    private static int[] add(int[] nArray, int[] nArray2) {
        boolean bl;
        int n = nArray.length;
        int n2 = nArray2.length;
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n3 = nArray.length;
        int n4 = nArray2.length;
        int n5 = n3--;
        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
        int[] nArray4 = new int[n5];
        long l = 0L;
        RuntimeCostAccounter.recordJump();
        if (n4 == 1) {
            l = ((long)nArray[n3] & 0xFFFFFFFFL) + ((long)nArray2[0] & 0xFFFFFFFFL);
            nArray4[n3] = (int)l;
            RuntimeCostAccounter.recordJump();
        } else {
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n4 <= 0) break;
                l = ((long)nArray[--n3] & 0xFFFFFFFFL) + ((long)nArray2[--n4] & 0xFFFFFFFFL) + (l >>> 32);
                nArray4[n3] = (int)l;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (l >>> 32 != 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        while (true) {
            boolean bl3;
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            nArray4[--n3] = nArray[n3] + 1;
            RuntimeCostAccounter.recordJump();
            if (nArray4[--n3] == 0) {
                bl3 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl3 = false;
            }
            bl2 = bl3;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            nArray4[--n3] = nArray[n3];
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            int n6 = nArray4.length + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)4);
            int[] nArray5 = new int[n6];
            int n7 = nArray4.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(nArray4, 0, nArray5, 1, n7);
            nArray5[0] = 1;
            return nArray5;
        }
        return nArray4;
    }

    private static int[] subtract(long l, int[] nArray) {
        int n = (int)(l >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)4);
            int[] nArray2 = new int[]{(int)(l - ((long)nArray[0] & 0xFFFFFFFFL))};
            return nArray2;
        }
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)4);
        int[] nArray3 = new int[2];
        int n2 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 == 1) {
            boolean bl;
            long l2 = ((long)((int)l) & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL);
            nArray3[1] = (int)l2;
            RuntimeCostAccounter.recordJump();
            if (l2 >> 32 != 0L) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            boolean bl2 = bl;
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                nArray3[0] = n - 1;
                RuntimeCostAccounter.recordJump();
            } else {
                nArray3[0] = n;
            }
            return nArray3;
        }
        long l3 = ((long)((int)l) & 0xFFFFFFFFL) - ((long)nArray[1] & 0xFFFFFFFFL);
        nArray3[1] = (int)l3;
        l3 = ((long)n & 0xFFFFFFFFL) - ((long)nArray[0] & 0xFFFFFFFFL) + (l3 >> 32);
        nArray3[0] = (int)l3;
        return nArray3;
    }

    private static int[] subtract(int[] nArray, long l) {
        boolean bl;
        int n = (int)(l >>> 32);
        int n2 = nArray.length;
        int n3 = n2--;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        int[] nArray2 = new int[n3];
        long l2 = 0L;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            l2 = ((long)nArray[n2] & 0xFFFFFFFFL) - l;
            nArray2[n2] = (int)l2;
            RuntimeCostAccounter.recordJump();
        } else {
            l2 = ((long)nArray[--n2] & 0xFFFFFFFFL) - (l & 0xFFFFFFFFL);
            nArray2[n2] = (int)l2;
            l2 = ((long)nArray[--n2] & 0xFFFFFFFFL) - ((long)n & 0xFFFFFFFFL) + (l2 >> 32);
            nArray2[n2] = (int)l2;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 >> 32 != 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        while (true) {
            boolean bl3;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            nArray2[--n2] = nArray[n2] - 1;
            RuntimeCostAccounter.recordJump();
            if (nArray2[--n2] == -1) {
                bl3 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl3 = false;
            }
            bl2 = bl3;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            nArray2[--n2] = nArray[n2];
            RuntimeCostAccounter.recordJump();
        }
        return nArray2;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        int n;
        int[] nArray;
        int n2 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return this;
        }
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
            return bigInteger.negate();
        }
        int n3 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n3 != this.signum) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            int[] nArray2 = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:([I[I)[I");
            int[] nArray3 = BigInteger.add(this.mag, nArray2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray3, this.signum);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareMagnitude:(Ljava/math/BigInteger;)I");
        int n4 = this.compareMagnitude(bigInteger);
        RuntimeCostAccounter.recordJump();
        if (n4 == 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (n4 > 0) {
            int[] nArray4 = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:([I[I)[I");
            nArray = BigInteger.subtract(this.mag, nArray4);
            RuntimeCostAccounter.recordJump();
        } else {
            int[] nArray5 = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:([I[I)[I");
            nArray = BigInteger.subtract(nArray5, this.mag);
        }
        int[] nArray6 = nArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        nArray6 = BigInteger.trustedStripLeadingZeroInts(nArray6);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordJump();
        if (n4 == this.signum) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray6, n);
    }

    private static int[] subtract(int[] nArray, int[] nArray2) {
        boolean bl;
        int n;
        int n2 = n = nArray.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
        int[] nArray3 = new int[n2];
        int n3 = nArray2.length;
        long l = 0L;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            l = ((long)nArray[--n] & 0xFFFFFFFFL) - ((long)nArray2[--n3] & 0xFFFFFFFFL) + (l >> 32);
            nArray3[n] = (int)l;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (l >> 32 != 0L) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        while (true) {
            boolean bl3;
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            nArray3[--n] = nArray[n] - 1;
            RuntimeCostAccounter.recordJump();
            if (nArray3[--n] == -1) {
                bl3 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl3 = false;
            }
            bl2 = bl3;
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            nArray3[--n] = nArray[n];
            RuntimeCostAccounter.recordJump();
        }
        return nArray3;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        int n;
        int n2;
        block17: {
            int n3;
            block16: {
                block15: {
                    block14: {
                        int n4 = bigInteger.signum;
                        RuntimeCostAccounter.recordJump();
                        if (n4 == 0) break block14;
                        RuntimeCostAccounter.recordJump();
                        if (this.signum != 0) break block15;
                    }
                    return ZERO;
                }
                n2 = this.mag.length;
                RuntimeCostAccounter.recordJump();
                if (bigInteger == this) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 > 20) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
                        return this.square();
                    }
                }
                n = bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n2 < 80) break block16;
                RuntimeCostAccounter.recordJump();
                if (n >= 80) break block17;
            }
            int n5 = bigInteger.signum;
            RuntimeCostAccounter.recordJump();
            if (this.signum == n5) {
                n3 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n3 = -1;
            }
            int n6 = n3;
            int n7 = bigInteger.mag.length;
            RuntimeCostAccounter.recordJump();
            if (n7 == 1) {
                int n8 = bigInteger.mag[0];
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyByInt:([III)Ljava/math/BigInteger;");
                return BigInteger.multiplyByInt(this.mag, n8, n6);
            }
            int n9 = this.mag.length;
            RuntimeCostAccounter.recordJump();
            if (n9 == 1) {
                int[] nArray = bigInteger.mag;
                int n10 = this.mag[0];
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyByInt:([III)Ljava/math/BigInteger;");
                return BigInteger.multiplyByInt(nArray, n10, n6);
            }
            int[] nArray = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyToLen:([II[II[I)[I");
            int[] nArray2 = this.multiplyToLen(this.mag, n2, nArray, n, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
            nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray2);
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray2, n6);
        }
        RuntimeCostAccounter.recordJump();
        if (n2 < 240) {
            RuntimeCostAccounter.recordJump();
            if (n < 240) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyKaratsuba:(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                return BigInteger.multiplyKaratsuba(this, bigInteger);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyToomCook3:(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        return BigInteger.multiplyToomCook3(this, bigInteger);
    }

    private static BigInteger multiplyByInt(int[] nArray, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.bitCount:(I)I");
        int n3 = Integer.bitCount(n);
        RuntimeCostAccounter.recordJump();
        if (n3 == 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
            int n4 = Integer.numberOfTrailingZeros(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:([II)[I");
            int[] nArray2 = BigInteger.shiftLeft(nArray, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray2, n2);
        }
        int n5 = nArray.length;
        int n6 = n5 + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)4);
        int[] nArray3 = new int[n6];
        long l = 0L;
        long l2 = (long)n & 0xFFFFFFFFL;
        int n7 = nArray3.length - 1;
        int n8 = n5 - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n8 < 0) break;
            long l3 = ((long)nArray[n8] & 0xFFFFFFFFL) * l2 + l;
            nArray3[n7--] = (int)l3;
            l = l3 >>> 32;
            --n8;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            int n9 = nArray3.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
            nArray3 = Arrays.copyOfRange(nArray3, 1, n9);
            RuntimeCostAccounter.recordJump();
        } else {
            nArray3[n7] = (int)l;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray3, n2);
    }

    BigInteger multiply(long l) {
        long l2;
        int[] nArray;
        int n;
        block14: {
            block13: {
                RuntimeCostAccounter.recordJump();
                if (l == 0L) break block13;
                RuntimeCostAccounter.recordJump();
                if (this.signum != 0) break block14;
            }
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
            BigInteger bigInteger = BigInteger.valueOf(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            return this.multiply(bigInteger);
        }
        RuntimeCostAccounter.recordJump();
        if (l > 0L) {
            n = this.signum;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -this.signum;
        }
        int n2 = n;
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            l = -l;
        }
        long l3 = l >>> 32;
        long l4 = l & 0xFFFFFFFFL;
        int n3 = this.mag.length;
        int[] nArray2 = this.mag;
        RuntimeCostAccounter.recordJump();
        if (l3 == 0L) {
            int n4 = n3 + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
            nArray = new int[n4];
            RuntimeCostAccounter.recordJump();
        } else {
            int n5 = n3 + 2;
            RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
            nArray = new int[n5];
        }
        int[] nArray3 = nArray;
        long l5 = 0L;
        int n6 = nArray3.length - 1;
        int n7 = n3 - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            l2 = ((long)nArray2[n7] & 0xFFFFFFFFL) * l4 + l5;
            nArray3[n6--] = (int)l2;
            l5 = l2 >>> 32;
            --n7;
            RuntimeCostAccounter.recordJump();
        }
        nArray3[n6] = (int)l5;
        RuntimeCostAccounter.recordJump();
        if (l3 != 0L) {
            l5 = 0L;
            n6 = nArray3.length - 2;
            n7 = n3 - 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 < 0) break;
                l2 = ((long)nArray2[n7] & 0xFFFFFFFFL) * l3 + ((long)nArray3[n6] & 0xFFFFFFFFL) + l5;
                nArray3[n6--] = (int)l2;
                l5 = l2 >>> 32;
                --n7;
                RuntimeCostAccounter.recordJump();
            }
            nArray3[0] = (int)l5;
        }
        RuntimeCostAccounter.recordJump();
        if (l5 == 0L) {
            int n8 = nArray3.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
            nArray3 = Arrays.copyOfRange(nArray3, 1, n8);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray3, n2);
    }

    private int[] multiplyToLen(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        int n3;
        int n4;
        block6: {
            block5: {
                n4 = n - 1;
                n3 = n2 - 1;
                RuntimeCostAccounter.recordJump();
                if (nArray3 == null) break block5;
                int n5 = nArray3.length;
                RuntimeCostAccounter.recordJump();
                if (n5 >= n + n2) break block6;
            }
            int n6 = n + n2;
            RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)4);
            nArray3 = new int[n6];
        }
        long l = 0L;
        int n7 = n3;
        int n8 = n3 + 1 + n4;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            long l2 = ((long)nArray2[n7] & 0xFFFFFFFFL) * ((long)nArray[n4] & 0xFFFFFFFFL) + l;
            nArray3[n8] = (int)l2;
            l = l2 >>> 32;
            --n7;
            --n8;
            RuntimeCostAccounter.recordJump();
        }
        nArray3[n4] = (int)l;
        n7 = n4 - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            l = 0L;
            n8 = n3;
            int n9 = n3 + 1 + n7;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n8 < 0) break;
                long l3 = ((long)nArray2[n8] & 0xFFFFFFFFL) * ((long)nArray[n7] & 0xFFFFFFFFL) + ((long)nArray3[n9] & 0xFFFFFFFFL) + l;
                nArray3[n9] = (int)l3;
                l = l3 >>> 32;
                --n8;
                --n9;
                RuntimeCostAccounter.recordJump();
            }
            nArray3[n7] = (int)l;
            --n7;
            RuntimeCostAccounter.recordJump();
        }
        return nArray3;
    }

    private static BigInteger multiplyKaratsuba(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger.mag.length;
        int n2 = bigInteger2.mag.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n3 = (Math.max(n, n2) + 1) / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLower:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = bigInteger.getLower(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getUpper:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger4 = bigInteger.getUpper(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLower:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger5 = bigInteger2.getLower(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getUpper:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger6 = bigInteger2.getUpper(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger8 = bigInteger3.multiply(bigInteger5);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger9 = bigInteger4.add(bigInteger3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger10 = bigInteger6.add(bigInteger5);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger11 = bigInteger9.multiply(bigInteger10);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger12 = bigInteger7.shiftLeft(32 * n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger13 = bigInteger11.subtract(bigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger14 = bigInteger13.subtract(bigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger15 = bigInteger12.add(bigInteger14);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger16 = bigInteger15.shiftLeft(32 * n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger17 = bigInteger16.add(bigInteger8);
        int n4 = bigInteger.signum;
        int n5 = bigInteger2.signum;
        RuntimeCostAccounter.recordJump();
        if (n4 != n5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
            return bigInteger17.negate();
        }
        return bigInteger17;
    }

    private static BigInteger multiplyToomCook3(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger.mag.length;
        int n2 = bigInteger2.mag.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n3 = Math.max(n, n2);
        int n4 = (n3 + 2) / 3;
        int n5 = n3 - 2 * n4;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = bigInteger.getToomSlice(n4, n5, 0, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger4 = bigInteger.getToomSlice(n4, n5, 1, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger5 = bigInteger.getToomSlice(n4, n5, 2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger6 = bigInteger2.getToomSlice(n4, n5, 0, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger7 = bigInteger2.getToomSlice(n4, n5, 1, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger8 = bigInteger2.getToomSlice(n4, n5, 2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger9 = bigInteger5.multiply(bigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger10 = bigInteger3.add(bigInteger5);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger11 = bigInteger6.add(bigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger12 = bigInteger10.subtract(bigInteger4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger13 = bigInteger11.subtract(bigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger14 = bigInteger12.multiply(bigInteger13);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger10 = bigInteger10.add(bigInteger4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger11 = bigInteger11.add(bigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger15 = bigInteger10.multiply(bigInteger11);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger16 = bigInteger10.add(bigInteger3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger17 = bigInteger16.shiftLeft(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger18 = bigInteger17.subtract(bigInteger5);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger19 = bigInteger11.add(bigInteger6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger20 = bigInteger19.shiftLeft(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger21 = bigInteger20.subtract(bigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger22 = bigInteger18.multiply(bigInteger21);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger23 = bigInteger3.multiply(bigInteger6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger24 = bigInteger22.subtract(bigInteger14);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.exactDivideBy3:()Ljava/math/BigInteger;");
        BigInteger bigInteger25 = bigInteger24.exactDivideBy3();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger26 = bigInteger15.subtract(bigInteger14);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger27 = bigInteger26.shiftRight(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger28 = bigInteger15.subtract(bigInteger9);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger29 = bigInteger25.subtract(bigInteger28);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
        bigInteger25 = bigInteger29.shiftRight(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger30 = bigInteger28.subtract(bigInteger27);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger28 = bigInteger30.subtract(bigInteger23);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger31 = bigInteger23.shiftLeft(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger25 = bigInteger25.subtract(bigInteger31);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger27 = bigInteger27.subtract(bigInteger25);
        int n6 = n4 * 32;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger32 = bigInteger23.shiftLeft(n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger33 = bigInteger32.add(bigInteger25);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger34 = bigInteger33.shiftLeft(n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger35 = bigInteger34.add(bigInteger28);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger36 = bigInteger35.shiftLeft(n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger37 = bigInteger36.add(bigInteger27);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger38 = bigInteger37.shiftLeft(n6);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger39 = bigInteger38.add(bigInteger9);
        int n7 = bigInteger.signum;
        int n8 = bigInteger2.signum;
        RuntimeCostAccounter.recordJump();
        if (n7 != n8) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
            return bigInteger39.negate();
        }
        return bigInteger39;
    }

    private BigInteger getToomSlice(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = this.mag.length;
        int n8 = n4 - n7;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            n6 = 0 - n8;
            n5 = n2 - 1 - n8;
            RuntimeCostAccounter.recordJump();
        } else {
            n6 = n2 + (n3 - 1) * n - n8;
            n5 = n6 + n - 1;
        }
        RuntimeCostAccounter.recordJump();
        if (n6 < 0) {
            n6 = 0;
        }
        RuntimeCostAccounter.recordJump();
        if (n5 < 0) {
            return ZERO;
        }
        int n9 = n5 - n6 + 1;
        RuntimeCostAccounter.recordJump();
        if (n9 <= 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (n6 == 0) {
            RuntimeCostAccounter.recordJump();
            if (n9 >= n7) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
                return this.abs();
            }
        }
        int n10 = n9;
        RuntimeCostAccounter.recordArrayAllocation((int)n10, (int)4);
        int[] nArray = new int[n10];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.mag, n6, nArray, 0, n9);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        int[] nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray2, 1);
    }

    private BigInteger exactDivideBy3() {
        int n;
        int n2 = n = this.mag.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)4);
        int[] nArray = new int[n2];
        long l = 0L;
        int n3 = n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) break;
            long l2 = (long)this.mag[n3] & 0xFFFFFFFFL;
            long l3 = l2 - l;
            RuntimeCostAccounter.recordJump();
            if (l > l2) {
                l = 1L;
                RuntimeCostAccounter.recordJump();
            } else {
                l = 0L;
            }
            long l4 = l3 * 0xAAAAAAABL & 0xFFFFFFFFL;
            nArray[n3] = (int)l4;
            RuntimeCostAccounter.recordJump();
            if (l4 >= 0x55555556L) {
                ++l;
                RuntimeCostAccounter.recordJump();
                if (l4 >= 0xAAAAAAABL) {
                    ++l;
                }
            }
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        nArray = BigInteger.trustedStripLeadingZeroInts(nArray);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray, this.signum);
    }

    private BigInteger getLower(int n) {
        int n2 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n2 <= n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
            return this.abs();
        }
        int n3 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        int[] nArray = new int[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.mag, n2 - n, nArray, 0, n);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        int[] nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray2, 1);
    }

    private BigInteger getUpper(int n) {
        int n2;
        int n3 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n3 <= n) {
            return ZERO;
        }
        int n4 = n2 = n3 - n;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.mag, 0, nArray, 0, n2);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
        int[] nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray2, 1);
    }

    private BigInteger square() {
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return ZERO;
        }
        int n = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n < 128) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.squareToLen:([II[I)[I");
            int[] nArray = BigInteger.squareToLen(this.mag, n, null);
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.trustedStripLeadingZeroInts:([I)[I");
            int[] nArray2 = BigInteger.trustedStripLeadingZeroInts(nArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray2, 1);
        }
        RuntimeCostAccounter.recordJump();
        if (n < 216) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.squareKaratsuba:()Ljava/math/BigInteger;");
            return this.squareKaratsuba();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.squareToomCook3:()Ljava/math/BigInteger;");
        return this.squareToomCook3();
    }

    private static final int[] squareToLen(int[] nArray, int n, int[] nArray2) {
        int n2;
        block5: {
            block4: {
                n2 = n << 1;
                RuntimeCostAccounter.recordJump();
                if (nArray2 == null) break block4;
                int n3 = nArray2.length;
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break block5;
            }
            int n4 = n2;
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
            nArray2 = new int[n4];
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 >= n) break;
            long l = (long)nArray[n6] & 0xFFFFFFFFL;
            long l2 = l * l;
            nArray2[n7++] = n5 << 31 | (int)(l2 >>> 33);
            nArray2[n7++] = (int)(l2 >>> 1);
            n5 = (int)l2;
            ++n6;
            RuntimeCostAccounter.recordJump();
        }
        n6 = n;
        n7 = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 <= 0) break;
            int n8 = nArray[n6 - 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mulAdd:([I[IIII)I");
            n8 = BigInteger.mulAdd(nArray2, nArray, n7, n6 - 1, n8);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.addOne:([IIII)I");
            BigInteger.addOne(nArray2, n7 - 1, n6, n8);
            --n6;
            n7 += 2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primitiveLeftShift:([III)V");
        BigInteger.primitiveLeftShift(nArray2, n2, 1);
        int n9 = n2 - 1;
        nArray2[n9] = nArray2[n9] | nArray[n - 1] & 1;
        return nArray2;
    }

    private BigInteger squareKaratsuba() {
        int n = (this.mag.length + 1) / 2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLower:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger = this.getLower(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getUpper:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = this.getUpper(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger3 = bigInteger2.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger4 = bigInteger.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger5 = bigInteger3.shiftLeft(n * 32);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger6 = bigInteger.add(bigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger7 = bigInteger6.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger8 = bigInteger3.add(bigInteger4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger9 = bigInteger7.subtract(bigInteger8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger10 = bigInteger5.add(bigInteger9);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger11 = bigInteger10.shiftLeft(n * 32);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        return bigInteger11.add(bigInteger4);
    }

    private BigInteger squareToomCook3() {
        int n = this.mag.length;
        int n2 = (n + 2) / 3;
        int n3 = n - 2 * n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger = this.getToomSlice(n2, n3, 0, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = this.getToomSlice(n2, n3, 1, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getToomSlice:(IIII)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = this.getToomSlice(n2, n3, 2, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger4 = bigInteger3.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger5 = bigInteger.add(bigInteger3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger6 = bigInteger5.subtract(bigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger7 = bigInteger6.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger5 = bigInteger5.add(bigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger8 = bigInteger5.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger9 = bigInteger.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger10 = bigInteger5.add(bigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger11 = bigInteger10.shiftLeft(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger12 = bigInteger11.subtract(bigInteger3);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
        BigInteger bigInteger13 = bigInteger12.square();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger14 = bigInteger13.subtract(bigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.exactDivideBy3:()Ljava/math/BigInteger;");
        BigInteger bigInteger15 = bigInteger14.exactDivideBy3();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger16 = bigInteger8.subtract(bigInteger7);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger17 = bigInteger16.shiftRight(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger18 = bigInteger8.subtract(bigInteger4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger19 = bigInteger15.subtract(bigInteger18);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
        bigInteger15 = bigInteger19.shiftRight(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger20 = bigInteger18.subtract(bigInteger17);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger18 = bigInteger20.subtract(bigInteger9);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger21 = bigInteger9.shiftLeft(1);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger15 = bigInteger15.subtract(bigInteger21);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subtract:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigInteger17 = bigInteger17.subtract(bigInteger15);
        int n4 = n2 * 32;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger22 = bigInteger9.shiftLeft(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger23 = bigInteger22.add(bigInteger15);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger24 = bigInteger23.shiftLeft(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger25 = bigInteger24.add(bigInteger18);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger26 = bigInteger25.shiftLeft(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger27 = bigInteger26.add(bigInteger17);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger28 = bigInteger27.shiftLeft(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        return bigInteger28.add(bigInteger4);
    }

    public BigInteger divide(BigInteger bigInteger) {
        block3: {
            block2: {
                int n = bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n < 80) break block2;
                int n2 = this.mag.length - bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= 40) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideKnuth:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            return this.divideKnuth(bigInteger);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideBurnikelZiegler:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        return this.divideBurnikelZiegler(bigInteger);
    }

    private BigInteger divideKnuth(BigInteger bigInteger) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(this.mag);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        int[] nArray = bigInteger.mag;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;Z)Ljava/math/MutableBigInteger;");
        mutableBigInteger2.divideKnuth(mutableBigInteger3, mutableBigInteger, false);
        int n = this.signum * bigInteger.signum;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        return mutableBigInteger.toBigInteger(n);
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        block3: {
            block2: {
                int n = bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n < 80) break block2;
                int n2 = this.mag.length - bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= 40) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideAndRemainderKnuth:(Ljava/math/BigInteger;)[Ljava/math/BigInteger;");
            return this.divideAndRemainderKnuth(bigInteger);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideAndRemainderBurnikelZiegler:(Ljava/math/BigInteger;)[Ljava/math/BigInteger;");
        return this.divideAndRemainderBurnikelZiegler(bigInteger);
    }

    private BigInteger[] divideAndRemainderKnuth(BigInteger bigInteger) {
        int n;
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(this.mag);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        int[] nArray = bigInteger.mag;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divideKnuth(mutableBigInteger3, mutableBigInteger);
        int n2 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (this.signum == n2) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        bigIntegerArray[0] = mutableBigInteger.toBigInteger(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        bigIntegerArray[1] = mutableBigInteger4.toBigInteger(this.signum);
        return bigIntegerArray;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        block3: {
            block2: {
                int n = bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n < 80) break block2;
                int n2 = this.mag.length - bigInteger.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= 40) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.remainderKnuth:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            return this.remainderKnuth(bigInteger);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.remainderBurnikelZiegler:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        return this.remainderBurnikelZiegler(bigInteger);
    }

    private BigInteger remainderKnuth(BigInteger bigInteger) {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(this.mag);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        int[] nArray = bigInteger.mag;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideKnuth:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divideKnuth(mutableBigInteger3, mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        return mutableBigInteger4.toBigInteger(this.signum);
    }

    private BigInteger divideBurnikelZiegler(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideAndRemainderBurnikelZiegler:(Ljava/math/BigInteger;)[Ljava/math/BigInteger;");
        return this.divideAndRemainderBurnikelZiegler(bigInteger)[0];
    }

    private BigInteger remainderBurnikelZiegler(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideAndRemainderBurnikelZiegler:(Ljava/math/BigInteger;)[Ljava/math/BigInteger;");
        return this.divideAndRemainderBurnikelZiegler(bigInteger)[1];
    }

    private BigInteger[] divideAndRemainderBurnikelZiegler(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(this);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(bigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divideAndRemainderBurnikelZiegler:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divideAndRemainderBurnikelZiegler(mutableBigInteger3, mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl = mutableBigInteger.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            bigInteger3 = ZERO;
            RuntimeCostAccounter.recordJump();
        } else {
            int n = this.signum * bigInteger.signum;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
            bigInteger3 = mutableBigInteger.toBigInteger(n);
        }
        BigInteger bigInteger4 = bigInteger3;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.isZero:()Z");
        boolean bl2 = mutableBigInteger4.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            bigInteger2 = ZERO;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
            bigInteger2 = mutableBigInteger4.toBigInteger(this.signum);
        }
        BigInteger bigInteger5 = bigInteger2;
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        return new BigInteger[]{bigInteger4, bigInteger5};
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger pow(int var1_1) {
        block24: {
            RuntimeCostAccounter.recordJump();
            if (var1_1 < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                v0 = new ArithmeticException("Negative exponent");
                RuntimeCostAccounter.recordThrow();
                throw v0;
            }
            RuntimeCostAccounter.recordJump();
            if (this.signum == 0) {
                RuntimeCostAccounter.recordJump();
                if (var1_1 == 0) {
                    v1 = BigInteger.ONE;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v1 = this;
                }
                return v1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
            var2_2 = this.abs();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLowestSetBit:()I");
            var3_3 = var2_2.getLowestSetBit();
            var4_4 = (long)var3_3 * (long)var1_1;
            RuntimeCostAccounter.recordJump();
            if (var4_4 > 0x7FFFFFFFL) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.reportOverflow:()V");
                BigInteger.reportOverflow();
            }
            RuntimeCostAccounter.recordJump();
            if (var3_3 > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
                var2_2 = var2_2.shiftRight(var3_3);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                var6_5 = var2_2.bitLength();
                RuntimeCostAccounter.recordJump();
                if (var6_5 == 1) {
                    RuntimeCostAccounter.recordJump();
                    if (this.signum < 0) {
                        RuntimeCostAccounter.recordJump();
                        if ((var1_1 & 1) == 1) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
                            return BigInteger.NEGATIVE_ONE.shiftLeft(var3_3 * var1_1);
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
                    return BigInteger.ONE.shiftLeft(var3_3 * var1_1);
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                var6_5 = var2_2.bitLength();
                RuntimeCostAccounter.recordJump();
                if (var6_5 == 1) {
                    RuntimeCostAccounter.recordJump();
                    if (this.signum < 0) {
                        RuntimeCostAccounter.recordJump();
                        if ((var1_1 & 1) == 1) {
                            return BigInteger.NEGATIVE_ONE;
                        }
                    }
                    return BigInteger.ONE;
                }
            }
            var7_6 = (long)var6_5 * (long)var1_1;
            v2 = var2_2.mag.length;
            RuntimeCostAccounter.recordJump();
            if (v2 != 1) break block24;
            RuntimeCostAccounter.recordJump();
            if (var7_6 > 62L) break block24;
            RuntimeCostAccounter.recordJump();
            if (this.signum >= 0) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if ((var1_1 & 1) == 1) {
                v3 = -1;
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                v3 = 1;
            }
            var9_7 = v3;
            var10_9 = 1L;
            var12_10 = (long)var2_2.mag[0] & 0xFFFFFFFFL;
            var14_11 = var1_1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var14_11 == 0) break;
                RuntimeCostAccounter.recordJump();
                if ((var14_11 & 1) == 1) {
                    var10_9 *= var12_10;
                }
                RuntimeCostAccounter.recordJump();
                if ((var14_11 >>>= 1) == 0) continue;
                var12_10 *= var12_10;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (var3_3 > 0) {
                RuntimeCostAccounter.recordJump();
                if (var4_4 + var7_6 <= 62L) {
                    v4 = (var10_9 << (int)var4_4) * (long)var9_7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
                    return BigInteger.valueOf(v4);
                }
                v5 = var10_9 * (long)var9_7;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
                v6 = BigInteger.valueOf(v5);
                v7 = (int)var4_4;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
                return v6.shiftLeft(v7);
            }
            v8 = var10_9 * (long)var9_7;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
            return BigInteger.valueOf(v8);
        }
        var9_8 = BigInteger.ONE;
        var15_12 = var1_1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (var15_12 == 0) break;
            RuntimeCostAccounter.recordJump();
            if ((var15_12 & 1) == 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                var9_8 = var9_8.multiply(var2_2);
            }
            RuntimeCostAccounter.recordJump();
            if ((var15_12 >>>= 1) == 0) continue;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
            var2_2 = var2_2.square();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (var3_3 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
            var9_8 = var9_8.shiftLeft(var3_3 * var1_1);
        }
        RuntimeCostAccounter.recordJump();
        if (this.signum < 0) {
            RuntimeCostAccounter.recordJump();
            if ((var1_1 & 1) == 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
                return var9_8.negate();
            }
        }
        return var9_8;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        int n = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
            return this.abs();
        }
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
            return bigInteger.abs();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger(this);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.hybridGCD:(Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger3 = mutableBigInteger.hybridGCD(mutableBigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        return mutableBigInteger3.toBigInteger(1);
    }

    static int bitLengthForInt(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
        return 32 - Integer.numberOfLeadingZeros(n);
    }

    private static int[] leftShift(int[] nArray, int n, int n2) {
        int n3 = n2 >>> 5;
        int n4 = n2 & 0x1F;
        int n5 = nArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
        int n6 = BigInteger.bitLengthForInt(n5);
        RuntimeCostAccounter.recordJump();
        if (n2 <= 32 - n6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primitiveLeftShift:([III)V");
            BigInteger.primitiveLeftShift(nArray, n, n4);
            return nArray;
        }
        RuntimeCostAccounter.recordJump();
        if (n4 <= 32 - n6) {
            int n7 = n3 + n;
            RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)4);
            int[] nArray2 = new int[n7];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(nArray, 0, nArray2, 0, n);
            int n8 = nArray2.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primitiveLeftShift:([III)V");
            BigInteger.primitiveLeftShift(nArray2, n8, n4);
            return nArray2;
        }
        int n9 = n3 + n + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n9, (int)4);
        int[] nArray3 = new int[n9];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(nArray, 0, nArray3, 0, n);
        int n10 = nArray3.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primitiveRightShift:([III)V");
        BigInteger.primitiveRightShift(nArray3, n10, 32 - n4);
        return nArray3;
    }

    static void primitiveRightShift(int[] nArray, int n, int n2) {
        int n3 = 32 - n2;
        int n4 = n - 1;
        int n5 = nArray[n4];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 <= 0) break;
            int n6 = n5;
            n5 = nArray[n4 - 1];
            nArray[n4] = n5 << n3 | n6 >>> n2;
            --n4;
            RuntimeCostAccounter.recordJump();
        }
        nArray[0] = nArray[0] >>> n2;
    }

    static void primitiveLeftShift(int[] nArray, int n, int n2) {
        block4: {
            block3: {
                RuntimeCostAccounter.recordJump();
                if (n == 0) break block3;
                RuntimeCostAccounter.recordJump();
                if (n2 != 0) break block4;
            }
            return;
        }
        int n3 = 32 - n2;
        int n4 = 0;
        int n5 = nArray[n4];
        int n6 = n4 + n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n6) break;
            int n7 = n5;
            n5 = nArray[n4 + 1];
            nArray[n4] = n7 << n2 | n5 >>> n3;
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        int n8 = n - 1;
        nArray[n8] = nArray[n8] << n2;
    }

    private static int bitLength(int[] nArray, int n) {
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return 0;
        }
        int n2 = nArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
        return (n - 1 << 5) + BigInteger.bitLengthForInt(n2);
    }

    public BigInteger abs() {
        BigInteger bigInteger;
        RuntimeCostAccounter.recordJump();
        if (this.signum >= 0) {
            bigInteger = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
            bigInteger = this.negate();
        }
        return bigInteger;
    }

    public BigInteger negate() {
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        int n = -this.signum;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(this.mag, n);
    }

    public int signum() {
        return this.signum;
    }

    public BigInteger mod(BigInteger bigInteger) {
        BigInteger bigInteger2;
        int n = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("BigInteger: modulus not positive");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.remainder:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = this.remainder(bigInteger);
        int n2 = bigInteger3.signum;
        RuntimeCostAccounter.recordJump();
        if (n2 >= 0) {
            bigInteger2 = bigInteger3;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            bigInteger2 = bigInteger3.add(bigInteger);
        }
        return bigInteger2;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger modPow(BigInteger var1_1, BigInteger var2_2) {
        block27: {
            block26: {
                v0 = var2_2.signum;
                RuntimeCostAccounter.recordJump();
                if (v0 <= 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                    v1 = new ArithmeticException("BigInteger: modulus not positive");
                    RuntimeCostAccounter.recordThrow();
                    throw v1;
                }
                v2 = var1_1.signum;
                RuntimeCostAccounter.recordJump();
                if (v2 == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                    v3 = var2_2.equals(BigInteger.ONE);
                    RuntimeCostAccounter.recordJump();
                    if (v3) {
                        v4 = BigInteger.ZERO;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        v4 = BigInteger.ONE;
                    }
                    return v4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                v5 = this.equals(BigInteger.ONE);
                RuntimeCostAccounter.recordJump();
                if (v5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                    v6 = var2_2.equals(BigInteger.ONE);
                    RuntimeCostAccounter.recordJump();
                    if (v6) {
                        v7 = BigInteger.ZERO;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        v7 = BigInteger.ONE;
                    }
                    return v7;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                v8 = this.equals(BigInteger.ZERO);
                RuntimeCostAccounter.recordJump();
                if (v8) {
                    v9 = var1_1.signum;
                    RuntimeCostAccounter.recordJump();
                    if (v9 >= 0) {
                        return BigInteger.ZERO;
                    }
                }
                v10 = BigInteger.negConst[1];
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                v11 = this.equals(v10);
                RuntimeCostAccounter.recordJump();
                if (v11) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
                    v12 = var1_1.testBit(0);
                    RuntimeCostAccounter.recordJump();
                    if (!v12) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                        v13 = var2_2.equals(BigInteger.ONE);
                        RuntimeCostAccounter.recordJump();
                        if (v13) {
                            v14 = BigInteger.ZERO;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v14 = BigInteger.ONE;
                        }
                        return v14;
                    }
                }
                v15 = var1_1.signum;
                RuntimeCostAccounter.recordJump();
                if (v15 < 0) {
                    v16 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v16 = false;
                }
                var3_3 = v16;
                RuntimeCostAccounter.recordJump();
                if (v16) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
                    var1_1 = var1_1.negate();
                }
                RuntimeCostAccounter.recordJump();
                if (this.signum < 0) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareTo:(Ljava/math/BigInteger;)I");
                v17 = this.compareTo(var2_2);
                RuntimeCostAccounter.recordJump();
                if (v17 >= 0) lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                    v18 = this.mod(var2_2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    v18 = this;
                }
                var4_4 = v18;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
                v19 = var2_2.testBit(0);
                RuntimeCostAccounter.recordJump();
                if (!v19) break block26;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.oddModPow:(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                var5_5 = var4_4.oddModPow(var1_1, var2_2);
                RuntimeCostAccounter.recordJump();
                break block27;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLowestSetBit:()I");
            var6_6 = var2_2.getLowestSetBit();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRight:(I)Ljava/math/BigInteger;");
            var7_7 = var2_2.shiftRight(var6_6);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:(I)Ljava/math/BigInteger;");
            var8_8 = BigInteger.ONE.shiftLeft(var6_6);
            RuntimeCostAccounter.recordJump();
            if (this.signum < 0) ** GOTO lbl-1000
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareTo:(Ljava/math/BigInteger;)I");
            v20 = this.compareTo(var7_7);
            RuntimeCostAccounter.recordJump();
            if (v20 >= 0) lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v21 = this.mod(var7_7);
                RuntimeCostAccounter.recordJump();
            } else {
                v21 = this;
            }
            var9_9 = v21;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
            v22 = var7_7.equals(BigInteger.ONE);
            RuntimeCostAccounter.recordJump();
            if (v22) {
                v23 = BigInteger.ZERO;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.oddModPow:(Ljava/math/BigInteger;Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v23 = var9_9.oddModPow(var1_1, var7_7);
            }
            var10_10 = v23;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.modPow2:(Ljava/math/BigInteger;I)Ljava/math/BigInteger;");
            var11_11 = var4_4.modPow2(var1_1, var6_6);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.modInverse:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            var12_12 = var8_8.modInverse(var7_7);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.modInverse:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            var13_13 = var7_7.modInverse(var8_8);
            v24 = var2_2.mag.length;
            RuntimeCostAccounter.recordJump();
            if (v24 < 0x2000000) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v25 = var10_10.multiply(var8_8);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v26 = v25.multiply(var12_12);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v27 = var11_11.multiply(var7_7);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v28 = v27.multiply(var13_13);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v29 = v26.add(v28);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                var5_5 = v29.mod(var2_2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
                var14_14 = new MutableBigInteger();
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v30 = var10_10.multiply(var8_8);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
                v31 = new MutableBigInteger(v30);
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
                v32 = new MutableBigInteger(var12_12);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
                v31.multiply(v32, var14_14);
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
                var15_15 = new MutableBigInteger();
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                v33 = var11_11.multiply(var7_7);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
                v34 = new MutableBigInteger(v33);
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
                v35 = new MutableBigInteger(var13_13);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.multiply:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)V");
                v34.multiply(v35, var15_15);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.add:(Ljava/math/MutableBigInteger;)V");
                var14_14.add(var15_15);
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
                var16_16 = new MutableBigInteger();
                RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
                v36 = new MutableBigInteger(var2_2);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
                v37 = var14_14.divide(v36, var16_16);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:()Ljava/math/BigInteger;");
                var5_5 = v37.toBigInteger();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (var3_3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.modInverse:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            v38 = var5_5.modInverse(var2_2);
            RuntimeCostAccounter.recordJump();
        } else {
            v38 = var5_5;
        }
        return v38;
    }

    private BigInteger oddModPow(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        int[] nArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        block27: {
            block26: {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                boolean bl = bigInteger.equals(ONE);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return this;
                }
                RuntimeCostAccounter.recordJump();
                if (this.signum == 0) {
                    return ZERO;
                }
                RuntimeCostAccounter.recordMethodCall((String)"[I.clone:()Ljava/lang/Object;");
                nArray4 = (int[])this.mag.clone();
                nArray3 = bigInteger.mag;
                nArray2 = bigInteger2.mag;
                n5 = nArray2.length;
                n4 = 0;
                int n6 = nArray3.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:([II)I");
                n3 = BigInteger.bitLength(nArray3, n6);
                RuntimeCostAccounter.recordJump();
                if (n3 != 17) break block26;
                int n7 = nArray3[0];
                RuntimeCostAccounter.recordJump();
                if (n7 == 65537) break block27;
            }
            while (true) {
                int n8 = bnExpModThreshTable[n4];
                RuntimeCostAccounter.recordJump();
                if (n3 <= n8) break;
                ++n4;
                RuntimeCostAccounter.recordJump();
            }
        }
        int n9 = n2 = 1 << n4;
        RuntimeCostAccounter.recordArrayAllocation((int)n9, (int)8);
        int[][] nArrayArray = new int[n9][];
        int n10 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n10 >= n2) break;
            int n11 = n5;
            RuntimeCostAccounter.recordArrayAllocation((int)n11, (int)4);
            nArrayArray[n10] = new int[n11];
            ++n10;
            RuntimeCostAccounter.recordJump();
        }
        int n12 = nArray2[n5 - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.inverseMod32:(I)I");
        n10 = -MutableBigInteger.inverseMod32(n12);
        int n13 = nArray4.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.leftShift:([III)[I");
        int[] nArray5 = BigInteger.leftShift(nArray4, n13, n5 << 5);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(nArray5);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toIntArray:()[I");
        nArrayArray[0] = mutableBigInteger4.toIntArray();
        int n14 = nArrayArray[0].length;
        RuntimeCostAccounter.recordJump();
        if (n14 < n5) {
            int n15 = n5 - nArrayArray[0].length;
            int n16 = n5;
            RuntimeCostAccounter.recordArrayAllocation((int)n16, (int)4);
            nArray = new int[n16];
            n = 0;
            while (true) {
                int n17 = nArrayArray[0].length;
                RuntimeCostAccounter.recordJump();
                if (n >= n17) break;
                nArray[n + n15] = nArrayArray[0][n];
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            nArrayArray[0] = nArray;
        }
        int[] nArray6 = nArrayArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.squareToLen:([II[I)[I");
        int[] nArray7 = BigInteger.squareToLen(nArray6, n5, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.montReduce:([I[III)[I");
        nArray7 = BigInteger.montReduce(nArray7, nArray2, n5, n10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([II)[I");
        nArray = Arrays.copyOf(nArray7, n5);
        n = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            int[] nArray8 = nArrayArray[n - 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyToLen:([II[II[I)[I");
            int[] nArray9 = this.multiplyToLen(nArray, n5, nArray8, n5, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.montReduce:([I[III)[I");
            nArrayArray[n] = BigInteger.montReduce(nArray9, nArray2, n5, n10);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        n = 1 << (n3 - 1 & 0x1F);
        int n18 = 0;
        int n19 = nArray3.length;
        int n20 = 0;
        int n21 = 0;
        while (true) {
            int n22;
            RuntimeCostAccounter.recordJump();
            if (n21 > n4) break;
            int n23 = nArray3[n20] & n;
            RuntimeCostAccounter.recordJump();
            if (n23 != 0) {
                n22 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n22 = 0;
            }
            n18 = n18 << 1 | n22;
            RuntimeCostAccounter.recordJump();
            if ((n >>>= 1) == 0) {
                ++n20;
                n = Integer.MIN_VALUE;
                --n19;
            }
            ++n21;
            RuntimeCostAccounter.recordJump();
        }
        n21 = n3--;
        boolean bl = true;
        n21 = n3 - n4;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if ((n18 & 1) != 0) break;
            n18 >>>= 1;
            ++n21;
            RuntimeCostAccounter.recordJump();
        }
        int[] nArray10 = nArrayArray[n18 >>> 1];
        n18 = 0;
        RuntimeCostAccounter.recordJump();
        if (n21 == n3) {
            bl = false;
        }
        while (true) {
            --n3;
            n18 <<= 1;
            RuntimeCostAccounter.recordJump();
            if (n19 != 0) {
                int n24;
                int n25 = nArray3[n20] & n;
                RuntimeCostAccounter.recordJump();
                if (n25 != 0) {
                    n24 = 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n24 = 0;
                }
                n18 |= n24;
                RuntimeCostAccounter.recordJump();
                if ((n >>>= 1) == 0) {
                    ++n20;
                    n = Integer.MIN_VALUE;
                    --n19;
                }
            }
            RuntimeCostAccounter.recordJump();
            if ((n18 & n2) != 0) {
                n21 = n3 - n4;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if ((n18 & 1) != 0) break;
                    n18 >>>= 1;
                    ++n21;
                    RuntimeCostAccounter.recordJump();
                }
                nArray10 = nArrayArray[n18 >>> 1];
                n18 = 0;
            }
            RuntimeCostAccounter.recordJump();
            if (n3 == n21) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"[I.clone:()Ljava/lang/Object;");
                    nArray7 = (int[])nArray10.clone();
                    bl = false;
                    RuntimeCostAccounter.recordJump();
                } else {
                    nArray = nArray7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiplyToLen:([II[II[I)[I");
                    nArray5 = this.multiplyToLen(nArray, n5, nArray10, n5, nArray5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.montReduce:([I[III)[I");
                    nArray5 = BigInteger.montReduce(nArray5, nArray2, n5, n10);
                    nArray = nArray5;
                    nArray5 = nArray7;
                    nArray7 = nArray;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n3 == 0) break;
            RuntimeCostAccounter.recordJump();
            if (bl) continue;
            nArray = nArray7;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.squareToLen:([II[I)[I");
            nArray5 = BigInteger.squareToLen(nArray, n5, nArray5);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.montReduce:([I[III)[I");
            nArray5 = BigInteger.montReduce(nArray5, nArray2, n5, n10);
            nArray = nArray5;
            nArray5 = nArray7;
            nArray7 = nArray;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        int n26 = 2 * n5;
        RuntimeCostAccounter.recordArrayAllocation((int)n26, (int)4);
        int[] nArray11 = new int[n26];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(nArray7, 0, nArray11, n5, n5);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.montReduce:([I[III)[I");
        nArray7 = BigInteger.montReduce(nArray11, nArray2, n5, n10);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([II)[I");
        nArray11 = Arrays.copyOf(nArray7, n5);
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(I[I)V");
        return new BigInteger(1, nArray11);
    }

    private static int[] montReduce(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        do {
            int n6 = nArray[nArray.length - 1 - n5];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mulAdd:([I[IIII)I");
            int n7 = BigInteger.mulAdd(nArray, nArray2, n5, n, n2 * n6);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.addOne:([IIII)I");
            n3 += BigInteger.addOne(nArray, n5, n, n7);
            ++n5;
            RuntimeCostAccounter.recordJump();
        } while (--n4 > 0);
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subN:([I[II)I");
            n3 += BigInteger.subN(nArray, nArray2, n);
            RuntimeCostAccounter.recordJump();
        }
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intArrayCmpToLen:([I[II)I");
            int n8 = BigInteger.intArrayCmpToLen(nArray, nArray2, n);
            RuntimeCostAccounter.recordJump();
            if (n8 < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.subN:([I[II)I");
            BigInteger.subN(nArray, nArray2, n);
            RuntimeCostAccounter.recordJump();
        }
        return nArray;
    }

    private static int intArrayCmpToLen(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            long l = (long)nArray[n2] & 0xFFFFFFFFL;
            long l2 = (long)nArray2[n2] & 0xFFFFFFFFL;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (l > l2) {
                return 1;
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return 0;
    }

    private static int subN(int[] nArray, int[] nArray2, int n) {
        long l = 0L;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (--n < 0) break;
            l = ((long)nArray[n] & 0xFFFFFFFFL) - ((long)nArray2[n] & 0xFFFFFFFFL) + (l >> 32);
            nArray[n] = (int)l;
            RuntimeCostAccounter.recordJump();
        }
        return (int)(l >> 32);
    }

    static int mulAdd(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        long l = (long)n3 & 0xFFFFFFFFL;
        long l2 = 0L;
        n = nArray.length - n - 1;
        int n4 = n2 - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 < 0) break;
            long l3 = ((long)nArray2[n4] & 0xFFFFFFFFL) * l + ((long)nArray[n] & 0xFFFFFFFFL) + l2;
            nArray[n--] = (int)l3;
            l2 = l3 >>> 32;
            --n4;
            RuntimeCostAccounter.recordJump();
        }
        return (int)l2;
    }

    static int addOne(int[] nArray, int n, int n2, int n3) {
        block3: {
            int n4;
            n = nArray.length - 1 - n2 - n;
            long l = ((long)nArray[n] & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL);
            nArray[n] = (int)l;
            RuntimeCostAccounter.recordJump();
            if (l >>> 32 == 0L) {
                return 0;
            }
            do {
                RuntimeCostAccounter.recordJump();
                if (--n2 < 0) break block3;
                RuntimeCostAccounter.recordJump();
                if (--n < 0) {
                    return 1;
                }
                int n5 = n;
                nArray[n5] = nArray[n5] + 1;
                n4 = nArray[n];
                RuntimeCostAccounter.recordJump();
            } while (n4 == 0);
            return 0;
        }
        return 1;
    }

    private BigInteger modPow2(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = ONE;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod2:(I)Ljava/math/BigInteger;");
        BigInteger bigInteger3 = this.mod2(n);
        int n2 = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n3 = bigInteger.bitLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
        boolean bl = this.testBit(0);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            int n4;
            RuntimeCostAccounter.recordJump();
            if (n - 1 < n3) {
                n4 = n - 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n4 = n3;
            }
            n3 = n4;
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
            boolean bl2 = bigInteger.testBit(n2);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                BigInteger bigInteger4 = bigInteger2.multiply(bigInteger3);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod2:(I)Ljava/math/BigInteger;");
                bigInteger2 = bigInteger4.mod2(n);
            }
            RuntimeCostAccounter.recordJump();
            if (++n2 >= n3) continue;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.square:()Ljava/math/BigInteger;");
            BigInteger bigInteger5 = bigInteger3.square();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod2:(I)Ljava/math/BigInteger;");
            bigInteger3 = bigInteger5.mod2(n);
            RuntimeCostAccounter.recordJump();
        }
        return bigInteger2;
    }

    private BigInteger mod2(int n) {
        BigInteger bigInteger;
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n3 = this.bitLength();
        RuntimeCostAccounter.recordJump();
        if (n3 <= n) {
            return this;
        }
        int n4 = n2 = n + 31 >>> 5;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        int n5 = this.mag.length - n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.mag, n5, nArray, 0, n2);
        int n6 = (n2 << 5) - n;
        nArray[0] = (int)((long)nArray[0] & (1L << 32 - n6) - 1L);
        int n7 = nArray[0];
        RuntimeCostAccounter.recordJump();
        if (n7 == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:(I[I)V");
            bigInteger = new BigInteger(1, nArray);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            bigInteger = new BigInteger(nArray, 1);
        }
        return bigInteger;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        BigInteger bigInteger2;
        block7: {
            block6: {
                int n = bigInteger.signum;
                RuntimeCostAccounter.recordJump();
                if (n != 1) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                    ArithmeticException arithmeticException = new ArithmeticException("BigInteger: modulus not positive");
                    RuntimeCostAccounter.recordThrow();
                    throw arithmeticException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                boolean bl = bigInteger.equals(ONE);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return ZERO;
                }
                bigInteger2 = this;
                RuntimeCostAccounter.recordJump();
                if (this.signum < 0) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareMagnitude:(Ljava/math/BigInteger;)I");
                int n2 = this.compareMagnitude(bigInteger);
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block7;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.mod:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
            bigInteger2 = this.mod(bigInteger);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
        boolean bl = bigInteger2.equals(ONE);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return ONE;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger = new MutableBigInteger(bigInteger2);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:(Ljava/math/BigInteger;)V");
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.mutableModInverse:(Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
        MutableBigInteger mutableBigInteger3 = mutableBigInteger.mutableModInverse(mutableBigInteger2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
        return mutableBigInteger3.toBigInteger(1);
    }

    public BigInteger shiftLeft(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:([II)[I");
            int[] nArray = BigInteger.shiftLeft(this.mag, n);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            return new BigInteger(nArray, this.signum);
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return this;
        }
        int n2 = -n;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRightImpl:(I)Ljava/math/BigInteger;");
        return this.shiftRightImpl(n2);
    }

    private static int[] shiftLeft(int[] nArray, int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = nArray.length;
        int[] nArray2 = null;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            int n5 = n4 + n2;
            RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
            nArray2 = new int[n5];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            RuntimeCostAccounter.recordJump();
        } else {
            int n6 = 0;
            int n7 = 32 - n3;
            int n8 = nArray[0] >>> n7;
            RuntimeCostAccounter.recordJump();
            if (n8 != 0) {
                int n9 = n4 + n2 + 1;
                RuntimeCostAccounter.recordArrayAllocation((int)n9, (int)4);
                nArray2 = new int[n9];
                nArray2[n6++] = n8;
                RuntimeCostAccounter.recordJump();
            } else {
                int n10 = n4 + n2;
                RuntimeCostAccounter.recordArrayAllocation((int)n10, (int)4);
                nArray2 = new int[n10];
            }
            int n11 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n11 >= n4 - 1) break;
                nArray2[n6++] = nArray[n11++] << n3 | nArray[n11] >>> n7;
                RuntimeCostAccounter.recordJump();
            }
            nArray2[n6] = nArray[n11] << n3;
        }
        return nArray2;
    }

    public BigInteger shiftRight(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return ZERO;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftRightImpl:(I)Ljava/math/BigInteger;");
            return this.shiftRightImpl(n);
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return this;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        int n2 = -n;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shiftLeft:([II)[I");
        int[] nArray = BigInteger.shiftLeft(this.mag, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray, this.signum);
    }

    private BigInteger shiftRightImpl(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n >>> 5;
        int n6 = n & 0x1F;
        int n7 = this.mag.length;
        int[] nArray = null;
        RuntimeCostAccounter.recordJump();
        if (n5 >= n7) {
            BigInteger bigInteger;
            RuntimeCostAccounter.recordJump();
            if (this.signum >= 0) {
                bigInteger = ZERO;
                RuntimeCostAccounter.recordJump();
            } else {
                bigInteger = negConst[1];
            }
            return bigInteger;
        }
        RuntimeCostAccounter.recordJump();
        if (n6 == 0) {
            n4 = n7 - n5;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([II)[I");
            nArray = Arrays.copyOf(this.mag, n4);
            RuntimeCostAccounter.recordJump();
        } else {
            n4 = 0;
            n3 = this.mag[0] >>> n6;
            RuntimeCostAccounter.recordJump();
            if (n3 != 0) {
                int n8 = n7 - n5;
                RuntimeCostAccounter.recordArrayAllocation((int)n8, (int)4);
                nArray = new int[n8];
                nArray[n4++] = n3;
                RuntimeCostAccounter.recordJump();
            } else {
                int n9 = n7 - n5 - 1;
                RuntimeCostAccounter.recordArrayAllocation((int)n9, (int)4);
                nArray = new int[n9];
            }
            n2 = 32 - n6;
            int n10 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n10 >= n7 - n5 - 1) break;
                nArray[n4++] = this.mag[n10++] << n2 | this.mag[n10] >>> n6;
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.signum < 0) {
            n4 = 0;
            n3 = n7 - 1;
            n2 = n7 - n5;
            while (true) {
                int n11;
                RuntimeCostAccounter.recordJump();
                if (n3 < n2) break;
                RuntimeCostAccounter.recordJump();
                if (n4 != 0) break;
                int n12 = this.mag[n3];
                RuntimeCostAccounter.recordJump();
                if (n12 != 0) {
                    n11 = 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n11 = 0;
                }
                n4 = n11;
                --n3;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (n4 == 0) {
                RuntimeCostAccounter.recordJump();
                if (n6 != 0) {
                    int n13;
                    int n14 = this.mag[n7 - n5 - 1] << 32 - n6;
                    RuntimeCostAccounter.recordJump();
                    if (n14 != 0) {
                        n13 = 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n13 = 0;
                    }
                    n4 = n13;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n4 != 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.javaIncrement:([I)[I");
                nArray = this.javaIncrement(nArray);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        return new BigInteger(nArray, this.signum);
    }

    int[] javaIncrement(int[] nArray) {
        int n = 0;
        int n2 = nArray.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 < 0) break;
            RuntimeCostAccounter.recordJump();
            if (n != 0) break;
            int n3 = n2--;
            int n4 = nArray[n3] + 1;
            nArray[n3] = n4;
            n = n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            int n5 = nArray.length + 1;
            RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)4);
            nArray = new int[n5];
            nArray[0] = 1;
        }
        return nArray;
    }

    public BigInteger and(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n2 = bigInteger.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n3 = Math.max(n, n2);
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        int[] nArray = new int[n3];
        int n4 = 0;
        while (true) {
            int n5 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            int n6 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            int n7 = this.getInt(n6);
            int n8 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n4] = n7 & bigInteger.getInt(n8);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public BigInteger or(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n2 = bigInteger.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n3 = Math.max(n, n2);
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        int[] nArray = new int[n3];
        int n4 = 0;
        while (true) {
            int n5 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            int n6 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            int n7 = this.getInt(n6);
            int n8 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n4] = n7 | bigInteger.getInt(n8);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public BigInteger xor(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n2 = bigInteger.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n3 = Math.max(n, n2);
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        int[] nArray = new int[n3];
        int n4 = 0;
        while (true) {
            int n5 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            int n6 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            int n7 = this.getInt(n6);
            int n8 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n4] = n7 ^ bigInteger.getInt(n8);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public BigInteger not() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n = this.intLength();
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
        int[] nArray = new int[n];
        int n2 = 0;
        while (true) {
            int n3 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            int n4 = nArray.length - n2 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n2] = ~this.getInt(n4);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n2 = bigInteger.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n3 = Math.max(n, n2);
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)4);
        int[] nArray = new int[n3];
        int n4 = 0;
        while (true) {
            int n5 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            int n6 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            int n7 = this.getInt(n6);
            int n8 = nArray.length - n4 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n4] = n7 & ~bigInteger.getInt(n8);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public boolean testBit(int n) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Negative bit address");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
        int n2 = this.getInt(n >>> 5) & 1 << (n & 0x1F);
        RuntimeCostAccounter.recordJump();
        if (n2 != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public BigInteger setBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Negative bit address");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        int n2 = n >>> 5;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n3 = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n4 = Math.max(n3, n2 + 2);
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        int n5 = 0;
        while (true) {
            int n6 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n6) break;
            int n7 = nArray.length - n5 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n7] = this.getInt(n5);
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        int n8 = nArray.length - n2 - 1;
        nArray[n8] = nArray[n8] | 1 << (n & 0x1F);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public BigInteger clearBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Negative bit address");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        int n2 = n >>> 5;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n3 = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n4 = Math.max(n3, (n + 1 >>> 5) + 1);
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        int n5 = 0;
        while (true) {
            int n6 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n6) break;
            int n7 = nArray.length - n5 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n7] = this.getInt(n5);
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        int n8 = nArray.length - n2 - 1;
        nArray[n8] = nArray[n8] & ~(1 << (n & 0x1F));
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public BigInteger flipBit(int n) {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
            ArithmeticException arithmeticException = new ArithmeticException("Negative bit address");
            RuntimeCostAccounter.recordThrow();
            throw arithmeticException;
        }
        int n2 = n >>> 5;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intLength:()I");
        int n3 = this.intLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n4 = Math.max(n3, n2 + 2);
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        int n5 = 0;
        while (true) {
            int n6 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n6) break;
            int n7 = nArray.length - n5 - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            nArray[n7] = this.getInt(n5);
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        int n8 = nArray.length - n2 - 1;
        nArray[n8] = nArray[n8] ^ 1 << (n & 0x1F);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:([I)Ljava/math/BigInteger;");
        return BigInteger.valueOf(nArray);
    }

    public int getLowestSetBit() {
        int n = this.lowestSetBit - 2;
        RuntimeCostAccounter.recordJump();
        if (n == -2) {
            n = 0;
            RuntimeCostAccounter.recordJump();
            if (this.signum == 0) {
                --n;
                RuntimeCostAccounter.recordJump();
            } else {
                int n2;
                int n3 = 0;
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
                    n2 = this.getInt(n3);
                    RuntimeCostAccounter.recordJump();
                    if (n2 != 0) break;
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
                n += (n3 << 5) + Integer.numberOfTrailingZeros(n2);
            }
            this.lowestSetBit = n + 2;
        }
        return n;
    }

    public int bitLength() {
        int n = this.bitLength - 1;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            int[] nArray = this.mag;
            int n2 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                int n3 = this.mag[0];
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
                int n4 = (n2 - 1 << 5) + BigInteger.bitLengthForInt(n3);
                RuntimeCostAccounter.recordJump();
                if (this.signum < 0) {
                    int n5;
                    boolean bl;
                    int n6 = this.mag[0];
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.bitCount:(I)I");
                    int n7 = Integer.bitCount(n6);
                    RuntimeCostAccounter.recordJump();
                    if (n7 == 1) {
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl = false;
                    }
                    boolean bl2 = bl;
                    int n8 = 1;
                    while (true) {
                        boolean bl3;
                        RuntimeCostAccounter.recordJump();
                        if (n8 >= n2) break;
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break;
                        int n9 = this.mag[n8];
                        RuntimeCostAccounter.recordJump();
                        if (n9 == 0) {
                            bl3 = true;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            bl3 = false;
                        }
                        bl2 = bl3;
                        ++n8;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        n5 = n4 - 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n5 = n4;
                    }
                    n = n5;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = n4;
                }
            }
            this.bitLength = n + 1;
        }
        return n;
    }

    public int bitCount() {
        int n = this.bitCount - 1;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            n = 0;
            int n2 = 0;
            while (true) {
                int n3 = this.mag.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                int n4 = this.mag[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.bitCount:(I)I");
                n += Integer.bitCount(n4);
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (this.signum < 0) {
                n2 = 0;
                int n5 = this.mag.length - 1;
                while (true) {
                    int n6 = this.mag[n5];
                    RuntimeCostAccounter.recordJump();
                    if (n6 != 0) break;
                    n2 += 32;
                    --n5;
                    RuntimeCostAccounter.recordJump();
                }
                int n7 = this.mag[n5];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfTrailingZeros:(I)I");
                n += (n2 += Integer.numberOfTrailingZeros(n7)) - 1;
            }
            this.bitCount = n + 1;
        }
        return n;
    }

    public boolean isProbablePrime(int n) {
        BigInteger bigInteger;
        block6: {
            block5: {
                RuntimeCostAccounter.recordJump();
                if (n <= 0) {
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
                bigInteger = this.abs();
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                boolean bl = bigInteger.equals(TWO);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return true;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.testBit:(I)Z");
                boolean bl2 = bigInteger.testBit(0);
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = bigInteger.equals(ONE);
                RuntimeCostAccounter.recordJump();
                if (!bl3) break block6;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.primeToCertainty:(ILjava/util/Random;)Z");
        return bigInteger.primeToCertainty(n, null);
    }

    @Override
    public int compareTo(BigInteger bigInteger) {
        int n;
        int n2 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (this.signum == n2) {
            switch (this.signum) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareMagnitude:(Ljava/math/BigInteger;)I");
                    return this.compareMagnitude(bigInteger);
                }
                case -1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareMagnitude:(Ljava/math/BigInteger;)I");
                    return bigInteger.compareMagnitude(this);
                }
            }
            return 0;
        }
        int n3 = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (this.signum > n3) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = -1;
        }
        return n;
    }

    final int compareMagnitude(BigInteger bigInteger) {
        int[] nArray = this.mag;
        int n = nArray.length;
        int[] nArray2 = bigInteger.mag;
        int n2 = nArray2.length;
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            return -1;
        }
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            return 1;
        }
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            int n4 = nArray[n3];
            int n5 = nArray2[n3];
            RuntimeCostAccounter.recordJump();
            if (n4 != n5) {
                int n6;
                long l = ((long)n4 & 0xFFFFFFFFL) - ((long)n5 & 0xFFFFFFFFL);
                long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l2 < 0) {
                    n6 = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n6 = 1;
                }
                return n6;
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return 0;
    }

    final int compareMagnitude(long l) {
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordJump();
            if (l == Long.MIN_VALUE) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        int[] nArray = this.mag;
        int n = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n > 2) {
            return 1;
        }
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            l = -l;
        }
        int n2 = (int)(l >>> 32);
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            RuntimeCostAccounter.recordJump();
            if (n < 1) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (n > 1) {
                return 1;
            }
            int n3 = nArray[0];
            int n4 = (int)l;
            RuntimeCostAccounter.recordJump();
            if (n3 != n4) {
                int n5;
                long l2 = ((long)n3 & 0xFFFFFFFFL) - ((long)n4 & 0xFFFFFFFFL);
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 < 0) {
                    n5 = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n5 = 1;
                }
                return n5;
            }
            return 0;
        }
        RuntimeCostAccounter.recordJump();
        if (n < 2) {
            return -1;
        }
        int n6 = nArray[0];
        int n7 = n2;
        RuntimeCostAccounter.recordJump();
        if (n6 != n7) {
            int n8;
            long l4 = ((long)n6 & 0xFFFFFFFFL) - ((long)n7 & 0xFFFFFFFFL);
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 < 0) {
                n8 = -1;
                RuntimeCostAccounter.recordJump();
            } else {
                n8 = 1;
            }
            return n8;
        }
        n6 = nArray[1];
        n7 = (int)l;
        RuntimeCostAccounter.recordJump();
        if (n6 != n7) {
            int n9;
            long l6 = ((long)n6 & 0xFFFFFFFFL) - ((long)n7 & 0xFFFFFFFFL);
            long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l7 < 0) {
                n9 = -1;
                RuntimeCostAccounter.recordJump();
            } else {
                n9 = 1;
            }
            return n9;
        }
        return 0;
    }

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof BigInteger;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)object;
        int n = bigInteger.signum;
        RuntimeCostAccounter.recordJump();
        if (n != this.signum) {
            return false;
        }
        int[] nArray = this.mag;
        int n2 = nArray.length;
        int[] nArray2 = bigInteger.mag;
        int n3 = nArray2.length;
        RuntimeCostAccounter.recordJump();
        if (n2 != n3) {
            return false;
        }
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n2) break;
            int n5 = nArray2[n4];
            int n6 = nArray[n4];
            RuntimeCostAccounter.recordJump();
            if (n5 != n6) {
                return false;
            }
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    public BigInteger min(BigInteger bigInteger) {
        BigInteger bigInteger2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareTo:(Ljava/math/BigInteger;)I");
        int n = this.compareTo(bigInteger);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bigInteger2 = this;
            RuntimeCostAccounter.recordJump();
        } else {
            bigInteger2 = bigInteger;
        }
        return bigInteger2;
    }

    public BigInteger max(BigInteger bigInteger) {
        BigInteger bigInteger2;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.compareTo:(Ljava/math/BigInteger;)I");
        int n = this.compareTo(bigInteger);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            bigInteger2 = this;
            RuntimeCostAccounter.recordJump();
        } else {
            bigInteger2 = bigInteger;
        }
        return bigInteger2;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3 = this.mag.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            n = (int)((long)(31 * n) + ((long)this.mag[n2] & 0xFFFFFFFFL));
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return n * this.signum;
    }

    public String toString(int n) {
        block8: {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (this.signum == 0) {
                    return "0";
                }
                RuntimeCostAccounter.recordJump();
                if (n < 2) break block7;
                RuntimeCostAccounter.recordJump();
                if (n <= 36) break block8;
            }
            n = 10;
        }
        int n2 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n2 <= 20) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.smallToString:(I)Ljava/lang/String;");
            return this.smallToString(n);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordJump();
        if (this.signum < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
            BigInteger bigInteger = this.negate();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:(Ljava/math/BigInteger;Ljava/lang/StringBuilder;II)V");
            BigInteger.toString(bigInteger, stringBuilder, n, 0);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.insert:(IC)Ljava/lang/StringBuilder;");
            stringBuilder.insert(0, '-');
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:(Ljava/math/BigInteger;Ljava/lang/StringBuilder;II)V");
            BigInteger.toString(this, stringBuilder, n, 0);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }

    private String smallToString(int n) {
        Comparable<BigInteger> comparable;
        int n2;
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return "0";
        }
        int n3 = n2 = (4 * this.mag.length + 6) / 7;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        String[] stringArray = new String[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
        BigInteger bigInteger = this.abs();
        int n4 = 0;
        while (true) {
            int n5 = bigInteger.signum;
            RuntimeCostAccounter.recordJump();
            if (n5 == 0) break;
            comparable = longRadix[n];
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:()V");
            MutableBigInteger mutableBigInteger = new MutableBigInteger();
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            int[] nArray = bigInteger.mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
            MutableBigInteger mutableBigInteger2 = new MutableBigInteger(nArray);
            RuntimeCostAccounter.recordAllocation((String)"java/math/MutableBigInteger");
            int[] nArray2 = ((BigInteger)comparable).mag;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.<init>:([I)V");
            MutableBigInteger mutableBigInteger3 = new MutableBigInteger(nArray2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.divide:(Ljava/math/MutableBigInteger;Ljava/math/MutableBigInteger;)Ljava/math/MutableBigInteger;");
            MutableBigInteger mutableBigInteger4 = mutableBigInteger2.divide(mutableBigInteger3, mutableBigInteger);
            int n6 = bigInteger.signum * ((BigInteger)comparable).signum;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
            BigInteger bigInteger2 = mutableBigInteger.toBigInteger(n6);
            int n7 = bigInteger.signum * ((BigInteger)comparable).signum;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/MutableBigInteger.toBigInteger:(I)Ljava/math/BigInteger;");
            BigInteger bigInteger3 = mutableBigInteger4.toBigInteger(n7);
            int n8 = n4++;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
            long l = bigInteger3.longValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(JI)Ljava/lang/String;");
            stringArray[n8] = Long.toString(l, n);
            bigInteger = bigInteger2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        int n9 = n4 * digitsPerLong[n] + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        comparable = new StringBuilder(n9);
        RuntimeCostAccounter.recordJump();
        if (this.signum < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            ((StringBuilder)comparable).append('-');
        }
        String string = stringArray[n4 - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        ((StringBuilder)comparable).append(string);
        int n10 = n4 - 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n10 < 0) break;
            int n11 = digitsPerLong[n];
            String string2 = stringArray[n10];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n12 = n11 - string2.length();
            RuntimeCostAccounter.recordJump();
            if (n12 != 0) {
                String string3 = zeros[n12];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                ((StringBuilder)comparable).append(string3);
            }
            String string4 = stringArray[n10];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            ((StringBuilder)comparable).append(string4);
            --n10;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return ((StringBuilder)comparable).toString();
    }

    private static void toString(BigInteger bigInteger, StringBuilder stringBuilder, int n, int n2) {
        int n3 = bigInteger.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n3 <= 20) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.smallToString:(I)Ljava/lang/String;");
            String string = bigInteger.smallToString(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n4 = string.length();
            RuntimeCostAccounter.recordJump();
            if (n4 < n2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                int n5 = stringBuilder.length();
                RuntimeCostAccounter.recordJump();
                if (n5 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n6 = string.length();
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n6 >= n2) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append('0');
                        ++n6;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(string);
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n7 = bigInteger.bitLength();
        double d = (double)n7 * LOG_TWO / logCache[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.log:(D)D");
        double d2 = Math.log(d) / LOG_TWO - 1.0;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.round:(D)J");
        int n8 = (int)Math.round(d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getRadixConversionCache:(II)Ljava/math/BigInteger;");
        BigInteger bigInteger2 = BigInteger.getRadixConversionCache(n, n8);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divideAndRemainder:(Ljava/math/BigInteger;)[Ljava/math/BigInteger;");
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
        int n9 = 1 << n8;
        BigInteger bigInteger3 = bigIntegerArray[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:(Ljava/math/BigInteger;Ljava/lang/StringBuilder;II)V");
        BigInteger.toString(bigInteger3, stringBuilder, n, n2 - n9);
        BigInteger bigInteger4 = bigIntegerArray[1];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:(Ljava/math/BigInteger;Ljava/lang/StringBuilder;II)V");
        BigInteger.toString(bigInteger4, stringBuilder, n, n9);
    }

    /*
     * Exception decompiling
     */
    private static BigInteger getRadixConversionCache(int var0, int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Invalid type string [[s
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils.decodeTypeTok(ConstantPoolUtils.java:101)
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.convertFromString(ConstantPoolEntryClass.java:52)
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.getTypeInstance(ConstantPoolEntryClass.java:61)
         *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef.getMethodPrototype(ConstantPoolEntryMethodRef.java:72)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvoke(Op02WithProcessedDataAndRefs.java:331)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1224)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:(I)Ljava/lang/String;");
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        int n2 = n = this.bitLength() / 8 + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        byte[] byArray = new byte[n2];
        int n3 = n - 1;
        int n4 = 4;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) break;
            RuntimeCostAccounter.recordJump();
            if (n4 == 4) {
                int n7 = n6++;
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
                n5 = this.getInt(n7);
                n4 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n5 >>>= 8;
                ++n4;
            }
            byArray[n3] = (byte)n5;
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        return byArray;
    }

    @Override
    public int intValue() {
        int n = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
        n = this.getInt(0);
        return n;
    }

    @Override
    public long longValue() {
        long l = 0L;
        int n = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getInt:(I)I");
            l = (l << 32) + ((long)this.getInt(n) & 0xFFFFFFFFL);
            --n;
            RuntimeCostAccounter.recordJump();
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public float floatValue() {
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return 0.0f;
        }
        v0 = this.mag.length - 1 << 5;
        v1 = this.mag[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
        var1_1 = v0 + BigInteger.bitLengthForInt(v1) - 1;
        RuntimeCostAccounter.recordJump();
        if (var1_1 < 63) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
            return this.longValue();
        }
        RuntimeCostAccounter.recordJump();
        if (var1_1 > 127) {
            RuntimeCostAccounter.recordJump();
            if (this.signum > 0) {
                v2 = Infinityf;
                RuntimeCostAccounter.recordJump();
            } else {
                v2 = -Infinityf;
            }
            return v2;
        }
        var2_2 = var1_1 - 24;
        var3_3 = var2_2 & 31;
        var4_4 = 32 - var3_3;
        RuntimeCostAccounter.recordJump();
        if (var3_3 == 0) {
            var5_5 = this.mag[0];
            RuntimeCostAccounter.recordJump();
        } else {
            var5_5 = this.mag[0] >>> var3_3;
            RuntimeCostAccounter.recordJump();
            if (var5_5 == 0) {
                var5_5 = this.mag[0] << var4_4 | this.mag[1] >>> var3_3;
            }
        }
        var6_6 = var5_5 >> 1;
        var6_6 &= 0x7FFFFF;
        RuntimeCostAccounter.recordJump();
        if ((var5_5 & 1) == 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if ((var6_6 & 1) != 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
        v3 = this.abs();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLowestSetBit:()I");
        v4 = v3.getLowestSetBit();
        RuntimeCostAccounter.recordJump();
        if (v4 < var2_2) lbl-1000:
        // 2 sources

        {
            v5 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        var7_7 = v5;
        RuntimeCostAccounter.recordJump();
        if (var7_7) {
            v6 = var6_6 + 1;
            RuntimeCostAccounter.recordJump();
        } else {
            v6 = var6_6;
        }
        var8_8 = v6;
        var9_9 = var1_1 + 127 << 23;
        var9_9 += var8_8;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.intBitsToFloat:(I)F");
        return Float.intBitsToFloat(var9_9 |= this.signum & -2147483648);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double doubleValue() {
        RuntimeCostAccounter.recordJump();
        if (this.signum == 0) {
            return 0.0;
        }
        v0 = this.mag.length - 1 << 5;
        v1 = this.mag[0];
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
        var1_1 = v0 + BigInteger.bitLengthForInt(v1) - 1;
        RuntimeCostAccounter.recordJump();
        if (var1_1 < 63) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
            return this.longValue();
        }
        RuntimeCostAccounter.recordJump();
        if (var1_1 > 1023) {
            RuntimeCostAccounter.recordJump();
            if (this.signum > 0) {
                v2 = Infinity;
                RuntimeCostAccounter.recordJump();
            } else {
                v2 = -Infinity;
            }
            return v2;
        }
        var2_2 = var1_1 - 53;
        var3_3 = var2_2 & 31;
        var4_4 = 32 - var3_3;
        RuntimeCostAccounter.recordJump();
        if (var3_3 == 0) {
            var5_5 = this.mag[0];
            var6_6 = this.mag[1];
            RuntimeCostAccounter.recordJump();
        } else {
            var5_5 = this.mag[0] >>> var3_3;
            var6_6 = this.mag[0] << var4_4 | this.mag[1] >>> var3_3;
            RuntimeCostAccounter.recordJump();
            if (var5_5 == 0) {
                var5_5 = var6_6;
                var6_6 = this.mag[1] << var4_4 | this.mag[2] >>> var3_3;
            }
        }
        var7_7 = ((long)var5_5 & 0xFFFFFFFFL) << 32 | (long)var6_6 & 0xFFFFFFFFL;
        var9_8 = var7_7 >> 1;
        var9_8 &= 0xFFFFFFFFFFFFFL;
        RuntimeCostAccounter.recordJump();
        if ((var7_7 & 1L) == 0L) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if ((var9_8 & 1L) != 0L) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.abs:()Ljava/math/BigInteger;");
        v3 = this.abs();
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.getLowestSetBit:()I");
        v4 = v3.getLowestSetBit();
        RuntimeCostAccounter.recordJump();
        if (v4 < var2_2) lbl-1000:
        // 2 sources

        {
            v5 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        var11_9 = v5;
        RuntimeCostAccounter.recordJump();
        if (var11_9) {
            v6 = var9_8 + 1L;
            RuntimeCostAccounter.recordJump();
        } else {
            v6 = var9_8;
        }
        var12_10 = v6;
        var14_11 = (long)(var1_1 + 1023) << 52;
        var14_11 += var12_10;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
        return Double.longBitsToDouble(var14_11 |= (long)this.signum & -9223372036854775808L);
    }

    private static int[] stripLeadingZeroInts(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            int n3 = nArray[n2];
            RuntimeCostAccounter.recordJump();
            if (n3 != 0) break;
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
        return Arrays.copyOfRange(nArray, n2, n);
    }

    private static int[] trustedStripLeadingZeroInts(int[] nArray) {
        int[] nArray2;
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            int n3 = nArray[n2];
            RuntimeCostAccounter.recordJump();
            if (n3 != 0) break;
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            nArray2 = nArray;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([III)[I");
            nArray2 = Arrays.copyOfRange(nArray, n2, n);
        }
        return nArray2;
    }

    private static int[] stripLeadingZeroBytes(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            byte by = byArray[n3];
            RuntimeCostAccounter.recordJump();
            if (by != 0) break;
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        int n4 = n = n2 - n3 + 3 >>> 2;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)4);
        int[] nArray = new int[n4];
        int n5 = n2 - 1;
        int n6 = n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 < 0) break;
            nArray[n6] = byArray[n5--] & 0xFF;
            int n7 = n5 - n3 + 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n8 = Math.min(3, n7);
            int n9 = 8;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n9 > n8 << 3) break;
                int n10 = n6;
                nArray[n10] = nArray[n10] | (byArray[n5--] & 0xFF) << n9;
                n9 += 8;
                RuntimeCostAccounter.recordJump();
            }
            --n6;
            RuntimeCostAccounter.recordJump();
        }
        return nArray;
    }

    private static int[] makePositive(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n3) break;
            byte by = byArray[n4];
            RuntimeCostAccounter.recordJump();
            if (by != -1) break;
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        int n5 = n4;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n5 >= n3) break;
            byte by = byArray[n5];
            RuntimeCostAccounter.recordJump();
            if (by != 0) break;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n5 == n3) {
            n2 = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0;
        }
        int n6 = n2;
        int n7 = n = n3 - n4 + n6 + 3 >>> 2;
        RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)4);
        int[] nArray = new int[n7];
        int n8 = n3 - 1;
        int n9 = n - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n9 < 0) break;
            nArray[n9] = byArray[n8--] & 0xFF;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n10 = Math.min(3, n8 - n4 + 1);
            RuntimeCostAccounter.recordJump();
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = 8;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n11 > 8 * n10) break;
                int n12 = n9;
                nArray[n12] = nArray[n12] | (byArray[n8--] & 0xFF) << n11;
                n11 += 8;
                RuntimeCostAccounter.recordJump();
            }
            n11 = -1 >>> 8 * (3 - n10);
            nArray[n9] = ~nArray[n9] & n11;
            --n9;
            RuntimeCostAccounter.recordJump();
        }
        n9 = nArray.length - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n9 < 0) break;
            nArray[n9] = (int)(((long)nArray[n9] & 0xFFFFFFFFL) + 1L);
            int n13 = nArray[n9];
            RuntimeCostAccounter.recordJump();
            if (n13 != 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            --n9;
            RuntimeCostAccounter.recordJump();
        }
        return nArray;
    }

    private static int[] makePositive(int[] nArray) {
        int n;
        int n2 = 0;
        while (true) {
            int n3 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            int n4 = nArray[n2];
            RuntimeCostAccounter.recordJump();
            if (n4 != -1) break;
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        int n5 = n2;
        while (true) {
            int n6 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n6) break;
            int n7 = nArray[n5];
            RuntimeCostAccounter.recordJump();
            if (n7 != 0) break;
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        int n8 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n5 == n8) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        int n9 = n;
        int n10 = nArray.length - n2 + n9;
        RuntimeCostAccounter.recordArrayAllocation((int)n10, (int)4);
        int[] nArray2 = new int[n10];
        int n11 = n2;
        while (true) {
            int n12 = nArray.length;
            RuntimeCostAccounter.recordJump();
            if (n11 >= n12) break;
            nArray2[n11 - n2 + n9] = ~nArray[n11];
            ++n11;
            RuntimeCostAccounter.recordJump();
        }
        n11 = nArray2.length - 1;
        while (true) {
            int n13 = n11--;
            int n14 = nArray2[n13] + 1;
            nArray2[n13] = n14;
            RuntimeCostAccounter.recordJump();
            if (n14 != 0) break;
            RuntimeCostAccounter.recordJump();
        }
        return nArray2;
    }

    private int intLength() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
        return (this.bitLength() >>> 5) + 1;
    }

    private int signBit() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.signum < 0) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    private int signInt() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.signum < 0) {
            n = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    private int getInt(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            return 0;
        }
        int n3 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n >= n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.signInt:()I");
            return this.signInt();
        }
        int n4 = this.mag[this.mag.length - n - 1];
        RuntimeCostAccounter.recordJump();
        if (this.signum >= 0) {
            n2 = n4;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.firstNonzeroIntNum:()I");
            int n5 = this.firstNonzeroIntNum();
            RuntimeCostAccounter.recordJump();
            if (n <= n5) {
                n2 = -n4;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = ~n4;
            }
        }
        return n2;
    }

    private int firstNonzeroIntNum() {
        int n = this.firstNonzeroIntNum - 2;
        RuntimeCostAccounter.recordJump();
        if (n == -2) {
            n = 0;
            int n2 = this.mag.length;
            int n3 = n2 - 1;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) break;
                int n4 = this.mag[n3];
                RuntimeCostAccounter.recordJump();
                if (n4 != 0) break;
                --n3;
                RuntimeCostAccounter.recordJump();
            }
            n = n2 - n3 - 1;
            this.firstNonzeroIntNum = n + 2;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        boolean bl2;
        byte[] byArray;
        int n;
        ObjectInputStream.GetField getField;
        block15: {
            block14: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readFields:()Ljava/io/ObjectInputStream$GetField;");
                getField = objectInputStream.readFields();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;I)I");
                n = getField.get("signum", -2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
                byArray = (byte[])getField.get("magnitude", null);
                RuntimeCostAccounter.recordJump();
                if (n < -1) break block14;
                RuntimeCostAccounter.recordJump();
                if (n <= 1) break block15;
            }
            String string = "BigInteger: Invalid signum value";
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.defaulted:(Ljava/lang/String;)Z");
            boolean bl3 = getField.defaulted("signum");
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                string = "BigInteger: Signum not present in stream";
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.stripLeadingZeroBytes:([B)[I");
        int[] nArray = BigInteger.stripLeadingZeroBytes(byArray);
        int n2 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            bl2 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl2 = false;
        }
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        RuntimeCostAccounter.recordJump();
        if (bl2 != bl) {
            String string = "BigInteger: signum-magnitude mismatch";
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.defaulted:(Ljava/lang/String;)Z");
            boolean bl4 = getField.defaulted("magnitude");
            RuntimeCostAccounter.recordJump();
            if (bl4) {
                string = "BigInteger: Magnitude not present in stream";
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger$UnsafeHolder.putSign:(Ljava/math/BigInteger;I)V");
        UnsafeHolder.putSign(this, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger$UnsafeHolder.putMag:(Ljava/math/BigInteger;[I)V");
        UnsafeHolder.putMag(this, nArray);
        int n3 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 >= 0x4000000) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.checkRange:()V");
                this.checkRange();
            }
            catch (ArithmeticException arithmeticException) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
                StreamCorruptedException streamCorruptedException = new StreamCorruptedException("BigInteger: Out of the supported range");
                RuntimeCostAccounter.recordThrow();
                throw streamCorruptedException;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.putFields:()Ljava/io/ObjectOutputStream$PutField;");
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;I)V");
        putField.put("signum", this.signum);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.magSerializedForm:()[B");
        byte[] byArray = this.magSerializedForm();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;Ljava/lang/Object;)V");
        putField.put("magnitude", byArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;I)V");
        putField.put("bitCount", -1);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;I)V");
        putField.put("bitLength", -1);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;I)V");
        putField.put("lowestSetBit", -2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;I)V");
        putField.put("firstNonzeroByteNum", -2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFields:()V");
        objectOutputStream.writeFields();
    }

    private byte[] magSerializedForm() {
        int n;
        int n2;
        int n3 = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n3 == 0) {
            n2 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            int n4 = this.mag[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLengthForInt:(I)I");
            n2 = (n3 - 1 << 5) + BigInteger.bitLengthForInt(n4);
        }
        int n5 = n2;
        int n6 = n = n5 + 7 >>> 3;
        RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)1);
        byte[] byArray = new byte[n6];
        int n7 = n - 1;
        int n8 = 4;
        int n9 = n3 - 1;
        int n10 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 < 0) break;
            RuntimeCostAccounter.recordJump();
            if (n8 == 4) {
                n10 = this.mag[n9--];
                n8 = 1;
                RuntimeCostAccounter.recordJump();
            } else {
                n10 >>>= 8;
                ++n8;
            }
            byArray[n7] = (byte)n10;
            --n7;
            RuntimeCostAccounter.recordJump();
        }
        return byArray;
    }

    public long longValueExact() {
        int n = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n <= 2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
            int n2 = this.bitLength();
            RuntimeCostAccounter.recordJump();
            if (n2 <= 63) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
                return this.longValue();
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
        ArithmeticException arithmeticException = new ArithmeticException("BigInteger out of long range");
        RuntimeCostAccounter.recordThrow();
        throw arithmeticException;
    }

    public int intValueExact() {
        int n = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n <= 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
            int n2 = this.bitLength();
            RuntimeCostAccounter.recordJump();
            if (n2 <= 31) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intValue:()I");
                return this.intValue();
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
        ArithmeticException arithmeticException = new ArithmeticException("BigInteger out of int range");
        RuntimeCostAccounter.recordThrow();
        throw arithmeticException;
    }

    public short shortValueExact() {
        int n = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n <= 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
            int n2 = this.bitLength();
            RuntimeCostAccounter.recordJump();
            if (n2 <= 31) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intValue:()I");
                int n3 = this.intValue();
                RuntimeCostAccounter.recordJump();
                if (n3 >= Short.MIN_VALUE) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 <= Short.MAX_VALUE) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.shortValue:()S");
                        return this.shortValue();
                    }
                }
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
        ArithmeticException arithmeticException = new ArithmeticException("BigInteger out of short range");
        RuntimeCostAccounter.recordThrow();
        throw arithmeticException;
    }

    public byte byteValueExact() {
        int n = this.mag.length;
        RuntimeCostAccounter.recordJump();
        if (n <= 1) {
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
            int n2 = this.bitLength();
            RuntimeCostAccounter.recordJump();
            if (n2 <= 31) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.intValue:()I");
                int n3 = this.intValue();
                RuntimeCostAccounter.recordJump();
                if (n3 >= -128) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 <= 127) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.byteValue:()B");
                        return this.byteValue();
                    }
                }
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
        ArithmeticException arithmeticException = new ArithmeticException("BigInteger out of byte range");
        RuntimeCostAccounter.recordThrow();
        throw arithmeticException;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = BigInteger.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)8);
        bitsPerDigit = new long[]{0L, 0L, 1024L, 1624L, 2048L, 2378L, 2648L, 2875L, 3072L, 3247L, 3402L, 3543L, 3672L, 3790L, 3899L, 4001L, 4096L, 4186L, 4271L, 4350L, 4426L, 4498L, 4567L, 4633L, 4696L, 4756L, 4814L, 4870L, 4923L, 4975L, 5025L, 5074L, 5120L, 5166L, 5210L, 5253L, 5295L};
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        SMALL_PRIME_PRODUCT = BigInteger.valueOf(152125131763605L);
        RuntimeCostAccounter.recordArrayAllocation((int)17, (int)8);
        posConst = new BigInteger[17];
        RuntimeCostAccounter.recordArrayAllocation((int)17, (int)8);
        negConst = new BigInteger[17];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.log:(D)D");
        LOG_TWO = Math.log(2.0);
        int n = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > 16) break;
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)4);
            int[] nArray = new int[]{n};
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            BigInteger.posConst[n] = new BigInteger(nArray, 1);
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
            BigInteger.negConst[n] = new BigInteger(nArray, -1);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)8);
        powerCache = new BigInteger[37][];
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)8);
        logCache = new double[37];
        n = 2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n > 36) break;
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            BigInteger[] bigIntegerArray = new BigInteger[1];
            long l = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
            bigIntegerArray[0] = BigInteger.valueOf(l);
            BigInteger.powerCache[n] = bigIntegerArray;
            double d = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.log:(D)D");
            BigInteger.logCache[n] = Math.log(d);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigInteger");
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)4);
        int[] nArray = new int[]{};
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.<init>:([II)V");
        ZERO = new BigInteger(nArray, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        ONE = BigInteger.valueOf(1L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        TWO = BigInteger.valueOf(2L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        NEGATIVE_ONE = BigInteger.valueOf(-1L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        TEN = BigInteger.valueOf(10L);
        RuntimeCostAccounter.recordArrayAllocation((int)7, (int)4);
        bnExpModThreshTable = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        RuntimeCostAccounter.recordArrayAllocation((int)64, (int)8);
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= 63) break;
            String string = zeros[63];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            BigInteger.zeros[n] = string.substring(0, n);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)4);
        digitsPerLong = new int[]{0, 0, 62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)8);
        BigInteger[] bigIntegerArray = new BigInteger[37];
        bigIntegerArray[0] = null;
        bigIntegerArray[1] = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[2] = BigInteger.valueOf(0x4000000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[3] = BigInteger.valueOf(4052555153018976267L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[4] = BigInteger.valueOf(0x4000000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[5] = BigInteger.valueOf(7450580596923828125L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[6] = BigInteger.valueOf(4738381338321616896L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[7] = BigInteger.valueOf(3909821048582988049L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[8] = BigInteger.valueOf(0x1000000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[9] = BigInteger.valueOf(1350851717672992089L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[10] = BigInteger.valueOf(1000000000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[11] = BigInteger.valueOf(5559917313492231481L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[12] = BigInteger.valueOf(2218611106740436992L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[13] = BigInteger.valueOf(8650415919381337933L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[14] = BigInteger.valueOf(2177953337809371136L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[15] = BigInteger.valueOf(6568408355712890625L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[16] = BigInteger.valueOf(0x1000000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[17] = BigInteger.valueOf(2862423051509815793L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[18] = BigInteger.valueOf(6746640616477458432L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[19] = BigInteger.valueOf(799006685782884121L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[20] = BigInteger.valueOf(1638400000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[21] = BigInteger.valueOf(3243919932521508681L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[22] = BigInteger.valueOf(6221821273427820544L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[23] = BigInteger.valueOf(504036361936467383L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[24] = BigInteger.valueOf(876488338465357824L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[25] = BigInteger.valueOf(1490116119384765625L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[26] = BigInteger.valueOf(2481152873203736576L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[27] = BigInteger.valueOf(4052555153018976267L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[28] = BigInteger.valueOf(6502111422497947648L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[29] = BigInteger.valueOf(353814783205469041L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[30] = BigInteger.valueOf(531441000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[31] = BigInteger.valueOf(787662783788549761L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[32] = BigInteger.valueOf(0x1000000000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[33] = BigInteger.valueOf(1667889514952984961L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[34] = BigInteger.valueOf(2386420683693101056L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[35] = BigInteger.valueOf(3379220508056640625L);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
        bigIntegerArray[36] = BigInteger.valueOf(4738381338321616896L);
        longRadix = bigIntegerArray;
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)4);
        digitsPerInt = new int[]{0, 0, 30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
        RuntimeCostAccounter.recordArrayAllocation((int)37, (int)4);
        intRadix = new int[]{0, 0, 0x40000000, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};
        RuntimeCostAccounter.recordArrayAllocation((int)6, (int)8);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[6];
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[0] = new ObjectStreamField("signum", Integer.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[1] = new ObjectStreamField("magnitude", byte[].class);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[2] = new ObjectStreamField("bitCount", Integer.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[3] = new ObjectStreamField("bitLength", Integer.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[4] = new ObjectStreamField("firstNonzeroByteNum", Integer.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[5] = new ObjectStreamField("lowestSetBit", Integer.TYPE);
        serialPersistentFields = objectStreamFieldArray;
    }

    private static class UnsafeHolder {
        private static final Unsafe unsafe;
        private static final long signumOffset;
        private static final long magOffset;

        private UnsafeHolder() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        static void putSign(BigInteger bigInteger, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putIntVolatile:(Ljava/lang/Object;JI)V");
            unsafe.putIntVolatile((Object)bigInteger, signumOffset, n);
        }

        static void putMag(BigInteger bigInteger, int[] nArray) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObjectVolatile:(Ljava/lang/Object;JLjava/lang/Object;)V");
            unsafe.putObjectVolatile((Object)bigInteger, magOffset, (Object)nArray);
        }

        static {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
                unsafe = Unsafe.getUnsafe();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field = BigInteger.class.getDeclaredField("signum");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                signumOffset = unsafe.objectFieldOffset(field);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
                Field field2 = BigInteger.class.getDeclaredField("mag");
                RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
                magOffset = unsafe.objectFieldOffset(field2);
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ExceptionInInitializerError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ExceptionInInitializerError.<init>:(Ljava/lang/Throwable;)V");
                ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError(exception);
                RuntimeCostAccounter.recordThrow();
                throw exceptionInInitializerError;
            }
            RuntimeCostAccounter.recordJump();
        }
    }
}

