/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.zip.ZStreamRef;

public class Deflater {
    private final ZStreamRef zsRef;
    private byte[] buf;
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    private long bytesRead;
    private long bytesWritten;
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Deflater(int n, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)1);
        this.buf = new byte[0];
        this.level = n;
        this.strategy = 0;
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZStreamRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.init:(IIZ)J");
        long l = Deflater.init(n, 0, bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.<init>:(J)V");
        this.zsRef = new ZStreamRef(l);
    }

    public Deflater(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.<init>:(IZ)V");
        this(n, false);
    }

    public Deflater() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.<init>:(IZ)V");
        this(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(byte[] byArray, int n, int n2) {
        block7: {
            block6: {
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block6;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block6;
                int n3 = byArray.length - n2;
                RuntimeCostAccounter.recordJump();
                if (n <= n3) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:()V");
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw arrayIndexOutOfBoundsException;
        }
        ZStreamRef zStreamRef = this.zsRef;
        try {
            this.buf = byArray;
            this.off = n;
            this.len = n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void setInput(byte[] byArray) {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.setInput:([BII)V");
        this.setInput(byArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(byte[] byArray, int n, int n2) {
        block7: {
            block6: {
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block6;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block6;
                int n3 = byArray.length - n2;
                RuntimeCostAccounter.recordJump();
                if (n <= n3) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:()V");
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw arrayIndexOutOfBoundsException;
        }
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.address:()J");
            long l = this.zsRef.address();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.setDictionary:(J[BII)V");
            Deflater.setDictionary(l, byArray, n, n2);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void setDictionary(byte[] byArray) {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.setDictionary:([BII)V");
        this.setDictionary(byArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrategy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.strategy != n) {
                this.strategy = n;
                this.setParams = true;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(int n) {
        block9: {
            block8: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block8;
                RuntimeCostAccounter.recordJump();
                if (n <= 9) break block9;
            }
            RuntimeCostAccounter.recordJump();
            if (n != -1) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid compression level");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.level != n) {
                this.level = n;
                this.setParams = true;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public boolean needsInput() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.len <= 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            this.finish = true;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finished() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            return this.finished;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    public int deflate(byte[] byArray, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.deflate:([BIII)I");
        return this.deflate(byArray, n, n2, 0);
    }

    public int deflate(byte[] byArray) {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.deflate:([BIII)I");
        return this.deflate(byArray, 0, n, 0);
    }

    public int deflate(byte[] byArray, int n, int n2, int n3) {
        block10: {
            block9: {
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block9;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block9;
                int n4 = byArray.length - n2;
                RuntimeCostAccounter.recordJump();
                if (n <= n4) break block10;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ArrayIndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArrayIndexOutOfBoundsException.<init>:()V");
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw arrayIndexOutOfBoundsException;
        }
        ZStreamRef zStreamRef = this.zsRef;
        try {
            block12: {
                block11: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordJump();
                    if (n3 == 0) break block11;
                    RuntimeCostAccounter.recordJump();
                    if (n3 == 2) break block11;
                    RuntimeCostAccounter.recordJump();
                    if (n3 != 3) break block12;
                }
                int n5 = this.len;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.address:()J");
                long l = this.zsRef.address();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.deflateBytes:(J[BIII)I");
                int n6 = this.deflateBytes(l, byArray, n, n2, n3);
                this.bytesWritten += (long)n6;
                this.bytesRead += (long)(n5 - this.len);
                return n6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdler() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.address:()J");
            long l = this.zsRef.address();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getAdler:(J)I");
            return Deflater.getAdler(l);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    public int getTotalIn() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesRead:()J");
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.ensureOpen:()V");
            this.ensureOpen();
            return this.bytesRead;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    public int getTotalOut() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.getBytesWritten:()J");
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.ensureOpen:()V");
            this.ensureOpen();
            return this.bytesWritten;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.address:()J");
            long l = this.zsRef.address();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.reset:(J)V");
            Deflater.reset(l);
            this.finish = false;
            this.finished = false;
            this.len = 0;
            this.off = 0;
            this.bytesWritten = 0L;
            this.bytesRead = 0L;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ZStreamRef zStreamRef = this.zsRef;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.address:()J");
            long l = this.zsRef.address();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.clear:()V");
            this.zsRef.clear();
            RuntimeCostAccounter.recordJump();
            if (l != 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.end:(J)V");
                Deflater.end(l);
                this.buf = null;
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    protected void finalize() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.end:()V");
        this.end();
    }

    private void ensureOpen() {
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.holdsLock:(Ljava/lang/Object;)Z");
            boolean bl = Thread.holdsLock(this.zsRef);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZStreamRef.address:()J");
        long l = this.zsRef.address() - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 == false) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("Deflater has been closed");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private static native int getAdler(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = Deflater.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Deflater.initIDs:()V");
        Deflater.initIDs();
    }
}

