/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.AbstractCollection;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Consumer;

public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue;
    int modCount;
    private static final Object NULL_KEY;
    private transient Set<Map.Entry<K, V>> entrySet;

    private Entry<K, V>[] newTable(int n) {
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        return new Entry[n2];
    }

    public WeakHashMap(int n, float f) {
        block7: {
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap.<init>:()V");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/ReferenceQueue");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.<init>:()V");
                this.queue = new ReferenceQueue();
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Illegal Initial Capacity: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordJump();
                if (n > 0x40000000) {
                    n = 0x40000000;
                }
                RuntimeCostAccounter.recordJump();
                if (f <= 0.0f) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Float.isNaN:(F)Z");
                boolean bl = Float.isNaN(f);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("Illegal Load factor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(F)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(f);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            n2 <<= 1;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.newTable:(I)[Ljava/util/WeakHashMap$Entry;");
        this.table = this.newTable(n2);
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
    }

    public WeakHashMap(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.<init>:(IF)V");
        this(n, 0.75f);
    }

    public WeakHashMap() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.<init>:(IF)V");
        this(16, 0.75f);
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = (int)((float)map.size() / 0.75f) + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n2 = Math.max(n, 16);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.<init>:(IF)V");
        this(n2, 0.75f);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.putAll:(Ljava/util/Map;)V");
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        Object object2;
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            object2 = NULL_KEY;
            RuntimeCostAccounter.recordJump();
        } else {
            object2 = object;
        }
        return object2;
    }

    static Object unmaskNull(Object object) {
        Object object2;
        RuntimeCostAccounter.recordJump();
        if (object == NULL_KEY) {
            object2 = null;
            RuntimeCostAccounter.recordJump();
        } else {
            object2 = object;
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean eq(Object object, Object object2) {
        RuntimeCostAccounter.recordJump();
        if (object != object2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            boolean bl = object.equals(object2);
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    final int hash(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.poll:()Ljava/lang/ref/Reference;");
            Reference<Object> reference = this.queue.poll();
            RuntimeCostAccounter.recordJump();
            if (reference == null) break;
            try {
                Entry<K, V> entry;
                Entry entry2 = (Entry)reference;
                int n = entry2.hash;
                int n2 = this.table.length;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
                int n3 = WeakHashMap.indexFor(n, n2);
                Entry<K, V> entry3 = entry = this.table[n3];
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry3 == null) break;
                    Entry entry4 = entry3.next;
                    RuntimeCostAccounter.recordJump();
                    if (entry3 == entry2) {
                        RuntimeCostAccounter.recordJump();
                        if (entry == entry2) {
                            this.table[n3] = entry4;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entry.next = entry4;
                        }
                        entry2.value = null;
                        --this.size;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    entry = entry3;
                    entry3 = entry4;
                    RuntimeCostAccounter.recordJump();
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
    }

    private Entry<K, V>[] getTable() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.expungeStaleEntries:()V");
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        RuntimeCostAccounter.recordJump();
        if (this.size == 0) {
            return 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.expungeStaleEntries:()V");
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public V get(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object2 = WeakHashMap.maskNull(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.hash:(Ljava/lang/Object;)I");
        int n = this.hash(object2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
        int n3 = WeakHashMap.indexFor(n, n2);
        Entry<K, V> entry = entryArray[n3];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n4 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n4 == n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = WeakHashMap.eq(object2, t);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return entry.value;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getEntry:(Ljava/lang/Object;)Ljava/util/WeakHashMap$Entry;");
        Entry<K, V> entry = this.getEntry(object);
        RuntimeCostAccounter.recordJump();
        if (entry != null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    Entry<K, V> getEntry(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object2 = WeakHashMap.maskNull(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.hash:(Ljava/lang/Object;)I");
        int n = this.hash(object2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
        int n3 = WeakHashMap.indexFor(n, n2);
        Entry<K, V> entry = entryArray[n3];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n4 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n4 == n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = WeakHashMap.eq(object2, t);
                RuntimeCostAccounter.recordJump();
                if (bl) break;
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object = WeakHashMap.maskNull(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.hash:(Ljava/lang/Object;)I");
        int n = this.hash(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
        int n3 = WeakHashMap.indexFor(n, n2);
        Entry<K, V> entry = entryArray[n3];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry == null) break;
            int n4 = entry.hash;
            RuntimeCostAccounter.recordJump();
            if (n == n4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = WeakHashMap.eq(object, t);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    Object v2 = entry.value;
                    RuntimeCostAccounter.recordJump();
                    if (v != v2) {
                        entry.value = v;
                    }
                    return v2;
                }
            }
            entry = entry.next;
            RuntimeCostAccounter.recordJump();
        }
        ++this.modCount;
        entry = entryArray[n3];
        RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$Entry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.<init>:(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;ILjava/util/WeakHashMap$Entry;)V");
        entryArray[n3] = new Entry<K, V>(object, v, this.queue, n, entry);
        RuntimeCostAccounter.recordJump();
        if (++this.size >= this.threshold) {
            int n5 = entryArray.length * 2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.resize:(I)V");
            this.resize(n5);
        }
        return null;
    }

    void resize(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.newTable:(I)[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray2 = this.newTable(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.transfer:([Ljava/util/WeakHashMap$Entry;[Ljava/util/WeakHashMap$Entry;)V");
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        int n3 = this.threshold / 2;
        RuntimeCostAccounter.recordJump();
        if (this.size >= n3) {
            this.threshold = (int)((float)n * this.loadFactor);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.expungeStaleEntries:()V");
            this.expungeStaleEntries();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.transfer:([Ljava/util/WeakHashMap$Entry;[Ljava/util/WeakHashMap$Entry;)V");
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2) {
        int n = 0;
        while (true) {
            int n2 = entryArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            Entry<K, V> entry = entryArray[n];
            entryArray[n] = null;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                Entry entry2 = entry.next;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry.get();
                RuntimeCostAccounter.recordJump();
                if (t == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n3 = entry.hash;
                    int n4 = entryArray2.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
                    int n5 = WeakHashMap.indexFor(n3, n4);
                    entry.next = entryArray2[n5];
                    entryArray2[n5] = entry;
                }
                entry = entry2;
                RuntimeCostAccounter.recordJump();
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = map.size();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return;
        }
        RuntimeCostAccounter.recordJump();
        if (n > this.threshold) {
            int n2 = (int)((float)n / this.loadFactor + 1.0f);
            RuntimeCostAccounter.recordJump();
            if (n2 > 0x40000000) {
                n2 = 0x40000000;
            }
            int n3 = this.table.length;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n2) break;
                n3 <<= 1;
                RuntimeCostAccounter.recordJump();
            }
            int n4 = this.table.length;
            RuntimeCostAccounter.recordJump();
            if (n3 > n4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.resize:(I)V");
                this.resize(n3);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<K, V>> set = map.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Map.Entry<K, V>> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Map.Entry<K, V> entry = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            K k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            V v = entry.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.put(k, v);
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object2 = WeakHashMap.maskNull(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.hash:(Ljava/lang/Object;)I");
        int n = this.hash(object2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
        int n3 = WeakHashMap.indexFor(n, n2);
        Entry<K, V> entry2 = entry = entryArray[n3];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry2 == null) break;
            Entry entry3 = entry2.next;
            int n4 = entry2.hash;
            RuntimeCostAccounter.recordJump();
            if (n == n4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry2.get();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.eq:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = WeakHashMap.eq(object2, t);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    ++this.modCount;
                    --this.size;
                    RuntimeCostAccounter.recordJump();
                    if (entry == entry2) {
                        entryArray[n3] = entry3;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        entry.next = entry3;
                    }
                    return entry2.value;
                }
            }
            entry = entry2;
            entry2 = entry3;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    boolean removeMapping(Object object) {
        Entry<K, V> entry;
        boolean bl = object instanceof Map.Entry;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
        Object k = entry2.getKey();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.maskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object2 = WeakHashMap.maskNull(k);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.hash:(Ljava/lang/Object;)I");
        int n = this.hash(object2);
        int n2 = entryArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.indexFor:(II)I");
        int n3 = WeakHashMap.indexFor(n, n2);
        Entry<K, V> entry3 = entry = entryArray[n3];
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (entry3 == null) break;
            Entry entry4 = entry3.next;
            int n4 = entry3.hash;
            RuntimeCostAccounter.recordJump();
            if (n == n4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = entry3.equals(entry2);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    ++this.modCount;
                    --this.size;
                    RuntimeCostAccounter.recordJump();
                    if (entry == entry3) {
                        entryArray[n3] = entry4;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        entry.next = entry4;
                    }
                    return true;
                }
            }
            entry = entry3;
            entry3 = entry4;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public void clear() {
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.poll:()Ljava/lang/ref/Reference;");
            Reference<Object> reference = this.queue.poll();
            RuntimeCostAccounter.recordJump();
            if (reference == null) break;
            RuntimeCostAccounter.recordJump();
        }
        ++this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.fill:([Ljava/lang/Object;Ljava/lang/Object;)V");
        Arrays.fill(this.table, null);
        this.size = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/ReferenceQueue.poll:()Ljava/lang/ref/Reference;");
            Reference<Object> reference = this.queue.poll();
            RuntimeCostAccounter.recordJump();
            if (reference == null) break;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public boolean containsValue(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.containsNullValue:()Z");
            return this.containsNullValue();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (true) {
            int n2 = n--;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            Entry<K, V> entry = entryArray[n];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                Object v = entry.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(v);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return true;
                }
                entry = entry.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    private boolean containsNullValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (true) {
            int n2 = n--;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break;
            Entry<K, V> entry = entryArray[n];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                Object v = entry.value;
                RuntimeCostAccounter.recordJump();
                if (v == null) {
                    return true;
                }
                entry = entry.next;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set;
        Set set2 = this.keySet;
        RuntimeCostAccounter.recordJump();
        if (set2 != null) {
            set = set2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$KeySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeySet.<init>:(Ljava/util/WeakHashMap;Ljava/util/WeakHashMap$1;)V");
            set = this.keySet = new KeySet(this, null);
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection;
        Collection collection2 = this.values;
        RuntimeCostAccounter.recordJump();
        if (collection2 != null) {
            collection = collection2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$Values");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Values.<init>:(Ljava/util/WeakHashMap;Ljava/util/WeakHashMap$1;)V");
            collection = this.values = new Values(this, null);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet;
        EntrySet entrySet2 = this.entrySet;
        RuntimeCostAccounter.recordJump();
        if (entrySet2 != null) {
            entrySet = entrySet2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$EntrySet");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySet.<init>:(Ljava/util/WeakHashMap;Ljava/util/WeakHashMap$1;)V");
            entrySet = this.entrySet = new EntrySet(this, null);
        }
        return entrySet;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Entry<K, V>[] entryArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer);
        int n = this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray2 = entryArray = this.getTable();
        int n2 = entryArray2.length;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            Entry<K, V> entry = entryArray2[n3];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry.get();
                RuntimeCostAccounter.recordJump();
                if (t != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object object = WeakHashMap.unmaskNull(t);
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
                    biConsumer.accept(object, v);
                }
                entry = entry.next;
                RuntimeCostAccounter.recordJump();
                if (n != this.modCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordJump();
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Entry<K, V>[] entryArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        int n = this.modCount;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getTable:()[Ljava/util/WeakHashMap$Entry;");
        Entry<K, V>[] entryArray2 = entryArray = this.getTable();
        int n2 = entryArray2.length;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            Entry<K, V> entry = entryArray2[n3];
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (entry == null) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                Object t = entry.get();
                RuntimeCostAccounter.recordJump();
                if (t != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Object object = WeakHashMap.unmaskNull(t);
                    Object v = entry.value;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    entry.value = biFunction.apply(object, v);
                }
                entry = entry.next;
                RuntimeCostAccounter.recordJump();
                if (n != this.modCount) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                    ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                    RuntimeCostAccounter.recordThrow();
                    throw concurrentModificationException;
                }
                RuntimeCostAccounter.recordJump();
            }
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        NULL_KEY = new Object();
    }

    static final class EntrySpliterator<K, V>
    extends WeakHashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$WeakHashMapSpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
            super(weakHashMap, n, n2, n3, n4);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = n2 + n >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                entrySpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$EntrySpliterator");
                this.index = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, n2, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            int n;
            WeakHashMap weakHashMap;
            block11: {
                int n2;
                int n3;
                Entry<K, V>[] entryArray;
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    weakHashMap = this.map;
                    entryArray = weakHashMap.table;
                    n3 = this.fence;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < 0) {
                        n = this.expectedModCount = weakHashMap.modCount;
                        n3 = this.fence = entryArray.length;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.expectedModCount;
                    }
                    int n4 = entryArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n4 < n3) break block11;
                    n2 = this.index;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block11;
                    this.index = n3;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < this.index) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (this.current == null) break block11;
                }
                Entry entry = this.current;
                this.current = null;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) {
                        entry = entryArray[n2++];
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                        Object t = entry.get();
                        Object v = entry.value;
                        entry = entry.next;
                        RuntimeCostAccounter.recordJump();
                        if (t != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                            Object object = WeakHashMap.unmaskNull(t);
                            RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(object, v);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(simpleImmutableEntry);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (entry != null) continue;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) break;
                }
            }
            int n5 = weakHashMap.modCount;
            RuntimeCostAccounter.recordJump();
            if (n5 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n = entryArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySpliterator.getFence:()I");
            int n2 = this.getFence();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= 0) {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (this.current == null) {
                            RuntimeCostAccounter.recordJump();
                            if (this.index >= n2) break;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.current == null) {
                            this.current = entryArray[this.index++];
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                        Object t = this.current.get();
                        Object v = this.current.value;
                        this.current = this.current.next;
                        RuntimeCostAccounter.recordJump();
                        if (t != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                            Object object = WeakHashMap.unmaskNull(t);
                            RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(object, v);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(simpleImmutableEntry);
                            int n3 = this.map.modCount;
                            RuntimeCostAccounter.recordJump();
                            if (n3 != this.expectedModCount) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                                RuntimeCostAccounter.recordThrow();
                                throw concurrentModificationException;
                            }
                            return true;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 1;
        }
    }

    static final class ValueSpliterator<K, V>
    extends WeakHashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$WeakHashMapSpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
            super(weakHashMap, n, n2, n3, n4);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = n2 + n >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                valueSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$ValueSpliterator");
                this.index = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueSpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, n2, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            int n;
            WeakHashMap weakHashMap;
            block11: {
                int n2;
                int n3;
                Entry<K, V>[] entryArray;
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    weakHashMap = this.map;
                    entryArray = weakHashMap.table;
                    n3 = this.fence;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < 0) {
                        n = this.expectedModCount = weakHashMap.modCount;
                        n3 = this.fence = entryArray.length;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.expectedModCount;
                    }
                    int n4 = entryArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n4 < n3) break block11;
                    n2 = this.index;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block11;
                    this.index = n3;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < this.index) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (this.current == null) break block11;
                }
                Entry entry = this.current;
                this.current = null;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) {
                        entry = entryArray[n2++];
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                        Object t = entry.get();
                        Object v = entry.value;
                        entry = entry.next;
                        RuntimeCostAccounter.recordJump();
                        if (t != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(v);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (entry != null) continue;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) break;
                }
            }
            int n5 = weakHashMap.modCount;
            RuntimeCostAccounter.recordJump();
            if (n5 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n = entryArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueSpliterator.getFence:()I");
            int n2 = this.getFence();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= 0) {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (this.current == null) {
                            RuntimeCostAccounter.recordJump();
                            if (this.index >= n2) break;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.current == null) {
                            this.current = entryArray[this.index++];
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                        Object t = this.current.get();
                        Object v = this.current.value;
                        this.current = this.current.next;
                        RuntimeCostAccounter.recordJump();
                        if (t != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(v);
                            int n3 = this.map.modCount;
                            RuntimeCostAccounter.recordJump();
                            if (n3 != this.expectedModCount) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                                RuntimeCostAccounter.recordThrow();
                                throw concurrentModificationException;
                            }
                            return true;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }

    static final class KeySpliterator<K, V>
    extends WeakHashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$WeakHashMapSpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
            super(weakHashMap, n, n2, n3, n4);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeySpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = n2 + n >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                keySpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$KeySpliterator");
                this.index = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeySpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, n2, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            int n;
            WeakHashMap weakHashMap;
            block11: {
                int n2;
                int n3;
                Entry<K, V>[] entryArray;
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (consumer == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                        NullPointerException nullPointerException = new NullPointerException();
                        RuntimeCostAccounter.recordThrow();
                        throw nullPointerException;
                    }
                    weakHashMap = this.map;
                    entryArray = weakHashMap.table;
                    n3 = this.fence;
                    RuntimeCostAccounter.recordJump();
                    if (n3 < 0) {
                        n = this.expectedModCount = weakHashMap.modCount;
                        n3 = this.fence = entryArray.length;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.expectedModCount;
                    }
                    int n4 = entryArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n4 < n3) break block11;
                    n2 = this.index;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block11;
                    this.index = n3;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < this.index) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (this.current == null) break block11;
                }
                Entry entry = this.current;
                this.current = null;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) {
                        entry = entryArray[n2++];
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                        Object t = entry.get();
                        entry = entry.next;
                        RuntimeCostAccounter.recordJump();
                        if (t != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                            Object object = WeakHashMap.unmaskNull(t);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(object);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (entry != null) continue;
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) break;
                }
            }
            int n5 = weakHashMap.modCount;
            RuntimeCostAccounter.recordJump();
            if (n5 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            Entry<K, V>[] entryArray = this.map.table;
            int n = entryArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeySpliterator.getFence:()I");
            int n2 = this.getFence();
            RuntimeCostAccounter.recordJump();
            if (n >= n2) {
                RuntimeCostAccounter.recordJump();
                if (this.index >= 0) {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (this.current == null) {
                            RuntimeCostAccounter.recordJump();
                            if (this.index >= n2) break;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.current == null) {
                            this.current = entryArray[this.index++];
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                        Object t = this.current.get();
                        this.current = this.current.next;
                        RuntimeCostAccounter.recordJump();
                        if (t != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                            Object object = WeakHashMap.unmaskNull(t);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                            consumer.accept(object);
                            int n3 = this.map.modCount;
                            RuntimeCostAccounter.recordJump();
                            if (n3 != this.expectedModCount) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                                RuntimeCostAccounter.recordThrow();
                                throw concurrentModificationException;
                            }
                            return true;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 1;
        }
    }

    static class WeakHashMapSpliterator<K, V> {
        final WeakHashMap<K, V> map;
        Entry<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        WeakHashMapSpliterator(WeakHashMap<K, V> weakHashMap, int n, int n2, int n3, int n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.map = weakHashMap;
            this.index = n;
            this.fence = n2;
            this.est = n3;
            this.expectedModCount = n4;
        }

        final int getFence() {
            int n = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                WeakHashMap<K, V> weakHashMap = this.map;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.size:()I");
                this.est = weakHashMap.size();
                this.expectedModCount = weakHashMap.modCount;
                n = this.fence = weakHashMap.table.length;
            }
            return n;
        }

        public final long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$WeakHashMapSpliterator.getFence:()I");
            this.getFence();
            return this.est;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final /* synthetic */ WeakHashMap this$0;

        private EntrySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$EntryIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntryIterator.<init>:(Ljava/util/WeakHashMap;Ljava/util/WeakHashMap$1;)V");
            return new EntryIterator(this.this$0, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object object) {
            boolean bl = object instanceof Map.Entry;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            Object k = entry.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.getEntry:(Ljava/lang/Object;)Ljava/util/WeakHashMap$Entry;");
            Entry entry2 = this.this$0.getEntry(k);
            RuntimeCostAccounter.recordJump();
            if (entry2 == null) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = entry2.equals(entry);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.removeMapping:(Ljava/lang/Object;)Z");
            return this.this$0.removeMapping(object);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.size:()I");
            return this.this$0.size();
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.clear:()V");
            this.this$0.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySet.size:()I");
            int n = this.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
            ArrayList arrayList = new ArrayList(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySet.iterator:()Ljava/util/Iterator;");
            Iterator iterator = this.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Map.Entry entry = iterator.next();
                RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleEntry.<init>:(Ljava/util/Map$Entry;)V");
                AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(entry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(simpleEntry);
                RuntimeCostAccounter.recordJump();
            }
            return arrayList;
        }

        @Override
        public Object[] toArray() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySet.deepCopy:()Ljava/util/List;");
            List list = this.deepCopy();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:()[Ljava/lang/Object;");
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySet.deepCopy:()Ljava/util/List;");
            List list = this.deepCopy();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            return list.toArray(TArray);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$EntrySpliterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
            return new EntrySpliterator(this.this$0, 0, -1, 0, 0);
        }

        /* synthetic */ EntrySet(WeakHashMap weakHashMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntrySet.<init>:(Ljava/util/WeakHashMap;)V");
            this(weakHashMap);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        final /* synthetic */ WeakHashMap this$0;

        private Values(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.<init>:()V");
        }

        @Override
        public Iterator<V> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$ValueIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueIterator.<init>:(Ljava/util/WeakHashMap;Ljava/util/WeakHashMap$1;)V");
            return new ValueIterator(this.this$0, null);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.size:()I");
            return this.this$0.size();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.containsValue:(Ljava/lang/Object;)Z");
            return this.this$0.containsValue(object);
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.clear:()V");
            this.this$0.clear();
        }

        @Override
        public Spliterator<V> spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$ValueSpliterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueSpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
            return new ValueSpliterator(this.this$0, 0, -1, 0, 0);
        }

        /* synthetic */ Values(WeakHashMap weakHashMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Values.<init>:(Ljava/util/WeakHashMap;)V");
            this(weakHashMap);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final /* synthetic */ WeakHashMap this$0;

        private KeySet(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        }

        @Override
        public Iterator<K> iterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$KeyIterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeyIterator.<init>:(Ljava/util/WeakHashMap;Ljava/util/WeakHashMap$1;)V");
            return new KeyIterator(this.this$0, null);
        }

        @Override
        public int size() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.size:()I");
            return this.this$0.size();
        }

        @Override
        public boolean contains(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.containsKey:(Ljava/lang/Object;)Z");
            return this.this$0.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.containsKey:(Ljava/lang/Object;)Z");
            boolean bl = this.this$0.containsKey(object);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                this.this$0.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.clear:()V");
            this.this$0.clear();
        }

        @Override
        public Spliterator<K> spliterator() {
            RuntimeCostAccounter.recordAllocation((String)"java/util/WeakHashMap$KeySpliterator");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeySpliterator.<init>:(Ljava/util/WeakHashMap;IIII)V");
            return new KeySpliterator(this.this$0, 0, -1, 0, 0);
        }

        /* synthetic */ KeySet(WeakHashMap weakHashMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeySet.<init>:(Ljava/util/WeakHashMap;)V");
            this(weakHashMap);
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        final /* synthetic */ WeakHashMap this$0;

        private EntryIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$HashIterator.<init>:(Ljava/util/WeakHashMap;)V");
        }

        @Override
        public Map.Entry<K, V> next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntryIterator.nextEntry:()Ljava/util/WeakHashMap$Entry;");
            return this.nextEntry();
        }

        /* synthetic */ EntryIterator(WeakHashMap weakHashMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$EntryIterator.<init>:(Ljava/util/WeakHashMap;)V");
            this(weakHashMap);
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        final /* synthetic */ WeakHashMap this$0;

        private KeyIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$HashIterator.<init>:(Ljava/util/WeakHashMap;)V");
        }

        @Override
        public K next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeyIterator.nextEntry:()Ljava/util/WeakHashMap$Entry;");
            Entry entry = this.nextEntry();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getKey:()Ljava/lang/Object;");
            return entry.getKey();
        }

        /* synthetic */ KeyIterator(WeakHashMap weakHashMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$KeyIterator.<init>:(Ljava/util/WeakHashMap;)V");
            this(weakHashMap);
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        final /* synthetic */ WeakHashMap this$0;

        private ValueIterator(WeakHashMap weakHashMap) {
            this.this$0 = weakHashMap;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$HashIterator.<init>:(Ljava/util/WeakHashMap;)V");
        }

        @Override
        public V next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueIterator.nextEntry:()Ljava/util/WeakHashMap$Entry;");
            return this.nextEntry().value;
        }

        /* synthetic */ ValueIterator(WeakHashMap weakHashMap, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$ValueIterator.<init>:(Ljava/util/WeakHashMap;)V");
            this(weakHashMap);
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.expectedModCount = WeakHashMap.this.modCount;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.isEmpty:()Z");
            boolean bl = WeakHashMap.this.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                n = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                n = WeakHashMap.this.table.length;
            }
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] entryArray = WeakHashMap.this.table;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.nextKey != null) break;
                Entry entry = this.entry;
                int n = this.index;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (entry != null) break;
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) break;
                    entry = entryArray[--n];
                    RuntimeCostAccounter.recordJump();
                }
                this.entry = entry;
                this.index = n;
                RuntimeCostAccounter.recordJump();
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
                this.nextKey = entry.get();
                RuntimeCostAccounter.recordJump();
                if (this.nextKey == null) {
                    this.entry = this.entry.next;
                }
                RuntimeCostAccounter.recordJump();
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            int n = WeakHashMap.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.nextKey == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$HashIterator.hasNext:()Z");
                boolean bl = this.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                    NoSuchElementException noSuchElementException = new NoSuchElementException();
                    RuntimeCostAccounter.recordThrow();
                    throw noSuchElementException;
                }
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            RuntimeCostAccounter.recordJump();
            if (this.lastReturned == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                IllegalStateException illegalStateException = new IllegalStateException();
                RuntimeCostAccounter.recordThrow();
                throw illegalStateException;
            }
            int n = WeakHashMap.this.modCount;
            RuntimeCostAccounter.recordJump();
            if (n != this.expectedModCount) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object object, V v, ReferenceQueue<Object> referenceQueue, int n, Entry<K, V> entry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/WeakReference.<init>:(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V");
            super(object, referenceQueue);
            this.value = v;
            this.hash = n;
            this.next = entry;
        }

        @Override
        public K getKey() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.get:()Ljava/lang/Object;");
            Object t = this.get();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap.unmaskNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            return (K)WeakHashMap.unmaskNull(t);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            block5: {
                block6: {
                    Map.Entry entry;
                    block4: {
                        boolean bl = object instanceof Map.Entry;
                        RuntimeCostAccounter.recordJump();
                        if (!bl) {
                            return false;
                        }
                        entry = (Map.Entry)object;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getKey:()Ljava/lang/Object;");
                        K k = this.getKey();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        Object k2 = entry.getKey();
                        RuntimeCostAccounter.recordJump();
                        if (k == k2) break block4;
                        RuntimeCostAccounter.recordJump();
                        if (k == null) break block5;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                        boolean bl2 = k.equals(k2);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block5;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getValue:()Ljava/lang/Object;");
                    V v = this.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Object v2 = entry.getValue();
                    RuntimeCostAccounter.recordJump();
                    if (v == v2) break block6;
                    RuntimeCostAccounter.recordJump();
                    if (v == null) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                    boolean bl = v.equals(v2);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block5;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getKey:()Ljava/lang/Object;");
            K k = this.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getValue:()Ljava/lang/Object;");
            V v = this.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.hashCode:(Ljava/lang/Object;)I");
            int n = Objects.hashCode(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.hashCode:(Ljava/lang/Object;)I");
            return n ^ Objects.hashCode(v);
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getKey:()Ljava/lang/Object;");
            K k = this.getKey();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(k);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("=");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/WeakHashMap$Entry.getValue:()Ljava/lang/Object;");
            V v = this.getValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(v);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }
}

