/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.temporal;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.temporal.TemporalField;

public final class ValueRange
implements Serializable {
    private static final long serialVersionUID = -7317881728594519368L;
    private final long minSmallest;
    private final long minLargest;
    private final long maxSmallest;
    private final long maxLargest;

    public static ValueRange of(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l > l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Minimum value must be less than maximum value");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/ValueRange");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.<init>:(JJJJ)V");
        return new ValueRange(l, l, l2, l2);
    }

    public static ValueRange of(long l, long l2, long l3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJJ)Ljava/time/temporal/ValueRange;");
        return ValueRange.of(l, l, l2, l3);
    }

    public static ValueRange of(long l, long l2, long l3, long l4) {
        RuntimeCostAccounter.recordJump();
        if (l > l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Smallest minimum value must be less than largest minimum value");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l3 > l4) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Smallest maximum value must be less than largest maximum value");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 > l4) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Minimum value must be less than maximum value");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/ValueRange");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.<init>:(JJJJ)V");
        return new ValueRange(l, l2, l3, l4);
    }

    private ValueRange(long l, long l2, long l3, long l4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.minSmallest = l;
        this.minLargest = l2;
        this.maxSmallest = l3;
        this.maxLargest = l4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFixed() {
        RuntimeCostAccounter.recordJump();
        if (this.minSmallest != this.minLargest) return false;
        RuntimeCostAccounter.recordJump();
        if (this.maxSmallest != this.maxLargest) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public long getMinimum() {
        return this.minSmallest;
    }

    public long getLargestMinimum() {
        return this.minLargest;
    }

    public long getSmallestMaximum() {
        return this.maxSmallest;
    }

    public long getMaximum() {
        return this.maxLargest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIntValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
        long l = this.getMinimum() - Integer.MIN_VALUE;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 < 0) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
        long l3 = this.getMaximum() - Integer.MAX_VALUE;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l4 > 0) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidValue(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
        long l2 = l - this.getMinimum();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 < 0) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
        long l4 = l - this.getMaximum();
        long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l5 > 0) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidIntValue(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isIntValue:()Z");
        boolean bl = this.isIntValue();
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isValidValue:(J)Z");
        boolean bl2 = this.isValidValue(l);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    public long checkValidValue(long l, TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isValidValue:(J)Z");
        boolean bl = this.isValidValue(l);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.genInvalidFieldMessage:(Ljava/time/temporal/TemporalField;J)Ljava/lang/String;");
            String string = this.genInvalidFieldMessage(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return l;
    }

    public int checkValidIntValue(long l, TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isValidIntValue:(J)Z");
        boolean bl = this.isValidIntValue(l);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.genInvalidFieldMessage:(Ljava/time/temporal/TemporalField;J)Ljava/lang/String;");
            String string = this.genInvalidFieldMessage(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return (int)l;
    }

    private String genInvalidFieldMessage(TemporalField temporalField, long l) {
        RuntimeCostAccounter.recordJump();
        if (temporalField != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid value for ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" (valid values ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("): ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder7.toString();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder.append("Invalid value (valid values ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder10 = stringBuilder9.append("): ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder11.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidObjectException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordJump();
        if (this.minSmallest > this.minLargest) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("Smallest minimum value must be less than largest minimum value");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.maxSmallest > this.maxLargest) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("Smallest maximum value must be less than largest maximum value");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.minLargest > this.maxLargest) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("Minimum value must be less than maximum value");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof ValueRange;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        ValueRange valueRange = (ValueRange)object;
        long l = this.minSmallest - valueRange.minSmallest;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 != false) return false;
        long l3 = this.minLargest - valueRange.minLargest;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l4 != false) return false;
        long l5 = this.maxSmallest - valueRange.maxSmallest;
        long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l6 != false) return false;
        long l7 = this.maxLargest - valueRange.maxLargest;
        long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l8 != false) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        long l = this.minSmallest + this.minLargest << (int)(16L + this.minLargest) >> (int)(48L + this.maxSmallest) << (int)(32L + this.maxSmallest) >> (int)(32L + this.maxLargest) << (int)(48L + this.maxLargest) >> 16;
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        stringBuilder.append(this.minSmallest);
        RuntimeCostAccounter.recordJump();
        if (this.minSmallest != this.minLargest) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append('/');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            stringBuilder2.append(this.minLargest);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder.append(" - ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        stringBuilder3.append(this.maxSmallest);
        RuntimeCostAccounter.recordJump();
        if (this.maxSmallest != this.maxLargest) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append('/');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            stringBuilder4.append(this.maxLargest);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }
}

