<?php

namespace Controller\Api;

class User extends \Controller\Api
{
    protected function user_array(\Model\User $user): array
    {
        $group_id = $user->id;

        if ($user->role == 'group') {
            $group = new \Model\Custom("user_group");
            $man = $group->find(["group_id = ? AND manager = 1", $user->id]);
            $man = array_filter($man);

            if ($man !== [] && $man[0]->user_id > 0) {
                $group_id = $man[0]->user_id;
            }
        }

        return [
            "id" => $group_id,
            "name" => $user->name,
            "username" => $user->username,
            "email" => $user->email,
        ];
    }

    public function single_get($f3, array $params): void
    {
        if ($params["username"] == "me") {
            $user = $f3->get("user_obj");
        } else {
            $user = new \Model\User();
            $user->load(["username = ?", $params["username"]]);
        }
        if ($user->id) {
            $this->_printJson($this->user_array($user));
        } else {
            $f3->error(404);
        }
    }

    public function single_email($f3, array $params): void
    {
        $user = new \Model\User();
        $user->load(["email = ? AND deleted_date IS NULL", $params["email"]]);
        if ($user->id) {
            $this->_printJson($this->user_array($user));
        } else {
            $f3->error(404);
        }
    }


    // Gets a List of users
    public function get($f3): void
    {
        $pagLimit = $f3->get("GET.limit") ?: 30;
        if ($pagLimit == -1) {
            $pagLimit = 100000;
        } elseif ($pagLimit < 0) {
            $pagLimit = 30;
        }

        $user = new \Model\User();
        $result = $user->paginate(
            $f3->get("GET.offset") / $pagLimit,
            $pagLimit,
            "deleted_date IS NULL AND role != 'group'"
        );

        $users = [];
        foreach ($result["subset"] as $user) {
            $users[] = $this->user_array($user);
        }

        $this->_printJson([
            "total_count" => $result["total"],
            "limit" => $result["limit"],
            "users" => $users,
            "offset" => $result["pos"] * $result["limit"],
        ]);
    }


    // Gets a list of Users
    public function get_group($f3): void
    {
        $pagLimit = $f3->get("GET.limit") ?: 30;

        if ($pagLimit == -1) {
            $pagLimit = 100000;
        } elseif ($pagLimit < 0) {
            $pagLimit = 30;
        }

        $user = new \Model\User();
        $result = $user->paginate(
            $f3->get("GET.offset") / $pagLimit,
            $pagLimit,
            "deleted_date IS NULL AND role = 'group' AND api_visible != '0'"
        );

        $groups = [];
        foreach ($result["subset"] as $user) {
            $groups[] = $this->user_array($user);
        }

        $this->_printJson([
            "total_count" => $result["total"],
            "limit" => $result["limit"],
            "groups" => $groups,
            "offset" => $result["pos"] * $result["limit"],
        ]);
    }
}
