/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

abstract class ChronoLocalDateImpl<D extends ChronoLocalDate>
implements ChronoLocalDate,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 6282433883239719096L;

    static <D extends ChronoLocalDate> D ensureValid(Chronology chronology, Temporal temporal) {
        ChronoLocalDate chronoLocalDate = (ChronoLocalDate)temporal;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology2 = chronoLocalDate.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl = chronology.equals(chronology2);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Chronology mismatch, expected: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string = chronology.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(", actual: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology3 = chronoLocalDate.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string2 = chronology3.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException(string3);
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        return (D)chronoLocalDate;
    }

    ChronoLocalDateImpl() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public D with(TemporalAdjuster temporalAdjuster) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        return (D)ChronoLocalDate.super.with(temporalAdjuster);
    }

    public D with(TemporalField temporalField, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
        return (D)ChronoLocalDate.super.with(temporalField, l);
    }

    public D plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (D)ChronoLocalDate.super.plus(temporalAmount);
    }

    public D plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusDays(l);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l2 = Math.multiplyExact(l, 7L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusDays(l2);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusMonths(l);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusYears(l);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l3 = Math.multiplyExact(l, 10L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusYears(l3);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l4 = Math.multiplyExact(l, 100L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusYears(l4);
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l5 = Math.multiplyExact(l, 1000L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
                    return this.plusYears(l5);
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l6 = this.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                    long l7 = Math.addExact(l6, l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
                    return (D)this.with(ChronoField.ERA, l7);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (D)ChronoLocalDate.super.plus(l, temporalUnit);
    }

    public D minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
        return (D)ChronoLocalDate.super.minus(temporalAmount);
    }

    public D minus(long l, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        return (D)ChronoLocalDate.super.minus(l, temporalUnit);
    }

    abstract D plusYears(long var1);

    abstract D plusMonths(long var1);

    D plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 7L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
        return this.plusDays(l2);
    }

    abstract D plusDays(long var1);

    D minusYears(long l) {
        D d;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDateImpl chronoLocalDateImpl = (ChronoLocalDateImpl)this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = chronoLocalDateImpl.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusYears:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = this.plusYears(l2);
        }
        return d;
    }

    D minusMonths(long l) {
        D d;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDateImpl chronoLocalDateImpl = (ChronoLocalDateImpl)this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = chronoLocalDateImpl.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusMonths:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = this.plusMonths(l2);
        }
        return d;
    }

    D minusWeeks(long l) {
        D d;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDateImpl chronoLocalDateImpl = (ChronoLocalDateImpl)this.plusWeeks(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = chronoLocalDateImpl.plusWeeks(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusWeeks:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = this.plusWeeks(l2);
        }
        return d;
    }

    D minusDays(long l) {
        D d;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDateImpl chronoLocalDateImpl = (ChronoLocalDateImpl)this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = chronoLocalDateImpl.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDate;");
            d = this.plusDays(l2);
        }
        return d;
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporal, "endExclusive");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = chronology.date(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.daysUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.daysUntil(chronoLocalDate);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.daysUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.daysUntil(chronoLocalDate) / 7L;
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.monthsUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.monthsUntil(chronoLocalDate);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.monthsUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.monthsUntil(chronoLocalDate) / 12L;
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.monthsUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.monthsUntil(chronoLocalDate) / 120L;
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.monthsUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.monthsUntil(chronoLocalDate) / 1200L;
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.monthsUntil:(Ljava/time/chrono/ChronoLocalDate;)J");
                    return this.monthsUntil(chronoLocalDate) / 12000L;
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l = chronoLocalDate.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
                    return l - this.getLong(ChronoField.ERA);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalUnit, "unit");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, chronoLocalDate);
    }

    private long daysUntil(ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = chronoLocalDate.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.toEpochDay:()J");
        return l - this.toEpochDay();
    }

    private long monthsUntil(ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = chronology.range(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
        long l = valueRange.getMaximum() - 12L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 != false) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("ChronoLocalDateImpl only supports Chronologies with 12 months per year");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l3 = this.getLong(ChronoField.PROLEPTIC_MONTH) * 32L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.get:(Ljava/time/temporal/TemporalField;)I");
        long l4 = l3 + (long)this.get(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l5 = chronoLocalDate.getLong(ChronoField.PROLEPTIC_MONTH) * 32L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
        long l6 = l5 + (long)chronoLocalDate.get(ChronoField.DAY_OF_MONTH);
        return (l6 - l4) / 32L;
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ChronoLocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            ChronoLocalDate chronoLocalDate = (ChronoLocalDate)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.compareTo:(Ljava/time/chrono/ChronoLocalDate;)I");
            int n = this.compareTo(chronoLocalDate);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.toEpochDay:()J");
        long l = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.hashCode:()I");
        return chronology.hashCode() ^ (int)(l ^ l >>> 32);
    }

    @Override
    public String toString() {
        String string;
        String string2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(ChronoField.YEAR_OF_ERA);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l2 = this.getLong(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l3 = this.getLong(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        StringBuilder stringBuilder = new StringBuilder(30);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.toString:()Ljava/lang/String;");
        String string3 = chronology.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(" ");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.getEra:()Ljava/time/chrono/Era;");
        Era era = this.getEra();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(era);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(" ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(l);
        RuntimeCostAccounter.recordJump();
        if (l2 < 10L) {
            string2 = "-0";
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = "-";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(l2);
        RuntimeCostAccounter.recordJump();
        if (l3 < 10L) {
            string = "-0";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "-";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
        stringBuilder9.append(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }
}

