/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands;

import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.instrument.DontInstrument;
import co.paralleluniverse.strands.CheckedSuspendableCallable;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.SuspendableRunnable;
import java.util.concurrent.Callable;

public class SuspendableUtils {
    public static SuspendableCallable<Void> runnableToCallable(SuspendableRunnable runnable) {
        return new VoidSuspendableCallable(runnable);
    }

    public static SuspendableRunnable asSuspendable(final Runnable runnable) {
        return new SuspendableRunnable(){

            @Override
            @DontInstrument
            public void run() throws SuspendExecution, InterruptedException {
                runnable.run();
            }
        };
    }

    public static <V> SuspendableCallable<V> asSuspendable(final Callable<V> callable) {
        return new SuspendableCallable<V>(){

            @Override
            @Instrumented(methodOptimized=true, methodStart=70, methodEnd=72, suspendableCallSites={}, suspendableCallSiteNames={}, suspendableCallSitesOffsetsAfterInstr={})
            public V run() throws SuspendExecution, InterruptedException {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw Exceptions.rethrow(e);
                }
            }
        };
    }

    public static <V, E extends Exception> SuspendableCallable<V> asSuspendableCallable(final CheckedSuspendableCallable<V, E> callable) {
        return new SuspendableCallable<V>(){

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=85, methodEnd=91, suspendableCallSites={85}, suspendableCallSiteNames={"co/paralleluniverse/strands/CheckedSuspendableCallable.call()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={76})
            public V run() throws SuspendExecution, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    public static class VoidSuspendableCallable
    implements SuspendableCallable<Void> {
        private final SuspendableRunnable runnable;

        public VoidSuspendableCallable(SuspendableRunnable runnable) {
            if (runnable == null) {
                throw new NullPointerException("Runnable is null");
            }
            this.runnable = runnable;
        }

        @Override
        @DontInstrument
        public Void run() throws SuspendExecution, InterruptedException {
            this.runnable.run();
            return null;
        }

        public SuspendableRunnable getRunnable() {
            return this.runnable;
        }
    }
}

